C
C
      SUBROUTINE TRIMC1 (STRNG)
C
C ACTION : Centralise a character string
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 3/11/95
C          28/02/2007 added INTENT
C
      IMPLICIT   NONE 
C
C Argument
C      
      CHARACTER (LEN = *), INTENT (INOUT) :: STRNG
C
C Locals
C      
      INTEGER    I, J, K1, K2, L, LEN100, LEN200
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      EXTERNAL   LEN100, LEN200, TRIML1, TRIMR1
      INTRINSIC  ABS, LEN
C
C Return if string is blank
C
      IF (STRNG.EQ.BLANK) RETURN
C
C Find the first and last nonblank characters
C
      K1 = LEN100(STRNG)
      K2 = LEN200(STRNG)
      L = LEN(STRNG)
C
C Return if end padding differs by 1 at most
C
      IF (ABS(K1 - 1 - L - K2).LE.1) RETURN
C
C Trim right or left depending on which end has most blanks
C
      IF (K1 - 1.GT.L - K2) THEN
         I = (K1 - 1 + L - K2)/2 + 1
         J = K2
         CALL TRIML1 (STRNG(I:J))
      ELSE
         I = K1
         J = (K1 - 1 + L - K2)/2 + K2
         CALL TRIMR1 (STRNG(I:J))
      ENDIF
      END
C
C
