C
C
      SUBROUTINE TUTOR1 (ICOLOR, NUMBLD, NUMHDR,
     +                   HEADER,
     +                   FRAME, NEXT, UPDOWN)
C
C ACTION : Display tutorial
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 13/12/98
C          20/11/2006 added INTENTS
C          30/05/2007 removed calls to W_DBLEUP 
C          05/04/2010 added N2COPY and extension to HEADER_TEMP to pass copy data to W_TUTOR1
C
C          Note about NEXT and UPDOWN
C          ==========================
C          Actually only one logical control variable is needed but both are
C          kept to remain consistent with TUTORS and to allow for future
C          developments. The scheme in this version is as follows:-
C
C          If both UPOWN and NEXT are .TRUE. the stores are filled up.
C          If either are .FALSE. the stores are displayed.
C
C          NMAX = max. no. of pages stored
C          NLINES = max. no. lines stored per page
C
      IMPLICIT   NONE   
C
C Arguments
C      
      INTEGER,             INTENT (IN) :: ICOLOR, NUMHDR
      INTEGER,             INTENT (IN) :: NUMBLD(NUMHDR) 
      CHARACTER (LEN = *), INTENT (IN) :: HEADER(NUMHDR) 
      LOGICAL,             INTENT (IN) :: FRAME, NEXT, UPDOWN
C
C Locals
C       
      INTEGER    N2COPY, NLINES, NMAX, NSTORE
      PARAMETER (NMAX = 15, NLINES = 30, NSTORE = NLINES*NMAX,
     +           N2COPY = NLINES + NSTORE)
      INTEGER    ICOLOR_STORE(NMAX), ICOLOR_TEMP,
     +           NUMBLD_STORE(NSTORE), NUMBLD_TEMP(NLINES),
     +           NUMHDR_STORE(NMAX), NUMHDR_TEMP
      INTEGER    NSTART(NMAX)
      INTEGER    I, ICOUNT, IPAGE, IPMAX, INEXT, J, JCOUNT, KCOUNT
      CHARACTER  HEADER_STORE(NSTORE)*129,
     +           HEADER_TEMP(N2COPY)*129, LINE*129
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    FRAME_STORE(NMAX), FRAME_TEMP
      EXTERNAL   W_TUTOR1
      INTRINSIC  MIN, INDEX
      SAVE       ICOUNT, JCOUNT, NSTART, ICOLOR_STORE, NUMBLD_STORE,
     +           NUMHDR_STORE, HEADER_STORE, FRAME_STORE, HEADER_TEMP
      DATA       ICOUNT, JCOUNT, KCOUNT / 0, 0, NLINES /
C
C Fill in the stores if not filled to capacity (controlled by parameter NMAX)
C
      IF (ICOUNT.LT.NMAX) THEN
         ICOUNT = ICOUNT + 1
         ICOLOR_STORE(ICOUNT) = ICOLOR
         NUMHDR_STORE(ICOUNT) = MIN(NUMHDR,NLINES)
         FRAME_STORE(ICOUNT) = FRAME
         NSTART(ICOUNT) = JCOUNT + 1
c
c Store up to the maximum number of lines (controlled by parameter NLINES)
c
         DO I = 1, NUMHDR_STORE(ICOUNT)
            HEADER_TEMP(I) = HEADER(I)
            JCOUNT = JCOUNT + 1
            NUMBLD_STORE(JCOUNT) = NUMBLD(I)
            HEADER_STORE(JCOUNT) = HEADER_TEMP(I)
         ENDDO
C
C Store as text for copy in W_TUTOR1
C         
         KCOUNT = KCOUNT + 1
         IF (KCOUNT.EQ.NLINES + 1) THEN
           WRITE (HEADER_TEMP(KCOUNT),100) 
           KCOUNT = KCOUNT + 1
         ENDIF
         HEADER_TEMP(KCOUNT) = BLANK
         KCOUNT = KCOUNT + 1
         WRITE (HEADER_TEMP(KCOUNT),200) ICOUNT
         KCOUNT = KCOUNT + 1
         HEADER_TEMP(KCOUNT) = BLANK 
         DO I = 1,   NUMHDR_STORE(ICOUNT)
            LINE = HEADER(I)
            J = INDEX(LINE,'`')
            DO WHILE (J.GT.0)
               LINE(J:J) = BLANK
               J = INDEX(LINE,'`')
            ENDDO
            KCOUNT = KCOUNT + 1
            HEADER_TEMP(KCOUNT) = LINE   
         ENDDO 
      ENDIF
      IF (UPDOWN .AND. NEXT) THEN
C
C Return for another page if UPDOWN and NEXT are .TRUE.
C
         RETURN
      ELSE
C
C Set IPMAX = ICOUNT then re-set ICOUNT and JCOUNT and display the stored pages
C
         KCOUNT = KCOUNT + 1
         WRITE(HEADER_TEMP(KCOUNT),300) 
         IPAGE = 1
         IPMAX = ICOUNT
         INEXT = 1
         ICOUNT = 0
         JCOUNT = 0
         KCOUNT = NLINES
         DO WHILE (INEXT.GT.0)
C
C Create the page to be displayed
C           
            ICOLOR_TEMP = ICOLOR_STORE(IPAGE)
            NUMHDR_TEMP = NUMHDR_STORE(IPAGE)
            FRAME_TEMP = FRAME_STORE(IPAGE)
            J = NSTART(IPAGE) - 1
            DO I = 1, NUMHDR_TEMP
               J = J + 1
               NUMBLD_TEMP(I) = NUMBLD_STORE(J)
               HEADER_TEMP(I) = HEADER_STORE(J)
            ENDDO
C
C Make sure lines up to NLINES are defined
C            
            DO I = NUMHDR_TEMP + 1, NLINES
               HEADER_TEMP(I) = BLANK
            ENDDO 
C
C Display page requested
C              
            CALL W_TUTOR1(ICOLOR_TEMP, INEXT, IPAGE, IPMAX, NUMBLD_TEMP,
     +                    NUMHDR_TEMP,
     +                    HEADER_TEMP, 
     +                    FRAME_TEMP)
            IF (INEXT.LT.1 .OR. INEXT.GT.IPMAX) RETURN
            IPAGE = INEXT
         ENDDO
      ENDIF
C
C Format codes .. these MUST NOT be changed  
C      
  100 FORMAT ('%start-of-text-to-copy%')
  200 FORMAT ('Page',I3)
  300 FORMAT ('%end-of-text-to-copy%')      
      END
C
C
