

c Resolution of some long-standing Simfit display/input/output problems 

c bill.bardsley@manchester.ac.uk, 11/08/2011 

c 1) History of the Simfit get* routines
c     -----------------------------------

c When the Windows95 version of simfit was created, all the DBOS
c routines were replaced by routines with prefix w95_. Over many
c years these gave all sorts of problems and were steadily evolved
c to get round them.

c In particular, Malcolm Cohen recently pointed out that double 
c precision variables could be truncated, so that values input as
c defaults for editing could be returned with errors in trailing
c significant figures, despite no editing action being taken by users.

c Also, Francisco Burguillo observed that double precision variables
c input to the subroutine getr00n could, in some circumstances, have
c internal representation errors leading to misleading displays.

c At the present time these problems, and several others, have finally
c been resolved by using new and improved routines in w_clearwin.dll
c for the user interface controls.

c 2) Subroutines in w_clearwin.dll
c    ----------------------------- 

c These are the routines now used for the user interface controls that 
c seem to have finally solved all the input/output/display problems.

c   w_get00n ... Get any number of integer, double precision, character,
c                or logical variables up to 20 in total. These must all be
c                initialised before calling w_get00n. 

c   w_xlines ... This accepts up to 25 character variables of length 12 
c                for integers and 25 for double precision variables.
c                Blank or initialised character strings can be input
c                then edited values are returned.

c   w_ylines ... Exactly as w_xlines except that extra character strings
c                can be supplied to display to the right of the edit boxes.

c   x_form12 ... Write integer variables in left justified format to 
c                (len = 12) character strings.
               
c   x_form25 ... Write double precision variables to left justified 
c                (len = 25) character strings so that at least 15 
c                significant figures are preserved, but using i format 
c                if appropriate, or else f or e format with trailng 
c                zeros removed.

c   x_txt2i1 ... Read an integer value using enhanced formatting and
c                error checking. Used by w_xlines and w_ylines. Allows
c                spaces in input fields so that, for instance
c                1 2 3 4 5 = 12345 

c   x_txt2r1 ... Read a double precision value using enhanced formatting 
c                and error checking. Used by w_get00n, w_xlines and
c                w_ylines. Allows commas and spaces in input fields so
c                that, for instance
c                1 2 3 , 4 5 6 = 123.456
c                Does not allow some otherwise legal inputs like just
c                a D, or just an E. 
 
c 3) Subroutines in w_menus.dll
c    --------------------------

c These are the front end subroutines that call the w_clearwin.dll codes.
c Most of the code required for argument checking is in the composite
c file called getw95.for described below.

c getall.for  Driver program to illustrate how to call the simple get
c             routines with 6-character stubs in getw95.for.

c getdbl.for  Intermediate w95_* subroutines called by the standard 
c             6-character stubs in getw95.for, calling routines
c             like w95_gettx1 then w95_txt2r1 to return double
c            precision values
 
c geti0n.for  Get up to 20 integers using w_get00n

c getint.for  Intermediate w95_* subroutines called by the standard 
c             6-character standard stubs in getw95.for, calling routines 
c             like w95_getx1 then w95_txt2i1 to return integer values.

c getr0n.for  Get up to 25 double precision values using w_ylines.

c getw95.for  The standard 6-character stubs used to call the w95_* routines
c             in getdbl and getint. The calling trees can be deduced from
c             these stubs. Almost all the calls from Simfit and Simdem are 
c             actually calls to these simple 6-character stubs.

c txtw95.for  Calls routines like w95_txt2i1 and w95_txt2r1.
c             Values are retrieved using w_xlines.

C
C
C--------------------------------------------------------------------------
C
      SUBROUTINE W95_TXT2I1 (NUMBER,
     +                       LINE,
     +                       ABORT)
C
C ACTION: simple check and integer conversion
C
      IMPLICIT  NONE  
C
C Arguments
C      
      INTEGER,             INTENT (OUT)   :: NUMBER
      CHARACTER (LEN = *), INTENT (INOUT) :: LINE
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C      
      INTEGER IOS, ITEMP 
      NUMBER = 0
      ABORT = .TRUE.
      READ (LINE,*,IOSTAT=IOS) ITEMP
      IF (IOS.EQ.0) THEN
         ABORT = .FALSE.
         NUMBER = ITEMP
      ENDIF   
      END
C
C------------------------------------------------------------------------
C


C
C------------------------------------------------------------------------
C
      SUBROUTINE W95_TXT2R1 (X,
     +                       LINE, 
     +                       ABORT)
C
C ACTION: simple check and double conversion
C
      IMPLICIT  NONE
C
C Arguments
C             
      DOUBLE PRECISION,    INTENT (OUT)   :: X  
      CHARACTER (LEN = *), INTENT (INOUT) :: LINE
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C
      INTEGER IOS
      DOUBLE PRECISION XTEMP      
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      X = ZERO
      ABORT = .TRUE.
      READ (LINE,*,IOSTAT=IOS) XTEMP
      IF (IOS.EQ.0) THEN
         X = XTEMP
         ABORT = .FALSE.
      ENDIF   
      END
C
C-----------------------------------------------------------------------------
C
      SUBROUTINE W95_TXT2R2 (X, Y,
     +                       LINE,
     +                       ABORT)
C
C ACTION : Transform a string into two reals using comma as separator      
C          06/02/2007 edited for w_clearwin.dll
C
      IMPLICIT   NONE 
C
C Arguments
C                          
      DOUBLE PRECISION,    INTENT (OUT)   :: X, Y 
      CHARACTER (LEN = *), INTENT (INOUT) :: LINE
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C                                  
      INTEGER    IX, LSWORD 
      INTEGER    LEN200
      DOUBLE PRECISION XTEMP, YTEMP 
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  DUMMY*80
      CHARACTER  BLANK*1, COMMA*1
      PARAMETER (BLANK = ' ', COMMA = ',')
      EXTERNAL   W95_TXT2R1
      EXTERNAL   LEN200
      INTRINSIC  INDEX
C
C Set ABORT = .TRUE. and initialise X, Y
C
      ABORT = .TRUE.
      X = ZERO
      Y = ZERO
C
C Find the first comma
C
      IX = INDEX(LINE,COMMA)
      LSWORD = LEN200(LINE)
      IF (IX.LT.2 .OR. IX.GT.LSWORD - 1) THEN
         LINE = BLANK
         RETURN
      ENDIF   
C
C All seems well .. Read in X, Y
C
      DUMMY = LINE(1:IX - 1)
      CALL W95_TXT2R1 (XTEMP,
     +                 DUMMY,
     +                 ABORT)
      IF (ABORT) THEN
         LINE = BLANK
         RETURN
      ENDIF   
      DUMMY = LINE(IX + 1:LSWORD)
      CALL W95_TXT2R1 (YTEMP,
     +                 DUMMY,
     +                 ABORT)
      IF (ABORT) THEN
         LINE = BLANK
      ELSE   
         X = XTEMP
         Y = YTEMP
      ENDIF
      END
C
C-------------------------------------------------------------------
C
      SUBROUTINE W95_TXT2R3 (X, Y, Z,
     +                       LINE,
     +                       ABORT)
C
C ACTION : Transform a string into three reals using commas as separators
C          06/02/2007 edited for w_clearwin.dll
C
      IMPLICIT   NONE 
C
C Arguments
C                     
      DOUBLE PRECISION,    INTENT (OUT)   :: X, Y, Z 
      CHARACTER (LEN = *), INTENT (INOUT) :: LINE 
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C       
      INTEGER    IX, LSWORD
      INTEGER    LEN200
      DOUBLE PRECISION XTEMP, YTEMP, ZTEMP
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  DUMMY*80
      CHARACTER  BLANK*1, COMMA*1
      PARAMETER (BLANK = ' ', COMMA = ',')
      EXTERNAL   LEN200
      EXTERNAL   W95_TXT2R1, W95_TXT2R2
      INTRINSIC  INDEX
      ABORT = .TRUE.
      X = ZERO
      Y = ZERO
      Z = ZERO
      IX = INDEX(LINE,COMMA)
      LSWORD = LEN200(LINE)
      IF (IX.LT.2 .OR. IX.GT.LSWORD - 3) THEN
         LINE = BLANK
         RETURN
      ENDIF   
C
C All seems well .. Read in X, Y, Z
C
      DUMMY = LINE(1:IX - 1)
      CALL W95_TXT2R1 (XTEMP,
     +                 DUMMY,
     +                 ABORT)
      IF (ABORT) THEN
         LINE = BLANK
         RETURN
      ENDIF   
      DUMMY = LINE(IX + 1:LSWORD)
      CALL W95_TXT2R2 (YTEMP, ZTEMP,
     +                 DUMMY,
     +                 ABORT)
      IF (ABORT) THEN
         LINE = BLANK
      ELSE    
         X = XTEMP
         Y = YTEMP
         Z = ZTEMP
      ENDIF
      END
C 
C---------------------------------------------------------------------
C
      SUBROUTINE W95_TXT2FN (FNAME,
     +                       ABORT)
C
C ACTION : Check that a string is an acceptable file name
C          22/10/1998 would not accept DO I = 1, LEN200(FNAME) so altered code
C          06/02/2007 edited for w_clearwin.dll
C          19/07/2007 changed FNAME to INTENT (IN)
C
      IMPLICIT   NONE 
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: FNAME
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C      
      INTEGER    I, LSWORD, NCOLON
      INTEGER    LEN200
      CHARACTER  FCOPY*1024, LETTER*1
      CHARACTER  BLANK*1, STARS*3
      PARAMETER (BLANK = ' ', STARS = '*.*')
      EXTERNAL   TRIML1, LEN200
C
C Initialise ABORT
C
      ABORT = .TRUE.
      IF (FNAME.EQ.BLANK .OR. FNAME.EQ.STARS) RETURN
C
C Make a copy
C  
      FCOPY = FNAME      
C
C Rotate to remove leading blanks
C
      CALL TRIML1 (FCOPY)
C
C Check if remaining block of text contains ambiguous letters
C
      LSWORD = LEN200(FCOPY)
      NCOLON = 0
      DO I = 1, LSWORD
         LETTER = FCOPY(I:I)
         IF (LETTER.EQ.':') THEN
            NCOLON = NCOLON + 1
            IF (NCOLON.GT.1) RETURN
         ELSEIF (LETTER.EQ.'?' .OR.
     +           LETTER.EQ.'*' .OR.
     +           LETTER.EQ.'"' .OR.
     +           LETTER.EQ.'<' .OR.
     +           LETTER.EQ.'>' .OR.
     +           LETTER.EQ.'|') THEN
            RETURN
         ENDIF
      ENDDO
      IF (LETTER.EQ.'\' .OR. LETTER.EQ.'/') RETURN
      ABORT = .FALSE.
      END
C
C---------------------------------------------------------------------------------
C
      SUBROUTINE W95_GETTXT (ICOLOR, IYL, NUMTXT, 
     +                       LINE, TEXT)
C
C ACTION : Read in text using win32 routines
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 17/1/94
C          21/05/1997 Modified to call LINEIN 
C          08/02/2007 edited for w_clearwin.dll
C          14/04/2009 added INTENTS 
C
C          ICOLOR = colour selection
C          IYL = coordinate
C          NUMTXT = no. of text lines
C          LINE = text string
C          TEXT = text string
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IYL, NUMTXT 
      CHARACTER (LEN = *), INTENT (INOUT) :: LINE
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT(NUMTXT)
C
C Locals
C      
      INTEGER    IXL, NMAX
      PARAMETER (IXL = 4, NMAX = 30)
      INTEGER    I, NCHAR, NTEXT, NUMBLD(NMAX)
      LOGICAL    FIXED
      PARAMETER (FIXED = .FALSE.)
      EXTERNAL   W_LINEIN
      INTRINSIC  LEN, MIN
      NCHAR = LEN(LINE) 
      NTEXT = MIN(NUMTXT,NMAX) 
      DO I = 1, NTEXT
         NUMBLD(I) = 0
      ENDDO
      CALL W_LINEIN (ICOLOR, IXL, IYL, NCHAR, NUMBLD, NTEXT,
     +               LINE, TEXT,
     +               FIXED)
      END
C
C---------------------------------------------------------------------------------
C
      SUBROUTINE W95_GETTX1 (ICOLOR, IYL, NUMTXT, 
     +                       LINE, TEXT)
C
C ACTION : Read in 1 line using W_XLINES
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          10/04/2009 derived from W95_GETTXT
C          27/10/2010 calls W_XLINES
C
C          ICOLOR = colour selection
C          IYL = coordinate
C          NUMTXT = no. of text lines
C          LINE = text string
C          TEXT = text string
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IYL, NUMTXT 
      CHARACTER (LEN = *), INTENT (INOUT) :: LINE
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT(NUMTXT)
C
C Locals
C      
      INTEGER    IXL, NMAX, NUMLIN
      PARAMETER (IXL = 4, NMAX = 30, NUMLIN = 1)
      INTEGER    I, NCHAR, NTEXT, NUMBLD(NMAX)
      CHARACTER  LINE12(NUMLIN)*12, LINE25(NUMLIN)*25
      LOGICAL    FIXED, STACK
      PARAMETER (FIXED = .FALSE., STACK = .FALSE.)
      EXTERNAL   W_XLINES
      INTRINSIC  LEN, MIN
      NCHAR = LEN(LINE) 
      NTEXT = MIN(NUMTXT,NMAX) 
      DO I = 1, NTEXT
         NUMBLD(I) = 0
      ENDDO
      IF (NCHAR.LE.12) THEN
         NCHAR = 12
         LINE12(1) = LINE
         CALL W_XLINES (ICOLOR, IXL, IYL, NCHAR, NUMBLD, NUMLIN, NTEXT,
     +                  LINE12, TEXT,
     +                  FIXED, STACK)
         LINE = LINE12(1)
      ELSE 
         NCHAR = 25 
         LINE25(1) = LINE
         CALL W_XLINES (ICOLOR, IXL, IYL, NCHAR, NUMBLD, NUMLIN, NTEXT,
     +                  LINE25, TEXT,
     +                  FIXED, STACK)
         LINE = LINE25(1)
      ENDIF    
      END 
C
C---------------------------------------------------------------------------------
C
      SUBROUTINE W95_GETTX2 (ICOLOR, IYL, NUMTXT, 
     +                       LINE1, LINE2, TEXT)
C
C ACTION : Read in 2 lines using W_XLINES
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          10/04/2009 derived from W95_GETTXT
C          27/10/2010 calls W_XLINES
C
C          ICOLOR = colour selection
C          IYL = coordinate
C          NUMTXT = no. of text lines
C          LINE = text string
C          TEXT = text string
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IYL, NUMTXT 
      CHARACTER (LEN = *), INTENT (INOUT) :: LINE1, LINE2
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT(NUMTXT)
C
C Locals
C      
      INTEGER    IXL, NMAX, NUMLIN
      PARAMETER (IXL = 4, NMAX = 30, NUMLIN = 2)
      INTEGER    I, J, NCHAR, NTEXT, NUMBLD(NMAX)
      CHARACTER  LINES_12(NUMLIN)*12, LINES_25(NUMLIN)*25
      LOGICAL    FIXED, STACK
      PARAMETER (FIXED = .FALSE., STACK = .TRUE.)
      EXTERNAL   W_XLINES
      INTRINSIC  LEN, MIN, MAX
      I = LEN(LINE1)
      J = LEN(LINE2)
      NCHAR = MAX(I,J) 
      NTEXT = MIN(NUMTXT,NMAX) 
      DO I = 1, NTEXT
         NUMBLD(I) = 0
      ENDDO
      IF (NCHAR.LE.12) THEN
         NCHAR = 12
         LINES_12(1) = LINE1
         LINES_12(2) = LINE2
         CALL W_XLINES (ICOLOR, IXL, IYL, NCHAR, NUMBLD, NUMLIN, NTEXT,
     +                  LINES_12, TEXT,
     +                  FIXED, STACK)
         LINE1 = LINES_12(1)
         LINE2 = LINES_12(2)
      ELSE
         NCHAR = 25
         LINES_25(1) = LINE1
         LINES_25(2) = LINE2
         CALL W_XLINES (ICOLOR, IXL, IYL, NCHAR, NUMBLD, NUMLIN, NTEXT,
     +                  LINES_25, TEXT,
     +                  FIXED, STACK)
         LINE1 = LINES_25(1)
         LINE2 = LINES_25(2)
      ENDIF     
      END 
C
C---------------------------------------------------------------------------------
C
      SUBROUTINE W95_GETTX3 (ICOLOR, IYL, NUMTXT, 
     +                       LINE1, LINE2, LINE3, TEXT)
C
C ACTION : Read in 3 lines using W_XLINES
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          10/04/2009 derived from W95_GETTXT
C          27/10/2010 calls W_XLINES
C
C          ICOLOR = colour selection
C          IYL = coordinate
C          NUMTXT = no. of text lines
C          LINE = text string
C          TEXT = text string
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IYL, NUMTXT 
      CHARACTER (LEN = *), INTENT (INOUT) :: LINE1, LINE2, LINE3
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT(NUMTXT)
C
C Locals
C      
      INTEGER    IXL, NMAX, NUMLIN
      PARAMETER (IXL = 4, NMAX = 30, NUMLIN = 3)
      INTEGER    I, J, K, NCHAR, NTEXT, NUMBLD(NMAX)
      CHARACTER  LINES_12(NUMLIN)*12, LINES_25(NUMLIN)*25
      LOGICAL    FIXED, STACK
      PARAMETER (FIXED = .FALSE., STACK = .TRUE.)
      EXTERNAL   W_XLINES
      INTRINSIC  LEN, MIN, MAX
      I = LEN(LINE1)
      J = LEN(LINE2)
      K = LEN(LINE3)
      NCHAR = MAX(I,J,K) 
      NTEXT = MIN(NUMTXT,NMAX) 
      DO I = 1, NTEXT
         NUMBLD(I) = 0
      ENDDO
      IF (NCHAR.LE.12) THEN
         NCHAR = 12
         LINES_12(1) = LINE1
         LINES_12(2) = LINE2
         LINES_12(3) = LINE3
         CALL W_XLINES (ICOLOR, IXL, IYL, NCHAR, NUMBLD, NUMLIN, NTEXT,
     +                  LINES_12, TEXT,
     +                  FIXED, STACK)
         LINE1 = LINES_12(1)
         LINE2 = LINES_12(2)
         LINE3 = LINES_12(3)
      ELSE
         NCHAR = 25
         LINES_25(1) = LINE1
         LINES_25(2) = LINE2
         LINES_25(3) = LINE3
         CALL W_XLINES (ICOLOR, IXL, IYL, NCHAR, NUMBLD, NUMLIN, NTEXT,
     +                  LINES_25, TEXT,
     +                  FIXED, STACK)
         LINE1 = LINES_25(1)
         LINE2 = LINES_25(2)
         LINE3 = LINES_25(3)
        
      ENDIF     
      END                                  
C 
C---------------------------------------------------------------------
C
      SUBROUTINE W95_REJECT (ICOLOR, ICOUNT, IY)
C
C ACTION : Declare *FATAL* : TEXT
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 26/11/92
C          W95 version ... 26/12/96
C          ICOLOR, and IY are not used in this version
C          MAXTRY must be consistent with limits in the other GET routines
C          In particular, MAXTRY in the calling routines must be > 3
C          02/01/1997 Derived from PUTFAT but calling PATCH1 directly
C          27/01/2001 eliminated PATCH1 and restored direct call to PUTFAT
C          08/02/2007 edited for w_clearwin.dll
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER, INTENT (IN) :: ICOLOR, ICOUNT, IY 
C
C Locals
C      
      INTEGER    MAXTRY
      PARAMETER (MAXTRY = 5)
      INTEGER    L
      INTEGER    LEN200
      CHARACTER  FATAL*128
      EXTERNAL   LEN200
      EXTERNAL   X_PUTFAT
      L = ICOLOR!to silence ftn95
      L = IY!to silence ftn95
      IF (ICOUNT.EQ.1) THEN
         WRITE (FATAL,100)
      ELSEIF (ICOUNT.EQ.2) THEN
         WRITE (FATAL,200)
      ELSEIF (ICOUNT.EQ.3) THEN
         WRITE (FATAL,300)
      ELSEIF (ICOUNT.EQ.MAXTRY) THEN
         WRITE (FATAL,400) MAXTRY
      ELSE
         WRITE (FATAL,500)
      ENDIF
      L = LEN200(FATAL)
      CALL X_PUTFAT (FATAL(1:L))
  100 FORMAT ('Unacceptable  ...  Input another single number')
  200 FORMAT ('Unacceptable  ...  Input another two numbers')
  300 FORMAT ('Unacceptable  ...  Input another three numbers')
  400 FORMAT ('Unacceptable  ...  Abandoned after',I3,
     +' failed attempts')
  500 FORMAT ('Input rejected  ...  Try again')
      END
C
C
