C
C
      SUBROUTINE VBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                   NUMOPT, NUMPOS, NUMSTA, NUMTXT, TEXT,
     +                   BORDER, FLASH, HIGH)
C
C ACTION : Get a decision from a v-type button box
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 5/2/97  
C          30/05/2007 now just calls W_VBOX01
C          06/03/2012 added error messages
C
      IMPLICIT   NONE                             
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IXL, IYL, LSHADE,
     +                                       NUMOPT, NUMSTA, NUMTXT
      INTEGER,             INTENT (INOUT) :: NUMDEC
      INTEGER,             INTENT (IN)    :: NUMBLD(NUMTXT),
     +                                       NUMPOS(NUMOPT)
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT(NUMTXT)
      LOGICAL,             INTENT (IN)    :: BORDER, FLASH, HIGH
C
C Locals
C      
      INTEGER    JCOLOR
      EXTERNAL   W_VBOX01, PUTFAT
      IF (NUMSTA.LT.1) THEN
         CALL PUTFAT ('NUMSTA < 1 in call to VBOX01')
         RETURN
      ENDIF
      IF (NUMTXT.LT.1) THEN
         CALL PUTFAT ('NUMTXT < 1 in call to VBOX01')
         RETURN
      ENDIF
      IF (NUMOPT.LT.1) THEN
         CALL PUTFAT ('NUMOPT < 1 in call to VBOX01')
         RETURN   
      ENDIF   
      IF (NUMSTA + NUMOPT - 1.GT.NUMTXT) THEN
         CALL PUTFAT ('NUMSTA + NUMOPT - 1 > NUMTXT in call to VBOX01')
         RETURN
      ENDIF
      IF (NUMDEC.LT.1 .OR. NUMDEC.GT.NUMOPT) THEN
         CALL PUTFAT ('NUMDEC out of range in call to VBOX01')
         NUMDEC = NUMOPT
         RETURN
      ENDIF        
      IF (NUMOPT.EQ.1) THEN
         NUMDEC = 1
         RETURN
      ENDIF 
      IF (ICOLOR.EQ.0 .OR. ICOLOR.EQ.1 .OR. ICOLOR.EQ.4) THEN
         JCOLOR = ICOLOR
      ELSE
         JCOLOR = 7
      ENDIF
      CALL W_VBOX01 (JCOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +               NUMOPT, NUMPOS, NUMSTA, NUMTXT,
     +               TEXT,
     +               BORDER, FLASH, HIGH)
      END
C
C
