C
C
      SUBROUTINE VBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                   OPTS)
C
C ACTION : Get a decision from a v-type button box
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 5/2/97
C          08/01/2001 introduced NMAX 
C          02/03/2007 added INTENTS and ALLOCATABLE
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IX, IY, NUMOPT,
     +                                       NUMPOS(NUMOPT) 
      INTEGER,             INTENT (INOUT) :: NUMDEC 
      CHARACTER (LEN = *), INTENT (IN)    :: OPTS(NUMOPT)
C
C Local allocatable array 
C 
      INTEGER, ALLOCATABLE :: NUMBLD(:)     
C                        
C Locals
C      
      INTEGER    LSHADE, NSTART, NUMOPT_NEW
      PARAMETER (LSHADE = 0, NSTART = 1)
      INTEGER    I, IERR, NMAX, NTEXT
      INTEGER    JCOLOR
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .FALSE.)
      EXTERNAL   W_VBOX01
      INTRINSIC  MIN 
C
C Allocate
C           
      IERR = 0
      IF (ALLOCATED(NUMBLD)) DEALLOCATE(NUMBLD, STAT = IERR)
      IF (IERR.NE.0) RETURN
      NMAX = NUMOPT + 1
      ALLOCATE(NUMBLD(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Initialise
C      
      NUMOPT_NEW = MIN(NMAX,NUMOPT)
      DO I = 1, NUMOPT_NEW
         NUMBLD(I) = 0
      ENDDO
      NTEXT = NUMOPT_NEW
      IF (ICOLOR.EQ.0 .OR. ICOLOR.EQ.1 .OR. ICOLOR.EQ.4) THEN
         JCOLOR = ICOLOR
      ELSE
         JCOLOR = 7
      ENDIF
C
C Call
C      
      CALL W_VBOX01 (JCOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT_NEW,
     +               NUMPOS, NSTART, NTEXT,
     +               OPTS,
     +               BORDER, FLASH, HIGH)
C
C Deallocate
C     
      DEALLOCATE(NUMBLD, STAT = IERR)
      END
C
C
