C
C
      SUBROUTINE VEC1IN (ISEND, NIN, NMAX, NPTS,
     +                   X,
     +                   FNAME, TITLE,
     +                   ABORT, FIXNPT, LABEL)
C
C ACTION : Input data points X
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 20/11/90
C
C          14/05/1992 GETNUM
C          03/10/1992 removed CLOSE statements
C          18/01/1993 added NBIG, GET???, removed J, N3, ONETO9, STEMP, XTEMP,
C                     YTEMP and compressed
C          20/01/1993 derived from DATTIN
C          22/01/1993 derived from VEC2IN
C          21/02/1994 DBOS version
C          10/11/1995 Swapped TITLES for ANSWER and introduced TRIML1
C          04/09/1996 Added CHKFIL
C          10/02/1997 Win32 version
C          28/10/1998 subsituted TITLE2 for TITLES
C          05/04/2000 Added extra CLOSE (UNIT = NIN)
C          08/05/2000 Removed the CLOSE after successful file opening
C                     since it may be required to read the trailer
C          08/01/2001 Changed wording to mention clipboard
C          28/11/2001 added VU2CHK
C          28/05/2002 added FNAME to argument list to CHKFIL and removed VU2CHK
C          02/02/2005 added VECVAL, NTEMP, CHECKF and ATTRIB, and altered control
C          16/07/2007 added SIM256 and YMDHMS for version 6
C          01/08/2008 introduced call to ISITSF
C          11/05/2010 introduced NKLCFG to switch on/off the TYPE-IN-DATA option 
C          18/04/2011 improved the input data page 
C          04/04/2015 replaced PUTADV by INFOFL
C          01/09/2015 made ISEND intent (in), added KSEND and call to SWITCH
C
C          ISEND: (input/unchanged) as follows
C                 ISEND = 1: user inputs TITLE etc. and ISEND is unchanged
C                 ISEND = 2: TITLE etc. from file and ISEND is unchanged
C                 OTHERWISE: user chooses mode 
C            NIN: (input/unchanged) unconnected unit for data input
C                 Note: if an existing file is successfully opened, then NIN is
C                       returned connected for further reading. Otherwise NIN is
C                       closed on exit
C           NMAX: (input/unchanged) maximum dimension
C           NPTS: (input/output) size of X as follows
C                  FIXNPT = .TRUE. then NPTS is unchanged
C                  FIXNPT = .FALSE. then NPTS is arbitrary
C          FNAME: (output) as follows
C                  ISEND = 1: file supplied by user (unchanged)
C                  OTHERWISE: temporary file name like vector_k.tmp
C           TITLE: (output) as follows
C                  ISEND = 1: read off file
C                  OTHERWISE: returned depending on LABEL
C           ABORT: (output) error indicator
C          FIXNPT: (input/unchanged)
C                  FIXNPT = .TRUE. return exactly NPTS data points
C                  FIXNPT = .FALSE. then return arbitrary NPTS data points
C           LABEL: (input/unchanged) as follows if data are to be typed in
C                  LABEL = .TRUE. then the user supplies a title
C                  LABEL = .FALSE. a temporary title is supplied
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ISEND, NIN, NMAX
      INTEGER,             INTENT (INOUT) :: NPTS 
      DOUBLE PRECISION,    INTENT (OUT)   :: X(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE
      LOGICAL,             INTENT (IN)    :: FIXNPT, LABEL
      LOGICAL,             INTENT (OUT)   :: ABORT 
C
C Locals
C
      INTEGER    N0, N1, N2, N3, N22, N34, NBIG
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N22 = 22, N34 = 34, 
     +           NBIG = 50)
      INTEGER    NCBOT, NCMID, NCTOP, NRBOT, NRMID, NRTOP
      PARAMETER (NCBOT = 1, NCTOP = 1)
      INTEGER    I, ICOUNT, IOS, J, KSEND, NPTSAV, NTEMP
      INTEGER    KVAL10, NKLCFG
      INTEGER    ICOLOR, NUMDEC, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 7, NUMHDR = 21, NUMOPT = 3)
      INTEGER    JSEND
      PARAMETER (JSEND = 2)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER (LEN = 1024) SIM256
      CHARACTER (LEN = 100 ) HEADER(NUMHDR), LINE
      CHARACTER (LEN = 20  ) OPTION(NUMOPT)
      CHARACTER (LEN = 15  ) WORD15
      CHARACTER (LEN = 8   ) NUM1, NUM2
      LOGICAL    EXIST, READ_ONLY
      EXTERNAL   GETIM1, GETSTR, GETVEC, OFILES, TITLE2, TRIML1, CHKFIL,
     +           PUTFAT, VECVAL, INFOFL, ATTRIB, CHECKF, GETTMP, SIM256,
     +           YMDHMS, ISITSF, SWITCH
      EXTERNAL   NKLCFG
      INTRINSIC  MIN
      DATA       NUMBLD / 1*4, 1*0, 1*2, 14*0, 2*1, 2*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION / 'File/clipboard',
     +                    'Type-in data',
     +                    'Suppress' /
C
C Initialise ABORT then define NRBOT, NRTOP and NPTSAV
C
      KSEND = ISEND
      ABORT = .TRUE.
      IF (NIN.LT.N1 .OR. NMAX.LT.N1) THEN
         WRITE (LINE,100)
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
      IF (FIXNPT) THEN
         IF (NPTS.LT.N1 .OR. NPTS.GT.NMAX) THEN
            WRITE (LINE,100)
            CALL PUTFAT (LINE)
            RETURN
         ENDIF
         NRBOT = NPTS
         NRTOP = NPTS
         NPTSAV = NPTS
      ELSE
         NRBOT = N1
         NRTOP = NMAX
         NPTSAV = - N1
      ENDIF
C
C Special action if KSEND (i.e. ISEND) is not 1 or 2
C
      IF (KSEND.LT.N1 .OR. KSEND.GT.N2) THEN
         KVAL10 = NKLCFG(N22)
         IF (KVAL10.EQ.N1) THEN
            WRITE (NUM1,'(I8)') NMAX
            WRITE (NUM2,'(I8)') MIN(NBIG, NMAX)
            CALL TRIML1 (NUM1)
            CALL TRIML1 (NUM2)
            WRITE (HEADER,200) NUM1, NUM2
            NUMDEC = N1
            CALL TITLE2 (ICOLOR, NUMBLD, NUMDEC, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            NUMDEC = N1
         ENDIF   
         IF (NUMDEC.EQ.N1) THEN
            KSEND = N2
         ELSEIF (NUMDEC.EQ.N2) THEN
            KSEND = N1
         ELSE
            KSEND = N2 
            CALL SWITCH (N34)  
         ENDIF
      ENDIF
      IF (KSEND.EQ.N1) THEN
C
C Type in the data
C
         WRITE (TITLE,300)
         IF (LABEL) THEN
            WRITE (LINE,400)
            CALL GETSTR (LINE, TITLE)
         ENDIF
         IF (.NOT.FIXNPT) THEN
            WRITE (LINE,500)
            CALL GETIM1 (N1, NPTS, MIN(NBIG, NMAX),
     +                   LINE)
         ENDIF
         WRITE (LINE,600)
         CALL GETVEC (NPTS,
     +                X,
     +                LINE)
C
C Create a temporary file
C
         CALL VECVAL (N1, NTEMP,
     +                ABORT)
         IF (ABORT) THEN
            CALL GETTMP (I,
     +                   FNAME)
         ELSE
            CALL VECVAL (N2, NTEMP,
     +                   ABORT)
            IF (ABORT) THEN
               CALL GETTMP (I,
     +                      FNAME)
            ELSE
               CLOSE (UNIT = NIN)
               IF (NTEMP.LT.10) THEN
                  WRITE (WORD15,700) NTEMP
               ELSEIF (NTEMP.LT.100) THEN
                  WRITE (WORD15,800) NTEMP
               ELSE
                  WRITE (WORD15,900) NTEMP
               ENDIF
               FNAME = SIM256(WORD15)
               CALL ATTRIB (FNAME,
     +                      EXIST, READ_ONLY)
               IF (EXIST .AND. READ_ONLY) THEN
                  WRITE (LINE,1000) WORD15
                  CALL PUTFAT (LINE)
                  CALL GETTMP (I,
     +                         FNAME)
               ENDIF
            ENDIF
         ENDIF
         OPEN (UNIT = NIN, FILE = FNAME)
         WRITE (NIN,'(A)') TITLE
         WRITE (NIN,'(2I6)') NPTS, N1
         DO I = N1, NPTS
            WRITE (NIN,'(1P,E14.6)') X(I)
         ENDDO
         WRITE (NIN,'(I6)') N1
         CALL YMDHMS (LINE)
         WRITE (NIN,'(A)') LINE
         CLOSE (UNIT = NIN)
         CALL INFOFL (JSEND,
     +                FNAME)        
         ABORT = .FALSE.
         RETURN
      ELSE
C
C Read in the data from a file
C
         CLOSE (UNIT = NIN)
         CALL OFILES (N3, NIN,
     +                FNAME,
     +                ABORT)
         CLOSE (UNIT = NIN)
         IF (ABORT) THEN
            FNAME = 'No current file'
            TITLE = 'no current data'
            RETURN
         ENDIF
         CALL ISITSF (NCMID, NRMID,
     +                FNAME)
         IF (NCMID.GT.N0 .AND. NRMID.GT.N0) THEN
            OPEN (UNIT = NIN, FILE = FNAME)
         ELSE
            ABORT = .TRUE.
            FNAME = 'No current file'
            TITLE = 'no current data'           
            RETURN
         ENDIF            
         ABORT = .TRUE.
         NCMID = - N1
         NRMID = - N1
         ICOUNT = N1
         READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
         IF (IOS.NE.0) GOTO 20
         ICOUNT = N2
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
         IF (IOS.NE.0) GOTO 20
         NCMID = J
         NRMID = I
         IF (NRMID.LT.N1 .OR. NRMID.GT.NMAX) GOTO 20
         IF (NCMID.NE.N1) GOTO 20
         IF (FIXNPT .AND. NRMID.NE.NPTSAV) GOTO 20
C
C Give user the choice view/accept/reject
C
         CLOSE (UNIT = NIN)
         CALL CHECKF (FNAME, TITLE,
     +                ABORT)
         IF (ABORT) THEN
            FNAME = 'No current file'
            TITLE = 'No current data'
            RETURN
         ELSE
            OPEN (UNIT = NIN, FILE = FNAME)
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
         ENDIF
         NPTS = NRMID
         DO I = N1, NPTS
            ICOUNT = ICOUNT + N1
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) X(I)
            IF (IOS.NE.0) GOTO 20
         ENDDO
         ABORT = .FALSE.
         RETURN
      ENDIF
C
C Label 20: Here if a crash has occurred
C =========
C
   20 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      CALL CHKFIL (ICOUNT, IOS, NCBOT, NCMID, NCTOP, NRBOT, NRMID,
     +             NRTOP,
     +             FNAME, TITLE)
      FNAME = 'No current file'
      TITLE = 'No current data'   
C
C Format statements
C      
  100 FORMAT ('NIN, NPTS, or NMAX out of range in call to VEC1IN')
  200 FORMAT (
     + 'Alternative methods for providing a table of data values'
     +/
     +/'To switch [Type-in data] on or off use [Configure]',
     +', [Advanced], [Speedup].'
     +/
     +/'1)`Simfit data files can be just a simple list of values but'
     +/'  `may have an optional title and a header with the number'
     +/'  `of rows (i.e. cases) and the number of columns (i.e. 1).'
     +/'  `Extra details can also be appended after the data.'
     +/'2)`Such files can be prepared/edited by Makmat/Editmt, or'
     +/'  `using any text editor, e.g. Notepad.'
     +/'3)`With small data sets, you can type in values now, when a'
     +/'  `temporary file called vector_k.tmp (0 =< k =< 20) will'
     +/'  `be created for you to save or discard retrospectively.'
     +/'4)`Clipboard or spreadsheet data must have no missing values,'
     +/'  `but can include row and column labels if required.'
     +/'5)`You can also use macros, e.g. Excel with simfit6.xls.' 
     +/ 
     +/'Maximum number of values input from file/clipboard =',1X,A
     +/'Maximum number of values typed in from the terminal =',1X,A
     +/
     +/'[Suppress] switches off future options to [Type-in data] from',
     + ' the terminal.')           
  300 FORMAT ('Temporary data')
  400 FORMAT ('Title for this data set')
  500 FORMAT ('The number of data values you want to type in now')
  600 FORMAT ('Data items should now be input one line at a time')
  700 FORMAT ('vector_',I1,'.tmp')
  800 FORMAT ('vector_',I2,'.tmp')
  900 FORMAT ('vector_',I3,'.tmp')
 1000 FORMAT ('Read_only file encountered ... Use attrib -r',1X,A)
      END
C
C
