C
C
      SUBROUTINE VEC2IN (NIN, NMAX, NPTS,
     +                   X,
     +                   FNAME, TITLE,
     +                   ABORT)
C
C ACTION : Read X from a vector file
C          NIN = UNIT number for file opening
C          NMAX = maximum dimension for X
C          NPTS = dimension of X
C
C AUTHOR : W. G. Bardsley, University of Manchester
C          13/12/96 Derived from VEC1IN
C          28/11/2001 added call to VU2CHK
C          28/05/2002 added FNAME to CHKFIL and suppressed VU2CHK 
C          02/03/2007 added INTENTS  
C                                        
C Normally this subroutine just opens a named file and redefines the TITLE,
C NPTS, and X so that NPTS > 0 on exit. On error exit then NPTS = 0 and the
C filename and title are re-initilaised
C
C   NIN: (input/unchanged) unconnected unit for data input
C  NMAX: (input/unchanged) maximum vector size
C  NPTS: (input/output) sometimes NPTS has been defined but can be redefined 
C     X: (input/output) sometimes X has been defined but can be redefined
C FNAME: (input/output) an existing vector file but can be redefined
C TITLE: (input/output) sometimes TITLE has been defined but can be redefined
C
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NIN, NMAX 
      INTEGER,             INTENT (INOUT) :: NPTS
      DOUBLE PRECISION,    INTENT (INOUT) :: X(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE  
C
C Locals
C      
      INTEGER    N0, N1, N2, N4
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N4 = 4)
      INTEGER    I, ICOUNT, IOS, J, NCOL, NROW
      LOGICAL    ABORT
      EXTERNAL   CHKFIL, OFILES
C
C Read in the data from a file
C
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      CALL OFILES (N4, NIN,
     +             FNAME,
     +             ABORT)
      IF (ABORT) THEN
         CLOSE (UNIT = NIN)
         NPTS = N0 
         FNAME = 'No file'
         TITLE = 'No data' 
         RETURN
      ENDIF
      ABORT = .TRUE.
      NCOL = - N1
      NROW = - N1
      ICOUNT = N1
      READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
      IF (IOS.NE.0) GOTO 20
      ICOUNT = N2
      READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) J, I
      IF (IOS.NE.0) GOTO 20
      NCOL = I
      NROW = J
      IF (NROW.LT.N1 .OR. NROW.GT.NMAX) GOTO 20
      IF (NCOL.NE.N1) GOTO 20
      NPTS = NROW
      DO I = N1, NPTS
         ICOUNT = ICOUNT + N1
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) X(I)
         IF (IOS.NE.0) GOTO 20
      ENDDO
      CLOSE (UNIT = NIN)
      ABORT = .FALSE.
      RETURN
C
C Here if a crash has occurred
C
   20 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      CALL CHKFIL (ICOUNT, IOS, N1, NCOL, N1, N1, NROW, NMAX,
     +             FNAME, TITLE)
      NPTS = N0 
      FNAME = 'No file'
      TITLE = 'No data'    
      END
C
C
