C
C
      SUBROUTINE VEC3IN (ISEND, NIN, NPTS,
     +                   FNAME, TITLE,
     +                   ABORT, FIXNPT, LABEL)
C
C ACTION : Input NPTS data points X(i) from console or file
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          17/01/2006 derived from VEC1IN  
C          02/03/2007 added INTENTS 
C          06/06/2007 corrected FORMAT 100
C          17/07/2007 added SIM256 and YMDHMS for version 6 
C          01/08/2008 added call to ISITSF
C          11/05/2010 introduced NKLCFG to switch on/off the TYPE-IN-DATA option 
C          19/04/2011 edited main menu
C          04/04/2015 replaced PUTADV by INFOFL
C          01/09/2015 made ISEND intent (in), added KSEND and call to SWITCH
C
C          ISEND: (input/unchanged) as follows
C                 ISEND = 1: user inputs TITLE etc. and ISEND is unchanged
C                 ISEND = 2: TITLE etc. from file and ISEND is unchanged
C                 OTHERWISE: user chooses mode 
C            NIN: (input/unchanged) unconnected unit for data input
C                 Note: if an existing file is successfully opened, then NIN is
C                       returned connected for further reading. Otherwise NIN is
C                       closed on exit
C           NPTS: (input/output) size of X as follows
C                  FIXNPT = .TRUE. then NPTS is unchanged
C                  FIXNPT = .FALSE. then NPTS is arbitrary
C          FNAME: (output) as follows
C                  ISEND = 1: file supplied by user (unchanged)
C                  OTHERWISE: temporary file name like vector_k.tmp
C           TITLE: (output) as follows
C                  ISEND = 1: read off file
C                  OTHERWISE: returned depending on LABEL
C           ABORT: (output) error indicator
C          FIXNPT: (input/unchanged)
C                  FIXNPT = .TRUE. return exactly NPTS data points
C                  FIXNPT = .FALSE. then return arbitrary NPTS data points
C           LABEL: (input/unchanged) as follows if data are to be typed in
C                  LABEL = .TRUE. then the user supplies a title
C                  LABEL = .FALSE. a temporary title is supplied
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ISEND, NIN 
      INTEGER,             INTENT (INOUT) :: NPTS
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE
      LOGICAL,             INTENT (IN)    :: FIXNPT, LABEL    
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Local allocatable array
C
      DOUBLE PRECISION, ALLOCATABLE :: X(:)
C
C Locals
C
      INTEGER    N0, N1, N2, N3, N4, N22, N34, NBIG, NVBIG, NMAX
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N22 = 22,
     +           N34 = 34, NBIG = 50, NVBIG = 1000000)
      INTEGER    NCBOT, NCMID, NCTOP, NRBOT, NRMID, NRTOP
      PARAMETER (NCBOT = 1, NCTOP = 1)
      INTEGER    I, ICOUNT, IOS, J, KSEND, NPTSAV, NTEMP
      INTEGER    KVAL10, NKLCFG
      INTEGER    ICOLOR, NUMDEC, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 7, NUMHDR = 21, NUMOPT = 3)
      INTEGER    JSEND
      PARAMETER (JSEND = 2)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER (LEN = 1024) SIM256
      CHARACTER (LEN = 100 ) HEADER(NUMHDR), LINE
      CHARACTER (LEN = 30  ) NUM1
      CHARACTER (LEN = 20  ) OPTION(NUMOPT)
      CHARACTER (LEN = 15  ) WORD15
      CHARACTER (LEN = 8   ) NUM2
      CHARACTER (LEN = 30  ) NO_DATA, NO_FILE, NO_LIMIT
      PARAMETER (NO_DATA = 'No current data',
     +           NO_FILE = 'No current file',
     +           NO_LIMIT = 'No limit')
      LOGICAL    EXIST, READ_ONLY
      EXTERNAL   GETIM1, GETSTR, GETVEC, OFILES, TITLE2, TRIML1, CHKFIL,
     +           PUTFAT, VECVAL, INFOFL, ATTRIB, CHECKF, GETTMP, VEC1IN,
     +           SIM256, YMDHMS, ISITSF, SWITCH
      EXTERNAL   NKLCFG
      DATA       NUMBLD / 1*1, 1*0, 1*2, 14*0, 2*1, 2*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION / 'File/Clipboard',
     +                    'Type-in-data',
     +                    'Suppress' /
C
C Initialise and check NIN
C
      KSEND = ISEND
      ABORT = .TRUE.
      IF (NIN.LT.N1) THEN
         WRITE (LINE,100) 'NIN < 1'
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
C
C Deallocate X
C
      IOS = N0
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IOS)
      IF (IOS.NE.N0) THEN
         WRITE (LINE,100) 'Cannot deallocate X'
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
C
C If FIXNPT call VEC1IN directly
C
      IF (FIXNPT) THEN
         IF (NPTS.LT.N1) THEN
            WRITE (LINE,100) 'NPTS < 1'
            CALL PUTFAT (LINE)
            RETURN
         ELSE
            NMAX = NPTS
            ALLOCATE(X(NMAX), STAT = IOS)
            IF (IOS.NE.N0) THEN
               WRITE (LINE,100) 'Cannot allocate X'
               CALL PUTFAT (LINE)
               DEALLOCATE(X, STAT = IOS)
               RETURN
            ELSE
               CALL VEC1IN (ISEND, NIN, NMAX, NPTS,
     +                      X,
     +                      FNAME, TITLE,
     +                      ABORT, FIXNPT, LABEL)
               IF (ABORT) THEN
                  FNAME = NO_FILE
                  TITLE = NO_DATA
               ENDIF
               DEALLOCATE(X, STAT = IOS)
               RETURN
            ENDIF
         ENDIF
      ELSE
         NRBOT = N1
         NRTOP = NVBIG
         NPTSAV = - N1
      ENDIF
C
C Special action if KSEND (i.e. ISEND) not 1 or 2
C
      IF (KSEND.LT.N1 .OR. KSEND.GT.N2) THEN
         KVAL10 = NKLCFG(N22)
         IF (KVAL10.EQ.N1) THEN
            WRITE (NUM1,'(A)') NO_LIMIT
            WRITE (NUM2,'(I8)') NBIG
            CALL TRIML1 (NUM1)
            CALL TRIML1 (NUM2)
            WRITE (HEADER,200) NUM1, NUM2
            NUMBLD(1) = N4
            NUMDEC = N1
            CALL TITLE2 (ICOLOR, NUMBLD, NUMDEC, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER,
     +                   OPTION)
         ELSE
            NUMDEC = N1
         ENDIF   
         IF (NUMDEC.EQ.N1) THEN
            KSEND = N2
         ELSEIF (NUMDEC.EQ.N2) THEN
            KSEND = N1
         ELSE
            KSEND = N2
            CALL SWITCH (N34)   
         ENDIF
      ENDIF
      IF (KSEND.EQ.N1) THEN
C
C Type in the data
C
         NMAX = NBIG
         ALLOCATE(X(NMAX), STAT = IOS)
         IF (IOS.NE.N0) THEN
            WRITE (LINE,100) 'Cannot allocate X'
            CALL PUTFAT (LINE)
            FNAME = NO_FILE
            TITLE = NO_DATA
            ABORT = .TRUE.
            DEALLOCATE(X, STAT = IOS)
            RETURN
         ENDIF
         WRITE (TITLE,300)
         IF (LABEL) THEN
            WRITE (LINE,400)
            CALL GETSTR (LINE, TITLE)
         ENDIF
         IF (.NOT.FIXNPT) THEN
            WRITE (LINE,500)
            CALL GETIM1 (N1, NPTS, NMAX,
     +                   LINE)
         ENDIF
         WRITE (LINE,600)
         CALL GETVEC (NPTS,
     +                X,
     +                LINE)
C
C Create a temporary file
C
         CALL VECVAL (N1, NTEMP,
     +                ABORT)
         IF (ABORT) THEN
            CALL GETTMP (I,
     +                   FNAME)
         ELSE
            CALL VECVAL (N2, NTEMP,
     +                   ABORT)
            IF (ABORT) THEN
               CALL GETTMP (I,
     +                      FNAME)
            ELSE
               CLOSE (UNIT = NIN)
               IF (NTEMP.LT.10) THEN
                  WRITE (WORD15,700) NTEMP
               ELSEIF (NTEMP.LT.100) THEN
                  WRITE (WORD15,800) NTEMP
               ELSE
                  WRITE (WORD15,900) NTEMP
               ENDIF
               FNAME = SIM256(WORD15)
               CALL ATTRIB (FNAME,
     +                      EXIST, READ_ONLY)
               IF (EXIST .AND. READ_ONLY) THEN
                  WRITE (LINE,1000) WORD15
                  CALL PUTFAT (LINE)
                  CALL GETTMP (I,
     +                         FNAME)
               ENDIF
            ENDIF
         ENDIF
         OPEN (UNIT = NIN, FILE = FNAME)
         WRITE (NIN,'(A)',IOSTAT=IOS) TITLE
         WRITE (NIN,'(2I6)',IOSTAT=IOS) NPTS, N1
         DO I = N1, NPTS
            WRITE (NIN,'(1P,E14.6)',IOSTAT=IOS) X(I)
         ENDDO
         WRITE (NIN,'(I6)',IOSTAT=IOS) N1
         CALL YMDHMS (LINE)
         WRITE (NIN,'(A)',IOSTAT=IOS) LINE
         CLOSE (UNIT = NIN)
         CALL INFOFL (JSEND,
     +                FNAME)       
         ABORT = .FALSE.
         DEALLOCATE(X, STAT = IOS)
         RETURN
      ELSE
C
C Read in the data from a file
C
         CLOSE (UNIT = NIN)
         CALL OFILES (N3, NIN,
     +                FNAME,
     +                ABORT)
         CLOSE (UNIT = NIN)
         IF (ABORT) THEN
            FNAME = NO_FILE
            TITLE = NO_DATA
            RETURN
         ENDIF
         CALL ISITSF (NCMID, NRMID,
     +                FNAME)
         IF (NCMID.GT.N0 .AND. NRMID.GT.N0) THEN
            OPEN (UNIT = NIN, FILE = FNAME)
         ELSE
            ABORT = .TRUE.
            FNAME = NO_FILE
            TITLE = NO_DATA
            RETURN           
         ENDIF              
         ABORT = .TRUE.
         NCMID = - N1
         NRMID = - N1
         ICOUNT = N1
         READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
         IF (IOS.NE.0) GOTO 20
         ICOUNT = N2
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
         IF (IOS.NE.0) GOTO 20
         NCMID = J
         NRMID = I
         NMAX = NRMID
         IF (NRMID.LT.N1) GOTO 20
         IF (NCMID.NE.N1) GOTO 20
         IF (FIXNPT .AND. NRMID.NE.NPTSAV) GOTO 20
C
C Give user the choice view/accept/reject
C
         CLOSE (UNIT = NIN)
         CALL CHECKF (FNAME, TITLE,
     +                ABORT)
         IF (ABORT) THEN
            FNAME = NO_FILE
            TITLE = NO_DATA
            RETURN
         ELSE
            OPEN (UNIT = NIN, FILE = FNAME)
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
         ENDIF
         ALLOCATE(X(NMAX), STAT = IOS)
         IF (IOS.NE.N0) THEN
            WRITE (LINE,100) 'Cannot allocate X'
            FNAME = NO_FILE
            TITLE = NO_DATA
            ABORT = .TRUE.
            DEALLOCATE(X, STAT = IOS)
            RETURN
         ENDIF
         NPTS = NRMID
         DO I = N1, NPTS
            ICOUNT = ICOUNT + N1
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) X(I)
            IF (IOS.NE.0) GOTO 20
         ENDDO
         ABORT = .FALSE.
         DEALLOCATE(X, STAT = IOS)
         RETURN
      ENDIF
C
C Label 20: Here if a crash has occurred
C =========
C
   20 CONTINUE
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IOS)
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      CALL CHKFIL (ICOUNT, IOS, NCBOT, NCMID, NCTOP, NRBOT, NRMID,
     +             NRTOP,
     +             FNAME, TITLE)
      FNAME = NO_FILE
      TITLE = NO_DATA         
C
C Format statements
C      
  100 FORMAT (A,1X,'in call to VEC3IN')
  200 FORMAT (
     + 'Alternative methods for providing a table of data values'
     +/
     +/'To switch [Type-in data] on or off use [Configure]',
     +', [Advanced], [Speedup].'
     +/
     +/'1)`Simfit data files can be just a simple list of values but'
     +/'  `may have an optional title and a header with the number'
     +/'  `of rows (i.e. cases) and the number of columns (i.e. 1).'
     +/'  `Extra details can also be appended after the data.'
     +/'2)`Such files can be prepared/edited by Makmat/Editmt, or'
     +/'  `using any text editor, e.g. Notepad.'
     +/'3)`With small data sets, you can type in values now, when a'
     +/'  `temporary file called vector_k.tmp (0 =< k =< 20) will'
     +/'  `be created for you to save or discard retrospectively.'
     +/'4)`Clipboard or spreadsheet data must have no missing values,'
     +/'  `but can include row and column labels if required.'
     +/'5)`You can also use macros, e.g. Excel with simfit6.xls.' 
     +/ 
     +/'Maximum number of values input from file/clipboard =',1X,A
     +/'Maximum number of values typed in from terminal =',1X,A 
     +/
     +/'[Suppress] switches off future options to [Type-in data] from',
     + ' the terminal.')       
  300 FORMAT ('Temporary data')
  400 FORMAT ('Title for this data set')
  500 FORMAT ('The number of data values you want to type in now')
  600 FORMAT ('Data items should now be input one line at a time')
  700 FORMAT ('vector_',I1,'.tmp')
  800 FORMAT ('vector_',I2,'.tmp')
  900 FORMAT ('vector_',I3,'.tmp')
 1000 FORMAT ('Read_only file encountered ... Use attrib -r',1X,A)
      END
C
C
