C
C
      SUBROUTINE VEC4IN (NZ,
     +                   Z,
     +                   FNAMEZ, HEADER, TITLEZ,
     +                   ABORT, NEWDAT)
C
C ACTION : Get a vector
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          19/01/2006 derived from VECONE
C          01/02/2006 added header to argument list
C          15/02/2006 added FNAMEZ to argument list
C          20/05/2006 code for new functionality of VECTRN
C          02/03/2007 added INTENTS
C          11/10/2007 edited for version 6 so that FNAMEZ and TITLEZ can be redefined
C          19/04/2011 edited main menu
C
C           NZ: (input/unchanged) sample size
C            Z: (input/output) sample (may be edited)
C       FNAMEZ: (input/output) data file (changed if data are transformed or edited) 
C       HEADER: (input/unchanged) header for menu
C       TITLEZ: (input/output) title (changed if data are transformed or edited)
C        ABORT: (output) error indicator
C       NEWDAT: (output) requests new data
C
C Note: This version has these features.
C       It does not allow NZ to be changed by editing or transformation.
C       It returns ABORT = .TRUE. if there are no appropriate data, or the user
C       has selected Cancel to abort further calculations. It does not set
C       ABORT = .TRUE. if the user fails to read in data as it will just leave
C       any existing data unchanged. This involves the use of ZNEW so it
C       is important that NRMAX >= NZ.
C       NEWDAT is returned as .TRUE. only if new data are requested.
C       If data are transformed or edited, a temporary file of the form
C       vector_n.tmp with a user defined title will be created.
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NZ
      DOUBLE PRECISION,    INTENT (INOUT) :: Z(NZ)
      CHARACTER (LEN = *), INTENT (IN)    :: HEADER
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAMEZ, TITLEZ
      LOGICAL,             INTENT (OUT)   :: ABORT, NEWDAT
C
C Local allocatable workspace
C
      DOUBLE PRECISION, ALLOCATABLE :: ZNEW(:)
C
C Locals
C
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 8,
     +           NSTART = 14, NTEXT = NUMOPT + NSTART - 1)
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N9, NRMAX
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N6 = 6, N9 = 9)
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      INTEGER    ITYPE, NCOL, NROW, NVEC
      PARAMETER (ITYPE = 1, NCOL = 1)
      INTEGER    I, IEDIT, IERR, ISEND, ITRAN, NOUT
      CHARACTER (LEN = 12) FORM12, WORD12
      CHARACTER  SIM256*1024, TEMP*1024, WORD14*14, WORD32*32,
     +           ZFNAME*80, ZTITLE*80
      CHARACTER  CHOP80*80, CIPHER*30, LINE*100, TEXT(30)*100, TRIM80*80
      CHARACTER  BLANK*1, DONE*30, NODATA*30, READY*30, STATE*30
      PARAMETER ( BLANK = ' ',
     +             DONE = '(... Edited ...)',
     +           NODATA = '(... No data ...)',
     +            READY = '(*** Ready ***)')
      LOGICAL    EXIST, READ_ONLY, REPEET
      LOGICAL    BORDER, FLASH, HIGH, MORE
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT
      PARAMETER (CURVE = .FALSE., FIXCOL = .TRUE., FIXROW = .FALSE.,
     +           LABEL = .TRUE., ORDER = .FALSE., WEIGHT = .FALSE.)
      EXTERNAL   PUTFAT, LBOX01, VECTRN, GETSTR, EDITOR, CHOP80, VECVAL,
     +           PATCH1, TRIM80, VIEWER, GETNOU, SIM256, INFOFL, YMDHMS,
     +           ATTRIB, FORM12 
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Allocate workspace
C
      IERR = 0
      IF (ALLOCATED(ZNEW)) DEALLOCATE(ZNEW, STAT = IERR)
      IF (IERR.NE.0) RETURN
      NRMAX = NZ
      ALLOCATE(ZNEW(NRMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Initialise
C
      ABORT = .FALSE.
      NEWDAT = .FALSE.
      ZFNAME = TRIM80(FNAMEZ)
      ZTITLE = CHOP80(TITLEZ)
      IEDIT = N0
      ITRAN = N0
C
C Loop
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (NZ.LT.N2) THEN
            STATE = NODATA
            NUMDEC = N5
         ELSE
            STATE = READY
            NUMDEC = N1
         ENDIF
         IF (IEDIT.GT.N0 .OR. ITRAN.GT.N0) THEN
            CIPHER = DONE
         ELSE
            CIPHER = BLANK
         ENDIF
         WORD12 = FORM12(NZ)
         WRITE (TEXT,100) HEADER, ZFNAME, ZTITLE, WORD12, STATE, CIPHER
         NUMBLD(1) = N4
         NUMBLD(4) = N1
         NUMBLD(7) = N1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = N0
         NUMBLD(4) = N0
         NUMBLD(7) = N0
         IF (NUMDEC.LT.N5 .AND. NZ.LT.N2) THEN
             WRITE (LINE,200)
             CALL PUTFAT (LINE)
             NUMDEC = N0
         ENDIF
         IF (NUMDEC.EQ.N1) THEN
C
C Analyse
C
            ABORT = .FALSE.
            NEWDAT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C Transform
C
            CALL VECTRN (NZ,
     +                   Z, ZNEW,
     +                   ABORT)
            IF (.NOT.ABORT) THEN
               DO I = N1, NZ
                  Z(I) = ZNEW(I)
               ENDDO
               ITRAN = ITRAN + N1
               WRITE (ZTITLE,300) ITRAN, IEDIT
            ENDIF
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C Edit
C
            WRITE (LINE,400)
            NROW = NZ
            ISEND = N2
C
C Store the old values then call the editor
C
            DO I = N1, NZ
               ZNEW(I) = Z(I)
            ENDDO
            CALL EDITOR (ISEND, ITYPE, NCOL, NRMAX, NROW,
     +                   ZNEW,
     +                   LINE,
     +                   CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT)
C
C See if any values have been edited
C
            MORE = .TRUE.
            I = N0
            DO WHILE (MORE .AND. I.LT.NZ)
               I = I + N1
               IF (Z(I).GT.ZNEW(I) .OR. Z(I).LT.ZNEW(I)) MORE = .FALSE.
            ENDDO
            IF (.NOT.MORE) THEN
               DO I = N1, NZ
                  Z(I) = ZNEW(I)
               ENDDO
               IEDIT = IEDIT + N1
               WRITE (ZTITLE,300) ITRAN, IEDIT
            ENDIF
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C View data
C
            DO I = N1, NZ
               ZNEW(I) = Z(I)
            ENDDO
            WRITE (LINE,500)
            NROW = NZ
            ISEND = N1
            CALL EDITOR (ISEND, ITYPE, NCOL, NRMAX, NROW,
     +                   ZNEW,
     +                   LINE,
     +                   CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT)
         ELSEIF (NUMDEC.EQ.N5) THEN
C
C View file
C
            CALL VIEWER (N1,
     +                   FNAMEZ, BLANK, BLANK)
         ELSEIF (NUMDEC.EQ.N6) THEN
C
C Read in new Z data
C
            ABORT = .FALSE.
            NEWDAT = .TRUE.
            REPEET = .FALSE.
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C Help
C
            WRITE (TEXT,1000)
            I = 20
            NUMBLD(1) = N1
            NUMBLD(8) = N1
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, I,
     +                   TEXT,
     +                   BORDER)
            NUMBLD(1) = N0
            NUMBLD(8) = N0
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Cancel
C
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C If analysis has been requested then check for transforming/editing
C      
      IF (.NOT.ABORT .AND. .NOT.NEWDAT) THEN
         IF (ITRAN.GT.N0 .OR. IEDIT.GT.N0) THEN
C
C Find n as in vector_n.tmp
C           
            ISEND = N1
            CALL VECVAL (ISEND, NVEC,
     +                   ABORT)
            IF (.NOT.ABORT) THEN
               ISEND = N2
               CALL VECVAL (ISEND, NVEC,
     +                      ABORT)
            ENDIF
            IF (.NOT.ABORT) THEN
               IF (NVEC.LE.N9) THEN
                  WRITE (WORD14,700) NVEC
               ELSE
                  WRITE (WORD14,800) NVEC
               ENDIF
               TEMP = SIM256(WORD14)
               CALL ATTRIB (TEMP,
     +                      EXIST, READ_ONLY)
               IF (EXIST .AND. READ_ONLY) THEN
C
C Do nothing as vector_n.tmp is read_only
C                 
                  ISEND = N6
                  CALL INFOFL (ISEND,
     +                         TEMP)
               ELSE    
C
C Overwrite FNAMEZ and TITLEZ
C                              
                  FNAMEZ = TEMP
                  WRITE (TITLEZ,300) ITRAN, IEDIT
                  WRITE (LINE,600)
                  CALL GETSTR (LINE, TITLEZ)
                  CALL GETNOU (NOUT)
                  OPEN (UNIT = NOUT, FILE = FNAMEZ)
                  WRITE (NOUT,'(A)') TITLEZ
                  WRITE (NOUT,'(2I6)') NZ, N1
                  DO I = N1, NZ
                     WRITE (NOUT,'(1P,E15.7)') Z(I)
                  ENDDO
                  WRITE (NOUT,'(I6)') N1
                  CALL YMDHMS (WORD32)
                  WRITE (NOUT,'(A)') WORD32
                  CLOSE (UNIT = NOUT)
                  ISEND = N2
                  CALL INFOFL (ISEND,
     +                          FNAMEZ)                
               ENDIF
            ENDIF      
         ENDIF
         ABORT = .FALSE.    
      ENDIF      
C
C Deallocate workspace
C
      DEALLOCATE(ZNEW, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     + A
     +/
     +/'Name of the current data file is:'
     +/A
     +/
     +/'Title of the current data set is:'
     +/A
     +/
     +/'Transformed or edited data will be written to a'
     +/'temporary file and a new title will be requested.'
     +/
     +/'Current sample size =',1X,A
     +/
     +/'Analyse the current data set',1X,A
     +/'Transform'
     +/'Edit'
     +/'Display the current data set',1X,A
     +/'View the original data file'
     +/'New data'
     +/'Help'
     +/'Quit ... Exit this data input procedure')
  200 FORMAT ('Insufficient data')
  300 FORMAT ('Transforms',I3,', Edits',i3,':.....')
  400 FORMAT ('Editing the current data')
  500 FORMAT ('Viewing the current data')
  600 FORMAT ('A new title for this edited data set')
  700 FORMAT ('vector_',i1,'.tmp')
  800 FORMAT ('vector_',i2,'.tmp')
 1000 FORMAT (
     + 'Supplying a data sample for analysis'
     +/
     +/'The analytical procedure you have selected requires one sample'
     +/'in the form of a column vector with no missing values, that is'
     +/'X with sample size n (where n >= 1), and with the n elements'
     +/'x(1), x(2), ..., x(n) arranged vertically as a column.'
     +/
     +/'Alternative methods to supply data'
     +/'1)`You can make a file using program MAKMAT. This is the best'
     +/'  `method since a permanent copy of your data will be saved'
     +/'  `for future reference.'
     +/'2)`You can create a file from your spreadsheet program, e.g.'
     +/'  `from Excel using a macro such as simfit4.xls.'
     +/'3)`You can copy a column from your spreadsheet to the clipboard'
     +/'  `then paste it in after choosing the [New data] option.'
     +/'4)`You can type in small samples at the terminal.'
     +/'5)`You can edit or transform an existing sample interactively.'
     +/'  `This will not alter the original data set.'
     +/'Any format can be used for data, e.g. 10, 10.0, 1.e1, 1.0e+01,'
     +/'etc. for ten, but you should always supply a meaningful title.')
      END
C
C
