C
C
      SUBROUTINE VECCHK (ISEND, NFILES, NIN, NROW,
     +                   FILES,
     +                   ABORT)
C
C ACTION: Check a set of NFILES SIMFIT vector type files
C AUTHOR: W.G.Bardsley, University of Manchester, U.K. 09/09/99
C         18/01/2006 upgraded  
C         02/03/2007 added INTENTS
C
C ISEND: (input/unchanged) as follows:
C         ISEND = 0: Just check they are all vector files
C         ISEND = 1: Also check they have the same dimensions
C NFILES: (input/unchanged) number of valid vector files
C    NIN: (input/unchanged) unconnected input unit
C   NROW: (output) row dimension of the largest file read in
C  FILES: (input/unchanged) filenames supplied
C  ABORT: (output) error indicator (.TRUE. if failure o/w .FALSE.)
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)  :: ISEND, NFILES, NIN
      INTEGER,             INTENT (OUT) :: NROW
      CHARACTER (LEN = *), INTENT (IN)  :: FILES(NFILES)
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    I, IOS, NROW1, NCOL, NTEMP
      INTEGER    N0, N1
      PARAMETER (N0 = 0, N1 = 1)
      CHARACTER  LINE*100
      LOGICAL    CHECK
      EXTERNAL   PUTFAT, PSWARN
C
C Make sure NIN is closed
C
      CLOSE (UNIT = NIN)
C
C Check input arguments
C
      IF (ISEND.LT.N0 .OR. ISEND.GT.N1 .OR. NFILES.LT.N1) THEN
         ABORT = .TRUE.
         WRITE (LINE,100)
         CALL PUTFAT (LINE)
         NROW = N0
         RETURN
      ELSE
         ABORT = .FALSE.
         IF (ISEND.EQ.N0) THEN
            CHECK = .FALSE.
         ELSE
            CHECK = .TRUE.
         ENDIF
      ENDIF
C
C Loop over the NFILES input files
C
      DO I = N1, NFILES
C
C Attempt to open the file
C
         CLOSE (UNIT = NIN)
         OPEN (NIN, FILE = FILES(I), IOSTAT = IOS)
         IF (IOS.NE.N0) THEN
C
C ERROR 1: Failure to open the file
C =======
C
            ABORT = .TRUE.
            WRITE (LINE,200) I
            CALL PUTFAT (LINE)
            CLOSE (UNIT = NIN)
            NROW = N0
            RETURN
         ENDIF
C
C Attempt to read the title
C
         READ (NIN, '(A)', IOSTAT = IOS) LINE
         IF (IOS.NE.N0) THEN
C
C ERROR 2: Failure to read the title
C ========
C
            ABORT = .TRUE.
            WRITE (LINE,300) I
            CALL PUTFAT (LINE)
            CLOSE (UNIT = NIN)
            NROW = N0
            RETURN
         ENDIF
C
C Is it a PostScript file ?
C
         CALL PSWARN (LINE)
C
C Attempt to read the row and column dimensions
C
         READ (NIN, *, IOSTAT = IOS) NTEMP, NCOL
         IF (IOS.NE.N0 .OR. NTEMP.LT.N1 .OR. NCOL.NE.N1) THEN
C
C ERROR 3: Failure to read NROW, NCOL, NCOL not 1 or NROW < 1
C ========
C
            ABORT = .TRUE.
            WRITE (LINE,400) I
            CALL PUTFAT (LINE)
            CLOSE (UNIT = NIN)
            NROW = N0
            RETURN
         ENDIF
C
C First time define NCOL and NCOL1 then set NCOL = MAX(NCOL,NTEMP)
C
         IF (I.EQ.N1) THEN
            NROW = NTEMP
            NROW1 = NROW
         ELSEIF (NTEMP.GT.NROW) THEN
            NROW = NTEMP
         ENDIF
         IF (CHECK .AND. I.GT.N1) THEN
            IF (NTEMP.NE.NROW1) THEN
C
C ERROR 4: NROW not equal to NROW1
C ========
C
               ABORT = .TRUE.
               WRITE (LINE,500) I, NTEMP, NROW1
               CALL PUTFAT (LINE)
               CLOSE (UNIT = NIN)
               NROW = N0
               RETURN
            ENDIF
         ENDIF
      ENDDO
C
C Make sure NIN is closed
C
      CLOSE (UNIT = NIN)               
C
C Format statements
C      
  100 FORMAT ('ISEND or NFILES out of range in call to VECCHK')
  200 FORMAT ('File',I6,' cannot be located/opened')
  300 FORMAT (
     +'File',I6,' does not have a valid title  ...  Check line 1')
  400 FORMAT (
     +'File',I6,' has incorrect nrow(>0) ncol(=1) ...  Check line 2')
  500 FORMAT (
     +'File',I6,' is of length',I6,' not',I6,'  ...  Check line 2')
      END
C
C
