C
C
      SUBROUTINE VECCPY (NCMAX, NCOL, NFILES, NIN, NRMAX, NROW,
     +                   A,
     +                   FSAV, TSAV,
     +                   ABORT)
C
C ACTION: Copy a set of vector files FSAV into a matrix A
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 09/08/99
C         02/03/2007 added INTENTS
C
C         It is assumed that all files have been checked for
C         existence and having a correct header using VECCHK
C         or similar.
C
C         If the files do not have the same length then the
C         matrix will only be partially filled.
C         NCOL will be returned as NFILES if all goes well
C         NROW will be returned as the largest row dimension
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NCMAX, NFILES, NIN, NRMAX  
      INTEGER,             INTENT (OUT)   :: NCOL, NROW 
      DOUBLE PRECISION,    INTENT (OUT)   :: A(NRMAX,NCMAX)
      CHARACTER (LEN = *), INTENT (IN)    :: FSAV(NFILES)
      CHARACTER (LEN = *), INTENT (INOUT) :: TSAV(NFILES)
      LOGICAL,             INTENT (OUT)   :: ABORT  
C
C Locals
C      
      INTEGER    I, IOS, J, K, L, NROW1
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      DOUBLE PRECISION TEMP
      CHARACTER  LINE*100
      EXTERNAL   PUTFAT
C
C Initialise then check NFILES
C
      ABORT = .TRUE.
      IF (NFILES.LT.N1) THEN
         CALL PUTFAT ('NFILES < 1 in call to VECCPY')
         RETURN
      ENDIF
      NROW1 = - N1
C
C Now open the files one at a time assuming they exist and have
C valid TITLE and HEADER information in lines 1 and 2. This will
C be OK if this routine is preceded by a call to VECCHK or similar
C
      DO I = N1, NFILES
         CLOSE (UNIT = NIN)
         OPEN (UNIT = NIN, FILE = FSAV(I), IOSTAT = IOS)
         IF (IOS.NE.N0) THEN
            WRITE (LINE,100) I
            CALL PUTFAT (LINE)
            RETURN
         ENDIF
         READ (NIN,'(A)',IOSTAT=IOS) TSAV(I)
         IF (IOS.NE.N0) THEN
            WRITE (LINE,100) I
            CALL PUTFAT (LINE)
            RETURN
         ENDIF
         READ (NIN,*,IOSTAT=IOS) K, L
         IF (IOS.NE.0 .OR. K.LT.N1 .OR. L.NE.N1) THEN
            WRITE (LINE,100) I
            CALL PUTFAT (LINE)
            RETURN
         ENDIF
         IF (K.GT.NROW1) NROW1 = K
         DO J = N1, K
            READ (NIN,*,IOSTAT=IOS) TEMP
            IF (IOS.EQ.N0) THEN
               A(J,I) = TEMP
            ELSE
               WRITE (LINE,200) I, J + N2
               CALL PUTFAT (LINE)
               ABORT = .TRUE.
               CLOSE (UNIT = NIN)
               RETURN
            ENDIF
         ENDDO
      ENDDO
C
C Close down and assign NCOl and NROW
C
      CLOSE (UNIT = NIN)
      NCOL = NFILES
      NROW = NROW1
      ABORT = .FALSE.                            
C
C Format statements
C      
  100 FORMAT ('File',I4,' is not a vector file or cannot be opened')
  200 FORMAT ('EOF or read error in file',I4,'  ...  Check line',I6)
      END
C
C
