C
C
      SUBROUTINE VECERR (NCOL, NERR, NMAX, NMIN, NROW,
     +                   FNAME,
     +                   ABORT)
C
C ACTION: Report errors from ANOVAF, etc.  when calling VECORD
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 17/09/2003 
C         02/03/2007 added INTENTS
C
      IMPLICIT  NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: NCOL, NERR, NMAX, NMIN, NROW
      CHARACTER (LEN = *), INTENT (IN)  :: FNAME
      LOGICAL,             INTENT (OUT) :: ABORT 
C
C Locals
C                  
      CHARACTER LINE*100
      EXTERNAL  PUTFAT, VU2CHK
      IF (NERR.EQ.1) THEN
         WRITE (LINE,1)
      ELSEIF (NERR.EQ.2) THEN
         WRITE (LINE,2) NCOL
      ELSEIF (NERR.EQ.3) THEN
         WRITE (LINE,3) NMIN, NROW, NCOL
      ELSEIF (NERR.EQ.4) THEN
         WRITE (LINE,4) NMAX, NROW, NCOL
      ELSEIF (NERR.EQ.5) THEN
         WRITE (LINE,5) NROW, NCOL
      ELSEIF (NERR.EQ.6) THEN
         WRITE (LINE,6) NROW, NCOL
      ELSE
         ABORT = .FALSE.
         RETURN
      ENDIF
      ABORT = .TRUE.
      CALL PUTFAT (LINE)
      CALL VU2CHK (FNAME)
C
C Format statements 
C
      
    1 FORMAT ('VECORD called with sample size too small, N < 2')
    2 FORMAT ('VECORD called with NMAX < NMIN in column',I3)
    3 FORMAT ('Value < ',I3,', at row',I5,', column',I3)
    4 FORMAT ('Value > ',I3,', at row',I5,', column',I3)
    5 FORMAT ('Value decreasing at row',I5,', column',I3)
    6 FORMAT ('Value increasing too much at row',I5,', column',I3)
      END
C
C
