C
C
      SUBROUTINE VECFIL (NFILES, NIN, NMAX, NSMALL,
     +                   X,
     +                   FSAV, TSAV,
     +                   ABORT, LIBFL)
C
C ACTION: Use a library file or VEC1IN to read in a set of vector files
C         Returns vector files FSAV(NFILES), TSAV(NFILES)
C AUTHOR: W. G. Bardsley, University of Manchester, U.K., 30/1/95
C         13/11/1995 Changed argument list so called with LIBFIL and returns
C                    with ABORT = .TRUE. if library file not usable
C         03/09/1996 Added PSWARN
C         06/09/1996 Added DBOS_TXT2FN
C         25/04/1997 WIN32 version ... used YESNO1 for input/output
C         29/11/2001 added VU2CHK and FNLIB
C         08/01/2007 edited to use LIBFIL
C         31/03/2012 made NCOL a variable instead of a parameter 
C
C NFILES: (output) no. of files in library file (depends on LIBFIL)
c    NIN: (input/unchanged) unconnected unit for file opening
c   NMAX: (input/unchanged) dimension of X
c NSMALL: (input/unchanged) dimension of FSAV and TSAV
C      X: (input/output) workspace
C   FSAV: (output) files, depending on LIBFIL
C   TSAV: (output) titles, depending on LIBFIL
C  ABORT: (output) error indicator
C  LIBFL: (input) as follows
C         LIBFL = .TRUE.: try to use a library file
C         LIBFL = .FALSE.: try individual files 
C
      IMPLICIT   NONE   
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NIN, NMAX, NSMALL  
      INTEGER,             INTENT (OUT)   :: NFILES 
      DOUBLE PRECISION,    INTENT (INOUT) :: X(NMAX)
      CHARACTER (LEN = *), INTENT (OUT)   :: FSAV(NSMALL), TSAV(NSMALL)
      LOGICAL,             INTENT (IN)    :: LIBFL  
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C      
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMCOL, NUMROW, NTEXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NUMCOL = 0,
     +           NUMROW = 0)
      INTEGER    N0, N1, N2, N14, N15
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N14 = 14, N15 = 15)
      INTEGER    NCOL, NROW
      INTEGER    I, IADD1, ISEND, NPTS
      CHARACTER  LINE*100, TEXT(30)*100, TRIM80*80
      CHARACTER  FNAME*1024, TITLE*80
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    REPEET
      LOGICAL    FIXNPT, LABEL
      PARAMETER (FIXNPT = .FALSE., LABEL = .FALSE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    FIXCOL, FIXROW
      PARAMETER (FIXCOL = .TRUE., FIXROW = .FALSE.)
      EXTERNAL   VEC1IN, PUTBEL, PUTFAT, YESNO1, YESNO2, LIBFIL, TRIM80
C
C Part 1: First initialise NFILES whatever LIBFL is...................
C ======
C
      ABORT = .TRUE.
      NCOL = N1
      NFILES = N0
      IF (NSMALL.LT.N1) THEN
         RETURN
      ELSE
         DO I = N1, NSMALL
            FSAV(I) = BLANK
            TSAV(I) = BLANK
         ENDDO
      ENDIF         
C
C Part 2: Do this if LIBFL = .TRUE. then return........................
C ======
C
      IF (LIBFL) THEN
C
C Read in from a library file then return
C                     
         CALL LIBFIL (NCOL, NFILES, NIN, NROW, NSMALL,
     +                FSAV, TSAV,
     +                ABORT, FIXCOL, FIXROW)         
         RETURN
      ENDIF
C
C Part 3: do this if LIBFL = .FALSE....................................
C ======         
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
C
C Try to open a vector file
C      
         ISEND = N2
         CLOSE (UNIT = NIN)
         CALL VEC1IN (ISEND, NIN, NMAX, NPTS,
     +                X, 
     +                FNAME, TITLE,
     +                ABORT, FIXNPT, LABEL)
         CLOSE (UNIT = NIN)
         IF (.NOT.ABORT) THEN
            IF (NFILES.GT.N0) THEN  
C
C Check if already accepted
C            
               IADD1 = N0
               DO I = N1, NFILES
                  IF (IADD1.EQ.N0 .AND. FNAME.EQ.FSAV(I)) THEN
                     IADD1 = IADD1 + N1
                     ABORT = .FALSE.
                     CALL PUTBEL 
                     WRITE (LINE,100)
                     CALL YESNO2 (ICOLOR, IXL, IYL,
     +                            LINE,                     
     +                            ABORT)
                     ABORT = .NOT.ABORT
                  ENDIF
               ENDDO
            ENDIF
            IF (.NOT.ABORT .AND. NPTS.GT.N0) THEN
C
C File accepted so set NFILES, FSAV and TSAV
C
               IF (NFILES.LT.NSMALL) THEN
                  NFILES = NFILES + N1
                  FSAV(NFILES) = FNAME
                  TSAV(NFILES) = TITLE
               ELSE 
                  WRITE (LINE,200)
                  CALL PUTFAT (LINE)
                  RETURN
               ENDIF
            ENDIF
         ENDIF 
         NTEXT = N0
         IF (NFILES.GT.N0) THEN
C
C List accepted files
C         
            NTEXT = N1
            WRITE (TEXT(NTEXT),300) NFILES
            IF (NFILES.LE.N15) THEN
               WRITE (LINE,400)
               NTEXT = NTEXT + N1
               TEXT(NTEXT) = LINE
               NTEXT = NTEXT + N1
               TEXT(NTEXT) = BLANK
               DO I = N1, NFILES
                  NTEXT = NTEXT + N1
                  TEXT(NTEXT) = TRIM80(FSAV(I))
               ENDDO
            ELSE
               WRITE (LINE,500)
               NTEXT = NTEXT + N1
               TEXT(NTEXT) = LINE
               NTEXT = NTEXT + N1
               TEXT(NTEXT) = BLANK
               DO I = NFILES - N14, NFILES
               NTEXT = NTEXT + N1
               TEXT(NTEXT) = TRIM80(FSAV(I))
               ENDDO
            ENDIF
         ENDIF
         WRITE (LINE,600)
         CALL YESNO1 (ICOLOR, IXL, IYL, LSHADE, NUMCOL, NUMROW, NTEXT,
     +                LINE, TEXT,
     +                BORDER, FLASH, HIGH, REPEET)
     
      ENDDO
C
C Set ABORT = .FALSE. if at least 1 file has been read in
C      
      IF (NFILES.GT.0) THEN
         ABORT = .FALSE.           
      ELSE
         ABORT = .TRUE.
      ENDIF      
C
C Format statements
C     
  100 FORMAT (
     +'WARNING : File is already accepted ... Use it again ?')
  200 FORMAT (    
     +'Too many files requested')
  300 FORMAT (
     +'Total number of currently accepted column vectors =',I3)
  400 FORMAT (   
     +'Data files currently available for analysis:') 
  500 FORMAT (   
     +'Last 15 of vector type files currently available for analysis:')     
  600 FORMAT (
     +'Do you want to read in another data file for analysis ?')
      END
C
C
