C
C
      SUBROUTINE VECLIB (NFILES,
     +                   FSAV, TSAV,
     +                   USE1)
C
C ACTION: Edit files in or out of a current set
C AUTHOR: W. G. Bardsley, University of manchester, U.K., 31/1/95
C         30/04/1997 win32 version
C         20/06/2000 Revised
C         07/02/2001 added CHOP80
C         02/03/2007 added INTENTS
C
      IMPLICIT   NONE   
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NFILES
      CHARACTER (LEN = *), INTENT (IN)    :: FSAV(NFILES), TSAV(NFILES)
      LOGICAL,             INTENT (INOUT) :: USE1(NFILES) 
C
C Locals
C      
      INTEGER    ICOLOR, IXL, IYL, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, NUMOPT = 6)
      INTEGER    N0, N1, N2, N3, N4, N5, N15
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N15 = 15)
      INTEGER    NUMPOS(NUMOPT)
      INTEGER    I, J
      CHARACTER  CHOP80*80, LINE*100, TEXT(30)*100, TRIM80*80, TX31*3,
     +           TX32*3, WORD80*80
      LOGICAL    AGAIN
      EXTERNAL   TABLE1, GETIM1, LBOX02, TRIM80, CHOP80
      DATA       NUMPOS / NUMOPT*N1 /
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         WRITE (TEXT,100)
         NUMDEC = N1
         CALL LBOX02 (ICOLOR, IXL, IYL, NUMDEC, NUMOPT, NUMPOS,
     +                TEXT)
         IF (NUMDEC.EQ.N1 .OR. NUMDEC.EQ.N2) THEN
            J = N15
            CALL TABLE1 (J, 'OPEN')
            DO I = N1, NFILES
               WRITE (TX31,'(I3)') I
               IF (USE1(I)) THEN
                  TX32 = '   '
                  J = N0
               ELSE
                  TX32 = ' - '
                  J = N4
               ENDIF
               IF (NUMDEC.EQ.N1) THEN
                  WORD80 = TRIM80(FSAV(I))
                  LINE = TX31//TX32//WORD80
               ELSE
                  WORD80 = CHOP80(TSAV(I))
                  LINE = TX31//TX32//WORD80
               ENDIF
               CALL TABLE1 (J, LINE)
            ENDDO
            CALL TABLE1 (J, 'CLOSE')
         ELSEIF (NUMDEC.EQ.N3) THEN
            CALL GETIM1 (N1, I, NFILES, 'File number to suppress')
            USE1(I) = .FALSE.
         ELSEIF (NUMDEC.EQ.N4) THEN
            CALL GETIM1 (N1, I, NFILES, 'File number to restore')
            USE1(I) = .TRUE.
         ELSEIF (NUMDEC.EQ.N5) THEN
            DO I = N1, NFILES
               USE1(I) = .TRUE.
            ENDDO
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Display files'
     +/'Display titles'
     +/'Suppress'
     +/'Restore'
     +/'Restore all'
     +/'Accept')
      END
C
C
