C
C
      SUBROUTINE VECONE (NIN, NMAX, NZ,
     +                   Z,
     +                   TITLEZ,
     +                   ABORT, FIXNPT)
C
C ACTION : Get a vector
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.,1/12/94
C          Derived from VECTWO
C          11/08/1998 Allowed transformation and editing
C          07/02/2001 introduced CHOP80
C          24/04/2004 extensive editing (see note below)
C          19/01/2006 introduced allocatable workspace
C          20/05/2006 aded code for new functionality with VECTRN
C          02/03/2007 added INTENTS
C          19/04/2011 edited main menu
C
C          NIN: (input/unchanged) unconnected unit for data input
C         NMAX: (input/unchanged) dimension
C           NZ: (input/output) sample size
C            Z: (input/output) sample
C       TITLEZ: (input/output) title
C        ABORT: (output) error indicator
C       FIXNPT: (input/unchanged) ensures all vectors have size = NZ
C                                 as input but only if NZ > 1 on input
C
C Note: This version only changes NZ if new data are input and only
C       returns ABORT = .TRUE. if there are no appropriate data, or the user
C       has selected Cancel to abort further calculations. It does not set
C       ABORT = .TRUE. if the user fails to read in data as it will just leave
C       any existing data unchanged. This involves the use of ZNEW so it
C       is important that NRMAX >= NMAX.

      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NIN, NMAX
      INTEGER,             INTENT (INOUT) :: NZ
      DOUBLE PRECISION,    INTENT (INOUT) :: Z(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: TITLEZ
      LOGICAL,             INTENT (IN)    :: FIXNPT
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Local allocatable workspace
C
      DOUBLE PRECISION, ALLOCATABLE :: ZNEW(:)
C
C Locals
C
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 7,
     +           NSTART = 11, NTEXT = NUMOPT + NSTART - 1)
      INTEGER    N0, N1, N2, N3, N4, N5, NRMAX
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5)
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      INTEGER    ISEND, ITYPE, NCOL, NROW
      PARAMETER (ITYPE = 1, NCOL = 1)
      INTEGER    I, IEDIT, IERR, ITRAN, J, K, L
      CHARACTER (LEN = 12) FORM12, WORD12
      CHARACTER  FNAME*1024, ZTITLE*80
      CHARACTER  CHOP80*80, LINE*100, TEXT(30)*100, TITLE*80
      CHARACTER  NODATA*30, READY*30, STATE*30
      PARAMETER (NODATA = '(... No data ...)',
     +            READY = '(*** Ready ***)')
      LOGICAL    BORDER, FLASH, HIGH, MORE, NPTFIX, REPEET
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT
      PARAMETER (CURVE = .FALSE., FIXCOL = .TRUE., FIXROW = .FALSE.,
     +           LABEL = .TRUE., ORDER = .FALSE., WEIGHT = .FALSE.)
      EXTERNAL   VEC1IN, PUTFAT, LBOX01, VECTRN, GETSTR, FORM12,
     +           EDITOR, CHOP80, PATCH1
      SAVE       IEDIT, ITRAN
      DATA       IEDIT, ITRAN / 0, 0 /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Allocate workspace
C
      IERR = 0
      IF (ALLOCATED(ZNEW)) DEALLOCATE(ZNEW, STAT = IERR)
      IF (IERR.NE.0) RETURN
      NRMAX = NMAX
      ALLOCATE(ZNEW(NRMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Check the data
C
      IF (NZ.LT.N2) then
         TITLEZ = NODATA
         NZ = N0
         NPTFIX = .FALSE.
      ELSE
         NPTFIX = FIXNPT
      ENDIF
      ZTITLE = CHOP80(TITLEZ)
C
C Loop
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (NZ.LT.N2) THEN
            STATE = NODATA
            NUMDEC = N5
         ELSE
            STATE = READY
            NUMDEC = N1
         ENDIF
         WORD12 = FORM12(NZ)
         WRITE (TEXT,100) ZTITLE, WORD12, STATE
         NUMBLD(1) = N4
         NUMBLD(4) = N1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = N0
         NUMBLD(4) = N0
         IF (NUMDEC.LT.N5 .AND. NZ.LT.N2) THEN
             WRITE (LINE,200)
             CALL PUTFAT (LINE)
             NUMDEC = N0
         ENDIF
         IF (NUMDEC.EQ.N1) THEN
C
C Analyse
C
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C Transform
C
            CALL VECTRN (NZ,
     +                   Z, ZNEW,
     +                   ABORT)
            IF (.NOT.ABORT) THEN
               DO I = N1, NZ
                 Z(I) = ZNEW(I)
               ENDDO
               ITRAN = ITRAN + N1
               WRITE (TITLEZ,300) ITRAN
               WRITE (LINE,400)
               CALL GETSTR (LINE, TITLEZ)
               ZTITLE = CHOP80(TITLEZ)
            ENDIF
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C Edit
C
            WRITE (LINE,500)
            NROW = NZ
            ISEND = N2
C
C Store the old values then call the editor
C
            DO I = N1, NZ
               ZNEW(I) = Z(I)
            ENDDO
            CALL EDITOR (ISEND, ITYPE, NCOL, NRMAX, NROW,
     +                   ZNEW,
     +                   LINE,
     +                   CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT)
C
C See if any values have been edited
C
            MORE = .TRUE.
            I = N0
            DO WHILE (MORE .AND. I.LT.NZ)
               I = I + N1
               IF (Z(I).GT.ZNEW(I) .OR. Z(I).LT.ZNEW(I)) MORE = .FALSE.
            ENDDO
            IF (.NOT.MORE) THEN
               DO I = N1, NZ
                  Z(I) = ZNEW(I)
               ENDDO
               IEDIT = IEDIT + N1
               WRITE (TITLEZ,600) IEDIT
               WRITE (LINE,700)
               CALL GETSTR (LINE, TITLEZ)
               ZTITLE = CHOP80(TITLEZ)
            ENDIF
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C View
C
            DO I = N1, NZ
               ZNEW(I) = Z(I)
            ENDDO
            WRITE (LINE,800)
            NROW = NZ
            ISEND = N1
            CALL EDITOR (ISEND, ITYPE, NCOL, NRMAX, NROW,
     +                   ZNEW,
     +                   LINE,
     +                   CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT)
         ELSEIF (NUMDEC.EQ.N5) THEN
C
C Read in new Z data
C
            I = N3
            J = NIN
            K = NRMAX
            L = NZ
            CLOSE (UNIT = J)
            CALL VEC1IN (I, J, K, L,
     +                   ZNEW,
     +                   FNAME, TITLE,
     +                   ABORT, NPTFIX, LABEL)
            CLOSE (UNIT = J)
            IF (.NOT.ABORT .AND. L.GT.N1) THEN
               NZ = L
               TITLEZ = TITLE
               ZTITLE = CHOP80(TITLEZ)
               DO I = N1, NZ
                  Z(I) = ZNEW(I)
               ENDDO
C
C New data set so re-set IEDIT and ITRAN
C
               IEDIT = N0
               ITRAN = N0
            ENDIF
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C Help
C
            WRITE (TEXT,1000)
            I = 20
            NUMBLD(1) = N1
            NUMBLD(8) = N1
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, I,
     +                   TEXT,
     +                   BORDER)
            NUMBLD(1) = N0
            NUMBLD(8) = N0
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Cancel
C
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Deallocate workspace
C
      DEALLOCATE(ZNEW, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     + 'Options for supplying a single column of data'
     +/ 
     +/'Title of current data set is:'
     +/A
     +/
     +/'If you transform or edit these data you should'
     +/'provide a new title to reflect the changes made'
     +/
     +/'Current sample size =',1X,A
     +/
     +/'Analyse the current data set',1X,A
     +/'Transform'
     +/'Edit'
     +/'View'
     +/'New data'
     +/'Help'
     +/'Quit ... Exit this data input procedure')
  200 FORMAT ('Insufficient data')
  300 FORMAT ('Transform',I3,': ')
  400 FORMAT ('A new title for this transformed data')
  500 FORMAT ('Editing the current data')
  600 FORMAT ('Edit',I3,': ')
  700 FORMAT ('A new title for this edited data')
  800 FORMAT ('Viewing the current data')
 1000 FORMAT (
     + 'Supplying a data sample for analysis'
     +/
     +/'The analytical procedure you have selected requires one sample'
     +/'in the form of a column vector with no missing values, that is'
     +/'X with sample size N (where N > 1), and with the N elements'
     +/'X(1), X(2), ..., X(N) arranged vertically as a column.'
     +/
     +/'Alternative methods to supply data'
     +/'1)`You can make a file using program MAKMAT. This is the best'
     +/'  `method since a permanent copy of your data will be saved'
     +/'  `for future reference.'
     +/'2)`You can create a file from your spreadsheet program, e.g.'
     +/'  `from Excel using a macro such as simfit4.xls.'
     +/'3)`You can copy a column from your spreadsheet to the clipboard'
     +/'  `then paste it in after choosing the [New data] option.'
     +/'4)`You can type in small samples at the terminal.'
     +/'5)`You can edit or transform an existing sample interactively.'
     +/'  `This will not alter the original data set.'
     +/'Any format can be used for data, e.g. 10, 10.0, 1.e1, 1.0e+01,'
     +/'etc. for ten, but you should always supply a meaningful title.')
      END
C
C
