c
c
      subroutine vecord (ivec, n, nerr, nline, nmax, nmin, nreps, ntype)
c
c action: check a vector for consecutive order between nmin and nmax
c author: w.g.bardsley, university of manchester, u.k., 16/09/2003
c         02/03/2007 added intents 
c
c         Note: this subroutine checks to see if the vector supplied contains
c               consecutive integers with no gaps or jumps and with
c               nmin =< ivec(i) =< nmax
c
c         ivec: integer vector (input/unchanged)
c         n: dimension of ivec (input/unchanged)
c         nerr: error type (output)
c               nerr = 0: no errors
c               nerr = 1: n < 2
c               nerr = 2: nmax < nmin
c               nerr = 3: ivec(nline) < nmin
c               nerr = 4: ivec(nline) > nmax
c               nerr = 5: ivec(nline) < ivec(nline - 1)...decreasing
c               nerr = 6: ivec(nline) > ivec(nline - 1) + 1...increase > 1
c         nline: line no. where error encountered
c         nreps: no. of replicates at each level (output)
c         nmax: maximum allowed value (input/unchanged)
c         nmin: minimum allowed value (input/unchanged)
c         ntype: no. of consecutive integer types (output)
c
      implicit none
c
c arguments supplied
c
      integer, intent (in)  :: n, ivec(n), nmax, nmin
      integer, intent (out) :: nerr, nline, nreps(n), ntype
c
c local parameters
c
      integer i, icount
c
c initialise
c
      nerr = 0
      nline = 0
      do i = 1, n
         nreps(i) = 0
      enddo
      ntype = 0
c
c check input parameters
c
      if (n.lt.2) then
         nerr = 1
         return
      endif
      if (nmax.lt.nmin) then
         nerr = 2
         return
      endif
      do i = 1, n
         if (ivec(i).lt.nmin) then
            nerr = 3
            nline = i
            return
         elseif (ivec(i).gt.nmax) then
            nerr = 4
            nline = i
            return
         endif
      enddo
c
c check the order
c
      icount = ivec(1)
      nreps(1) = 1
      ntype = 1
      do i = 2, n
         if (ivec(i).eq.icount) then
            nreps(ntype) = nreps(ntype) + 1
         elseif (ivec(i).eq. icount + 1) then
            icount = icount + 1
            ntype = ntype + 1
            nreps(ntype) = 1
         elseif (ivec(i).lt.icount) then
            nerr = 5
            nline = i
            return
         else
            nerr = 6
            nline = i
            return
         endif
      enddo
      end
c
c
