C
C
      SUBROUTINE VECOUT (ISEND, NMAX, NOUT, NPTS,
     +                   A,
     +                   FNAME, TITLE,
     +                   ABORT, QTEXT, QTITLE)
C
C ACTION : Write NPTS values from vector A to a data file as follows:-
C          ISEND  = 1, user supplies filename at terminal, then OPEN new file
C          ISEND  = 2, filename as argument to subroutine, then OPEN new file
C          QTEXT  = .TRUE. ask for TEXT , otherwise use default text
C          QTITLE = .TRUE. ask for TITLE, otherwise use TITLE supplied
C          Notes: 1) NOUT is now closed on entry and also on exit
C                 2) Set ISEND = 2, QTEXT = .FALSE., and QTITLE = .FALSE. for 
C                    completely silent file creation using FNAME and TITLE supplied.
C                 3) Use MATOUT if it is required to append user supplied TEXT to
C                    the end of file
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 26/11/1990
C          05/10/1992 removed CLOSE statement and corrected output format
C          21/05/1997 win32 version
C          16/05/2005 increased no. of significant figures in output, added
C                     call to EDITTX, and closed NOUT before calling OFILES
C          28/06/2006 introduced I1FILE and I2FILE for row and column dimensions
C          24/08/2006 corrected error assigning FNAME and TITLE as INTENT (IN) 
C                     and replaced GETSTR by GETTXT to be identical to MATOUT
C          06/10/2006 restored GETTXT and introduced YMDHMS to get data and time 
C          10/10/2006 revised CHARACTER INTENTS and other details
C          24/03/2008 altered trailer code to agree with MATOUT
C          25/09/2021 added D15 and SHOW15 to replace E format
C
C          ISEND: (input/unchanged) 1 =< ISEND =< 2    
C                 ISEND = 1: to OFILES for new file selected from terminal
C                 ISEND = 2: to OFILES for new file using argument supplied         
C           NMAX: (input/unchanged) dimension, NMAX >= NPTS
C           NOUT: (input/unchanged) unconnected unit for output
C           NPTS: (input/unchanged) NPTS >= 1, NPTS =< NMAX
C              A: (input/unchanged) vector
C          FNAME: (input/output) as follows:
C                  ISEND = 1: user selects a file
C                  ISEND = 2: filename is supplied for silent file creation                
C          TITLE: (input/output) as follows:
C                  QTITLE = .TRUE. : query ... offer to change title supplied
C                  QTITLE = .FALSE.: use title as supplied
C          ABORT: (output)
C          QTEXT: (input/unchanged) as follows:
C                  QTEXT = .TRUE. : ask if user wants to add text
C                  QTEXT = .FALSE.: add a default text line 
C         QTITLE: (input/unchanged) as follows:
C                  QTITLE = .TRUE. : query ... offer to change title supplied
C                  QTITLE = .FALSE.: use title as supplied
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ISEND, NMAX, NOUT, NPTS
      DOUBLE PRECISION,    INTENT (IN)    :: A(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE
      LOGICAL,             INTENT (OUT)   :: ABORT
      LOGICAL,             INTENT (IN)    :: QTEXT, QTITLE
C
C Locals
C
      INTEGER    N1, N2, NHIGH, NWIDE
      PARAMETER (N1 = 1, N2 = 2, NHIGH = 100, NWIDE = 80)
      INTEGER    I, NLINES 
      INTEGER    L1, L2, LEN200
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4)
      CHARACTER  LINE*100, PHRASE(NHIGH)*(NWIDE), WORD32*32
      CHARACTER (LEN = 15) D15, SHOW15
      CHARACTER  BLANK*1, COLON*1
      PARAMETER (BLANK = ' ', COLON = ':')
      LOGICAL    YES
      EXTERNAL   OFILES, YESNO2, GETSTR, EDITTX, I1FILE, I2FILE, LEN200,
     +           YMDHMS, PUTFAT, SHOW15
      INTRINSIC  LEN 
      SAVE       PHRASE
      DATA       PHRASE / NHIGH*BLANK /
C
C Initialise
C           
      ABORT = .TRUE.
C
C Check arguments supplied
C
      IF (ISEND.LT.N1 .OR. ISEND.GT.N2 .OR.
     +    NPTS.LT.N1  .OR. NPTS.GT.NMAX) THEN
         WRITE (LINE,100)
         CALL PUTFAT (LINE) 
         RETURN
      ENDIF   
C
C Close NOUT then try to select and open a file
C
      CLOSE (UNIT = NOUT)
      IF (ISEND.EQ.1) FNAME = BLANK
      CALL OFILES (ISEND, NOUT,
     +             FNAME,
     +             ABORT)
      IF (ABORT) THEN
         CLOSE (UNIT = NOUT)
         RETURN        
      ENDIF   
C
C Get the year-month-day-hours-minutes-seconds
C      
      CALL YMDHMS (WORD32)
C
C Query to edit title supplied if QTITLE = .TRUE.
C    
      IF (QTITLE) THEN
         WRITE (LINE,200)
         L1 = LEN200(TITLE)
         L2 = LEN(TITLE)
         IF (L2 - L1.GE.9) THEN 
            L1 = L1 + 1
            TITLE(L1:L1) = COLON   
            L1 = L1 + 1
            TITLE(L1:L1 + 7) = WORD32(10:17)
         ENDIF   
         CALL GETSTR (LINE, TITLE)
      ENDIF
C
C Write out the title, header, and vector
C
      WRITE (NOUT,'(A)') TITLE
      CALL I2FILE (NOUT, NPTS, N1)
      DO I = 1, NPTS
         D15 = SHOW15(A(I)) 
         WRITE (NOUT,'(1X,A)') D15
      ENDDO   
C
C Query to write out a trailer
C
      IF (QTEXT) THEN
         YES = .FALSE.
         WRITE (LINE,300)
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE,
     +                YES)
         IF (YES) THEN 
            CALL EDITTX (NHIGH, NLINES, NWIDE,
     +                   PHRASE)
            IF (NLINES.LE.0) THEN
               NLINES = 0
            ELSEIF (NLINES.GT.NHIGH) THEN
               NLINES = NHIGH
            ENDIF   
            NLINES = NLINES + 1 
            CALL I1FILE (NOUT, NLINES)
            DO I = N1, NLINES
               IF (I.LT.NLINES) THEN
                  WRITE (NOUT,'(A)') PHRASE(I)
               ELSE   
                  WRITE (NOUT,'(A)') WORD32
               ENDIF   
            ENDDO  
            CLOSE (UNIT = NOUT) 
            ABORT = .FALSE.
            RETURN
         ENDIF
      ENDIF          
C
C Otherwise add a default line then CLOSE, set ABORT = .FALSE. and RETURN
C      
      CALL I1FILE (NOUT, N1)
      WRITE (NOUT,'(A)') WORD32 
      CLOSE (UNIT = NOUT)
      ABORT = .FALSE.
C
C Format statements
C  
  100 FORMAT ('Error in in call to VECOUT')
  200 FORMAT ('New title or edit the default title for these data')
  300 FORMAT ('Add extra details to the end of the file ?')
      END
C
C
