C
C
C
      SUBROUTINE VECSRT (M, N, NRMAX,
     +                   A, B)
C
C ACTION : Check then sort array A using HEAPSORT if required or swap around
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          03/10/1992 added PROMPT when all elements are equal
C                     Also added NUP, NDOWN, NEQUAL and removed NWRONG
C          22/02/1993 Added GETYES
C          23/03/1994 DBOS version
C          01/02/1997 Windows 95 version
C          02/03/2007 added INTENTS
C          01/04/2008 edited to correct for overdimensioning B  
C
C Note: Only column 1 items 1 to N are rearranged
C       M is only used for consistency with other matrix routine calls where a 
C       matrix with 1 column is used to hold a vector and so would normally be 1
C       
C     M: (input/unchanged) column dimension for A (M > = 1)
C     N: (input/unchanged) no. of rows in column 1 to be re-ordered (N =< NRMAX)
C NRMAX: (input/unchanged) leading dimension of A (NRMAX >= N >= 1)
C     A: (input/output) matrix returned but only in column 1
C     B: (workspace 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: M, N, NRMAX 
      DOUBLE PRECISION, INTENT (INOUT) :: A(NRMAX,M), B(N)
C
C Locals
C      
      INTEGER    I, J, K, L, NDEC, NDOWN, NEQUAL, NM1, NUP
      INTEGER    ICOLOR, IX, IY, LSHADE, NTEXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1, NTEXT = 7)
      INTEGER    NUMBLD(NTEXT), NUMOPT, NUMPOS(3), NUMTXT, NSTART
      DOUBLE PRECISION ATEMP, BTEMP
      CHARACTER  CIPHER(3)*6, LINE*100, TEXT(NTEXT)*100
      LOGICAL    YES
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .FALSE.)
      EXTERNAL   PUTADV, YESNO2, VBOX01, TRIML1
      DATA       NUMBLD / 4*1, 3*0 /
      DATA       NUMPOS / 3*1 /
C
C Check then initialise
C
      IF (N.LT.2) RETURN
      NDOWN = 0
      NEQUAL = 0
      NM1 = N - 1
      NUP = 0
C
C Calcuate counters
C
      BTEMP  = A(1,1)
      DO I = 1, NM1
         ATEMP = BTEMP
         BTEMP = A(I + 1,1)
         IF (BTEMP.GT.ATEMP) THEN
            NUP = NUP + 1
         ELSEIF (BTEMP.LT.ATEMP) THEN
            NDOWN = NDOWN + 1
         ELSE
            NEQUAL = NEQUAL + 1
         ENDIF
      ENDDO
C
C Return if all equal
C
      IF (NEQUAL.EQ.NM1) THEN
         WRITE (LINE,100)
         CALL PUTADV (LINE)
         RETURN
      ENDIF
C
C All increasing or all decreasing
C
      IF (NUP.EQ.0 .OR. NDOWN.EQ.0) THEN
         IF (NDOWN.EQ.0) THEN
            WRITE (LINE,200)
         ELSE
            WRITE (LINE,300)
         ENDIF
         WRITE (TEXT,400)
         TEXT(1) = LINE
         NUMTXT = 3
         NDEC = 1
         NUMOPT = 2
         NSTART = 2
         CALL VBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT,
     +                NUMPOS, NSTART, NUMTXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NDEC.EQ.1) RETURN
      ELSE
C
C Rearranging may be required
C
         WRITE (CIPHER(1),'(I6)') NUP
         WRITE (CIPHER(2),'(I6)') NDOWN
         WRITE (CIPHER(3),'(I6)') NEQUAL
         CALL TRIML1 (CIPHER(1))
         CALL TRIML1 (CIPHER(2))
         CALL TRIML1 (CIPHER(3))
         WRITE (TEXT,500) CIPHER(1), CIPHER(2), CIPHER(3)
         NDEC = 3
         NUMOPT = 3
         NSTART = 5
         CALL VBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NDEC.EQ.3) RETURN
         WRITE (LINE,600)
         YES = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE,
     +                YES)
         IF (.NOT.YES) RETURN
         L = N/2 + 1
         K = N
   20    CONTINUE
            IF (L.GT.1) THEN
               L = L - 1
               ATEMP = A(L,1)
            ELSE
               ATEMP = A(K,1)
               A(K,1) = A(1,1)
               K = K - 1
               IF (K.EQ.1) THEN
                  A(1,1) = ATEMP
                  GOTO 60
               ENDIF
            ENDIF
            I = L
            J = L + L
   40       IF (J.LE.K) THEN
               IF (J.LT.K) THEN
                  IF (A(J,1).LT.A(J + 1,1)) J = J + 1
               ENDIF
               IF (ATEMP.LT.A(J,1)) THEN
                  A(I,1) = A(J,1)
                  I = J
                  J = J + J
               ELSE
                  J = K + 1
               ENDIF
               GOTO 40
            ENDIF
            A(I,1) = ATEMP
            GOTO 20
   60    CONTINUE
      ENDIF
      IF (NDEC.EQ.2) THEN
         DO I = 1, N
            B(I) = A(I,1)
         ENDDO
         DO I = 1, N
            J = N - I + 1
            A(I,1) = B(J)
         ENDDO
      ENDIF
      WRITE (LINE,700)
      CALL PUTADV (LINE)
C
C Format statements
C      
  100 FORMAT ('All elements of vector are equal')
  200 FORMAT ('Vector now in INCREASING order')
  300 FORMAT ('Vector now in DECREASING order')
  400 FORMAT (/'Preserve order'
     +/'Reverse order')
  500 FORMAT ('You can reverse the order if required'
     +/'No. increasing values = ',A
     +/'No. decreasing values = ',A
     +/'No. identical values = ',A
     +/'Increasing order'
     +/'Decreasing order'
     +/'Preserve order')
  600 FORMAT ('This will destroy existing order ... Proceed ?')
  700 FORMAT ('The data have now been rearranged')
      END
C
C
