C
C
      SUBROUTINE VECTRN (N,
     +                   X, Y,
     +                   ABORT)
C
C ACTION : Transform a vector X to Y = F(X)
C ADVICE : In this version X is returned unchanged
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 12/8/92
C          21/02/1994 DBOS version
C          11/02/1997 Win32 version
C          11/08/1998 edited to remove inconsistencies on error exit so that
C                     ABORT = .FALSE. if ANY transformation has succeeded
C          12/08/1998 Added NORMAL CDF and INVERSE
C          18/05/2006 Edited, added logs to various bases and changed eror exit to
C                     ABORT = .FALSE. Apply selected and NTRAN > 0
C                     ABORT = .TRUE. Cancel selected or Apply selected but NTRAN = 0
C                     X is now unchanged on exit 
C          02/03/2007 added INTENTS
C          14/08/2007 added centralise 
C          24/07/2008 added normalise to st.dev. = 1
C
C     N: (input/unchanged) size of input vector X
C     X: (input/unchanged) original data on input 
C        Note X is saved as ASAV on input then restored on output
C        Hence the intent is (INOUT) not (IN) even though X is unchanged
C     Y: (output) output as Y = f(X) unless ABORT = .TRUE. on exit
C ABORT: (output) if returned .TRUE. then Y = X = original data
C                 if returned .FALSE. then Y = transformed data
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: N
      DOUBLE PRECISION, INTENT (INOUT) :: X(N), Y(N)
      LOGICAL,          INTENT (OUT)   :: ABORT
C
C Local allocatable array
C
      DOUBLE PRECISION, ALLOCATABLE :: XSAV(:,:)
C
C Locals
C
      INTEGER    I, IERR, IFAIL, J, K, NDEC, NLOG, NTRAN, NTRIG
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NSTART = 1,
     +           NUMOPT = 21)
      INTEGER    NCOL, NRMAX , NROW, NTYPE
      PARAMETER (NCOL = 3, NTYPE = 3)
      INTEGER    NUMBLD(30), NUMPOS(21)
      DOUBLE PRECISION EPSI, FACTOR, POWER, POWNEG, XBIG, XSMALL
      DOUBLE PRECISION CONST, SSQ, TEMP, TEST, XBAR, XSIG, XVAR
      DOUBLE PRECISION X02AMFG, G01EAFG, G01FAFG
      DOUBLE PRECISION ZERO, TWO, SMALL, VSMALL
      PARAMETER (ZERO = 0.0D+00, TWO = 2.0D+00, SMALL = 1.0D-03,
     +           VSMALL = 1.0D-06)
      DOUBLE PRECISION PMAX, PMIN
      PARAMETER (PMAX = 0.999D+00, PMIN = 0.001D+00)
      CHARACTER  BASE*2, LINE*100, RESUL*40, TEXT(30)*100
      CHARACTER  BLANK*1, INFO(17)*20, YES*20
      PARAMETER (BLANK = ' ', YES = '(***Done***)')
      CHARACTER  TITLE*43
C
C TITLE must be consistent with FORMAT for output 1P,3E13.5
C
      PARAMETER (TITLE = '    Supplied      Transformed    Difference')
      LOGICAL    ABORT1, DONE, LOOP, REPEET, XTREME
      LOGICAL    LOGE, LOGTEN
      LOGICAL    BORDER
      PARAMETER (BORDER = .FALSE.)
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_BOT = .FALSE., TAB_MID = .TRUE., TAB_TOP = .FALSE.)
      EXTERNAL   PUTADV, PUTFAT, REJECT, TBOX01, TRIGFN, LISTBX, VIEWIT,
     +           NXXBARG, PATCH1
      EXTERNAL   WPARAM
      EXTERNAL   X02AMFG, G01EAFG, G01FAFG
      INTRINSIC  ABS, LOG, LOG10, SQRT, DBLE, NINT
      SAVE       NLOG
      DATA       NLOG / 1 /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Check then allocate space for XSAV
C
      ABORT = .TRUE.
      IF (N.LT.1) THEN
         RETURN
      ELSE
         IERR = 0
         IF (ALLOCATED(XSAV)) DEALLOCATE(XSAV, STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE (XSAV(N,3), STAT =IERR)
         IF (IERR.NE.0) RETURN
      ENDIF
C
C Store initial values for X (and Y) in XSAV then Initialise
C
      DO I = 1, N
         XSAV(I,1) = X(I)
         Y(I) = X(I)
         XSAV(I,2) = Y(I)
         XSAV(I,3) = ZERO
      ENDDO
      NTRAN = 0
      NTRIG = 0
      CONST = 1.0D+00
      EPSI = 1.0D+09*X02AMFG()
      XBIG = 1.0D+00/EPSI
      XSMALL = - XBIG
      POWER = LOG10(XBIG)
      POWNEG = - POWER
      DO I = 1, 17
         INFO(I) = BLANK
      ENDDO
C
C Main loop............................................................................
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (TEXT,100) (INFO(I), I = 1, 17), NTRAN, NTRIG
         NTEXT = NUMOPT + 4
         NUMBLD(NTEXT) = 1
         NDEC = NUMOPT - 3
         CALL TBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                TAB_BOT, TAB_MID, TAB_TOP)
         NUMBLD(NTEXT) = 0
         IF (NDEC.LE.8 .OR. NDEC.EQ.10) THEN
C
C Make sure k = CONST is defined if k is required
C
            CALL WPARAM (CONST)
         ENDIF
         IF (NDEC.EQ.5 .AND. ABS(CONST).LE.EPSI) THEN
C
C Check if abs(k) large enough
C
            CALL REJECT
            NDEC = 0
         ENDIF
         IF (NDEC.EQ.7 .AND. CONST.LE.EPSI) THEN
C
C Check if k is large enough
C
            CALL REJECT
            NDEC = 0
         ENDIF
         IF (NDEC.EQ.9 .OR. NDEC.EQ.10) THEN
C
C Choose a log base
C
            WRITE (TEXT,200)
            J = 10
            CALL LISTBX (NLOG, J,
     +                   TEXT)
            IF (NLOG.EQ.1) THEN
               LOGE = .TRUE.
               LOGTEN = .FALSE.
               BASE = 'e'
            ELSEIF (NLOG.EQ.10) THEN
               BASE = '10'
               LOGE = .FALSE.
               LOGTEN = .TRUE.
            ELSE
               WRITE (BASE,'(I1,1X)') NLOG
               FACTOR = LOG(DBLE(NLOG))
               LOGE = .FALSE.
               LOGTEN = .FALSE.
            ENDIF
         ENDIF
C
C Initialise DONE and J then execute the option selected
C
         DONE = .FALSE.
         J = 0
         IF (NDEC.EQ.1) THEN
C
C NDEC = 1: y = x ... will always work
C =========
C
            DO I = 1, N
               Y(I) = CONST
            ENDDO
            WRITE (RESUL,300) CONST
            DONE = .TRUE.
         ELSEIF (NDEC.EQ.2) THEN
C
C NDEC = 2: y = x + k ... will always work
C =========
C
            DO I = 1, N
               Y(I) = CONST + X(I)
            ENDDO
            WRITE (RESUL,300) CONST
            DONE = .TRUE.
         ELSEIF (NDEC.EQ.3) THEN
C
C NDEC = 3: y = x - k ... will always work
C =========
C
            DO I = 1, N
               Y(I) = X(I) - CONST
            ENDDO
            WRITE (RESUL,300) CONST
            DONE = .TRUE.
         ELSEIF (NDEC.EQ.4) THEN
C
C NDEC = 4: y = kx ... will always work
C =========
C
            DO I = 1, N
               Y(I) = CONST*X(I)
            ENDDO
            WRITE (RESUL,300) CONST
            DONE = .TRUE.
         ELSEIF (NDEC.EQ.5) THEN
C
C NDEC = 5: y = x/k ... requires abs(k) > epsi
C =========
C
            DO I = 1, N
               Y(I) = X(I)/CONST
            ENDDO
            WRITE (RESUL,300) CONST
            DONE = .TRUE.
         ELSEIF (NDEC.EQ.6) THEN
C
C NDEC = 6: y = k/x ... requires abs(x) > epsi
C =========
C
            I = 0
            DONE = .TRUE.
            DO WHILE (I.LT.N .AND. DONE)
               I = I + 1
               J = I
               IF (ABS(X(I)).LE.EPSI) THEN
                  DONE = .FALSE.
               ELSE
                  Y(I) = CONST/X(I)
               ENDIF
            ENDDO
            IF (DONE) WRITE (RESUL,300) CONST
         ELSEIF (NDEC.EQ.7) THEN
C
C NDEC = 7: y = k^x ... requires k > epsi
C =========
C
            TEMP = LOG10(CONST)
            I = 0
            DONE = .TRUE.
            DO WHILE (I.LT.N .AND. DONE)
               I = I + 1
               J = I
               TEST = X(I)*TEMP
               IF (TEST.LE.POWNEG .OR. TEST.GE.POWER) THEN
                   DONE = .FALSE.
               ELSE
                  Y(I) = CONST**X(I)
               ENDIF
            ENDDO
            IF (DONE) WRITE (RESUL,300) CONST
         ELSEIF (NDEC.EQ.8) THEN
C
C NDEC = 8: y = x^k ... requires k positive integer or x > epsi
C =========
C
           IF (CONST.GE.TWO) THEN
              K = NINT(CONST)
              TEMP = DBLE(K)
              IF (ABS(TEMP - CONST).LE.SMALL) THEN
                 LOOP = .TRUE.
              ELSE
                 LOOP = .FALSE.
              ENDIF
           ELSE
              LOOP = .FALSE.
           ENDIF
           I = 0
           DONE = .TRUE.
           IF (LOOP) THEN
C
C CONST is an integer >= 2 so calculate as a loop
C
              DO I = 1, N
                 TEMP = X(I)
                 DO J = 2, K
                    TEMP = TEMP*X(I)
                 ENDDO
                 Y(I) = TEMP
              ENDDO
           ELSE
C
C Otherwise calculate using ** operator
C
              DO WHILE (I.LT.N .AND. DONE)
                  I = I + 1
                  J = I
                  IF (X(I).LE.EPSI) THEN
                     DONE = .FALSE.
                  ELSE
                     TEST = CONST*LOG10(X(I))
                     IF (TEST.LE.POWNEG .OR. TEST.GE.POWER) THEN
                        DONE = .FALSE.
                     ELSE
                        Y(I) = X(I)**CONST
                     ENDIF
                  ENDIF
               ENDDO
            ENDIF
            IF (DONE) WRITE (RESUL,300) CONST
         ELSEIF (NDEC.EQ.9) THEN
C
C NDEC = 9: y = log(x) ... requires x > epsi
C =========
C
            I = 0
            DONE = .TRUE.
            DO WHILE (I.LT.N .AND. DONE)
               I = I + 1
               J = I
               IF (X(I).LE.EPSI) THEN
                  DONE = .FALSE.
               ELSE
                  IF (LOGE) THEN
                     Y(I) = LOG(X(I))
                  ELSEIF (LOGTEN) THEN
                     Y(I) = LOG10(X(I))
                  ELSE
                     Y(I) = LOG(X(I))/FACTOR
                  ENDIF
               ENDIF
            ENDDO
            IF (DONE) WRITE (RESUL,400) BASE
         ELSEIF (NDEC.EQ.10) THEN
C
C NDEC = 10: y = log(x/(k - x)) ... requires x/(k - x) > epsi
C ==========
C
            I = 0
            DONE = .TRUE.
            DO WHILE(I.LT.N .AND. DONE)
               I = I + 1
               J = I
               TEMP = CONST - X(I)
               IF (ABS(TEMP).LE.EPSI) THEN
                  DONE = .FALSE.
               ELSE
                  TEST = X(I)/TEMP
                  IF (TEST.LE.EPSI) THEN
                     DONE = .FALSE.
                  ELSE
                     IF (LOGE) THEN
                        Y(I) = LOG(TEST)
                     ELSEIF (LOGTEN) THEN
                        Y(I) =  LOG10(TEST)
                     ELSE
                        Y(I) = LOG(TEST)/FACTOR
                     ENDIF
                  ENDIF
               ENDIF
            ENDDO
            IF (DONE) WRITE (RESUL,500) CONST, BASE
        ELSEIF (NDEC.EQ.11) THEN
C
C NDEC = 11: Scale to length 1
C ==========
C
            SSQ = ZERO
            DO I = 1, N
               SSQ = SSQ + X(I)**2
            ENDDO
            IF (SSQ.LE.EPSI) THEN
               DONE = .FALSE.
            ELSE
               XSIG = SQRT(SSQ)
               DO I = 1, N
                  Y(I) = X(I)/XSIG
               ENDDO
               DONE = .TRUE.
            ENDIF
            IF (DONE) RESUL = 'scale to unit length'   
       ELSEIF (NDEC.EQ.12) THEN
C
C NDEC = 12: Scale to std.dev. = 1
C ==========
C
            J = 0
            CALL NXXBARG (N,
     +                    X, XBAR, XVAR)
            IF (XVAR.LE.EPSI) THEN
               DONE = .FALSE.
            ELSE
               XSIG = SQRT(XVAR)
               DO I = 1, N
                  Y(I) = X(I)/XSIG
               ENDDO
               DONE = .TRUE.     
            ENDIF
            IF (DONE) RESUL = 'scale to std.dev. = 1'                 
         ELSEIF (NDEC.EQ.13) THEN
C
C NDEC = 13: centralise
C ==========
C
            J = 0
            CALL NXXBARG (N,
     +                    X, XBAR, XVAR)
            DO I = 1, N
               Y(I) = X(I) - XBAR
            ENDDO
            DONE = .TRUE.
            RESUL = 'centralise'
         ELSEIF (NDEC.EQ.14) THEN
C
C NDEC = 14: Standardise ... requires XVAR > epsi
C ==========
C
            J = 0
            CALL NXXBARG (N,
     +                    X, XBAR, XVAR)
            IF (XVAR.LE.EPSI) THEN
               DONE = .FALSE.
            ELSE
               XSIG = SQRT(XVAR)
               DO I = 1, N
                  Y(I) = (X(I) - XBAR)/XSIG
               ENDDO
               DONE = .TRUE.
            ENDIF
            IF (DONE) RESUL = 'centralise/scale'
         ELSEIF (NDEC.EQ.15) THEN
C
C NDEC = 15: Phi(x)
C ==========
C
            I = 0
            DONE = .TRUE.
            DO WHILE (I.LT.N .AND. DONE)
               I = I + 1
               J = I
               IFAIL = 0
               Y(I) = G01EAFG('L', X(I), IFAIL)
               IF (IFAIL.NE.0) DONE = .FALSE.
            ENDDO
            IF (DONE) RESUL = 'Phi(x)'
         ELSEIF (NDEC.EQ.16) THEN
C
C NDEC = 16: Phi_inverse(x) ... requires 0 < x < 1
C ==========
C
            I = 0
            DONE = .TRUE.
            DO WHILE (I.LT.N .AND. DONE)
               I = I + 1
               J = I
               IF (X(I).GE.PMIN .AND. X(I).LE.PMAX) THEN
                  IFAIL = 0
                  Y(I) = G01FAFG('L', X(I), IFAIL)
                  IF (IFAIL.NE.0) DONE = .FALSE.
               ELSE
                  DONE = .FALSE.
               ENDIF
            ENDDO
            IF (DONE) RESUL = 'Phi_inverse(x)'
         ELSEIF (NDEC.EQ.17) THEN
C
C NDEC = 17: Trig functions
C ==========
C
            J = 0
            CALL TRIGFN (N, NTRIG,
     +                   X, Y,
     +                   ABORT1)
            DONE = .NOT.ABORT1
            IF (DONE) RESUL = 'trig/hyperbolic transformation'
         ELSEIF (NDEC.EQ.NUMOPT - 3) THEN
C
C NDEC = NUMOPT - 3: View
C ==================
C
            DO I = 1, N
               TEMP = (XSAV(I,1) - XSAV(I,2))/
     +                (ABS(XSAV(I,1)) + ABS(XSAV(I,2)) + EPSI)
               IF (ABS(TEMP).LE.VSMALL) THEN
                  XSAV(I,3) = ZERO
               ELSE
                  XSAV(I,3) = XSAV(I,1) - X(I)
               ENDIF
            ENDDO
            NRMAX = N
            NROW = N
            CALL VIEWIT (NCOL, NRMAX, NROW, NTYPE,
     +                   XSAV,
     +                   TITLE)
            NDEC = 0
         ELSEIF (NDEC.EQ.NUMOPT - 2) THEN
C
C NDEC = NUMOPT - 2: Help
C ==================
C
            WRITE (TEXT,600)
            NTEXT = 22
            NUMBLD(1) = 1
            NUMBLD(7) = 1
            NUMBLD(17) = 1
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTEXT,
     +                   TEXT,
     +                   BORDER)
            NUMBLD(1) = 0
            NUMBLD(7) = 0
            NUMBLD(17) = 0
            NDEC = 0
         ELSEIF (NDEC.EQ.NUMOPT - 1) THEN
C
C NDEC = NUMOPT - 1: Restore X and Apply transformations
C
            IF (NTRAN + NTRIG.GT.0) THEN
               CALL PUTADV (TEXT(NTEXT))
               ABORT = .FALSE.
            ELSE
               WRITE (LINE,700)
               CALL PUTADV (LINE)
               ABORT = .TRUE.
               DO I = 1, N
                  Y(I) = XSAV(I,1)
               ENDDO
            ENDIF
            DO I = 1, N
               X(I) = XSAV(I,1)
            ENDDO
            DEALLOCATE(XSAV, STAT = IERR)
            RETURN
         ELSEIF (NDEC.EQ.NUMOPT) THEN
C
C NDEC = NUMOPT: End transformations
C ==============
C
            WRITE (LINE,700)
            CALL PUTADV (LINE)
            ABORT = .TRUE.
            DO I = 1, N
               X(I) = XSAV(I,1)
               Y(I) = X(I)
            ENDDO
            DEALLOCATE (XSAV, STAT = IERR)
            RETURN
         ENDIF
C
C Check on exit from the loop unless view or help have been selected
C
         IF (NDEC.GT.0 .AND. NDEC.LT.NUMOPT - 3) THEN
            IF (DONE) THEN
C
C Check that the numbers are not too large or small
C
               XTREME = .FALSE.
               I = 0
               DO WHILE (I.LT.N .AND. .NOT.XTREME)
                  I = I + 1
                  J = I
                  IF (Y(I).GE.XBIG .OR. Y(I).LE.XSMALL) XTREME = .TRUE.
               ENDDO
            ELSE
               XTREME = .TRUE.
            ENDIF
            IF (.NOT.XTREME) THEN
C
C Success: Set all X equal to Y
C
               IF (NDEC.NE.15) NTRAN = NTRAN + 1
               INFO(NDEC) = YES
               DO I = 1, N
                  X(I) = Y(I)
                  XSAV(I,2) = Y(I)
               ENDDO
               WRITE (LINE,800) RESUL
               CALL PUTADV (LINE)
            ELSE
C
C Failure: Set all Y equal to current X
C
               DO I = 1, N
                  Y(I) = X(I)
               ENDDO
               IF (J.GE.1 .AND. J.LE.N) THEN
                  WRITE (LINE,900) J, X(J)
               ELSE
                  WRITE (LINE,700)
               ENDIF
               CALL PUTFAT (LINE)
            ENDIF
         ENDIF
      ENDDO
C
C Format statements
C
  100 FORMAT (
     + 'x := k                     `Substitute'         ,1X,A
     +/'x := x + k                 `Add'                ,1X,A
     +/'x := x - k                 `Subtract'           ,1X,A
     +/'x := kx                    `Multiply'           ,1X,A
     +/'x := x/k                   `Divide'             ,1X,A
     +/'x := k/x                   `Reciprocate'        ,1X,A
     +/'x := k^x                   `Exponentiate'       ,1X,A
     +/'x := x^k                   `Power'              ,1X,A
     +/'x := log(x)                `Log(any base)'      ,1X,A
     +/'x := log[x/(k - x)]        `Logit(any base)'    ,1X,A
     +/'x := x/sqrt(sum x^2)       `Scale to length = 1',1X,A
     +/'x := x/std.dev(X)          `Scale to sigma = 1 ',1X,A
     +/'x := (x - X_bar)           `Centralise'         ,1X,A
     +/'x := (x - X_bar)/st.dev.(X)`Centralise/Scale'   ,1X,A 
     +/'x := Phi(x)                `N(0,1) cdf'         ,1X,A
     +/'x := Phi_inverse(x)        `N(0,1) inverse'     ,1X,A
     +/'x := arcsin,sinh,etc.      `Trig/Hyperbolic'    ,1X,A
     +/'View                       `Original/Transformed'
     +/'Help                       `More information'
     +/'Apply                      `Accept transformations'
     +/'Cancel                     `Discard transformations'
     +/'Note that transformations of x are done consecutively, log(x)'
     +/'can be base e,2,3,4,5,6,7,8,9, or 10, and some transformations'
     +/'require either k > 0, x > 0, 0 < x < 1, or k > x.'
     +/'No. of transformations =',i3, ', no. of Trig/Hyperbolic =',i3)
  200 FORMAT (
     + 'log to base e'
     +/'log to base 2'
     +/'log to base 3'
     +/'log to base 4'
     +/'log to base 5'
     +/'log to base 6'
     +/'log to base 7'
     +/'log to base 8'
     +/'log to base 9'
     +/'log to base 10')
  300 FORMAT ('k =',1P,E12.4)
  400 FORMAT ('log to base',1X,A)
  500 FORMAT ('k =',1P,E12.4,', log to base',1X,A)
  600 FORMAT (
     + 'How to transform and restore data'
     +/
     +/'From this menu you can transform the vector of data values as'
     +/'long as all the values are consistent with the transformation'
     +/'selected. For instance you cannot take logs or square roots of'
     +/'negative numbers or divide by zero.'
     +/'Example 1: the arcsine transformation'
     +/'Suppose you have some proportions expressed as percentages on'
     +/'a scale of 0 to 100 and wish to do the arcsine transformation.'
     +/'This would involve transforming the percentages to proportions'
     +/'by dividing by 100, taking the square root, then calculating'
     +/'the inverse sine of this. The following transformations would'
     +/'do this:'
     +/'x := x/k (with k = 100)'
     +/'x := x^k (with k = 0.5)'
     +/'x := arcsin(x) (from the Trig/Hyperbolic option)'
     +/'Example 2: reversing a transformation'
     +/'This is done using the inverse functions. For instance, to'
     +/'restore data from an arcsine transformation you would use'
     +/'x := sin(x) (from the trig/hperbolic option)'
     +/'x := x^k (with k = 2)'
     +/'x := kx (with k = 100)')
  700 FORMAT ('The data have not been transformed')
  800 FORMAT ('Success using',1X,A)
  900 FORMAT (
     +'No action taken...transformation stopped at x(',I6,') =',1PE12.4)
      END
C
C
