C
C
      SUBROUTINE VECTWO (NIN, NMAX, NX, NY,
     +                   X, Y,
     +                   TITLEX, TITLEY,
     +                   ABORT, FIXNPT)
C
C ACTION : Get one or two individual vectors or two columns from a matrix
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.,1/12/94
C          14/05/2003 extensively revised
C          22/04/2004 revised to permit use of n by 2 matrix for data input
C          22/01/2006 introduced allocatable arrays
C          02/03/2007 added INTENTS
C          19/04/2011 edited main menu
C
C           NIN: (input/unchanged) unconnected unit for data input
C          NMAX: (input/unchanged) dimension
C            NX: (input/output) size of X
C            NY: (input/output) size of Y
C             X: (input/output) X data
C             Y: (input/output) Y data
C        TITLEX: (input/output) X-title
c        TITLEY: (input/output) Y-title
C         ABORT: (output) error indicator
C        FIXNPT: (input/unchanged) if .TRUE. then warns if NX .NE. NY
C
C Note: This version only changes NX or NY if new data are input and only
C       returns ABORT = .TRUE. if there are no appropriate data, or the user
C       has selected Cancel to abort further calculations. It does not set
C       ABORT = .TRUE. if the user fails to read in data as it will just leave
C       any existing data unchanged. This involves the use of A and B so it
C       is important that NRMAX >= NMAX as set in the main program.
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NIN, NMAX 
      INTEGER,             INTENT (INOUT) :: NX, NY
      DOUBLE PRECISION,    INTENT (INOUT) :: X(NMAX), Y(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: TITLEX, TITLEY
      LOGICAL,             INTENT (IN)    :: FIXNPT   
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Local allocatable wokspaces
C
      DOUBLE PRECISION, ALLOCATABLE :: A(:,:), B(:)
C
C Locals
C
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NSTART, NTEXT, NUMOPT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NSTART = 11,
     +           NUMOPT = 7)
      INTEGER    N0, N1, N2, N3, N4, N5
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5)
      INTEGER    NCMAX, NRMAX
      PARAMETER (NCMAX = 2)
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      INTEGER    I, IERR, J, K, L, NROW
      CHARACTER  FNAME*1024, LINE*100, TITLE*80
      CHARACTER  CHOP60*60, CHOP80*80, TEXT(30)*100
      CHARACTER  XTITLE*80, YTITLE*80
      CHARACTER  STATE*30, WORD60*60, WX8*10, WY8*10
      CHARACTER  NODATA*60, NREADY*30, READY*30
      PARAMETER (NODATA = '(...No data...)',
     +           NREADY = '(..Not ready..)',
     +            READY = '(*** Ready ***)' )
      CHARACTER  OPTION(3)*4
      CHARACTER  BLANK4*4, STAR4*4
      PARAMETER (BLANK4 = '    ', STAR4 = '****')
      LOGICAL    REPEET
      LOGICAL    FIXNX, FIXNY, LABEL
      PARAMETER (FIXNX = .FALSE., FIXNY = .FALSE., LABEL = .TRUE.)
      LOGICAL    FIXCOL, FIXROW
      PARAMETER (FIXCOL = .TRUE., FIXROW = .FALSE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   PUTADV, VEC1IN, PUTFAT, LBOX01, CHOP80, TRIML1,
     +           PATCH1, MATTIN, CHOP60
      INTRINSIC  MIN
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
      ABORT = .TRUE.
      IF (NMAX.LT.1) RETURN
C
C Allocate workspaces
C
      NRMAX = NMAX
      IERR = 0
      IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(A(NRMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(B(NRMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Check input data
C
      IF (NX.GT.N1) THEN
         XTITLE = CHOP80(TITLEX)
      ELSE
         NX = N0
         XTITLE = NODATA
      ENDIF
      IF (NY.GT.N1) THEN
         YTITLE = CHOP80(TITLEY)
      ELSE
         NY = N0
         YTITLE = NODATA
      ENDIF
C
C Main loop
C
      NUMBLD(1) = 1
      REPEET = .TRUE.
      DO WHILE (REPEET)
         DO I = N1, N3
            OPTION(I) = BLANK4
         ENDDO
         IF (NX.LT.N2) THEN
            IF (FIXNPT) THEN
               NUMDEC = N3
            ELSE
               NUMDEC = N1
            ENDIF
            OPTION(NUMDEC) = STAR4
            STATE = NREADY
         ELSEIF (NY.LT.N2) THEN
            NUMDEC = N2
            OPTION(NUMDEC) = STAR4
            STATE = NREADY
         ELSEIF (FIXNPT) THEN
            IF (NX.EQ.NY) THEN
               NUMDEC = N5
               STATE = READY
            ELSE
               NUMDEC = N3
               OPTION(NUMDEC) = STAR4
               STATE = NREADY
            ENDIF
         ELSE
            NUMDEC = N5
            STATE = READY
         ENDIF
         WRITE (WX8,100) NX
         WRITE (WY8,100) NY
         CALL TRIML1 (WX8)
         CALL TRIML1 (WY8)
         WRITE (TEXT,200) WX8, XTITLE, WY8, YTITLE,
     +                   (OPTION(I), I = N1, N3),STATE
         NTEXT = NSTART + NUMOPT - 1
         NUMBLD(5) = 1
         NUMBLD(9) = 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(5) = 0
         NUMBLD(9) = 0
         IF (NUMDEC.EQ.N1) THEN
C
C Read in X data
C
            WRITE (LINE,300)
            CALL PUTADV (LINE)
            I = N3
            J = NIN
            K = MIN(NMAX, NRMAX)
            CLOSE (UNIT = J)
            CALL VEC1IN (I, J, K, L,
     +                   B,
     +                   FNAME, TITLE,
     +                   ABORT, FIXNX, LABEL)
            CLOSE (UNIT = J)
            IF (.NOT.ABORT .AND. L.GT.N1) THEN
               NX = L
               TITLEX = CHOP80(TITLE)
               XTITLE = TITLEX
               DO I = N1, NX
                  X(I) = B(I)
               ENDDO
            ENDIF
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C Read in Y data
C
            WRITE (LINE,400)
            CALL PUTADV (LINE)
            I = N3
            J = NIN
            K = MIN(NMAX, NRMAX)
            CLOSE (UNIT = J)
            CALL VEC1IN (I, J, K, L,
     +                   B,
     +                   FNAME, TITLE,
     +                   ABORT, FIXNY, LABEL)
            CLOSE (UNIT = J)
            IF (.NOT.ABORT .AND. L.GT.N1) THEN
               NY = L
               TITLEY = CHOP80(TITLE)
               YTITLE = TITLEY
               DO I = N1, NY
                  Y(I) = B(I)
               ENDDO
            ENDIF
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C Input a n by 2 matrix
C
            I = N3
            J = NCMAX
            K = NIN
            L = NRMAX
            CLOSE (UNIT = K)
            CALL MATTIN (I, J, J, K, L, NROW,
     +                   A, B,
     +                   FNAME, TITLE,
     +                   ABORT, FIXCOL, FIXROW, LABEL)
            CLOSE (UNIT = K)
            IF (.NOT.ABORT .AND. NROW.GT.N1) THEN
                NX = NROW
                NY = NROW
                DO I = N1, NROW
                   X(I) = A(I,N1)
                   Y(I) = A(I,N2)
                ENDDO
                WORD60 = CHOP60(TITLE)
                TITLEX = 'Col 1 of: '//WORD60
                TITLEY = 'Col 2 of: '//WORD60
                XTITLE = TITLEX
                YTITLE = TITLEY
            ENDIF
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C Interchange X and Y
C
            IF (NX.GT.N1 .AND. NY.GT.N1) THEN
               TITLE = TITLEX
               NROW = NX
               DO I = N1, NROW
                  B(I) = X(I)
               ENDDO
               TITLEX = TITLEY
               NX = NY
               DO I = N1, NX
                  X(I) = Y(I)
               ENDDO
               TITLEY = TITLE
               NY = NROW
               DO I = N1, NY
                  Y(I) = B(I)
               ENDDO
               XTITLE = TITLEX
               YTITLE = TITLEY
               WRITE (LINE,500)
               CALL PUTADV (LINE)
            ELSE
               WRITE (LINE,600)
               CALL PUTFAT (LINE)
            ENDIF
         ELSEIF (NUMDEC.EQ.N5) THEN
            IF (NX.LT.N2 .OR. NY.LT.N2) THEN
               WRITE (LINE,700)
               CALL PUTFAT (LINE)
            ELSEIF (FIXNPT .AND. NX.NE.NY) THEN
               WRITE (LINE,800)
               CALL PUTFAT (LINE)
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
               CLOSE (UNIT = NIN)
            ENDIF
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
            WRITE (TEXT,1000)
            NTEXT = 20
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTEXT,
     +                   TEXT,
     +                   BORDER)
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            REPEET = .FALSE.
            CLOSE (UNIT = NIN)
            ABORT = .TRUE.
         ENDIF
      ENDDO
C
C Deallocate workspace
C
      DEALLOCATE(A, STAT = IERR)
      DEALLOCATE(B, STAT = IERR)
C
C Format statements
C
  100 FORMAT (I8)
  200 FORMAT (
     + 'Identifying two data sets (X, Y) for analysis'
     +/
     +/'Size of current X-data: NX =',1X,A
     +/'Title of current X-data is:'
     +/A
     +/
     +/'Size of current Y-data: NY =',1X,A
     +/'Title of current Y-data is:'
     +/A
     +/
     +/'Input a new X-data vector',1X,A
     +/'Input a new Y-data vector',1X,A
     +/'Input a two-column matrix',1X,A
     +/'Interchange X and Y samples'
     +/'Analyse current X,Y data',1X,A
     +/'Help'
     +/'Quit ... Exit this data input procedure')
  300 FORMAT ('Now input the first data sample (X as a n by 1 vector)')
  400 FORMAT ('Now input the second data sample (Y as a n by 1 vector)')
  500 FORMAT ('The data sets have been successfully interchanged')
  600 FORMAT ('Insufficient data')
  700 FORMAT ('Sample size too small for a meaningful test')
  800 FORMAT ('Sample sizes are not equal')
 1000 FORMAT (
     + 'Supplying two data samples for analysis'
     +/
     +/'The analytical procedure you have selected requires two samples'
     +/'in the form of column vectors with no missing values, that is'
     +/
     +/'X with sample size NX (where NX > 1), and'
     +/'Y with sample size NY (where NY > 1).'
     +/
     +/'From this control you can input two sample vectors for each'
     +/'analysis or, if it is more convenient, maintain one sample'
     +/'as a reference sample and just renew one of the data sets.'
     +/
     +/'Note that some procedures (e.g. a paired t test) require'
     +/'identical sample sizes, i.e. NX = NY, which is easily done'
     +/'by reading in a two-column data matrix instead of 2 vectors.'
     +/'You can input data from vector/matrix files, type values at'
     +/'the terminal, or paste in as columns from the clipboard, but'
     +/'you should always supply meaningful titles, to identify the'
     +/'results retrospectively from these titles as they are written'
     +/'to the results log file.')
      END
C
C
