c
c
      subroutine vecval (isend, n,
     +                   abort)
c
c action: return values for the vector temporary file number
c author: w.g.bardsley, university of manchester, u.k., 25/01/2005
c         20/01/2007 added call to sim256
c         26/06/2010 added call to infofl
c
c         Note: this routine must be called in sequence with isend set
c               to 1, then 2. 3 decreases the counter in the event of
c               failure to create a file
c
c         isend: (input/unchanged) as follows
c                isend = 1 ... just open w_vector.cfg then return current n
c                isend = 2 ... increment n to n + 1 then update w_vector.cfg
c                isend = 3 ... decrement n to n - 1 then update w_vector.cfg
c             n: (output) as follows
c                abort = .true., n = - 1, isend out of range
c                abort = .true., n = - 2, w_vector.cfg is read_only
c                abort = .true., n = - 3, cannot create w_vector.cfg
c                abort = .true., n = - 4, cannot open w_vector.cfg
c                abort = .true., n = - 5, cannot read k from w_vector.cfg
c                abort = .false., 0 < n < kmax = current clipboard file number
c         abort: (output) error indicator
c
      implicit   none
c
c arguments
c
      integer, intent (in)  :: isend 
      integer, intent (out) :: n
      logical, intent (out) :: abort
c
c locals
c
      integer    ios, k, ksav, nout
c      
c Note: kmax limits the maximum number of temporary vector files
c
      integer    kmax, k6
      parameter (kmax = 20, k6 = 6)
      character  fname*1024, sim256*1024
      character  w_vector_cfg*12
      parameter (w_vector_cfg = 'w_vector.cfg')
      logical    exist, read_only
      external   getnou, attrib, sim256, infofl
      save       ksav
      data       ksav / 1 /
c
c initialise and check if w_vector.cfg is read_only
c
      abort = .true.
      n = - 1
      if (isend.lt.1 .or. isend.gt.3) return
      fname = sim256(w_vector_cfg)
      call attrib (fname, 
     +             exist, read_only)
      n = - 2
      if (exist .and. read_only) then
         call infofl (k6,
     +                fname)        
         return
      endif   
      if (.not.exist) then
c
c create a new w_vector.cfg file
c
         call getnou (nout)
         open (unit = nout, file = fname, iostat = ios)
         if (ios.ne.0) then
            n = - 3
            close (unit = nout)
            return
         endif
         n = 0
         write (nout,'(i6)') n
         write (nout,100)
         close (unit = nout)
      endif
c
c isend = 1: read and check current value
c
      if (isend.eq.1) then
         call getnou (nout)
         open (unit = nout, file = fname, iostat = ios)
         if (ios.ne.0) then
            n = - 4
            close (unit = nout)
            return
         endif
         read (nout,*,iostat=ios) k
         close (unit = nout)
         if (ios.ne.0) then
            n = - 5
            return
         endif
         ksav = k
c
c check that 0 =< ksav =< kmax
c
         if (ksav.lt.0) then
            ksav = 0
         elseif (ksav.gt.kmax) then
            ksav = kmax
         endif
         n = ksav
      else
         if (isend.eq.2) then
c
c isend = 2: increment n for the next file to be created
c
            if (ksav.eq.kmax) ksav = 0
            n = ksav + 1
         else
c
c isend = 3: decrement n as no file was created
c
            if (ksav.lt.1) ksav = 1
            n = ksav - 1
         endif
c
c write current value of n to w_vector.cfg then return
c
         call getnou (nout)
         open (unit = nout, file = fname)
         write (nout,'(i6)') n
         write (nout,100)
         close (unit = nout)
      endif
c
c set abort = .false. as there were no errors
c
      abort = .false.
c
c format statement
c      
  100 format (
     + 'This file stores the counter k for your current temporary'
     +/'vector data file, i.e. vector_k.tmp (0 =< k =< 20)'
     +/'Note: On reaching k = 20 the counter is re-set to k = 1')
      end
c
c
