
c
c
      subroutine viewer (isend,
     +                   fname, path, pattern)
c
c action: view/print ASCII text files
c         this version just calls w_viewer
c author: w.g.bardsley, university of manchester, u.k., 11/10/2004
c         15/02/2007 added intents
c         05/03/2012 added error message
c
c     isend: (input/unchanged) as follows:
c             isend = 1: view just the named file (if located) then return
c             isend = 2: view wild card pattern repeatedly until user quits
c             o/w return with no action
c     fname: (unchanged) as follows:
c             isend = 1: (input) fname must be the full path/file-name
c             isend = 2: not referenced
c      path: (unchanged) as follows:
c             isend = 1: not referenced
c             isend = 2: (input) path to be searched
c   pattern: (unchanged) as follows:
c             isend = 1: not referenced
c             isend = 2: (input) wild card pattern for search, e.g. "*.txt"
c
      implicit   none
c
c arguments
c      
      integer,             intent (in) :: isend
      character (len = *), intent (in) :: fname, path, pattern
c
c locals
c       
      integer    new_isend
      external   w_viewer, putfat
      if (isend.lt.1 .or. isend.gt.2) then
         call putfat ('ISEND must be 1 or 2 in call to VIEWER')
         return  
      endif   
      new_isend = isend
      call w_viewer (new_isend,
     +               fname, path, pattern)
      end
c
c
c
c
      subroutine view_file_types (itype,
     +                            fname, 
     +                            abort)
c
c action: view a file with special restrictions on file extensions
c author: w.g.bardsley, university of manchester, u.k., 16/11/2022  
c         02/01/2024 replaced logical check by a list box 
c
c itype = 1: extension = .eps, .ps
c itype = 2: extension = .pdf
c itype = 3: .bat., .c, .cfg,  .cpp, .f, .for, .htm. 'html, .ps, .tex, .tf1, .tf2, tf3, .txt., .tfl, .tmp, etc.
c otherwise return
 
c
c argument
c     
      integer, intent (in)               :: itype
      character (len = *), intent(inout) :: fname 
      logical, intent (inout)            :: abort
c
c local
c      
      integer    i, isend, l, nout
      parameter (isend = 3)
      integer    numdec, numopt, numsta, numtxt
      parameter (numopt = 3, numsta = 8, numtxt = 10)
      integer    numbld(numtxt) 
      character (len = 2   ) word2
      character (len = 3   ) word3
      character (len = 4   ) word4
      character (len = 5   ) word5
      character (len = 100 ) opts(numtxt)
      character (len = 46  ) mssage1, mssage2
      parameter (mssage1 = 
     +'EPS file for viewing must have extension .eps',
     +           mssage2 =
     +'PDF file for viewing must have extension .pdf')
      logical    ok, others
      external   getnou, ofiles, putadv, lcase1, x_epspdf, run_acrobat,
     +           text_viewer, lstbox
      intrinsic  len_trim
c
c check and intialise
c      
      if (itype.lt.1 .or. itype.gt.3) then
         abort = .true.
         call putadv ('ITYPE out of range in call to VIEW_FILE_TYPES')
         return
      else   
         abort = .false.
      endif   
c
c preliminary action to see if a file can be located
c      
      call getnou (nout)
      close (unit = nout)
      fname = ' '
      call ofiles (isend, nout,
     +             fname,
     +             abort)
      close (nout)
      if (abort) then
         call putadv ('File cannot be located or is in use') 
         return
      else
         ok = .true.   
      endif
c     
c a file has been located but action depends on file extension as required by itype
c
      l = len_trim (fname)
      word2 = fname(l - 1:l)
      word3 = fname(l - 2:l) 
      word4 = fname(l - 3:l)
      word5 = fname(l - 4:l)
      call lcase1 (word4)
c
c check for each value of itype
c      
          
      if (itype.eq.1) then
c
c ITYPE = 1: *.eps and *.ps
c      
         if (word3.eq.'.ps') then   
            call text_viewer (fname,
     +                           ok) 
         elseif (word4.eq.'.eps') then
            do i = 1, numtxt
               numbld(i) = 0
            enddo
            numbld(1) = 4   
            write (opts,100)
            numdec = 2
            do while (numdec.lt.3)
               call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                      opts)      
               if (numdec.eq.1) then 
                  ok = .true.           
                  call text_viewer (fname,
     +                              ok)           
               elseif (numdec.eq.2) then  
                  ok = .false.                  
                  call x_epspdf (fname)  
               endif
            enddo
         else  
            abort = .true.
            call putadv (mssage1)
            return
         endif   

      elseif (itype.eq.2) then
c
c IYPE = 2: *.pdf
c      
          if (word4.eq.'.pdf') then 
             call run_acrobat (fname)
          else
             abort = .true. 
             call putadv (mssage2)
             return
          endif   
      elseif (itype.eq.3) then
c
c ITYPE = 3: various file types
c      
         if (word4.eq.'.pdf') then
            call run_acrobat (fname)
            return
         endif   
c
c others
c      
          if (word2 .eq. '.f'   .or. 
     +        word3 .eq. '.ps'  .or.
     +        word4 .eq. '.eps' .or.
     +        word4 .eq. '.bat' .or.  word4.eq. '.cfg' .or.
     +        word4 .eq. '.cpp' .or.  word4.eq. '.htm' .or.
     +        word4 .eq. '.tex' .or.  word4.eq. '.tf1' .or.
     +        word4 .eq. '.tf2' .or.  word4.eq. '.tf3' .or.
     +        word4 .eq. '.tfl' .or.  word4.eq. '.tmp' .or. 
     +        word4 .eq. '.txt' .or.
     +        word5 .eq. '.html' ) then
            others = .true.
         endif 
         if (others) then
           call text_viewer (fname,
     +                       ok)
         else
            abort = .true.
            return
         endif   
      endif
      abort = .false.
  100 format (
     + 'Using the Simfit program EPSVIEW'
     +/
     +/'This utility allows users to swap between'
     +/'viewing the ASCII source code or viewing as'
     +/'pdf. In either case the data can be saved'
     +/'to file in the chosen format.'
     +/
     +/'View/Save the eps source code'
     +/'View/Save as a pdf file'
     +/'Quit ... Exit epsview')    
      end
c
c   