c
c
      subroutine window (isend, 
     +                   title,
     +                   action)
c
c action: open/close a window and create f$simfit.tmp if title = Simfit program
c author: w.g.bardsley, university of manchester, u.k., 15/11/2006
c         15/11/2006 new front end to call w_window  
c         16/02/2007 added call to sim256
c         20/04/2014 added subroutine close_unit_4
c         26/06/2014 extended units closed to include 3, 4, then between 10 and 15 
c
c         isend: (input/unchanged) no window if isend < 1
c         title: (input/unchanged) must be a Simfit program to create f$simfit.tmp
c        action: (input/unchanged) switch on/off window/f$simfit.tmp
c
      implicit   none
c
c arguments
c
      integer,             intent (in) :: isend
      character (len = *), intent (in) :: title
      logical,             intent (in) :: action
c
c locals
c
      integer    ios, k, len200, mode
      parameter (mode = -1)
      integer    kval(12)
      character  line*100, temp*80, title1*8
      character  cval(12)*1024, fname*1024, sim256*1024
      character  pname*12
      parameter (pname = 'f$simfit.tmp')
      logical    showit
      logical    askif, there
      parameter (askif = .false.)
      external   lcase1, getnou, deleet, putfat, triml1, len200,
     +           w_waiter, ucase1, w_config, w_window, sim256
      external   temporary_yield
      external   close_unit_4
      save       showit
      data       showit / .true. / 
      fname = sim256(pname)
      if (action) then
c 
c *************************************
c MODE 1, entered with action = .true.: first check isend then see if we have  
c ************************************* been called from a main program as
c                                       ...'Simfit: program '//PNAME
c   
         if (isend.lt.1) then
            showit = .false.
         else   
            call temporary_yield()
            call w_config (mode, kval,
     +                     cval)
            call temporary_yield()
            if (kval(6).eq.1) then
               showit = .true.
            else
               showit = .false.
            endif
         endif 
         temp = title
         call triml1 (temp)
         call lcase1 (temp)
         title1 = temp(1:8)
         if (temp(1:16).eq.'simfit: program ') then
            title1 = temp(17:len200(temp))
            call triml1 (title1)
            if (title1.eq.'adderr'   .or. title1.eq.'average'  .or.
     +          title1.eq.'binomial' .or. title1.eq.'calcurve' .or.
     +          title1.eq.'chisqd'   .or. title1.eq.'compare'  .or.
     +          title1.eq.'csafit'   .or. title1.eq.'deqsol'   .or.
     +          title1.eq.'editfl'   .or. title1.eq.'editmt'   .or.
     +          title1.eq.'editps'   .or. title1.eq.'eoqsol'   .or.
     +          title1.eq.'exfit'    .or. title1.eq.'ftest'    .or.
c
c no action if called from help
c****+          title1.eq.'gcfit'    .or. title1.eq.'help'     .or.
c
     +          title1.eq.'gcfit'    .or.
     +          title1.eq.'hlfit'    .or. title1.eq.'inrate'   .or.
     +          title1.eq.'linfit'   .or. title1.eq.'makcsa'   .or.
     +          title1.eq.'makdat'   .or. title1.eq.'makfil'   .or.
     +          title1.eq.'maklib'   .or. title1.eq.'makmat'   .or.
     +          title1.eq.'maksim'   .or. title1.eq.'mmfit'    .or.
     +          title1.eq.'normal'   .or. title1.eq.'polnom'   .or.
     +          title1.eq.'qnfit'    .or. title1.eq.'rannum'   .or.
     +          title1.eq.'rffit'    .or. title1.eq.'rstest'   .or.
c
c no action if called from run5
c****+          title1.eq.'run5'     .or. title1.eq.'sffit'    .or.
c
     +                                    title1.eq.'sffit'    .or.
     +          title1.eq.'simplot'  .or. title1.eq.'simstat'  .or.
     +          title1.eq.'spline'   .or. title1.eq.'ttest'    .or.
     +          title1.eq.'usermod') then
c
c if action and appropriate then try to create and write to f$simfit.tmp
c
               call getnou (k)
               close (unit = k)      
               open (unit = k, file = fname, iostat = ios)
               close (unit = k)
               inquire (file = fname, exist = there)
               if (there .and. ios.eq.0) then
                  open (unit = k, file = fname)
                  write (k,'(a)',iostat=ios) title1
                  close (unit = k)
               endif
               if (ios.ne.0) then
                  write (line,100)
                  call putfat (line)
               endif
            endif
         endif
         if (showit) then
c
c call w_window to create the backgound window if required
c              
            call ucase1 (title1)       
            temp = title1
            call w_window (close_unit_4,
     +                     temp,
     +                     action)              
         endif
      else
c                               
c***************************************
c MODE 2, entered with action = .false.: first make sure waiter is switched off
c*************************************** then delete f$simfit.tmp and close down
c                                        the window (if it has been created)
c
         call w_waiter (action)
         call deleet (fname,
     +                askif, there)
         if (there) then
            ios = -1
            write (line,200)
            call putfat (line)
         else
            ios = 0
         endif
         if (ios.ne.0) then
            write (line,300)
            call putfat(line)
         endif
         if (showit) then
            temp = '...'
            call w_window (close_unit_4, 
     +                     temp,
     +                     action)             
         endif
      endif
  100 format (
     +'Simfit cannot write to f$simfit.tmp: remove read-only attribute')
  200 format (
     +'Simfit cannot delete f$simfit.tmp: remove read-only attribute')
  300 format (
     +'Simfit must be permitted to create, write to and delete files.')
      end
c
c  
      subroutine close_unit_4
c
c action: close any units that may have been opened by simfit i.e. 3, 4 or 10 upwards
c author: w.g.bardsley, university of manchester, u.k., 04/07/2014
c         11/04/2019 edited to make sure units 3, 4, 10, 11, 12, 13, 14, 15 are closed   
c     
      implicit none
      integer    i, ios, nout
      integer    nout_4
      parameter (nout_4 = 4)
      character (len = 40) mssage
      parameter (mssage = '**Program terminated by closure cross**')
      logical    op
      external   temporary_yield
c
c attempt to sign off then close unit = 4
c      
      call temporary_yield()
      inquire (unit = nout_4, opened = op, iostat = ios)
      if (ios.eq.0 .and. op) then
         write (nout_4,'(a)',iostat=ios) mssage
         close (unit = nout_4, iostat = ios)
         call temporary_yield() 
      endif  
c
c make sure all possible simfit units are closed
c       
      do i = 3, 15
         if (i.le.4 .or. i.ge.10) then
            nout = i
            close (unit = nout, iostat = ios)
         endif   
      enddo 
      call temporary_yield()  
      end
c
c       