c
c
       subroutine xml000 (nin, nlines, nrmax, 
     +                    fname, matrix, strng)           
c
c action: parse a putative xml file from Excel
c author: w.g.bardsley, university of manchester, u.k., 21/04/2008
c         31/08/2008 corrected error counting > and < as part of the string  
c         27/11/2014 decreased nmax from 10^7 to 10^5
c         09/08/2022 added two blanks after a cell is closed by "<"         
c
c    nin: (input/unchanged) unconnected unit for file opening
c nlines: (output) no. of lines read from file
c  nrmax: (input/unchanged) dimension of matrix
c  fname: (input/unchanged) supposed xml file
c matrix: (output) table read from the file
c  strng: (output) workspace  
c
      implicit none
c
c arguments
c          
      integer,             intent (in)  :: nin, nrmax
      integer,             intent (out) :: nlines 
      character (len = *), intent (in)  :: fname
      character (len = *), intent (out) :: matrix(nrmax), strng
c
c locals
c      
      integer    icount, l, ios, nstart, nstop
      integer    len200
      integer    nmax
      parameter (nmax = 100000)
      character  new_file*1024 
      character  buffer*(nmax), ext*4, letter*1, text*1024
      character  bigx*1, blank*1, tab*1
      parameter (bigx = 'X', blank = ' ')
      logical    abort, action, there
      logical    askif
      parameter (askif = .false.)
      external   len200, lcase1, xml001, deleet
      intrinsic  len, index, char
c
c initialise then open the file
c      
      nlines = 0
      if (nin.lt.1 .or. nrmax.lt.1) return
      l = len(strng)
      if (l.lt.1) return  
      inquire (file = fname, exist = there)
      if (.not.there) return
      l = len200(fname)
      if (l.lt.5) return
      ext = fname(l - 3:l)
      call lcase1 (ext)
      if (ext.ne.'.xml') return
c
c copy the file into buffer then parse and write out to new_file
c        
      call xml001 (nin,
     +             buffer, fname, new_file,
     +             abort)
      if (abort) return      
      close (unit = nin)
      open (unit = nin, file = new_file, iostat = ios)
      if (ios.ne.0) then
         close (unit = nin)
         return
      endif
c
c attempt to read the file
c      
      tab = char(9)
      action = .false.
      
      do while (ios.eq.0)
        
         read (nin,'(a)',iostat=ios) text
         
         if (index(text,'<Table').gt.0) then
c
c the table has started so read another line
c           
            read (nin,'(a)',iostat=ios) text
         elseif (index(text,'</Table').gt.0) then
c
c the table has ended so close down
c         
            ios = -1
         endif
                
         if (ios.eq.0) then
           
            if (index(text,'<Row').gt.0) then
c
c a new row has started so initialise then increment nlines
c              
                icount = 0
                action = .true.
                strng = blank
                text = blank
                nlines = nlines + 1
            endif
            
            if (index(text,'</Row>').gt.0) then
c
c a row has finished so add to matrix (if len200(strng) > 0) or cancel if blank
c              
               action = .false.
               if (icount.gt.0) strng(icount:icount) = blank
               l = len200(strng)
               if (l.le.0) strng = blank  
               if (strng.eq.blank) then
c
c cancel this line
c                 
                  nlines = nlines - 1
               else
c
c add this line if space permits
c                      
                  if (nlines.le.nrmax) matrix(nlines) = strng
               endif   
            endif
            
            if (action) then
c
c a row is being constructed
c
               l = index(text,'ss:Index="')

               if (l.gt.0) then
                  nstart = 11
                  nstop = l + 4
                  if (text(nstart:nstop).eq.'256"') l = 0
               endif      

               if (l.gt.0) then
c
c an empty cell has been encountered
c                 
                  icount = icount + 1
                  strng(icount:icount) = bigx
                  icount = icount + 1
                  strng(icount:icount) = tab
               endif
                   
               
               l = index(text,'ss:Type="String">')
               
               if (l.gt.0) then
c
c a cell with a string has been encountered
c                 
                  l = l + 17
                  letter = text(l:l)
                  icount = icount + 1
                  strng(icount:icount) = letter
                  do while (letter.ne.'<')
                     l = l + 1
                     letter = text(l:l)
                     if (letter.ne.'<') then
                        icount = icount + 1
                        strng(icount:icount) = letter
                     endif
                  enddo
                  icount = icount + 1
                  strng(icount:icount) = tab       
               endif
               
               l = index(text,'ss:Type="Number">')
               
               if (l.gt.0) then
c
c a numeric cell has been encountered
c                 
                  l = l + 17
                  letter = text(l:l)
                  icount = icount + 1
                  strng(icount:icount) = letter
                  do while (letter.ne.'<')
                     l = l + 1
                     letter = text(l:l)
                     if (letter.ne.'<') then
                        icount = icount + 1
                        strng(icount:icount) = letter
                     endif
                  enddo
                  icount = icount + 1
                  strng(icount:icount) = blank
                  icount = icount + 1
                  strng(icount:icount) = blank
                  icount = icount + 1
                  strng(icount:icount) = tab       
               endif
               
            endif
         
         endif   
            
      enddo
c
c close unit = nin
c      
      close (unit = nin)
      call deleet (new_file,
     +             askif, there)
      end   
c
c  

