c
c
      subroutine xml001 (nin,
     +                   buffer, fname1, fname2, 
     +                   abort)
c
c action: break a buffer into tokens at xml tags
c author: w.g.bardsley, university of manchester, u.k., 28/04/2008
c     
      implicit none
c
c arguments
c      
      integer,             intent(in)   :: nin  
      character (len = *), intent (out) :: buffer, fname2            
      character (len = *), intent (in)  :: fname1            
      logical,             intent (out) :: abort 
c
c allocatable
c            
      logical, allocatable :: testit(:)    
c
c locals
c      
      integer  i, ierr, ios, j, n, nstart, nstop
      logical  check_cell, check_row, check_table
      external nbytes, gettmp
c
c initialise abort then calculate n = number of bytes read into buffer
c      
      abort = .true.
      call nbytes (n,
     +             buffer, fname1)
      if (n.le.0) return
c
c get a new temporary file name
c        
      call gettmp (i, 
     +             fname2)
      close (unit = nin)
      open (unit = nin, file = fname2, iostat = ios)   
      if (ios.ne.0) then
         close (unit = nin)
         return
      endif
      ierr = 0
      if (allocated(testit)) deallocate(testit, stat = ierr)
      if (ierr.ne.0) return
      allocate(testit(n), stat = ierr)
      if (ierr.ne.0) return
      do i = 1, n
         testit(i) = .true.
      enddo     
c
c parse the buffer
c      
      check_cell = .true.
      check_row = .true.
      check_table = .true.
      do i = 1, n

         if (check_table) then
           
           if (buffer(i:i + 5).eq.'<Table') then
c
c check for start of the table
c           
               nstart = i
               nstop = nstart + 5
               write (nin,'(a)') buffer(nstart:nstop)
               do j = nstart, nstop 
                  testit(j) = .false.
               enddo   
               check_table = .false.
            endif        
        
         elseif (testit(i)) then
 
            if (check_row) then
               if (buffer(i:i + 3).eq.'<Row') then
c
c start of a row
c            
                  nstart = i
                  nstop = nstart + 3
                  write (nin,'(a)') buffer(nstart:nstop)
                  do j = nstart, nstop 
                    testit(j) = .false.
                 enddo
                 check_row = .false.                
              endif
            endif   
         
            if (testit(i)) then
               if (check_cell) then
                  if (buffer(i:i + 4).eq.'<Cell') then
c
c start of a cell
c             
                     nstart = i
                     do j = nstart, nstart + 4
                        testit(j) = .false.
                     enddo   
                  endif
                  check_cell = .false.
               endif   
            endif   
         
            if (testit(i)) then
               if (.not.check_cell) then
                  if (buffer(i:i + 6).eq.'</Cell>') then
c
c end of a cell
c           
                     nstop = i + 6
                     write (nin,'(a)') buffer(nstart:nstop)
                     do j = nstart, nstop 
                        testit(j) = .false.
                     enddo                 
                  endif
                  check_cell = .true.
               endif   
            endif

            if (testit(i)) then 
               if (.not.check_row) then
                  if (buffer(i:i + 5).eq.'</Row>') then
c
c end of a row
c           
                     nstart = i
                     nstop = nstart + 5
                     write (nin,'(a)') buffer(nstart:nstop)
                     do j = nstart, nstop 
                        testit(j) = .false.
                     enddo                
                     check_row = .true.
                  endif
               endif   
            endif            
         endif

         if (testit(i)) then
            if (buffer(i:i + 7).eq.'</Table>') then
c
c check for end of the table
c           
               nstart = i
               nstop = nstart + 7
               write (nin,'(a)') buffer(nstart:nstop)
               close (unit = nin)
               abort = .false.
               deallocate(testit, stat = ierr)
               return
            endif
         endif            
      enddo
      close (unit = nin)
      deallocate(testit, stat = ierr)

      end
c
c      
      