c
c
      subroutine xpress (file_in, file_out,
     +                   abort)
c
c action: call the David Bailey program DB_PARSER to parse expressions in model files
c author: w.g.bardsley, university of manchester, u.k., 27/01/2016
c
c This subroutine reads in a model file called file_in and there are three cases
c 1) w_db_parser.exe is a local file
c 2) x64_db_parser.exe is a local file
c 3) w_db_parser.exe and x64_db_parser.exe are not local files
c In cases 1) and 2) file_out contains file_in parsed for begin{expression} ... end{expression}
c In case 3) file_out is just a copy of file_in
c
      implicit none
c
c arguments
c          
      character (len = *), intent (in)  :: file_in
      character (len = *), intent (out) :: file_out
      logical,             intent (out) :: abort 
c
c locals
c       
      integer    ios, l_in, l_out, nout
      character (len = 100) line
      character (len = 12 ) parser
      parameter (parser = 'f$parser.tmp')
      character (len = 1  ) blank, bslash
      parameter (blank = ' ', bslash = '\')
      logical    op, there
      external   getnou, putfat, ucase1, v7path
      external   w_xpress
c
c initialise then check the filename supplied
c
      file_out = blank 
      abort = .true.
      
      inquire (file = file_in, exist = there, opened = op, iostat = ios)
      if (.not.there) then
         call putfat ('Model file supplied does not exist')
         return
      endif
      if (op) then
         call putfat ('Model file supplied is already opened')
         return
      endif 
c
c define file_out
c      
      call v7path (l_out,
     +             'tmp', file_out)
      if (file_out(l_out:l_out).ne.bslash) then
         l_out = l_out + 1
         file_out(l_out:l_out) = bslash
      endif 
      l_in = l_out + 1
      l_out = l_out + 12
      file_out(l_in:l_out) = parser
      call getnou (nout)
      open (unit = nout, file = file_out, iostat = ios)
      if (ios.eq.0) write (nout,'(a)',iostat=ios) blank
      close (unit = nout)
      if (ios.ne.0) then
         call putfat ('Output file f$parser.tmp cannot be opened')
         return
      endif
      l_in = len_trim(file_in)
      l_out = len_trim(file_out)
c
c call to dp_parser.cpp
c      
      call w_xpress (file_in(1:l_in), file_out(1:l_out))
c
c see if an error has been detected in db_parser
c       
      inquire (file = file_out, iostat = ios, opened = op)
      if (op) then
         call putfat ('f$parser.tmp connected on exit from w_xpress')
         abort = .true.
         return
      endif
      if (ios .ne. 0) then
         call putfat ('ios.ne.0 from inquire (f$parser.tmp/w_xpress)')
         abort = .true.
         return
      endif      
      call getnou (nout)
      open (unit = nout, file = file_out, iostat = ios)
      if (ios.eq.0) then
         read (nout,'(a)',iostat=ios) line
         call ucase1 (line)
         if (index(line,'ERROR:').gt.0) then
            call putfat (line) 
            abort = .true.
         else
            abort = .false.
         endif
      else
         call putfat ('f$parser.tmp cannot be opened for checking')
         abort = .true.
      endif
      close (unit = nout)
      end
c
c        