C
C Sublevel 1 models for QNLIB1
C ============================
C
C
      FUNCTION F101 (M, N, A, X, XTOL, ZTOL, CONST)
C      ... Polynomial of degree M
      IMPLICIT NONE
      INTEGER  M, N
      INTEGER  I
      DOUBLE PRECISION A(N), X, XTOL, ZTOL
      DOUBLE PRECISION F101
      LOGICAL  CONST
      EXTERNAL MIDDLE
      IF (M.EQ.0) THEN
         F101 = A(1)
      ELSE
         F101 = A(M)
         DO I = M - 1, 1, - 1
            F101 = F101*X + A(I)
            CALL MIDDLE (XTOL, F101, ZTOL)
         ENDDO
         F101 = F101*X
         IF (CONST) F101 = F101 + A(N)
      ENDIF
      END
C
C
      FUNCTION F102 (M, N, A, RTOL, X, XTOL, ZTOL, CONST)
C      ... Rational function of degree M:M: where M = (N - 1)/2
      IMPLICIT NONE
      INTEGER  M, N
      INTEGER  I
      DOUBLE PRECISION A(N), RTOL, X, XTOL, ZTOL
      DOUBLE PRECISION C, D, F102
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      LOGICAL  CONST
      EXTERNAL MIDDLE
      INTRINSIC ABS
      F102 = ZERO
      C = A(2*M)
      D = A(M)
      DO I = M - 1, 1, - 1
         C = C*X + A(M + I)
         CALL MIDDLE (XTOL, C, ZTOL)
         D = D*X + A(I)
         CALL MIDDLE (XTOL, D, ZTOL)
      ENDDO
      C = C*X + ONE
      CALL MIDDLE (XTOL, C, ZTOL)
      D = D*X
      IF (CONST) D = D + A(N)
      CALL MIDDLE (XTOL, D, ZTOL)
      IF (ABS(C).GE.RTOL) F102 = D/C
      END
C
C
      FUNCTION F103 (M, N, A, B, RTOL, X, XTOL, ZTOL, CONST)
C      ... Sum of Michaelis Menten functions plus constant
      IMPLICIT NONE
      INTEGER  M, N
      INTEGER  I
      DOUBLE PRECISION A(N), B(N), RTOL, X, XTOL, ZTOL
      DOUBLE PRECISION C, F103, XTEMP
      DOUBLE PRECISION ZERO, ONE, THREE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, THREE = 3.0D+00)
      LOGICAL  CONST
      EXTERNAL MIDDLE
      INTRINSIC ABS
      F103 = ZERO
      IF (B(1).LE.ONE) THEN
         DO I = 1, M
            C = A(M + I) + X
            IF (ABS(C).GE.RTOL) F103 = F103 + A(I)*X/C
            CALL MIDDLE (XTOL, F103, ZTOL)
         ENDDO
      ELSEIF (B(1).LE.THREE) THEN
         XTEMP = X + B(2)
         DO I = 1, M
            C = A(M + I) + XTEMP
            IF (ABS(C).GE.RTOL) F103 = F103 + B(2)*A(I)/C
            CALL MIDDLE (XTOL, F103, ZTOL)
         ENDDO
      ELSE
         DO I = 1, M
            C = A(M + I) + X
            IF (ABS(C).GE.RTOL) F103 = F103 + A(I)/C
            CALL MIDDLE (XTOL, F103, ZTOL)
         ENDDO
      ENDIF
      IF (CONST) F103 = F103 + A(N)
      END
C
C
      FUNCTION F104 (M, N, A, B, RTOL, X, XTOL, ZTOL, CONST)
C      ... Sum of high/low affinity sites plus constant
      IMPLICIT NONE
      INTEGER  M, N
      INTEGER  I
      DOUBLE PRECISION A(N), B(N), RTOL, X, XTOL, ZTOL
      DOUBLE PRECISION C, D, F104, XTEMP
      DOUBLE PRECISION ZERO, ONE, THREE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, THREE = 3.0D+00)
      LOGICAL  CONST
      EXTERNAL MIDDLE
      INTRINSIC ABS
      F104 = ZERO
      IF (B(1).LE.ONE) THEN
         DO I = 1, M
            C = A(M + I)*X
            D = ONE + C
            IF (ABS(D).GE.RTOL) F104 = F104 + A(I)*C/D
            CALL MIDDLE (XTOL, F104, ZTOL)
         ENDDO
      ELSEIF (B(1).LE.THREE) THEN
         XTEMP = X + B(2)
         DO I = 1, M
            C = A(M + I)
            D = ONE + C*XTEMP
            IF (ABS(D).GE.RTOL) F104 = F104 + B(2)*A(I)*C/D
            CALL MIDDLE (XTOL, F104, ZTOL)
         ENDDO
      ELSE
         DO I = 1, M
            C = A(M + I)
            D = ONE + C*X
            IF (ABS(D).GE.RTOL) F104 = F104 + A(I)*C/D
            CALL MIDDLE (XTOL, F104, ZTOL)
         ENDDO
      ENDIF
      IF (CONST) F104 = F104 + A(N)
      END
C
C
      FUNCTION F105 (M, N, A, B, RTOL, X, XTOL, ZTOL, CONST)
C      ... Saturation function plus constant
      IMPLICIT NONE
      INTEGER  M, N
      INTEGER  I
      DOUBLE PRECISION A(N), B(N), RTOL, X, XTOL, ZTOL
      DOUBLE PRECISION C, D, F105, XTEMP
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      LOGICAL  CONST
      EXTERNAL MIDDLE
      INTRINSIC ABS, DBLE
      F105 = ZERO
      C = ZERO
      D = A(M)
      IF (B(1).LE.ONE) THEN
         DO I = M - 1, 1, - 1
            C = C*X + D
            CALL MIDDLE (XTOL, C, ZTOL)
            D = D*X + A(I)
            CALL MIDDLE (XTOL, D, ZTOL)
         ENDDO
         C = C*X + D
         CALL MIDDLE (XTOL, C, ZTOL)
         D = D*X + ONE
         CALL MIDDLE (XTOL, D, ZTOL)
         IF (ABS(D).GE.RTOL) F105 = A(M + 1)*C*X/(DBLE(M)*D)
      ELSE
         XTEMP = X + B(2)
         DO I = M - 1, 1, - 1
            C = C*XTEMP + D
            CALL MIDDLE (XTOL, C, ZTOL)
            D = D*XTEMP + A(I)
            CALL MIDDLE (XTOL, D, ZTOL)
         ENDDO
         C = C*XTEMP + D
         CALL MIDDLE (XTOL, C, ZTOL)
         D = D*XTEMP + ONE
         CALL MIDDLE (XTOL, D, ZTOL)
         IF (ABS(D).GE.RTOL) F105 = A(M + 1)*C*B(2)/(DBLE(M)*D)
      ENDIF
      IF (CONST) F105 = F105 + A(N)
      END
C
C
      FUNCTION F106 (M, N, A, B, RTOL, X, XTOL, ZTOL, CONST)
C     ... Saturation function plus constant
      IMPLICIT NONE
      INTEGER  M, N
      INTEGER  I
      DOUBLE PRECISION A(N), B(N), RTOL, X, XTOL, ZTOL
      DOUBLE PRECISION BTEMP(50), C, D, F106, XTEMP
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      LOGICAL  CONST
      EXTERNAL MIDDLE
      INTRINSIC ABS, DBLE
      F106 = ZERO
      BTEMP(1) = A(1)
      DO I = 2, M
         BTEMP(I) = A(I)*BTEMP(I - 1)
      ENDDO
      C = ZERO
      D = BTEMP(M)
      IF (B(1).LE.ONE) THEN
         DO I = M - 1, 1, - 1
            C = C*X + D
            CALL MIDDLE (XTOL, C, ZTOL)
            D = D*X + BTEMP(I)
            CALL MIDDLE (XTOL, D, ZTOL)
         ENDDO
         C = C*X + D
         CALL MIDDLE (XTOL, C, ZTOL)
         D = D*X + ONE
         CALL MIDDLE (XTOL, D, ZTOL)
         IF (ABS(D).GE.RTOL) F106 = A(M + 1)*C*X/(DBLE(M)*D)
      ELSE
         XTEMP = X + B(2)
         DO I = M - 1, 1, - 1
            C = C*XTEMP + D
            CALL MIDDLE (XTOL, C, ZTOL)
            D = D*XTEMP + BTEMP(I)
            CALL MIDDLE (XTOL, D, ZTOL)
         ENDDO
         C = C*XTEMP + D
         CALL MIDDLE (XTOL, C, ZTOL)
         D = D*XTEMP + ONE
         CALL MIDDLE (XTOL, D, ZTOL)
         IF (ABS(D).GE.RTOL) F106 = A(M + 1)*C*B(2)/(DBLE(M)*D)
      ENDIF
      IF (CONST) F106 = F106 + A(N)
      END
C
C
      FUNCTION F107 (M, N, A, B, ENEG, EPOS, X, XTOL, ZTOL, CONST)
C     ... Sum of Exponentials
      IMPLICIT NONE
      INTEGER  M, N
      INTEGER  I
      DOUBLE PRECISION A(N), B(N), ENEG, EPOS, X, XTOL, ZTOL
      DOUBLE PRECISION C, F107
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      LOGICAL  CONST
      EXTERNAL MIDDLE
      INTRINSIC EXP
      F107 = ZERO
      IF (B(1).LE.ONE) THEN
         DO I = 1, M
            C = - A(M + I)*X
            CALL MIDDLE (ENEG, C, EPOS)
            F107 = F107 + A(I)*EXP(C)
            CALL MIDDLE (XTOL, F107, ZTOL)
         ENDDO
      ELSE
         DO I = 1, M
            C = - A(M + I)*X
            CALL MIDDLE (ENEG, C, EPOS)
            F107 = F107 + A(I)*(ONE - EXP(C))
            CALL MIDDLE (XTOL, F107, ZTOL)
         ENDDO
      ENDIF
      IF (CONST) F107 = F107 + A(N)
      END
C
C
      FUNCTION F108 (M, N, A, B, X, XTOL, ZTOL, CONST)
C     ... trigonometrics
      IMPLICIT   NONE
      INTEGER    M, N
      INTEGER    I, J, K
      DOUBLE PRECISION A(N), B(N), X, XTOL, ZTOL
      DOUBLE PRECISION C, F108
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      LOGICAL    CONST
      EXTERNAL   MIDDLE
      INTRINSIC  COS, SIN
      F108 = ZERO
      J = M
      K = 2*M
      IF (B(1).LE.ONE) THEN
         DO I = 1, M
            J = J + 1
            K = K + 1
            C = A(J)*X + A(K)
            F108 = F108 + A(I)*SIN(C)
            CALL MIDDLE (XTOL, F108, ZTOL)
         ENDDO
      ELSE
         DO I = 1, M
            J = J + 1
            K = K + 1
            C = A(J)*X + A(K)
            F108 = F108 + A(I)*COS(C)
         ENDDO
      ENDIF
      IF (CONST) F108 = F108 + A(N)
      END
C
C
      FUNCTION F109 (M, N, A, B, ENEG, EPOS, RTOL, X, XTOL, ZTOL, CONST)
C     ... Gaussians
C     ... Z = sqrt(2pi)
      IMPLICIT   NONE
      INTEGER    M, N
      INTEGER    I, IFAIL
      DOUBLE PRECISION A(N), B(N), ENEG, EPOS, RTOL, X, XTOL, ZTOL
      DOUBLE PRECISION Z
      PARAMETER (Z = 2.50662827463D+00)
      DOUBLE PRECISION C, D, F109, S15ABF$
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      LOGICAL    CONST
      EXTERNAL   MIDDLE, S15ABF$
      INTRINSIC  ABS, EXP
      F109 = ZERO
      IF (B(1).LE.ONE) THEN
         DO I = 1, M
            IFAIL = 2*M + I
            C = TWO*(A(IFAIL)**2)
            IF (C.GT.RTOL) THEN
               D = - ((X - A(M + I))**2/C)
               CALL MIDDLE (ENEG, D, EPOS)
               C = Z*A(IFAIL)
               IF (ABS(C).GE.RTOL) THEN
                  F109 = F109 + A(I)*EXP(D)/C
                  CALL MIDDLE (XTOL, F109, ZTOL)
               ENDIF
            ENDIF
         ENDDO
      ELSE
         DO I = 1, M
            IFAIL = 2*M + I
            C = ABS(A(IFAIL))
            IF (C.GT.RTOL) THEN
               D = (X - A(M + I))/A(IFAIL)
               IFAIL = 1
               F109 = F109 + A(I)*S15ABF$(D, IFAIL)
               CALL MIDDLE (XTOL, F109, ZTOL)
            ENDIF
         ENDDO
      ENDIF
      IF (CONST) F109 = F109 + A(N)
      END
C
C
