C
C Sublevel 2 Models for QNLIB1
C ============================
C
C
      FUNCTION F110 (M, N, A, B, ENEG, EPOS, RTOL, X, CONST)
C     ... Selection A ... Biological
      IMPLICIT NONE
      INTEGER  M, N
      DOUBLE PRECISION A(N), B(N), ENEG, EPOS, RTOL, X
      DOUBLE PRECISION C, D, E, F110
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, FIVE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, FIVE = 5.0D+00)
      LOGICAL  CONST
      EXTERNAL MIDDLE
      INTRINSIC ABS, EXP, MAX
      F110 = ZERO
      IF (M.EQ.1) THEN
C     ... Exponential growth
         IF (B(1).LE.ONE) THEN
            C = - A(2)*X
            CALL MIDDLE (ENEG, C, EPOS)
            F110 = A(1)*EXP(C)
            IF (CONST) F110 = F110 + A(N)
         ELSEIF (B(1).LE.THREE) THEN
            C = A(1) - A(2)*X
            CALL MIDDLE (ENEG, C, EPOS)
            F110 = EXP(C)
            IF (CONST) F110 = F110 + A(N)
         ELSE
            C = - A(2)*X
            CALL MIDDLE (ENEG, C, EPOS)
            D = EXP(C)
            F110 = A(1)*D
            IF (CONST) F110 = F110 + A(3) - A(3)*D
         ENDIF
      ELSEIF (M.EQ.2) THEN
C     ... Monomolecular growth
         C = - A(2)*X
         CALL MIDDLE (ENEG, C, EPOS)
         F110 = A(1)*(ONE - EXP(C))
         IF (CONST) F110 = F110 + A(N)
      ELSEIF (M.EQ.3) THEN
C     ... Logistic growth
         IF (B(1).LE.ONE) THEN
            C = - A(3)*X
            CALL MIDDLE (ENEG, C, EPOS)
            D = ONE + A(2)*EXP(C)
         ELSEIF (B(1).LE.THREE) THEN
            C = A(2) - A(3)*X
            CALL MIDDLE (ENEG, C, EPOS)
            D = ONE + EXP(C)
         ELSEIF (B(1).LE.FIVE) THEN
            C = - A(3)*(X - A(2))
            CALL MIDDLE (ENEG, C, EPOS)
            D = ONE + EXP(C)
         ELSE
            C = - (A(2) + A(3)*X)
            CALL MIDDLE (ENEG, C, EPOS)
            D = ONE + EXP(C)
         ENDIF
         IF (ABS(D).GE.RTOL) F110 = A(1)/D
         IF (CONST) F110 = F110 + A(N)
      ELSEIF (M.EQ.4) THEN
C     ... Gompertz growth
         C = - A(3)*X
         CALL MIDDLE (ENEG, C, EPOS)
         D = - A(2)*EXP(C)
         CALL MIDDLE (ENEG, D, EPOS)
         F110 = A(1)*EXP(D)
         IF (CONST) F110 = F110 + A(N)
      ELSEIF (M.EQ.5) THEN
C     ... Richards growth
         IF (A(1).LE.RTOL) RETURN
         C = ONE - A(4)
         IF (ABS(C).LE.RTOL) RETURN
         D = - A(3)*X
         CALL MIDDLE (ENEG, D, EPOS)
         E = A(1)**C - A(2)*EXP(D)
         IF (E.LE.RTOL) RETURN
         F110 = E**(ONE/C)
         IF (CONST) F110 = F110 + A(N)
      ELSEIF (M.EQ.6) THEN
C     ... Preece and Baines growth
         C = X - A(3)
         D = A(1)*C
         CALL MIDDLE (ENEG, D, EPOS)
         E = A(2)*C
         CALL MIDDLE (ENEG, E, EPOS)
         C = EXP(E) + EXP(D)
         IF (C.LE.RTOL) RETURN
         F110 = A(4) + TWO*(A(4) - A(5))/C
         IF (CONST) F110 = F110 + A(N)
      ELSEIF (M.EQ.7) THEN
C     ... Weibull survival
         C = MAX(X, RTOL)
         D = C**A(3)
         IF (B(1).LE.ONE) THEN
            E = - A(2)*D
         ELSEIF (B(1).LE.THREE) THEN
            E = - D/MAX(A(2), RTOL)
         ELSEIF (B(1).LE.FIVE) THEN
            C = MAX(A(2), RTOL)**A(3)
            E = - C*D
         ELSE
            C = A(2)
            CALL MIDDLE (ENEG, C, EPOS)
            E = - EXP(C)*D
         ENDIF
         CALL MIDDLE (ENEG, E, EPOS)
         F110 = A(1)*EXP(E)
         IF (CONST) F110 = F110 + A(N)
      ELSEIF (M.EQ.8) THEN
C     ... Gompertz survival
         C = A(3)*X
         CALL MIDDLE (ENEG, C, EPOS)
         D = - A(2)*(EXP(C) - ONE)/MAX(RTOL, A(3))
         CALL MIDDLE (ENEG, D, EPOS)
         F110 = A(1)*EXP(D)
         IF (CONST) F110 = F110 + A(N)
      ENDIF
      END
C
C
      FUNCTION F111 (M, N, A, B, ENEG, EPOS, RTOL, X, CONST)
C     ... Selection B ... Biochemical
      IMPLICIT NONE
      INTEGER  M, N
      INTEGER  I, J, K
      DOUBLE PRECISION A(N), B(N), ENEG, EPOS, RTOL, X
      DOUBLE PRECISION WORK(20)
      DOUBLE PRECISION ARG1, ARG2, ARG3
      DOUBLE PRECISION C, D, E, F, F111
      DOUBLE PRECISION ZERO, ONE, THREE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, THREE = 3.0D+00)
      LOGICAL  CONST
      EXTERNAL C05AZF$
      EXTERNAL MIDDLE
      INTRINSIC LOG, MAX, EXP, ABS, SQRT
      F111 = ZERO
      IF (M.EQ.1) THEN
C     ... MWC allosteric model
         IF (A(2).GT.ONE) RETURN
         C = A(1)*X
         ARG1 = ONE + C
         IF (ARG1.LE.RTOL) RETURN
         ARG2 = ONE + A(2)*C
         IF (ARG2.LE.RTOL) RETURN
         ARG3 = B(1) - ONE
         D = ARG1**B(1) + A(3)*(ARG2**B(1))
         IF (ABS(D).GE.RTOL) THEN
            E = C*(ARG1**ARG3 + A(2)*A(3)*(ARG2**ARG3))
            F111 = A(4)*E/D
         ENDIF
      ELSEIF (M.EQ.2) THEN
C     ... Lag phase to steady state
         C = - A(3)*X
         CALL MIDDLE (ENEG, C, EPOS)
         F111 = A(1)*X + A(2)*(ONE - EXP(C))
         IF (CONST) F111 = F111 + A(N)
      ELSEIF (M.EQ.3) THEN
C     ... Binding using quadratic method
         ARG1 =  X + A(1) + A(2)
         ARG2 = MAX((ARG1**2 - 4.0D+00*A(2)*X), RTOL)
         IF (A(2).GE.RTOL) F111 = 0.5D+00*(ARG1 - SQRT(ARG2))/A(2)
      ELSEIF (M.EQ.4) THEN
C     ... Irreversible MM progress curve
         IF (X.LE.RTOL) RETURN
         F111 = A(3)
         C = 1.0D-04
         D = ZERO
         E = 0.999D+00*A(3)
         ARG1 = A(1)*LOG(A(3)/(A(3) - D)) + D - A(2)*X
         ARG2 = A(1)*LOG(A(3)/(A(3) - E)) + E - A(2)*X
         IF (ARG1*ARG2.GT.ZERO) RETURN
         I = 2
         J = 1
         K = 1
   20    CONTINUE
         CALL C05AZF$(D, E, F, C, I, WORK, J, K)
         IF (J.EQ.0) GOTO 40
         IF (J.LT.2 .OR. J.GT.4) RETURN
         F = A(1)*LOG(A(3)/(A(3) - D)) + D - A(2)*X
         GOTO 20
   40    CONTINUE
         F111 = D
      ELSEIF (M.EQ.5) THEN
C     ... Irreversible MM depletion curve
         F111 = A(3)
         IF (X.LE.RTOL) RETURN
         C = 1.0D-04
         D = 0.999D+00*A(3)
         E = 1.0D-10
         ARG1 = A(1)*LOG(D/A(3)) + D - A(3) + A(2)*X
         ARG2 = A(1)*LOG(E/A(3)) + E - A(3) + A(2)*X
         IF (ARG1*ARG2.GT.ZERO) RETURN
         I = 2
         J = 1
         K = 1
   60    CONTINUE
         CALL C05AZF$(D, E, F, C, I, WORK, J, K)
         IF (J.EQ.0) GOTO 80
         IF (J.LT.2 .OR. J.GT.4) RETURN
         F = A(1)*LOG(D/A(3)) + D - A(3) + A(2)*X
         GOTO 60
   80    CONTINUE
         F111 = D         
      ELSEIF (M.EQ.6) THEN
C     ...Michaelis-Menten plus diffusion
         IF (B(1).LE.ONE) THEN
            C = A(1)*X
            D = A(2) + X
            E = A(3)*X
         ELSEIF (B(1).LE.THREE) THEN
            C = A(1)*B(2)
            D = A(2) + B(2) + X
            E = A(3)*B(2)
         ELSE
            C = A(1)
            D = A(2) + X
            E = A(3)
         ENDIF
         IF (ABS(D).GT.RTOL) F111 = C/D + E
      ELSEIF (M.EQ.7) THEN
C     ... Generalised inhibition

         D = A(2) + X
         IF (ABS(D).GT.RTOL) F111 = A(1)/D
      ENDIF
      END
C
C
      FUNCTION F112 (M, N, A, B, ENEG, EPOS, EPSI, RTOL, X, CONST)
C     ... Selection C ... Chemical
      IMPLICIT NONE
      INTEGER  M, N
      DOUBLE PRECISION A(N), B(N), ENEG, EPOS, EPSI, RTOL, X
      DOUBLE PRECISION C, D, E, F, F112
      DOUBLE PRECISION ZERO, ONE, THREE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, THREE = 3.0D+00)
      LOGICAL  CONST
      EXTERNAL MIDDLE
      INTRINSIC EXP, ABS
      F112 = ZERO
      IF (M.EQ.1) THEN
C     ... Arrhenius
         IF (X.LE.RTOL) RETURN
         C = - A(2)/X
         CALL MIDDLE (ENEG, C, EPOS)
         F112 = A(1)*EXP(C)
      ELSEIF (M.EQ.2) THEN
C     ... Transition state
         IF (X.LE.RTOL) RETURN
         C = - A(2)/X
         CALL MIDDLE (ENEG, C, EPOS)
         F112 = A(1)*(X**A(3))*EXP(C)
      ELSEIF (M.EQ.3) THEN
C     ... B in A -> B -> C
         C = A(2) - A(1)
         D = - A(1)*X
         CALL MIDDLE (ENEG, D, EPOS)
         IF (ABS(C).GE.EPSI) THEN
            E = - A(2)*X
            CALL MIDDLE (ENEG, E, EPOS)
            F = A(1)*A(3)/C
            F112 = F*EXP(D) + (A(4) - F)*EXP(E)
         ELSE
            F112 = (A(1)*A(3)*X + A(4))*EXP(D)
         ENDIF
      ELSEIF (M.EQ.4) THEN
C     ... C in A -> B -> C
         C = A(2) - A(1)
         D = - A(1)*X
         CALL MIDDLE (ENEG, D, EPOS)
         IF (ABS(C).GE.EPSI) THEN
            E = - A(2)*X
            CALL MIDDLE (ENEG, E, EPOS)
            F = A(3)/C
            F112 =  A(3)+A(4)+A(5)-A(2)*F*EXP(D)-(A(4)-A(1)*F)*EXP(E)
         ELSE
            E = A(3) + A(4)
            F112 = E + A(5) - (A(1)*A(3)*X + E)*EXP(D)
         ENDIF
      ELSEIF (M.EQ.5) THEN
C     ... B in A = B reversibly
         C = A(1) + A(2)
         IF (ABS(C).LE.RTOL) RETURN
         D = - C*X
         CALL MIDDLE (ENEG, D, EPOS)
         F112 = (A(1)*(A(3) + A(4)) + (A(2)*A(4) - A(1)*A(3))*EXP(D))/C
      ELSEIF (M.EQ.6) THEN
C     .... Michaelis pH functions
         IF (X.LT.RTOL .OR. A(1).LT.RTOL .OR. A(2).LT.RTOL) RETURN
         IF (B(1).LE.ONE) THEN
            F112 = ONE + A(1)/X + A(1)*A(2)/(X**2)
         ELSEIF (B(1).LE.THREE) THEN
            F112 = ONE + X/A(1) + A(2)/X
         ELSE
            F112 = ONE + X/A(2) + (X**2)/(A(1)*A(2))
         ENDIF
         F112 = A(3)*F112
         IF (CONST) F112 = F112 + A(N)
      ELSEIF (M.EQ.7) THEN
C     ... Freundlich isotherm
         IF (A(2).GT.RTOL .AND. X.GT.RTOL) THEN
            C = ONE/A(2)
            F112 = A(1)*X**C
         ENDIF
         IF (CONST) F112 = F112 + A(N)
      ENDIF
      END
C
C
      FUNCTION F113 (M, N, A, RTOL, X)
C     ... Selection D ... Physical
      IMPLICIT NONE
      INTEGER  M, N
      INTEGER  I
      DOUBLE PRECISION A(N), RTOL, X
      DOUBLE PRECISION U, V 
      DOUBLE PRECISION C, D, F113, S15ADF$
      DOUBLE PRECISION ZERO, HALF, ONE, EPSI  
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00, 
     +           EPSI = 1.0D-07)
      EXTERNAL S15ADF$
      INTRINSIC SQRT, ABS, TANH, LOG, LOG10
      F113 = ZERO
      IF (M.EQ.1) THEN
C     ... Diffusion
         IF (A(2).LE.RTOL .OR. X.LT.ZERO) RETURN
         C = HALF*X/SQRT(A(2))
         I = 1
         F113 = A(1)*S15ADF$(C, I)
      ELSEIF (M.EQ.2) THEN
C     ... Full Mualen
         C = A(1)*X
         IF (C.LE.RTOL) RETURN
         D = ONE + C**A(2)
         F113 = (ONE/D)**A(3)
      ELSEIF (M.EQ.3) THEN
C     ... Short Mualen
         IF (ABS(A(2)).LE.RTOL) RETURN
         C = A(1)*X
         IF (C.LE.RTOL) RETURN
         D = ONE + C**A(2)
         F113 = (ONE/D)**(ONE - ONE/A(2))
       ELSEIF (M.EQ.4) THEN
C     ... brittle-ductile-transformation
         IF (ABS(A(3)).LE.RTOL) RETURN
         C = (X - A(4))/A(3)
         F113 = A(1) + A(2)*TANH(C)
      ELSEIF (M.GE.5 .AND. M.LE.7) THEN
C     ... Pabst-Einstein equation      
         IF (X.GE.A(1) - EPSI .OR.
     +       X.LE.EPSI        .OR.      
     +       A(1).LE.EPSI     .OR.
     +       A(2).LE.EPSI     .OR.
     +       A(3).LE.EPSI) RETURN
         U = ONE - X/A(1)  
         V = -A(1)*A(2)
         F113 = A(3)*(U**V)
         IF (M.EQ.6) THEN
            F113 = LOG(F113)
         ELSEIF (M.EQ.7) THEN           
            F113 = LOG10(F113)
         ENDIF   
      ENDIF
      END
C
C
      FUNCTION F114 (M, N, A, ENEG, EPOS, RTOL, X)
C     ... Selection E ... Statistical
      IMPLICIT   NONE
      INTEGER    M, N
      INTEGER    I
      DOUBLE PRECISION A(N), ENEG, EPOS, RTOL, X
      DOUBLE PRECISION BETA_CDF, BETA_PDF
      DOUBLE PRECISION C, D, E, F, F114
      DOUBLE PRECISION U
      DOUBLE PRECISION FACTOR
      PARAMETER (FACTOR = 0.3989422D+00)
      DOUBLE PRECISION ZERO, HALF, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00)
      DOUBLE PRECISION S14AAF$, S15ABF$, X01AAF$
      EXTERNAL   S15ABF$, X01AAF$, S14AAF$
      EXTERNAL   MIDDLE, BETA_CDF, BETA_PDF
      INTRINSIC  EXP, MAX, LOG, ATAN
      F114 = ZERO
      IF (M.EQ.1) THEN
C     ... Normal pdf
         IF (A(2).LE.RTOL) RETURN
         C = - HALF*(((X - A(1))/A(2))**2)
         CALL MIDDLE (ENEG, C, EPOS)
         F114 = (A(3)*FACTOR/A(2))*EXP(C)
      ELSEIF (M.EQ.2) THEN
C     ... Beta pdf
         IF (X.LT.ZERO .OR. X.GT.ONE) RETURN
         IF (A(1).LE.RTOL .OR. A(2).LE.RTOL) RETURN
         F114 = A(3)*BETA_PDF(A(1), A(2), X)
      ELSEIF (M.EQ.3) THEN
C     ... Exponential pdf
         IF (X.LT.ZERO .OR. A(1).LE.ZERO) RETURN
         C = - A(1)*X
         CALL MIDDLE (ENEG, C, EPOS)
         F114 = A(1)*A(2)*EXP(C)
      ELSEIF (M.EQ.4) THEN
C     ... Cauchy pdf
         IF (A(2).LE.RTOL) RETURN
         C = (X - A(1))/A(2)
         D = A(2)*X01AAF$(F)
         F114 = A(3)/(D*(1 + C**2))
      ELSEIF (M.EQ.5) THEN
C     ... Logistic pdf
         IF (A(2).LE.RTOL) RETURN
         C = (X - A(1))/A(2)
         CALL MIDDLE (ENEG, C, EPOS)
         D = EXP(C)
         F114 = A(3)*D/(A(2)*(ONE + D)**2)
      ELSEIF (M.EQ.6) THEN
C     ... Lognormal pdf
         IF (X.LE.RTOL) RETURN
         C = A(2)*X
         IF (C.LE.RTOL) RETURN
         D = - HALF*(((LOG(X) - A(1))/A(2))**2)
         CALL MIDDLE (ENEG, D, EPOS)
         F114 = (A(3)*FACTOR/C)*EXP(D)
      ELSEIF (M.EQ.7) THEN
C     ... Gamma pdf
         IF (A(1).LE.RTOL .OR. A(2).LE.RTOL .OR. X.LT.ZERO) RETURN
         IF (X.LE.RTOL) THEN
            U = RTOL
         ELSE
            U = X
         ENDIF
         C = - A(1)*X
         CALL MIDDLE (ENEG, C, EPOS)
         I = 1
         D = MAX(RTOL, S14AAF$(A(2), I))
         F114 = A(3)*(A(1)**A(2))*(U**(A(2) - ONE))*EXP(C)/D
      ELSEIF (M.EQ.8) THEN
C     ... Rayleigh pdf
         IF (X.LT.ZERO) RETURN
         C = A(1)**2
         IF (C.LE.RTOL) RETURN
         D = - HALF*(X**2)/C
         CALL MIDDLE (ENEG, D, EPOS)
         F114 = (A(2)*X/C)*EXP(D)
      ELSEIF (M.EQ.9) THEN
C     ... Maxwell pdf
         IF (X.LT.ZERO) RETURN
         C = A(1)**3
         IF (C.LE.RTOL) RETURN
         D = A(1)**2
         IF (D.LE.RTOL) RETURN
         E = X**2
         F = - HALF*E/D
         CALL MIDDLE (ENEG, F, EPOS)
         F114 = (A(2)*TWO*FACTOR*E/C)*EXP(F)
      ELSEIF (M.EQ.10) THEN
C     ... Weibull pdf
         IF (X.LE.RTOL .OR. A(1).LE.RTOL .OR. A(2).LE.RTOL) RETURN
         F = - X**A(1)/A(2)
         CALL MIDDLE (ENEG, F, EPOS)
         F114 = A(1)*A(3)*X**(A(1) - ONE)*EXP(F)/A(2)
      ELSEIF (M.EQ.101) THEN
C     ... Normal cdf
         IF (A(2).LE.RTOL) RETURN
         C = (X - A(1))/A(2)
         I = 1
         F114 = A(3)*S15ABF$(C, I)
      ELSEIF (M.EQ.102) THEN
C     ... Beta cdf
         IF (A(1).LE.RTOL .OR. A(2).LE.RTOL) RETURN
         IF (X.LE.ZERO) THEN
            F114 = ZERO
         ELSEIF (X.GE.ONE) THEN
            F114 = A(3)
         ELSE
            F114 = A(3)*BETA_CDF(A(1), A(2), X)
         ENDIF
      ELSEIF (M.EQ.103) THEN
C     ... Exponential cdf
         IF (X.LE.ZERO .OR. A(1).LE.ZERO) RETURN
         C = - A(1)*X
         CALL MIDDLE (ENEG, C, EPOS)
         F114 = A(2)*(ONE - EXP(C))
      ELSEIF (M.EQ.104) THEN
C     ... Cauchy cdf
         IF (A(2).LE.RTOL) RETURN
         C = (X - A(1))/A(2)
         F114 = A(3)*(HALF + ATAN(C)/X01AAF$(D))
      ELSEIF (M.EQ.105) THEN
C     ... Logistic cdf
         IF (A(2).LE.RTOL) RETURN
         C = (X - A(1))/A(2)
         CALL MIDDLE (ENEG, C, EPOS)
         D = EXP(C)
         F114 = A(3)*D/(ONE + D)
      ELSEIF (M.EQ.106) THEN
C     ... Lognormal cdf
         IF (X.LE.RTOL .OR. A(2).LE.RTOL) RETURN
         C = (LOG(X) - A(1))/A(2)
         I = 1
         F114 = A(3)*S15ABF$(C, I)
      ELSEIF (M.EQ.107) THEN
C     ... Weibull cdf
         IF (X.LE.RTOL .OR. A(1).LE.RTOL .OR. A(2).LE.RTOL) RETURN
         F = - X**A(1)/A(2)
         CALL MIDDLE (ENEG, F, EPOS)
         F114 = A(3)*(ONE - EXP(F))
      ELSEIF (M.EQ.201) THEN
C     ... Logit
         C = - (A(1) + A(2)*X)
         CALL MIDDLE (ENEG, C, EPOS)
         F114 = ONE/(ONE + EXP(C))
      ELSEIF (M.EQ.202) THEN
C     ... Probit
         C = A(1) + A(2)*X
         I = 1
         F114 = A(3)*S15ABF$(C, I)
      ELSEIF (M.EQ.203) THEN
C     ... 2 Normal pdfs  
         IF (A(2).LE.RTOL .OR. A(5).LE.RTOL) RETURN
         C = - HALF*(((X - A(1))/A(2))**2)
         CALL MIDDLE (ENEG, C, EPOS)
         F114 = (A(3)*FACTOR/A(2))*EXP(C)
         C = - HALF*(((X - A(4))/A(5))**2)
         CALL MIDDLE (ENEG, C, EPOS)
         F114 = F114 + ((ONE - A(3))*FACTOR/A(5))*EXP(C) 
      ELSEIF (M.EQ.204) THEN 
C        ... 2 Normal cdfs      
         IF (A(2).LE.RTOL .OR. A(5).LE.RTOL) RETURN
         C = (X - A(1))/A(2)
         I = 1
         F114 = A(3)*S15ABF$(C, I)
         C = (X - A(4))/A(5)
         I = 1
         F114 = F114 + (ONE - A(3))*S15ABF$(C, I)           
      ENDIF
      END
C
C
      FUNCTION F115 (M, N, A, B, ENEG, EPOS, RTOL, X, CONST)
C     ... Selection F ... Empirical
      IMPLICIT NONE
      INTEGER  M, N
      DOUBLE PRECISION A(N), B(N), ENEG, EPOS, RTOL, X
      DOUBLE PRECISION C, D, E, F, F115
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION HALF, R2PI
      PARAMETER (HALF = 0.5D+00, R2PI = 2.506628274631D+00)
      LOGICAL  CONST
      EXTERNAL MIDDLE
      INTRINSIC ABS, LOG10, EXP
      F115 = ZERO
      IF (M.EQ.1) THEN
C     ... Hill: n fixed
         IF (A(2).LT.ZERO .OR. X.LT.ZERO) RETURN
         C = X**B(1)
         D = A(2)**B(1) + C
         IF (ABS(D).GE.RTOL) F115 = A(1)*C/D
         IF (CONST) F115 = F115 + A(N)
      ELSEIF (M.EQ.2) THEN
C     ... Hill: n varied
         IF (A(2).LT.ZERO .OR. X.LT.ZERO) RETURN
         C = X**A(3)
         D = A(2)**A(3) + C
         IF (ABS(D).GE.RTOL) F115 = A(1)*C/D
         IF (CONST) F115 = F115 + A(N)
      ELSEIF (M.EQ.3) THEN
C     ... Power law
         IF (X.LT.RTOL) RETURN
         C = X**A(2)
         F115 = A(1)*C
         IF (CONST) F115 = F115 + A(N)
      ELSEIF (M.EQ.4) THEN
C     ... Log10 law
         IF (X.LT.RTOL) RETURN
         F115 = A(1)*LOG10(X)
         IF (CONST) F115 = F115 + A(N)
      ELSEIF (M.EQ.5) THEN
C     ... Up/Down exponential
         C = - A(1)*X
         CALL MIDDLE (ENEG, C, EPOS)
         D = - A(2)*X
         CALL MIDDLE (ENEG, D, EPOS)
         F115 = A(3)*(EXP(C) - EXP(D))
         IF (CONST) F115 = F115 + A(N)
      ELSEIF (M.EQ.6) THEN
C     ... Up/Down logistic
         C = A(2) - A(3)*X
         CALL MIDDLE (ENEG, C, EPOS)
         D = A(4) + A(5)*X
         CALL MIDDLE (ENEG, D, EPOS)
         E = ONE + EXP(C) + EXP(D)
         IF (ABS(E).LE.RTOL) RETURN
         F115 = A(1)/E
         IF (CONST) F115 = F115 + A(N)
      ELSEIF (M.EQ.7) THEN
C     ... Double exponential plus quadratic
         C = - A(2)*X
         CALL MIDDLE (ENEG, C, EPOS)
         D = - A(4)*X
         CALL MIDDLE (ENEG, D, EPOS)
         F115 = A(1)*EXP(C) + A(3)*EXP(D) + X*(A(5)*X + A(6))
         IF (CONST) F115 = F115 + A(N)
      ELSEIF (M.EQ.8) THEN
C     ... Double logistic
         C = A(2) - A(3)*X
         CALL MIDDLE (ENEG, C, EPOS)
         D = A(4) - A(5)*X
         CALL MIDDLE (ENEG, D, EPOS)
         E = ONE + EXP(C)
         F = ONE + EXP(D)
         IF (ABS(E).LE.RTOL .OR. ABS(F).LT.RTOL) RETURN
         F115 = A(1)/E + A(4)/F
         IF (CONST) F115 = F115 + A(N)
      ELSEIF (M.EQ.9) THEN
C     ... linear plus reciprocal
         IF (ABS(X).GT.RTOL) THEN
            F = X
         ELSEIF (X.GE.ZERO) THEN
            F = RTOL
         ELSE
            F = - RTOL
         ENDIF
         F115 = A(1)*X + A(2)/F
         IF (CONST) F115 = F115 + A(N)
      ELSEIF (M.EQ.10) THEN
C     .... Gaussian plus exponential         
         IF (A(2).GT.ZERO) THEN        
            C = A(3)/(A(2)*R2PI)
            D = - HALF*(((X - A(1))/A(2))**2) 
            CALL MIDDLE (ENEG, D, EPOS)
            E = - A(4)*X
            CALL MIDDLE (ENEG, E, EPOS)
            F115 = C*EXP(D) + A(5)*EXP(E)  
         ENDIF  
         IF (CONST) F115 = F115 + A(N) 
      ELSEIF (M.EQ.11) THEN
C     .... Gaussian times exponential         
         IF (A(2).GT.ZERO) THEN        
            C = A(3)/(A(2)*R2PI)
            D = - HALF*(((X - A(1))/A(2))**2) 
            CALL MIDDLE (ENEG, D, EPOS)
            E = - A(4)*X
            CALL MIDDLE (ENEG, E, EPOS)
            F115 = C*EXP(D)*EXP(E)   
         ENDIF
         IF (CONST) F115 = F115 + A(N)
      ENDIF
      END
C
C
      FUNCTION F116 (M, N, A, B, ENEG, EPOS, RTOL, X, CONST)
C     ... Selection G ... Mathematical
      IMPLICIT NONE
      INTEGER  M, N
      DOUBLE PRECISION A(N), B(N), ENEG, EPOS, RTOL, X
      DOUBLE PRECISION C, D, F116
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      LOGICAL   CONST
      EXTERNAL  MIDDLE
      INTRINSIC COS, SIN, ABS, SQRT, ATAN, EXP, MAX, SINH, COSH,
     +          TANH
      F116 = ZERO
      IF (M.EQ.1) THEN
C     ... Semicircle
         C = MAX(RTOL, A(3)**2 - (X - A(1))**2)
         F116 = A(2) + B(1)*SQRT(C)
      ELSEIF (M.EQ.2) THEN
C     ... Semiellipse
         IF (ABS(A(3)).LE.RTOL) THEN
            F116 = A(2)
         ELSE
            C = MAX(RTOL, ONE - ((X - A(1))/A(3))**2)
            F116 = A(2) + A(4)*B(1)*SQRT(C)
         ENDIF
      ELSEIF (M.EQ.3) THEN
C     ... Sine/Cos
         C = A(3)*B(1)*X
         F116 = A(1)*SIN(C) + A(2)*COS(C)
         IF (CONST) F116 = F116 + A(N)
      ELSEIF (M.EQ.4) THEN
C     ... Damped SHM
         C = A(3)*B(1)*X
         D = - A(4)*X
         CALL MIDDLE (ENEG, D, EPOS)
         F116 = EXP(D)*(A(1)*SIN(C) + A(2)*COS(C))
         IF (CONST) F116 = F116 + A(N)
      ELSEIF (M.EQ.5) THEN
C     ... Arctangent
         C = A(2)*X
         F116 = A(1)*B(1)*ATAN(C)
         IF (CONST) F116 = F116 + A(N)
      ELSEIF (M.EQ.6) THEN
C     ... Gamma type
         IF (X.LE.RTOL .OR. A(2).LE.RTOL) RETURN
         C = - A(3)*X
         CALL MIDDLE (ENEG, C, EPOS)
         F116 = A(1)*X**A(2)*EXP(C)
         IF (CONST) F116 = F116 + A(N)
      ELSEIF (M.EQ.7) THEN
C     ... Sinh/Cosh
         C = A(3)*X
         F116 = A(1)*SINH(C) + A(2)*COSH(C)
         IF (CONST) F116 = F116 + A(N)
      ELSEIF (M.EQ.8) THEN
C     ... Tanh
         C = A(2)*X
         F116 = A(1)*TANH(C)
         IF (CONST) F116 = F116 + A(N)
      ENDIF
      END
C
C
