c
c title_checker
c model_checker
c model_deqn_viewer
c model_files
C model_parameters
c model_viewer
c model_vuopener (full_path,
c                 abort) 
c model_variables
c
      subroutine title_checker (isend, ntitle,
     +                          title)
c     
c     isend = 1: save
c     isend = 2: retrieve
c     isend = 3: zeroise  
c     o/w error message  
c
c arguments
c
      integer,              intent(in)    :: isend
      integer,              intent(inout) :: ntitle  
      character (len = 80), intent(inout) :: title(24)
c
c locals
c      
      integer    i, ntitle_sav
      character (len = 80) title_sav(24)
      character (len = 1 ) blank
      parameter (blank = ' ')
      save       ntitle_sav, title_sav
      data       ntitle_sav / 0 /
      data       title_sav / 24*blank /  
      external   putadv !changed x_putadv to putadv bill bardsly 25/03/2024
      if (isend.eq.1) then
c
c isend = 1: save
c        
         ntitle_sav = ntitle
         do i = 1, ntitle
            title_sav(i) = title(i)
         enddo
      elseif (isend.eq.2) then
c
c isend = 2: retrieve
c      
         ntitle = ntitle_sav
         do i = 1, ntitle
            title(i) = title_sav(i)
         enddo
      elseif (isend.eq.3) then
c
c isend = 3: initialise
c      
         ntitle_sav = 0  
         do i = 1, 24
            title_sav(i) = blank 
         enddo   
      else
c
c isend < 1 or isend > 3
c        
         call putadv (
     +'ISEND out of range 1 to 3 in call to TITLE_CHECKER')
      endif
      end
c
c
      subroutine model_checker (neqn, npar, nvar,
     +                          fname, 
     +                          abort, deqn)
c
c action: preliminary checking for a user-defined model
c author: w.g.bardsley, university of manchester, u.k. 22/04/2016 derived from modchk
c         17/06/2016 introduced subroutine model_variables to improve checking for x, y, and z 
c         22/12/2020 added call to title_checker
c
c This subroutine only does very simple checking to prevent a user-defined
c file being submitted for further analysis from program usermod and hence 
c more rigorous checking when there are obvious elementary errors.
c
c   neqn: number of equations 
c  nhigh: length of text array	
c   npar: number of parameters in the model file
c  nwide: width of text array
c   nvar: number of variables in the model file
c  fname: name of the model file
c   text: (len = nwide) 
c  abort: returned .true. if model is inconsistent
c   deqn: .true. if model is a differential equation
c

      implicit none
c
c arguments
c      
      integer,                 intent (out) :: neqn, npar, nvar
      character (len = *),     intent (in)  :: fname                
      logical,                 intent (out) :: abort, deqn 
c
c locals
c      
      integer    i, icount, ios, j, jcount, k, kcount, nstart, nstop,
     +           nout
      integer    nlines, npar_temp
      integer    n_title, n_head, n_body
      integer    iadd1, jadd1, kadd1
      integer    isend, jsend, ncheck, nhigh, nwide
      parameter (isend = 1, jsend = 3, ncheck = 100, nhigh = 1000,
     +           nwide = 200)
      integer    n1, n2, n3
      parameter (n1 = 1, n2 = 2, n3 = 3)
      integer    ipcent, npcent(ncheck)
      integer    numtxt
      parameter (numtxt = 18)
      integer    numbld(numtxt) 
      integer    nwide1, ntitle, ntitle_sav
      parameter (nwide1 = 100, ntitle = 30)
      character (len = 80    ) title_sav(ntitle)
      character (len = nwide ) text(nhigh)
      character (len = nwide1) line, x_line 
      character (len = 100   ) mssage(100)
      character (len = 6     ) cipher, error(0:7), f(ncheck), p(ncheck),
     +                         y(ncheck)
      character (len = 1     ) blank, pcent
      parameter (blank = ' ', pcent = '%') 
      logical    ok_eqn(ncheck), ok_par(ncheck), ok_var(ncheck)
      logical    pcent_error, there
      logical    found
      external   lcase1, getnou, patch2, putfat
      external   model_variables
      external   title_checker
      intrinsic  adjustl, index, trim
      data       numbld / numtxt*0 /
c
c initialise
c
      abort = .true.
      deqn = .false.
      neqn = 0
      npar = 0
      nvar = 0
      do i = 1, nhigh
         text(i) = blank
      enddo   
      inquire (file = fname, exist = there, iostat = ios)
      if (ios.eq.0 .and. .not.there) return
      call getnou (nout)
      open (unit = nout, file = fname, iostat = ios)
      if (ios.ne.0) then
         close (unit = nout)
         return
      endif
      i = 0
      do while (ios.eq.0)
         read (nout,'(a)',iostat=ios) line
         if (ios.eq.0) then
            i = i + 1
            text(i) = line
         endif
      enddo
      close (unit = nout)
      if (i.lt.9) then
         call putfat ('Model files must have at least 9 lines')
         return
      endif 
      line = adjustl(text(1))
      if (line(1:1).ne.pcent) then
         call putfat ('Model files must begin with a % character')
         return
      endif    
c
c intialise ntitle_sav and title_sav
c
      call title_checker (jsend, ntitle_sav,
     +                    title_sav) 
c
c check the model line by line saving title_sav(ntitle_sav) o/w using lcase1
c     
      jcount = 0
      kcount = 0
      ntitle_sav = 0
      do i = 1, nhigh
         if (text(i).ne.blank) then
c
c calculate the title text only if text(i) .ne. blank to compress the title
c           
            jcount = jcount + 1
            line = text(i)
            line = adjustl(line)  
            if (line(1:1).eq.pcent) then
                kcount = kcount + 1 
            elseif (kcount.ge.1 .and. kcount.lt.2) then
               ntitle_sav = ntitle_sav + 1
               title_sav(ntitle_sav) = line(1:80)
            else
               call lcase1 (line)   
            endif
            text(jcount) = line
         endif
      enddo
      call title_checker (isend, ntitle_sav,
     +                    title_sav) 
      do i = jcount + 1, nhigh
         text(i) = blank
      enddo     
c
c initialise
c    
      iadd1 = 0
      jadd1 = 0
      kadd1 = 0
      npar_temp = -1
      nstart = -1
      ipcent = 0
      n_title = 0
      n_head = 0
      n_body = 0
      x_line = 'Summary of items declared and numbers counted'
      do i = 1, ncheck
         npcent(i) = -1
         ok_eqn(i) = .false.
         ok_par(i) = .false.
         ok_var(i) = .false.  
         if (i.lt.10) then
            write (p(i),'(a,i1,a)',iostat=ios) 'p(',i,')'
            write (y(i),'(a,i1,a)',iostat=ios) 'y(',i,')'
            write (f(i),'(a,i1,a)',iostat=ios) 'f(',i,')' 
         elseif (i.lt.100) then  
            write (p(i),'(a,i2,a)',iostat=ios) 'p(',i,')'
            write (y(i),'(a,i2,a)',iostat=ios) 'y(',i,')'
            write (f(i),'(a,i2,a)',iostat=ios) 'f(',i,')'     
         else   
            write (p(i),'(a,i3,a)',iostat=ios) 'p(',i,')'
            write (y(i),'(a,i3,a)',iostat=ios) 'y(',i,')'
            write (f(i),'(a,i3,a)',iostat=ios) 'f(',i,')'
         endif
c
c make sure they are left justified as trim will be used with call to index 
c         
         p(i) = adjustl(p(i))
         y(i) = adjustl(y(i))
         f(i) = adjustl(f(i))
      enddo            
c
c find escape characters: npcent(j) is the line number for the j'th % if > 0
c
      do i = 1, nhigh
         cipher = text(i)(1:6)
         cipher = adjustl(cipher)
         if (cipher(1:1).eq.pcent) then
            ipcent = ipcent + 1
            npcent(ipcent) = i
         endif 
      enddo
      do i = nhigh, 1, -1
         if (text(i).ne.blank) then
            nlines = i
            exit
         endif
      enddo      
      pcent_error = .false.
      if (ipcent.lt.4) then
         x_line = '% COUNT ERROR: Must be >= 4 lines starting with a %'
         goto 20
      else
         if (npcent(2).ge.3) then
            n_title = npcent(2) - npcent(1) - 1  
            if (npcent(3).eq.npcent(2) + 4) then
               n_head = npcent(3) - npcent(2) - 1
               if (npcent(4).gt.npcent(3) + 1) then
                  n_body = npcent(4) - npcent(3) - 1
               endif
            endif
         endif         
      endif 
      if (n_title.le.0 .or. n_head.ne.3 .or. n_body.le.0 .or.
     +    nlines.lt.9) then
         pcent_error = .true.
         if (n_title.le.0) then
            x_line = 'TITLE ERROR: Model has not been given a title' 
         elseif (n_head.ne.3) then
            x_line = 'HEADER ERROR: Must have a 3-line header statement'
         else
            x_line = 'MODEL ERROR: Model must have at least one line'
         endif        
         goto 20
      endif   
c
c define nstart and nstop then find npar, nvar, neqn
c     
      nstart = npcent(2) + 1
      nstop = npcent(3) - 1
      icount = 0
      loop_1 : do i = nstart, nstop
         icount = icount + 1
         line = text(i)
         call lcase1 (line)
         if (icount.eq.1) then
            j = index(line,'equation')
            if (j.gt.1 .and. j.lt.6) then 
               j = j - 1
               read (line(1:j),*,iostat=ios) k
               if (ios.eq.0) neqn = k
            endif
         elseif (icount.eq.2) then  
            j = index(line,'differential equation') 
            if (j.gt.0) then 
               deqn = .true.
               nvar = 1
            else   
               j = index(line,'variable')
               if (j.gt.1 .and. j.lt.6) then
                  j = j - 1
                  read (line(1:j),*,iostat=ios) k
                  if (ios.eq.0) nvar = k
               endif
            endif        
         elseif (icount.eq.3) then   
            j = index(line,'parameter')
            if (j.gt.1 .and. j.lt.6) then
               j = j - 1
               read (line(1:j),*,iostat=ios) k
               if (ios.eq.0) npar = k
            endif
         endif
      enddo loop_1
      if (npar.lt.0 .or. nvar.lt.0 .or. neqn.le.0)then
         if (npar.lt.0) then
            x_line = 'HEADER ERROR: Number of parameters must be >= 0'
         elseif (nvar.lt.0) then   
            x_line = 'HEADER ERROR: Number of variables must be >= 0'
         else   
            x_line = 'HEADER ERROR: Number of equations must be > 0'
         endif   
         goto 20
      endif  
c
c re-define nstart and nstop then check for parameters
c     
      nstart = npcent(3) + 1
      nstop = npcent(4) - 1
      
      iadd1 = 0
      if (deqn) then
         npar_temp = npar - neqn
      else
         npar_temp = npar
      endif      
      if (npar.gt.0) then
         loop_2 : do i = nstart, nstop
            line = text(i)
            do j = 1, npar_temp
               if (.not.ok_par(j)) then
                  if (index(line,trim(p(j))).gt.0) then
                    ok_par(j) = .true.
                    iadd1 = iadd1 + 1
                  endif 
                  if (iadd1.eq.npar) exit loop_2 
               endif     
            enddo 
         enddo loop_2
      endif
c-----------------------------------------------------
c start of check for variables
c      
      jadd1 = 0
      if (nvar.ge.1 .and. nvar.le.3) then
         loop_3 : do i = nstart, nstop
            line = text(i)
            if (nvar.ge.1 .and. .not.ok_var(1)) then
               k = index(line,'x')
               if (k.gt.0) then
                  call model_variables (n1,
     +                                  line,
     +                                  found)                 
                  if (found) then
                     ok_var(1) = .true.
                     jadd1 = jadd1 + 1
                     if (nvar.eq.1) exit loop_3
                  endif 
               endif 
            endif
            if (nvar.ge.2 .and. .not.ok_var(2)) then
               k = index(line,'y')
               if (k.gt.0) then
                  call model_variables (n2,
     +                                  line,
     +                                  found)
                  if (found) then
                     ok_var(2) = .true.
                     jadd1 = jadd1 + 1
                     if (ok_var(1) .and. nvar.eq.2) exit loop_3
                  endif     
               endif
            endif
            if (nvar.eq.3 .and. .not.ok_var(3)) then
               k = index(line,'z')
               if (k.gt.0) then
                  call model_variables (n3,
     +                                  line,
     +                                  found)
                  if (found) then
                     ok_var(3) = .true.
                     jadd1 = jadd1 + 1
                     if (ok_var(1) .and. ok_var(2) .and. 
     +                   nvar.eq.3) exit loop_3
                  endif     
               endif
            endif
         enddo loop_3
      elseif (nvar.gt.3) then
         loop_4 : do i = nstart, nstop
            line = text(i)
            do j = 1, nvar
               if (.not.ok_var(j)) then
                 if (index(line,trim(y(j))).gt.0) then
                    ok_var(j) = .true.
                    jadd1 = jadd1 + 1 
                    if (jadd1.eq.nvar) exit loop_4
                 endif    
               endif    
            enddo 
          enddo loop_4           
      endif
      if (deqn) then
         if (jadd1.le.0) then 
            nvar = 0
         elseif (jadd1.gt.0) then
            nvar = 1
         endif
      endif 
c
c end of check for variables
c---------------------------------------------------------      
c
c check for variables
c      
c      jadd1 = 0
c      if (nvar.ge.1 .and. nvar.le.3) then
c         loop_3 : do i = nstart, nstop
c            line = text(i)
c            if (.not.ok_var(1)) then
c               if (index(line,'x').gt.0) then
c                  if (index(line,'begin{expression}').le.0 .and.
c     +                index(line,'end{expression}').le.0) then                  
c                      ok_var(1) = .true.
c                      jadd1 = jadd1 + 1
c                      if (nvar.eq.1) exit loop_3
c                  endif 
c               endif 
c            endif
c            if (.not.ok_var(2)) then
c               k = index(line,'y')
c               if (k.gt.0) then
c                  if (line(k:k + 1).ne.'y(') then
c                     ok_var(2) = .true.
c                     jadd1 = jadd1 + 1
c                     if (ok_var(1) .and. nvar.eq.2) exit loop_3
c                  endif     
c               endif
c            endif
c            if (.not.ok_var(3)) then
c               if (index(line,'z').gt.0) then
c                  ok_var(3) = .true.
c                  jadd1 = jadd1 + 1
c                  if (ok_var(1).and.ok_var(2).and.nvar.eq.3) exit loop_3
c               endif
c            endif
c         enddo loop_3
c      elseif (nvar.gt.3) then
c         loop_4 : do i = nstart, nstop
c            line = text(i)
c            do j = 1, nvar
c               if (.not.ok_var(j)) then
c                 if (index(line,trim(y(j))).gt.0) then
c                    ok_var(j) = .true.
c                    jadd1 = jadd1 + 1 
c                    if (jadd1.eq.nvar) exit loop_4
c                 endif    
c               endif    
c            enddo 
c          enddo loop_4           
c      endif
c      if (deqn) then
c         if (jadd1.le.0) then 
c            nvar = 0
c         elseif (jadd1.gt.0) then
c            nvar = 1
c         endif
c      endif         
c
c check for equations
c      
      kadd1 = 0
      loop_5 : do i = nstart, nstop
         line = text(i)
         do j = 1, neqn
            if (.not.ok_eqn(j)) then 
               if (index(line,trim(f(j))).gt.0) then
                  ok_eqn(j) = .true.
                  kadd1 = kadd1 + 1
                  if (kadd1.eq.neqn) exit loop_5    
               endif   
            endif 
         enddo  
      enddo loop_5    
      if (.not.pcent_error .and. npar_temp.eq.iadd1 .and. nvar.eq.jadd1 
     +    .and. neqn.eq.kadd1) then
         abort = .false.
         return
      endif     
c
c LABEL 20: here if errors already found
c        
   20 continue    
      if (deqn .and. npar_temp.ne.iadd1) x_line = 
     +'DEQN ERROR: NEQN parameters also needed for inital conditions' 
      do i = 0, 7
         error(i) = blank
      enddo   
      if (ipcent.lt.4)   error(0) = '*ERROR'
      if (npar_temp.ne.iadd1) error(1) = '*ERROR'
      if (nvar.ne.jadd1) error(2) = '*ERROR'
      if (neqn.ne.kadd1) error(3) = '*ERROR'
      if (n_title.lt.1)  error(4) = '*ERROR'
      if (n_head.ne.3)   error(5) = '*ERROR'
      if (n_body.lt.1)   error(6) = '*ERROR' 
      if (nlines.le.0)   error(7) = '*ERROR'       
      write (mssage,100) ipcent,      error(0),
     +                   npar, iadd1, error(1), 
     +                   nvar, jadd1, error(2), 
     +                   neqn, kadd1, error(3), 
     +                   n_title,     error(4),
     +                   n_head,      error(5), 
     +                   n_body,      error(6), 
     +                   nlines,      error(7)
      mssage(3) = x_line
      if (.not.deqn) mssage(numtxt) = blank
      numbld(1) = 1  
      call patch2 (numbld, numtxt,
     +             mssage)     
c
c format statement
c      
  100 format (
     + 'Results from preliminary checking'
     +/
     +/
     +/
     +/'N_ESC =',I4,'` Number of % escape character lines',4x,a
     +/'N_PAR =',i4,'` Number of parameters used =',i4,4x,a
     +/'N_VAR =',i4,'` Number of variables used =',i4,4x,a         
     +/'N_EQN =',i4,'` Number of equations defined =',i4,4x,a
     +/'N_NAM =',i4,'` Number of model name lines (title)',4x,a
     +/'N_DES =',i4,'` Number of description lines (header)',4x,a
     +/'N_MOD =',i4,'` Number of model defining lines (body)',4x,a
     +/'N_COM =',i4,'` Number of lines in file (commands, etc.)',4x,a
     +/
     +/'A model can only be used when the number of parameters'
     +/'required (NPAR), the number of variables declared (NVAR)'
     +/'and the number of equations (NEQN) defined are all consistent.'
     +/
     +/'NVAR can be 0 or 1 for systems of differential equations.')         
      end  
c
c
      subroutine model_deqn_viewer
      implicit   none
      integer    isend, ntext
      parameter (isend = 7, ntext = 1)      
      integer    nfiles
      character (len = 1024) full_path
      character (len = 1   ) text(ntext)
      external   model_files
      call model_files (isend, nfiles, ntext,
     +                  full_path, text)
      end
c         
c
      subroutine model_files (isend, nfiles, ntext,
     +                        full_path, text) 
      implicit none
c
c action: return a list of user-defined model example files, or select a file for opening or viewing  
c author: w.g.bardsley, university of manchester, u.k, 10/04/2016
c 
c isend = 1: return nfiles filenames (len >= 16)
c isend = 2: return nfiles descriptions (len >= 60)
c isend = 3: return nfiles filenames (len >= 77) linked by grave accents to descriptions for display using listview1, etc.  
c isend = 4: return nfiles = list item and full_path (len >= 1024) = filename selected or 0 and blank if Cancel selected 
c isend = 5: return nfiles = list item and full_path (len >= 1024) = filename selected or 0 and blank if Cancel selected
c            but also view the selected file using viewer
c isend = 6: return nfiles = list item and full_path (len >= 1024) = filename selected or 0 and blank if Cancel selected
c            but also option to view the selected file using vuopen/viewer
c isend = 7: as isend = 5 but only differential equations 
c 
c Note: ntext must be >= nmax
c       nmax must be the number of model files
c       text must have len >= 16 (isend = 1), 60 (isend = 2), or 76 (isend = 3)
c       full_path should have (len >= 1024) if isend is 4 or 5
c
c arguments
c      
      integer,             intent (in)  :: isend, ntext
      integer,             intent (out) :: nfiles
      character (len = *), intent (out) :: full_path, text(ntext)
c
c locals
c     
      integer    i, ios, j, k, l, numdec 
      integer    jsend, nmax
      parameter (jsend = 1, nmax = 116)
      integer    numopt, numtxt
      parameter (numopt = nmax + 1, numtxt = numopt)
      integer    numoptp6, numtxtp6
      parameter (numoptp6 = numopt + 6, numtxtp6 = numtxt + 6)
      integer    numopt7
      parameter (numopt7 = 31)
      character (len = 1024) demo, doc
      character (len = 80  ) text4(numtxt), text5(numtxtp6), text6(6),
     +                       text7(numopt7) 
      character (len = 60  ) types(nmax + 1)
      character (len = 16  ) fnames(nmax + 1) 
      character (len = 1   ) blank, bslash, grave, path, pattern
      parameter (blank = ' ', bslash = '\', grave = '`')
      logical    repeet, there, view
      external   listbx, demdir, viewer, vuopen, docdir
      intrinsic  min
      full_path = blank
      if (isend.le.3) then
         nfiles = nmax
      else
         nfiles = 0
      endif      
      if (isend.eq.1) then
c
c isend = 1: return filenames
c        
         write (text,100)
      elseif (isend.eq.2) then  
c
c isend = 2: return descriptions
c      
         write (text,200)
      elseif (isend.eq.3) then
c
c isend = 3: return names with details
c      
         write (fnames,100)
         write (types,200)  
         do i = 1, min(ntext,nmax)
            text(i) = fnames(i)//grave//types(i)
         enddo 
      elseif (isend.eq.4) then
c
c isend = 4: return selected file
c      
         write (fnames,100)
         write (types,200)  
         do i = 1, nmax
            text4(i) = fnames(i)//grave//types(i)
         enddo 
         text4(numtxt) = 'Cancel          ` '
         numdec = 1
         call listbx (numdec, numopt, 
     +                text4)
         if (numdec.lt.numopt) then
            call demdir (l,
     +                   demo)
            if (demo(l:l).ne.bslash) then
               l = l + 1
               demo(l:l) = bslash
            endif
            full_path = demo(1:l)//fnames(numdec)
            inquire (file = full_path, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
               nfiles = 1
            else                      
               nfiles = 0
               full_path = blank
            endif    
         else
            nfiles = 0
            full_path = blank
         endif 
      elseif (isend.eq.5) then
c
c isend = 5: view only
c      
         write (fnames,100)
         write (types,200)  
         do i = 1, nmax
            text4(i) = fnames(i)//grave//types(i)
         enddo 
         text4(numtxt) = 'Cancel          ` '
         write (text6,300)
         do i = 1, 6
            text5(i) = text6(i)
         enddo
         do i = 1, numtxt
            text5(i + 6) = text4(i)
         enddo     
         call demdir (l,
     +                demo)
         if (demo(l:l).ne.bslash) then
            l = l + 1
            demo(l:l) = bslash
         endif 
         call docdir (j,
     +                doc) 
         if (doc(j:j).ne.bslash) then
            j = j + 1
            demo(l:l) = bslash
         endif           
         numdec = 1
         repeet = .true.
         do while (repeet)
            call listbx (numdec, numoptp6, 
     +                   text5)
            if (numdec.lt.numoptp6) then
               if (numdec.le.6) then
                  full_path = doc(1:j)//text5(numdec)(1:15)
               else   
                  full_path = demo(1:l)//fnames(numdec - 6)
               endif   
               inquire (file = full_path, exist = there, iostat = ios)
               if (ios.eq.0 .and. there) then
                  path = blank
                  pattern = blank
                  call viewer (jsend,
     +                         full_path, path, pattern)                   
               else                       
                  nfiles = 0
                  full_path = blank
                  repeet = .false.
               endif    
            else
               nfiles = 0
               full_path = blank
               repeet = .false.
            endif              
         enddo
      elseif (isend.eq.6) then
c
c isend = 6: view and/or open
c      
         write (fnames,100)
         write (types,200)  
         do i = 1, nmax
            text4(i) = fnames(i)//grave//types(i)
         enddo 
         text4(numtxt) = 'Cancel          ` '
         call demdir (l,
     +                demo)
         if (demo(l:l).ne.bslash) then
            l = l + 1
            demo(l:l) = bslash
         endif       
         numdec = 1
         repeet = .true.
         do while (repeet)
            call vuopen (numdec, numopt, 
     +                   text4,
     +                   view)
            if (view .and. numdec.lt.numopt) then
               full_path = demo(1:l)//fnames(numdec)
               inquire (file = full_path, exist = there, iostat = ios)
               if (ios.eq.0 .and. there) then
                  path = blank
                  pattern = blank
                  call viewer (jsend,
     +                         full_path, path, pattern)                   
               else                       
                  nfiles = 0
                  full_path = blank
                  repeet = .false.
               endif 
            elseif (numdec.lt.numopt) then 
               full_path = demo(1:l)//fnames(numdec)
               inquire (file = full_path, exist = there, iostat = ios)
               if (ios.eq.0 .and. there) then
                  nfiles = 1
                  repeet = .false.
               endif
            else
               nfiles = 0
               full_path = blank
               repeet = .false.
            endif              
         enddo
      elseif (isend.eq.7) then
c
c isend = 7: view differential equations only
c      
         write (fnames,100)
         write (types,200)  
         do i = 1, nmax
            text4(i) = fnames(i)//grave//types(i)
         enddo 
         text4(numtxt) = 'Cancel          ` '
         write (text6,300)
         do i = 1, 6
            text5(i) = text6(i)
         enddo
         do i = 1, numtxt
            text5(i + 6) = text4(i)
         enddo     
         call demdir (l,
     +                demo)
         if (demo(l:l).ne.bslash) then
            l = l + 1
            demo(l:l) = bslash
         endif 
         call docdir (j,
     +                doc) 
         if (doc(j:j).ne.bslash) then
            j = j + 1
            demo(j:j) = bslash
         endif  
         k = 0
         do i = 1, 6
            k = k + 1
            text7(k) = text5(i)
         enddo
         do i = 40, 63                   
            k = k + 1
            text7(k) = text5(i)
         enddo
         k = k + 1
         text7(k) = text5(numoptp6)   
 
         numdec = 1
         repeet = .true.
         do while (repeet)
            call listbx (numdec, numopt7, 
     +                   text7)
            if (numdec.lt.numopt7) then
               if (numdec.le.6) then
                  full_path = doc(1:j)//text5(numdec)(1:15)
               else   
                  full_path = demo(1:l)//fnames(numdec + 27)
               endif   
               inquire (file = full_path, exist = there, iostat = ios)
               if (ios.eq.0 .and. there) then
                  path = blank
                  pattern = blank
                  call viewer (jsend,
     +                         full_path, path, pattern)                   
               else                       
                  nfiles = 0
                  full_path = blank
                  repeet = .false.
               endif    
            else
               nfiles = 0
               full_path = blank
               repeet = .false.
            endif              
         enddo   
      endif 
c
c format statements
c        
 100  format (
     + 'qnfit_model.tf1 '
     +/'qnfit_model.tf2 '
     +/'qnfit_model.tf3 '
     +/'qnfit_model.tf4 '
     +/'qnfit_model.tf5 '
     +/'qnfit_model.tf6 '
     +/'qnfit_model.tf7 '
     +/'usermod1_e.tf1  '
     +/'usermod1_e.tf2  '
     +/'usermod1_e.tf3  '
     +/'usermod1_e.tf4  '
     +/'usermod1_e.tf5  '
     +/'usermod1_e.tf6  '
     +/'usermod1_e.tf7  '
     +/'usermod1_e.tf8  '
     +/'usermod1_e.tf9  '
     +/'usermod2_e.tf1  '
     +/'usermod3_e.tf1  '
     +/'usermod4_e.tf1  '
     +/'usermodd_e.tf1  '
     +/'usermods_e.tf1  '
     +/'usermods_e.tf2  '
     +/'usermods_e.tf3  '
     +/'usermodn_e.tf1  '
     +/'usermodn_e.tf2  '
     +/'usermodn_e.tf3  '
     +/'usermodn_e.tf4  '
     +/'camalot_e.mod   '
     +/'deqmod2_e.tf2   '
     +/'ellipse_e.mod   '
     +/'helix_e.mod     '
     +/'line3_e.mod     '
     +/'optimum_e.mod   '
     +/'rose_e.mod      '
     +/'c05adf_e.mod    '
     +/'c05nbf_e.mod    '
     +/'d01ajf_e.mod    '
     +/'d01eaf_e.mod    '
     +/'d01fcf_e.mod    '
     +/'e04fyf_e.mod    '
     +/'deqmod1_e.tf1   '
     +/'deqmod1_e.tf2   '
     +/'deqmod1_e.tf3   '
     +/'deqmod1_e.tf4   '
     +/'deqmod1_e.tf5   '
     +/'deqmod1_e.tf6   '
     +/'deqmod2_e.tf1   '
     +/'deqmod2_e.tf2   '
     +/'deqmod2_e.tf3   '
     +/'deqmod3_e.tf1   '
     +/'deqmod3_e.tf2   '
     +/'deqmod4_e.tf1   '     
     +/'deqmod1.tf1     '
     +/'deqmod1.tf2     '
     +/'deqmod1.tf3     '
     +/'deqmod1.tf4     '
     +/'deqmod1.tf5     '
     +/'deqmod1.tf6     '
     +/'deqmod2.tf1     '
     +/'deqmod2.tf2     '
     +/'deqmod2.tf3     '
     +/'deqmod3.tf1     '
     +/'deqmod3.tf2     '
     +/'deqmod4.tf1     '
     +/'ellipse.mod     '
     +/'family2D.mod    '
     +/'family3D.mod    '
     +/'helix.mod       '
     +/'if.mod          '
     +/'impulse.mod     '
     +/'line3.mod       '
     +/'optimum.mod     '
     +/'periodic.mod    '
     +/'rose.mod        '
     +/'tangent.mod     '
     +/'twister.mod     '
     +/'updown.mod      '
     +/'updownup.mod    '
     +/'user1.mod       '
     +/'usermod1.tf1    '
     +/'usermod1.tf2    '
     +/'usermod1.tf3    '
     +/'usermod1.tf4    '
     +/'usermod1.tf5    '
     +/'usermod1.tf6    '
     +/'usermod1.tf7    '
     +/'usermod1.tf8    '
     +/'usermod1.tf9    '
     +/'usermod2.tf1    '
     +/'usermod3.tf1    '
     +/'usermod4.tf1    '
     +/'usermodd.tf1    '
     +/'usermods.tf1    '
     +/'usermods.tf2    '
     +/'usermods.tf3    '
     +/'usermodn.tf1    '
     +/'usermodn.tf2    '
     +/'usermodn.tf3    '
     +/'usermodn.tf4    '
     +/'usermodx.tf1    '
     +/'usermodx.tf2    '
     +/'usermodx.tf3    '
     +/'usermodx.tf4    '
     +/'usermodx.tf5    '
     +/'camalot.mod     '
     +/'cheby.mod       '
     +/'consec3.mod     '
     +/'convolve.mod    '
     +/'convolv3.mod    '
     +/'dble_exp.mod    '
     +/'c05adf.mod      '
     +/'c05nbf.mod      '
     +/'d01ajf.mod      '
     +/'d01eaf.mod      '
     +/'d01fcf.mod      '
     +/'e04fyf.mod      ')
  200 format (   
     + 'f(x): a quadratic'   
     +/'g(x,y): a plane'
     +/'h(x,y,z): a hyperplane'
     +/'f(x): Sum of two Michaelis-Menten models'
     +/'B(x): A-->B-->C with A(0)=A0,B(0)=C(0)=0'
     +/'f(x): Sum of two normal pdfs'
     +/'f(x): Sum of two normal cdfs'
     +/'Function of 1 variable: a line'
     +/'Function of 1 variable: a quadratic'
     +/'Function of 1 variable: a cubic'
     +/'Function of 1 variable: a 2:2 rational function'
     +/'Function of 1 variable: one exponential'
     +/'Function of 1 variable: two exponentials'
     +/'Function of 1 variable: normal integral'
     +/'Function of 1 variable: capillary diffusion'
     +/'Function of 1 variable: damped simple harmonic motion'
     +/'Function of 2 variables: linear'
     +/'Function of 3 variables: linear'
     +/'Function of 4 variables: integrand for D01FCF'
     +/'Differential equation'
     +/'Special functions with 1 argument'
     +/'Special functions with 2 arguments'
     +/'Special functions with 3 arguments'
     +/'Four functions of 1 variable for USERMOD'
     +/'Two functions of 2 variables for USERMOD'
     +/'Three functions of 3 variables for USERMOD'
     +/'Nine functions of 9 variables for USERMOD'
     +/'Logarithmic spiral as used by Camalots'
     +/'Model for 2 differential equations'
     +/'Parameteric ellipse equation'
     +/'Parameteric helix equation'
     +/'Model for fitting 3 lines'
     +/'Model for optimizing Rosenbruck 2-D test function'
     +/'Parameteric rose equation'
     +/'(NAG) 1 function  of 1 variable'
     +/'(NAG) 9 functions of 9 variables'
     +/'(NAG)1 function  of 1 variable'
     +/'(NAG) 10 functions of 4 variables'
     +/'(NAG) 1 function  of 4 variables'
     +/'(NAG) 1 function  of 3 variables'
     +/'1 DE: Michaelis-Menten substrate depletion'
     +/'1 DE: Michaelis-Menten product accumulation'
     +/'1 DE: Generalised substrate depletion'
     +/'1 DE: Generalised product accumulation'
     +/'1 DE: Membrane transport allowing for osmosis'
     +/'1 DE: Von Bertalannfy allometric growth'
     +/'2 DE: 1 second order as a system of 2 first order'
     +/'2 DE: Lotka-Volterra predator-prey'
     +/'2 DE: Competing species ecological'
     +/'3 DE: Epidemic (with Jacobian)'
     +/'3 DE: Epidemic (without Jacobian)'
     +/'4 DE: Comprehensive Michaelis-Menten scheme'
     +/'1 DE: Michaelis-Menten substrate depletion'
     +/'1 DE: Michaelis-Menten product accumulation'
     +/'1 DE: Generalised substrate depletion'
     +/'1 DE: Generalised product accumulation'
     +/'1 DE: Membrane transport allowing for osmosis'
     +/'1 DE: Von Bertalannfy allometric growth'
     +/'2 DE: 1 second order as a system of 2 first order'
     +/'2 DE: Lotka-Volterra predator-prey'
     +/'2 DE: Competing species ecological'
     +/'3 DE: Epidemic (with Jacobian)'
     +/'3 DE: Epidemic (without Jacobian)'
     +/'4 DE: Comprehensive Michaelis-Menten scheme'
     +/'Parameteric ellipse equation'
     +/'2-D family of diffusion curves'
     +/'3-D family of diffusion curves'
     +/'Parameteric helix equation'
     +/'Illustrates how to use logical commands'
     +/'Model illustrating 5 single impulse functions'
     +/'Model for fitting 3 lines'
     +/'Model for optimizing Rosenbruck 2-D test function'
     +/'Model illustrating 7 periodic impulse functions'
     +/'Parameteric rose equation'
     +/'Tangent to logarithmic spiral in camalot.mod'
     +/'Model for 3D projections onto 2D planes'
     +/'Model with a cross-over point at 1 critical x-value'
     +/'Model with a cross-over point at 2 critical x-values'
     +/'Illustrates how to use arbitrary models'
     +/'Function of 1 variable: a line'
     +/'Function of 1 variable: a quadratic'
     +/'Function of 1 variable: a cubic'
     +/'Function of 1 variable: a 2:2 rational function'
     +/'Function of 1 variable: one exponential'
     +/'Function of 1 variable: two exponentials'
     +/'Function of 1 variable: normal integral'
     +/'Function of 1 variable: capillary diffusion'
     +/'Function of 1 variable: damped simple harmonic motion'
     +/'Function of 2 variables: linear'
     +/'Function of 3 variables: linear'
     +/'Function of 4 variables: integrand for D01FCF'
     +/'Differential equation'
     +/'Special functions with 1 argument'
     +/'Special functions with 2 arguments'
     +/'Special functions with 3 arguments'
     +/'Four functions of 1 variable for USERMOD'
     +/'Two functions of 2 variables for USERMOD'
     +/'Three functions of 3 variables for USERMOD'
     +/'Nine functions of 9 variables for USERMOD'
     +/'Extra sub-model for evaluation'
     +/'Extra sub-model for quadrature'
     +/'Extra sub-model for root finding'
     +/'Extra sub-models for roots involving quadrature'
     +/'Extra sub-model for multidimensional quadrature'
     +/'Logarithmic spiral as used by Camalots'
     +/'Model illustrating Chebyshev expansion'
     +/'Irreversible chemical reaction A --> B --> C'
     +/'Model for a convolution integral'
     +/'Model for a convolution integral with all components'
     +/'Chemical kinetic double exponential model'
     +/'(NAG) 1 function  of 1 variable'
     +/'(NAG) 9 functions of 9 variables'
     +/'(NAG) 1 function  of 1 variable'
     +/'(NAG) 10 functions of 4 variables'
     +/'(NAG) 1 function  of 4 variables'
     +/'(NAG) 1 function  of 3 variables')
  300 format (
     + 'w_readme.f5    `User-defined models: introduction'
     +/'w_readme.f6    `User-defined models: supplement 1'   
     +/'w_readme.f7    `User-defined models: supplement 2'   
     +/'w_readme.f8    `User-defined models: supplement 3'   
     +/'w_readme.f9    `User-defined models: supplement 4'   
     +/'w_readme.f10   `User-defined models: supplement 5')   
       end        
c
c      
      subroutine model_parameters (neqn, npar, nvar,
     +                             deqn, store)
      implicit none
      integer, intent (inout) :: neqn, npar, nvar            
      logical, intent (in)    :: store
      logical, intent (inout) :: deqn
      integer neqn_sav, npar_sav, nvar_sav
      logical deqn_sav
      save neqn_sav , npar_sav, nvar_sav
      save deqn_sav
      data neqn_sav, npar_sav, nvar_sav / 0, 0, 0 /
      data deqn_sav / .false. /
      if (store) then
         neqn_sav = neqn
         npar_sav = npar
         nvar_sav = nvar
         deqn_sav = deqn
      else
         neqn = neqn_sav
         npar = npar_sav
         nvar = nvar_sav
         deqn = deqn_sav
      endif
      end      
c
c
      subroutine model_viewer
      implicit   none
      integer    isend, ntext
      parameter (isend = 5, ntext = 1)      
      integer    nfiles
      character (len = 1024) full_path
      character (len = 1   ) text(ntext)
      external   model_files
      call model_files (isend, nfiles, ntext,
     +                  full_path, text)
      end
c
c  
      subroutine model_vuopener (full_path,
     +                           abort)
      implicit   none
      character (len = *), intent (out) :: full_path 
      logical,             intent (out) :: abort
      integer    isend, ntext
      parameter (isend = 6, ntext = 1)      
      integer    ios, nfiles
      character (len = 1) blank, text(ntext)
      parameter (blank = ' ')
      logical    there
      external   model_files
      abort = .true.
      full_path = blank
      call model_files (isend, nfiles, ntext,
     +                  full_path, text)
      if (full_path.eq.blank) then
          abort = .true.
      else     
         inquire (file = full_path, exist = there, iostat = ios) 
         if (ios.eq.0 .and. there) then
            abort = .false.
         else
            full_path = blank
            abort = .true.   
         endif
      endif      
      end     
c
c
c
c
      subroutine model_variables (isend, 
     +                            line_in,
     +                            found)
c
c action: check a user-defined model file for variables
c author: w.g.bardsley, university of manchester, u.k., 17/06/2016
c     
c It is assumed that the following are .true.
c isend = 1: line contains a letter 'x'
c isend = 2: line contains a letter 'y'
c isend = 3: line contains a letter 'z'
c
      implicit none
c
c arguments
c      
      integer,             intent (in)  :: isend
      character (len = *), intent (in)  :: line_in  
      logical,             intent (out) :: found
c
c locals
c      
      integer    i, m 
      integer    nmax
      parameter (nmax = 1024)
      character (len = nmax) line
      character (len = 2   ) word2
      character (len = 1   ) blank, exclam, letter, pcent, x, y, z
      parameter (blank = ' ', exclam = '!', pcent = '%', 
     +           x = 'x', y = 'y', z = 'z')
      logical    ignore   
      intrinsic  len, min, adjustl, index, len_trim
      external   lcase1
c
c initialise and preliminary check
c      
      found = .false.
      if (line_in.eq.blank) return
      line = blank
      m = min(nmax,len(line_in))
      line(1:m) = line_in(1:m)
      line = adjustl(line)
      m = len_trim(line)
      call lcase1 (line)
      if (index(line,'begin{expression}').gt.0 .or.
     +    index(line,'end{expression}')  .gt.0 .or.
     +    line(1:1).eq.exclam                  .or.
     +    line(1:1).eq.pcent) return 
c
c check for x, y, or z depending on isend
c     
      if (isend.eq.1) then
c
c isend = 1: search for x
c        
         letter = line(1:1)
         if (letter.eq.x) then
            found = .true.
            return
         endif   
         do i = 1, m
            letter = line(i:i)
            if (letter.eq.exclam) return
            if (letter.eq.x) then
               ignore = .false.
               if (i.gt.1) then
                  word2 = line(i - 1:i)
                  if (word2.eq.'ex' .or.
     +                word2.eq.'ax' .or.
     +                word2.eq.'dx' .or.
     +                word2.eq.',x') then
                     ignore = .true.
                  elseif (i.lt.m) then
                     word2 = line(i:i + 1)
                     if (word2.eq.'x,') then
                        ignore = .true.
                     endif
                  endif
                  if (.not.ignore) then            
                     found = .true.
                     return
                  endif   
               endif     
            endif 
         enddo  
      elseif (isend.eq.2) then
c
c isend = 2: search for y
c      
         letter = line(1:1)
         if (letter.eq.y) then
            found = .true.
            return
         endif   
         do i = 1, m
            letter = line(i:i)
            if (letter.eq.exclam) return
            if (letter.eq.y) then
               ignore = .false.
               if (i.gt.1) then
                  word2 = line(i - 1:i)
                  if (word2.eq.'dy' .or.
     +                word2.eq.',y' .or.
     +                word2.eq.'ly') then
                     ignore = .true.
                  elseif (i.lt.m) then
                     word2 = line(i:i + 1)
                     if (word2.eq.'y(' .or.
     +                   word2.eq.'y,') then
                        ignore = .true.
                     endif
                  endif
                  if (.not.ignore) then            
                     found = .true.
                     return
                  endif   
               endif     
            endif 
         enddo  
      elseif (isend.eq.3) then
c
c isend = 3: search for z
c
         letter = line(1:1)
         if (letter.eq.z) then
            found = .true.
            return
         endif   
         do i = 1, m
            letter = line(i:i)
            if (letter.eq.exclam) return
            if (letter.eq.z) then
               found = .true.
               return
            endif   
         enddo  
      endif  
      end
c        
c            