C
C ================================================================
C Extra parsing for special functions
C ================================================================
C
      SUBROUTINE PARSE_SPECIALS (ICOUNT, INDEX1, NLINES, NSTACK,
     +                           LINE, WORD1, WORD2, WORD3, WORD4,
     +                           WORD5, WORD6, WORD7, WORD8, WORD10,
     +                           ABORT, STACK_ERROR)
C
C ACTION : subsidiary parsing for special functions
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 14/12/2001
C          This subroutine is called with the character strings defined
C          from the PARSE_FILE routine if the line has not been identified
C          after the first 56 possibilities in PARSE_FILE, or FILE_PARSE
C          27/05/2003 added Heaviside unit function and WORD10 to argument
C          02/06/2003 added impulse functions
C          Date of this version 02/06/2003
C
      IMPLICIT   NONE
      INTEGER    ICOUNT, NLINES, NSTACK
      INTEGER    INDEX1(NSTACK)
      INTEGER    N0, N1, N2, N3, N9, N11, N12, N13, N14
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N9 = 9, 
     +           N11 = 11, N12 = 12, N13 = 13, N14 = 14)
      CHARACTER  LINE*1024
      CHARACTER  WORD1*1, WORD2*2, WORD3*3, WORD4*4, WORD5*5, WORD6*6,
     +           WORD7*7, WORD8*8, WORD10*10
      CHARACTER  WORD9*9, WORD11*11, WORD12*12, WORD13*13,
     +           WORD14*14
      CHARACTER  BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT, STACK_ERROR
      EXTERNAL   PUTFAT
C
C Initialise ABORT and STACK_ERROR
C
      ABORT = .FALSE.
      STACK_ERROR = .FALSE.
C
C Define the important words to scan
C 
      WORD9 = WORD2!to silence FTN95
      WORD9 = LINE(N1:N9)
      WORD11 = LINE(N1:N11)
      WORD12 = LINE(N1:N12)
      WORD13 = LINE(N1:N13)
      WORD14 = LINE(N1:N14)
C
C Indented since was part of a main loop
C --------------------------------------
C
         IF (WORD1.EQ.'!' .OR. WORD1.EQ.'*' .OR. WORD1.EQ.'/') THEN
C
C A comment line has been encountered
C
            WORD9 = BLANK!to silence ftn95
         ELSE
            IF (WORD5.EQ.'ai(x)') THEN
C
C 101 Airy Ai(x) S17AGF
C
               INDEX1(NLINES) = 101
            ELSEIF (WORD6.EQ.'dai(x)') THEN
C
C 102 d/dx Ai(x) S17AJF
C
               INDEX1(NLINES) = 102
            ELSEIF (WORD5.EQ.'bi(x)') THEN
C
C 103 Airy Bi(x) S17AHF
C
               INDEX1(NLINES) = 103
            ELSEIF (WORD6.EQ.'dbi(x)') THEN
C
C 104 d/dx Bi(x) S17AKF
C
               INDEX1(NLINES) = 104
            ELSEIF (WORD8.EQ.'besj0(x)') THEN
C
C 105 Bessel J0 S17AEF
C
               INDEX1(NLINES) = 105
            ELSEIF (WORD8.EQ.'besj1(x)') THEN
C
C 106 Bessel J1 S17AFF
C
               INDEX1(NLINES) = 106
            ELSEIF (WORD8.EQ.'besy0(x)') THEN
C
C 107 Bessel Y0 S17ACF
C
               INDEX1(NLINES) = 107
            ELSEIF (WORD8.EQ.'besy1(x)') THEN
C
C 108 Bessel Y1 S17ADF
C
               INDEX1(NLINES) = 108
            ELSEIF (WORD7.EQ.'phic(x)') THEN
C
C 109 Complement of normal cdf S15ACF
C
               INDEX1(NLINES) = 109
            ELSEIF (WORD7.EQ.'erfc(x)' .OR. WORD5.EQ.'erfc ') THEN
C
C 110 Complement of error function S15ADF
C
               INDEX1(NLINES) = 110
            ELSEIF (WORD5.EQ.'ci(x)') THEN
C
C 111 Cosine integral S13ACF
C
               INDEX1(NLINES) = 111
            ELSEIF (WORD6.EQ.'phi(x)' .OR. WORD7.EQ.'cdfn(x)' .OR.
     +              WORD4.EQ.'phi '   .OR. WORD6.EQ.'normal') THEN
C
C 112 Normal cdf S15ABF
C
               INDEX1(NLINES) = 112
            ELSEIF (WORD7.EQ.'rc(x,y)') THEN
C
C 113 Elliptic RC S21BAF
C
               INDEX1(NLINES) = 113
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD9.EQ.'rf(x,y,z)') THEN
C
C 114 Elliptic RF S21BBF
C
               INDEX1(NLINES) = 114
               ICOUNT = ICOUNT - N2
            ELSEIF (WORD9.EQ.'rd(x,y,z)') THEN
C
C 115 Elliptic RD S21BCF
C
               INDEX1(NLINES) = 115
               ICOUNT = ICOUNT - N2
            ELSEIF (WORD11.EQ.'rj(x,y,z,r)') THEN
C
C 116 Elliptic RJ S21BDF
C
               INDEX1(NLINES) = 116
               ICOUNT = ICOUNT - N3
            ELSEIF (WORD6.EQ.'erf(x)') THEN
C
C 117 Error function S15AEF
C
               INDEX1(NLINES) = 117
            ELSEIF (WORD5.EQ.'e1(x)') THEN
C
C 118 Exponential integral S13AAF
C
               INDEX1(NLINES) = 118
            ELSEIF (WORD8.EQ.'gamma(x)' .OR. WORD5.EQ.'gamma') THEN
C
C 119 Gamma S14AAF
C
               INDEX1(NLINES) = 119
            ELSEIF (WORD11.EQ.'fresnelc(x)') THEN
C
C 120 Fresnel C S20ADF
C
               INDEX1(NLINES) = 120
            ELSEIF (WORD11.EQ.'fresnels(x)') THEN
C
C 121 Fresnel S S20ACF
C
               INDEX1(NLINES) = 121
            ELSEIF (WORD6.EQ.'bei(x)') THEN
C
C 122 Kelvin bei(x) S19ABF
C
               INDEX1(NLINES) = 122
            ELSEIF (WORD6.EQ.'ber(x)') THEN
C
C 123 Kelvin ber(x) S19AAF
C
               INDEX1(NLINES) = 123
            ELSEIF (WORD6.EQ.'kei(x)') THEN
C
C 124 Kelvin kei(x) S19ADF
C
               INDEX1(NLINES) = 124
            ELSEIF (WORD6.EQ.'ker(x)') THEN
C
C 125 Kelvin ker(x) S19ACF
C
               INDEX1(NLINES) = 125
            ELSEIF (WORD10.EQ.'lngamma(x)' .OR. WORD6.EQ.'lgamma') THEN
C
C 126 log Gamma(x) S14ABF
C
               INDEX1(NLINES) = 126
            ELSEIF (WORD8.EQ.'besi0(x)') THEN
C
C 127 Bessel I0 S18AEF
C
               INDEX1(NLINES) = 127
            ELSEIF (WORD8.EQ.'besi1(x)') THEN
C
C 128 Bessel I1 S18AFF
C
               INDEX1(NLINES) = 128
            ELSEIF (WORD8.EQ.'besk0(x)') THEN
C
C 129 Bessel K0 S18ACF
C
               INDEX1(NLINES) = 129
            ELSEIF (WORD8.EQ.'besk1(x)') THEN
C
C 130 Bessel K1 S18ADF
C
               INDEX1(NLINES) = 130
            ELSEIF (WORD5.EQ.'si(x)') THEN
C
C 131 Sine integral S13ADF
C
               INDEX1(NLINES) = 131
            ELSEIF (WORD6.EQ.'psi(x)' .OR. WORD10.EQ.'digamma(x)') THEN
C
C 132 Psi(x) = digamma (-) S14ADF
C
               INDEX1(NLINES) = 132
            ELSEIF (WORD11.EQ.'trigamma(x)') THEN
C
C 133 trigamma (+) S14ADF
C
               INDEX1(NLINES) = 133
            ELSEIF (WORD7.EQ.'sn(x,m)' .OR.
     +              WORD7.EQ.'sn(x,n)') THEN
C
C 134 Elliptic sn S21CAF
C
               INDEX1(NLINES) = 134
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD7.EQ.'cn(x,m)' .OR.
     +              WORD7.EQ.'cn(x,n)') THEN
C
C 135 Elliptic cn S21CAF
C
               INDEX1(NLINES) = 135
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD7.EQ.'dn(x,m)' .OR.
     +              WORD7.EQ.'dn(x,n)') THEN
C
C 136 Elliptic dn S21CAF
C
               INDEX1(NLINES) = 136
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD11.EQ.'igamma(x,a)') THEN
C
C 137 incomplete gamma S14BAF
C
               INDEX1(NLINES) = 137
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD12.EQ.'igammac(x,a)') THEN
C
C 138 incomplete gamma complement S14BAF
C
               INDEX1(NLINES) = 138
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD9.EQ.'cdft(x,m)' .OR.
     +              WORD9.EQ.'cdft(x,n)') THEN
C
C 139 cdf t(x,n) G01EBF
C
               INDEX1(NLINES) = 139
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD9.EQ.'cdfc(x,m)' .OR.
     +              WORD9.EQ.'cdfc(x,n)') THEN
C
C 140 cdf c(x,n) G01ECF
C
               INDEX1(NLINES) = 140
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD11.EQ.'cdff(x,n,m)' .OR.
     +              WORD11.EQ.'cdff(x,m,n)') THEN
C
C 141 cdf f(x,n,m) G01EDF
C
               INDEX1(NLINES) = 141
               ICOUNT = ICOUNT - N2
            ELSEIF (WORD11.EQ.'cdfb(x,a,b)') THEN
C
C 142 cdf b(x,a,b) G01EEF
C
               INDEX1(NLINES) = 142
               ICOUNT = ICOUNT - N2
            ELSEIF (WORD11.EQ.'cdfg(x,a,b)') THEN
C
C 143 cdf g(x,a,b) G01EFF
C
               INDEX1(NLINES) = 143
               ICOUNT = ICOUNT - N2
            ELSEIF (WORD7.EQ.'invn(x)') THEN
C
C 144 invn(x) G01FAF
C
               INDEX1(NLINES) = 144
            ELSEIF (WORD9.EQ.'invt(x,m)' .OR.
     +              WORD9.EQ.'invt(x,n)') THEN
C
C 145 invt(x,n) G01FBF
C
               INDEX1(NLINES) = 145
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD9.EQ.'invc(x,m)' .OR.
     +              WORD9.EQ.'invc(x,n)' ) THEN
C
C 146 invc(x,n) G01FCF
C
               INDEX1(NLINES) = 146
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD11.EQ.'invf(x,n,m)' .OR.
     +              WORD11.EQ.'invf(x,m,n)') THEN
C
C 147 invf(x,n,m) G01FDF
C
               INDEX1(NLINES) = 147
               ICOUNT = ICOUNT - N2
            ELSEIF (WORD11.EQ.'invb(x,a,b)') THEN
C
C 148 invb(x,a,b) G01FEF
C
               INDEX1(NLINES) = 148
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD11.EQ.'invg(x,a,b)') THEN
C
C 149 invg(x,a,b) G01FFF
C
               INDEX1(NLINES) = 149
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD9 .EQ. 'dawson(x)') THEN
C
C 150 dawson(x) S15AFF
C
               INDEX1(NLINES) = 150
            ELSEIF (WORD9 .EQ.'spence(x)') THEN
C
C 151 Spence's integral 0 to x of - (1/y)log|1 - y| = DSPENC
C
               INDEX1(NLINES) = 151
            ELSEIF (WORD10 .EQ.'arctanh(x)') THEN
C
C 152 arctanh(x) S11AAF
C

               INDEX1(NLINES) = 152
            ELSEIF (WORD10 .EQ.'arcsinh(x)') THEN
C
C 153 arcsinh(x) S11ABF
C
               INDEX1(NLINES) = 153
            ELSEIF (WORD10 .EQ.'arccosh(x)') THEN
C
C 154 arccosh(x) S11ACF
C
               INDEX1(NLINES) = 154
            ELSEIF (WORD10.EQ.'debye(x,m)' .OR.
     +              WORD10.EQ.'debye(x,n)') THEN
C
C 155 debye(x,n)
C
               INDEX1(NLINES) = 155
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD10.EQ.'clausen(x)') THEN
C
C 156 clausen(x)
C

               INDEX1(NLINES) = 156
            ELSEIF (WORD10.EQ.'fermi(x,a)') THEN
C
C 157 fermi(x,a)
C
               INDEX1(NLINES) = 157
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD5 .EQ.'ei(x)') THEN
C
C 158 ei(x)
C
               INDEX1(NLINES) = 158
            ELSEIF (WORD12.EQ.'struveh(x,m)' .or.
     +              WORD12.EQ.'struveh(x,n)') THEN
C
C 159 struveh(x,n)
C
               INDEX1(NLINES) = 159
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD12.EQ.'struvel(x,m)' .or.
     +              WORD12.EQ.'struvel(x,n)') THEN
C
C 160 struvel(x,n)
C
               INDEX1(NLINES) = 160
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD14.EQ.'kummerm(x,a,b)') THEN
C
C 161 kummerm(x,a,b)
C
               INDEX1(NLINES) = 161
               ICOUNT = ICOUNT - N2
            ELSEIF (WORD14.EQ.'kummeru(x,a,b)') THEN
C
C 162 kummeru(x,a,b)
C
               INDEX1(NLINES) = 162
               ICOUNT = ICOUNT - N2
            ELSEIF (WORD7.EQ.'ln(1+x)') THEN
C
C 163 ln(1+x)
C
               INDEX1(NLINES) = 163
            ELSEIF (WORD13.EQ.'mchoosen(m,n)') THEN
C
C 164 mchoosen(m,n)
C
               INDEX1(NLINES) = 164
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD11.EQ.'lpol(x,m,n)' .OR.
     +              WORD11.EQ.'lpol(x,n,m)') THEN
C
C 165 lpol1(x,m,n)
C
               INDEX1(NLINES) = 165
               ICOUNT = ICOUNT - N2
               ICOUNT = ICOUNT - N2
            ELSEIF (WORD10.EQ.'abram(x,m)' .OR.
     +              WORD10.EQ.'abram(x,n)') THEN
C
C 166 abram(x,m)
C
               INDEX1(NLINES) = 166
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD11.EQ.'poly(x,m,n)' .OR.
     +              WORD11.EQ.'poly(x,n,m)') THEN
C
C 167 poly(x,m,n)
C
               INDEX1(NLINES) = 167
               ICOUNT = ICOUNT - N2
            ELSEIF (WORD12.EQ.'cheby(x,m,n)' .OR.
     +              WORD12.EQ.'cheby(x,n,m)') THEN
C
C 168 cheby(x,m,n)
C
               INDEX1(NLINES) = 168
               ICOUNT = ICOUNT - N2
            ELSEIF (WORD11.EQ.'l1norm(m,n)' .OR.
     +              WORD11.EQ.'l1norm(n,m)') THEN
C
C 169 l1norm(m,n)
C
               INDEX1(NLINES) = 169
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD11.EQ.'l2norm(m,n)' .OR.
     +              WORD11.EQ.'l2norm(n,m)') THEN
C
C 170 l2norm(m,n)
C
               INDEX1(NLINES) = 170
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD11.EQ.'linorm(m,n)' .OR.
     +              WORD11.EQ.'linorm(n,m)') THEN
C
C 171 linorm(m,n)
C
               INDEX1(NLINES) = 171
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD8.EQ.'sum(m,n)' .OR.
     +              WORD8.EQ.'sum(n,m)') THEN
C
C 172 sum(m,n)
C
               INDEX1(NLINES) = 172
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD8.EQ.'ssq(m,n)' .OR.
     +              WORD8.EQ.'ssq(n,m)') THEN
C
C 173 ssq(m,n)
C
               INDEX1(NLINES) = 173
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD3.EQ.'pi ') THEN
C
C 174 pi
C
               INDEX1(NLINES) = 174
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD5.EQ.'piby2') THEN
C
C 175 piby2
C
               INDEX1(NLINES) = 175
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD5.EQ.'piby3') THEN
C
C 176 piby3
C
               INDEX1(NLINES) = 176
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD5.EQ.'piby4') THEN
C
C 177 piby4
C
               INDEX1(NLINES) = 177
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD5.EQ.'twopi') THEN
C
C 178 twopi
C
               INDEX1(NLINES) = 178
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD7.EQ.'root2pi') THEN
C
C 179 root2pi
C
               INDEX1(NLINES) = 179
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD7.EQ.'deg2rad') THEN
C
C 180 deg3rad
C
               INDEX1(NLINES) = 180
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD7.EQ.'rad2deg') THEN
C
C 181 rad2deg
C
               INDEX1(NLINES) = 181
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD6.EQ.'root2 ') THEN
C
C 182 root2
C
               INDEX1(NLINES) = 182
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD6.EQ.'root3 ') THEN
C
C 183 root3
C
               INDEX1(NLINES) = 183
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD6.EQ.'eulerg') THEN
C
C 184 eulerg
C
               INDEX1(NLINES) = 184
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD8.EQ.'lneulerg' .OR. WORD9.EQ.'logeulerg') THEN
C
C 185 lneulerg
C
               INDEX1(NLINES) = 185
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD14.EQ.'dotprod(l,m,n)') THEN
C
C 186 dotprod(l,m,n)
C
               INDEX1(NLINES) = 186
               ICOUNT = ICOUNT - N2
            ELSEIF (WORD6.EQ.'int(x)') THEN
C
C 187 int(x)
C
               INDEX1(NLINES) = 187
            ELSEIF (WORD7.EQ.'nint(x)') THEN
C
C 188 nint(x)
C
               INDEX1(NLINES) = 188

            ELSEIF (WORD7.EQ.'sign(x)') THEN
C
C 189 sign(x)
C
               INDEX1(NLINES) = 189
            ELSEIF (WORD10.EQ.'user1(x,m)' .OR. WORD10.EQ.
     +              'user1(x,n)') THEN
C
C 190 user1(x,m)
C
               INDEX1(NLINES) = 190
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD12.EQ.'user2(x,y,m)' .OR. WORD12.EQ.
     +              'user2(x,y,n)') THEN
C
C 191 user2(x,y,m)
C
               INDEX1(NLINES) = 191
               ICOUNT = ICOUNT - N2
            ELSEIF (WORD14.EQ.'user3(x,y,z,m)' .OR. WORD14.EQ.
     +              'user3(x,y,z,n)') THEN
C
C 192 user3(x,y,z,m)
C
               INDEX1(NLINES) = 192
               ICOUNT = ICOUNT - N3
            ELSEIF (WORD6.EQ.'lt0(x)') THEN
C
C 193 lt0(x)
C
               INDEX1(NLINES) = 193
            ELSEIF (WORD6.EQ.'le0(x)') THEN
C
C 194 le0(x)
C
               INDEX1(NLINES) = 194
            ELSEIF (WORD6.EQ.'eq0(x)') THEN
C
C 195 eq0(x)
C
               INDEX1(NLINES) = 195
            ELSEIF (WORD6.EQ.'ge0(x)') THEN
C
C 196 ge0(x)
C
               INDEX1(NLINES) = 196
            ELSEIF (WORD6.EQ.'gt0(x)') THEN
C
C 197 gt0(x)
C
               INDEX1(NLINES) = 197
            ELSEIF (WORD6.EQ.'not(m)') THEN
C
C 198 not(m)
C
               INDEX1(NLINES) = 198
            ELSEIF (WORD8.EQ.'and(m,n)') THEN
C
C 199 and(m,n)
C
               INDEX1(NLINES) = 199
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD7.EQ.'or(m,n)') THEN
C
C 200 or(m,n)
C
               INDEX1(NLINES) = 200
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD8.EQ.'xor(m,n)') THEN
C
C 201 xor(m,n)
C
               INDEX1(NLINES) = 201
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD10.EQ.'heavy(x,a)' .OR.
     +              WORD10.EQ.'heavi(x,a)' .OR.
     +              WORD14.EQ.'heaviside(x,a)') THEN
C
C 202 h(x - a)
C
C
               INDEX1(NLINES) = 202
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD10.EQ.'delta(m,n)' .OR.
     +              WORD10.EQ.'delta(i,j)') THEN
C
C 203 Kronecker delta
C
               INDEX1(NLINES) = 203
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD14.EQ.'impulse(x,a,b)') THEN
C
C 204 square wave impulse = Dirac delta
C
               INDEX1(NLINES) = 204
               ICOUNT = ICOUNT - N2
            ELSEIF (WORD12.EQ.'spike(x,a,b)') THEN
C
C 205 triangular impulse
C
               INDEX1(NLINES) = 205
               ICOUNT = ICOUNT - N2
            ELSEIF (WORD12.EQ.'gauss(x,a,b)') THEN
C
C 206 Gauss pdf
C
               INDEX1(NLINES) = 206
               ICOUNT = ICOUNT - N2
            ELSEIF (WORD11.EQ.'sqwave(x,a)') THEN
C
C 207 Square wave
C
               INDEX1(NLINES) = 207
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD11.EQ.'rtwave(x,a)') THEN
C
C 208 Rectified triangle
C
               INDEX1(NLINES) = 208
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD11.EQ.'mdwave(x,a)') THEN
C
C 209 Morse dot function
C
               INDEX1(NLINES) = 209
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD11.EQ.'stwave(x,a)') THEN
C
C 210 Saw tooth wave
C
               INDEX1(NLINES) = 210
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD11.EQ.'rswave(x,a)') THEN
C
C 211 Rectified sine
C
               INDEX1(NLINES) = 211
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD11.EQ.'shwave(x,a)') THEN
C
C 212 Rectified sine half-wave
C
               INDEX1(NLINES) = 212
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD13.EQ.'uiwave(x,a,b)') THEN
C
C 213 Unit implulse function
C
               INDEX1(NLINES) = 213
               ICOUNT = ICOUNT - N2
            ELSEIF (WORD11.EQ.'pdfb(x,a,b)') THEN   
               INDEX1(NLINES) = 214
               ICOUNT = ICOUNT - N2
            ELSE
C Crash
C
               ABORT = .TRUE.
               STACK_ERROR = .TRUE.
            ENDIF
         ENDIF
         IF (ICOUNT.LT.N0 .OR. STACK_ERROR) THEN
            CALL PUTFAT (
     +'Stack error ... empty stack or unknown command encountered')
            ABORT = .TRUE.
            STACK_ERROR = .TRUE.
         ENDIF
      END
C
C

