C
C QNLIB1 : Functions of one variable for MAKDAT, QNFIT etc
C To be consistent this version must have MODNAM dimensioned MODNAM(24)*80
C This version dimensions using KMAX_A, KMAX_F, KMAX_J and KMAX_Y
C ADVICE : Subroutine MIDDLE makes sure result returned is limited in range
C AUTHOR : W. G. Bardsley, University of Manchester, U. K.
C          29/12/1994 Added user supplied models
C          10/02/1998 Revision for Win32 version
C          30/08/2000 added Michaelis pH functions, Hot/Cold MM isotope
C          01/09/2000 extensive revision
C          14/10/2001 dimensioned MODNAM(12)*80
C          18/04/2002 new argument list for 107/8 for exp/trig functions
C          Date of this version 18/04/2002
C
C NAGTYPE: C05AZF$, G01EEF$, S14AAF$, S15ABF$, S15ADF$, X01AAF$
C
      FUNCTION QNLIB1 (MODEL, NMOD, NPAR, NX, A, B, ENEG, EPOS, EPSI,
     +                 RTOL, X, XTOL, ZTOL, CONST)
      IMPLICIT   NONE
      INTEGER    MODEL, NMOD, NPAR, NX
      INTEGER    ISEND, NEQN, NVAR
      PARAMETER (ISEND = 2, NEQN = 1, NVAR = 1)
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      PARAMETER (KMAX_F = NEQN, KMAX_J = NEQN**2, KMAX_Y = NEQN)
      DOUBLE PRECISION A(NX), B(NX)
      DOUBLE PRECISION ENEG, EPOS, EPSI, RTOL, X, XTOL, ZTOL
      DOUBLE PRECISION F(NEQN), Y, YDE(NEQN), YJA(NEQN**2), Z
      DOUBLE PRECISION QNLIB1
      DOUBLE PRECISION F101, F102, F103, F104, F105, F106, F107, F108,
     +                 F109, F110, F111, F112, F113, F114, F115, F116
      CHARACTER  MODNAM(24)*80
      LOGICAL    CONST
      LOGICAL    ABORT, DEQN
      PARAMETER (DEQN = .FALSE.)
      EXTERNAL   MIDDLE, PUTFAT
      EXTERNAL   F101, F102, F103, F104, F105, F106, F107, F108, F109,
     +           F110, F111, F112, F113, F114, F115, F116
      EXTERNAL   QNUSER
      IF (MODEL.EQ.1) THEN
         QNLIB1 = F101 (NMOD, NPAR, A,                            X,
     +                  XTOL, ZTOL, CONST)
      ELSEIF (MODEL.EQ.2) THEN
         QNLIB1 = F102 (NMOD, NPAR, A,                      RTOL, X,
     +                  XTOL, ZTOL, CONST)
      ELSEIF (MODEL.EQ.3) THEN
         QNLIB1 = F103 (NMOD, NPAR, A, B,                   RTOL, X,
     +                  XTOL, ZTOL, CONST)
      ELSEIF (MODEL.EQ.4) THEN
         QNLIB1 = F104 (NMOD, NPAR, A, B,                   RTOL, X,
     +                  XTOL, ZTOL, CONST)
      ELSEIF (MODEL.EQ.5) THEN
         QNLIB1 = F105 (NMOD, NPAR, A, B,                   RTOL, X,
     +                  XTOL, ZTOL, CONST)
      ELSEIF (MODEL.EQ.6) THEN
         QNLIB1 = F106 (NMOD, NPAR, A, B,                   RTOL, X,
     +                  XTOL, ZTOL, CONST)
      ELSEIF (MODEL.EQ.7) THEN
         QNLIB1 = F107 (NMOD, NPAR, A, B, ENEG, EPOS,             X,
     +                  XTOL, ZTOL, CONST)
      ELSEIF (MODEL.EQ.8) THEN
         QNLIB1 = F108 (NMOD, NPAR, A, B,                         X,
     +                  XTOL, ZTOL, CONST)
      ELSEIF (MODEL.EQ.9) THEN
         QNLIB1 = F109 (NMOD, NPAR, A, B, ENEG, EPOS,       RTOL, X,
     +                  XTOL, ZTOL, CONST)
      ELSEIF (MODEL.EQ.10) THEN
         QNLIB1 = F110 (NMOD, NPAR, A, B, ENEG, EPOS,       RTOL, X,
     +                              CONST)
      ELSEIF (MODEL.EQ.11) THEN
         QNLIB1 = F111 (NMOD, NPAR, A, B, ENEG, EPOS,       RTOL, X,
     +                              CONST)
      ELSEIF (MODEL.EQ.12) THEN
         QNLIB1 = F112 (NMOD, NPAR, A, B, ENEG, EPOS, EPSI, RTOL, X,
     +                              CONST)
      ELSEIF (MODEL.EQ.13) THEN
         QNLIB1 = F113 (NMOD, NPAR, A,                      RTOL, X
     +                                   )
      ELSEIF (MODEL.EQ.14) THEN
         QNLIB1 = F114 (NMOD, NPAR, A,    ENEG, EPOS,       RTOL, X
     +                                   )
      ELSEIF (MODEL.EQ.15) THEN
         QNLIB1 = F115 (NMOD, NPAR, A, B, ENEG, EPOS,       RTOL, X,
     +                              CONST)
      ELSEIF (MODEL.EQ.16) THEN
         QNLIB1 = F116 (NMOD, NPAR, A, B, ENEG, EPOS,       RTOL, X,
     +                              CONST)
      ELSEIF (MODEL.EQ.17) THEN
         KMAX_A = NX
         CALL QNUSER (ISEND,
     +                KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                NEQN, NPAR, NVAR, NX, A, F, X, Y, YDE, YJA,
     +                Z, MODNAM, ABORT, DEQN)
         QNLIB1 = F(1)
      ELSE
         CALL PUTFAT ('MODEL incorrect in F1/QNLIB1')
      ENDIF
      CALL MIDDLE (XTOL, QNLIB1, ZTOL)
      END
C
C
