C
C QNLIB2 : Functions of two variables for MAKDAT, QNFIT etc.
C To be consistent this version must have MODNAM dimensioned MODNAM(24)*80
C This version dimensions using KMAX_A, KMAX_F, KMAX_J and KMAX_Y
C ADVICE : Subroutine MIDDLE makes sure result returned is limited in range
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          10/02/1998 Revised for win32 version
C          02/09/2000 extensive revision
C          14/10/2001 DIMENSIONED MODNAM(24)*80
C          03/06/2005 added logistic growth to biological models
C
      FUNCTION QNLIB2 (MODEL, NMOD, NPAR, NX, A, B, ENEG, EPOS, EPSI,
     +                 RTOL, X, XTOL, Y, ZTOL, CONST)
      IMPLICIT   NONE
      INTEGER    MODEL, NMOD, NPAR, NX
      INTEGER    ISEND, NEQN, NVAR
      PARAMETER (ISEND = 2, NEQN = 1, NVAR = 2)
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      PARAMETER (KMAX_F = NEQN, KMAX_J = NEQN**2, KMAX_Y = NEQN)
      DOUBLE PRECISION A(NX), B(NX), ENEG, EPOS, EPSI, RTOL, X, XTOL,
     +                 Y, ZTOL
      DOUBLE PRECISION QNLIB2
      DOUBLE PRECISION F201, F202, F203, F210, F213, F214
      DOUBLE PRECISION F(NEQN), YDE(NEQN), YJA(NEQN**2), Z
      CHARACTER  MODNAM(24)*80
      LOGICAL    CONST
      LOGICAL    ABORT, DEQN
      PARAMETER (DEQN = .FALSE.)
      EXTERNAL MIDDLE
      EXTERNAL F201, F202, F203, F210, F213, F214
      EXTERNAL QNUSER
      IF (MODEL.EQ.1) THEN
         QNLIB2 = F201 (NMOD, NPAR, A, X, Y, CONST)
      ELSEIF (MODEL.EQ.2) THEN
         QNLIB2 = F202 (NMOD, NPAR, A, RTOL, X, Y, CONST)
      ELSEIF (MODEL.EQ.3) THEN
         QNLIB2 = F203 (NMOD, NPAR, A, ENEG, EPOS, RTOL, X, Y)
      ELSEIF (MODEL.EQ.10) THEN
         QNLIB2 = F210 (NPAR, A, ENEG, EPOS, X, Y, CONST)
      ELSEIF (MODEL.EQ.13) THEN
         QNLIB2 = F213 (NPAR, A, RTOL, X, Y)
      ELSEIF (MODEL.EQ.14) THEN
         QNLIB2 = F214 (NMOD, NPAR, A, ENEG, EPOS, EPSI, RTOL,
     +                  X, Y, CONST)
      ELSEIF (MODEL.EQ.17) THEN
         KMAX_A = NX
         CALL QNUSER (ISEND,
     +                KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                NEQN, NPAR, NVAR, NX, A, F, X, Y, YDE, YJA,
     +                Z, MODNAM, ABORT, DEQN)
         QNLIB2 = F(1)
      ELSE
C     ... dummy code to silence FTN95
         B(1) = EPSI
      ENDIF
      CALL MIDDLE (XTOL, QNLIB2, ZTOL)
      END
C
C
      FUNCTION F201 (M, N, A, X, Y, CONST)
C      ... Polynomials
      IMPLICIT NONE
      INTEGER  M, N
      DOUBLE PRECISION A(N), X, Y
      DOUBLE PRECISION C, D, F201
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      LOGICAL  CONST
      F201 = ZERO
      IF (M.EQ.1) THEN
         F201 = A(1)*X + A(2)*Y
      ELSEIF (M.EQ.2) THEN
         F201 = A(1)*X + A(2)*Y + A(3)*X*X + A(4)*X*Y + A(5)*Y*Y
      ELSEIF (M.EQ.3) THEN
         C = X*X
         D = Y*Y
         F201 = A(1)*X + A(2)*Y + A(3)*C + A(4)*X*Y + A(5)*D +
     +          A(6)*C*X + A(7)*C*Y + A(8)*D*X + A(9)*D*Y
      ENDIF
      IF (CONST) F201 = F201 + A(N)
      END
C
C
      FUNCTION F202 (M, N, A, RTOL, X, Y, CONST)
C      ... Rational functions
      IMPLICIT NONE
      INTEGER  M, N
      DOUBLE PRECISION A(N), RTOL, X, Y
      DOUBLE PRECISION C, D, F202
      DOUBLE PRECISION XY, XY2, X2, X2Y, Y2
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      LOGICAL  CONST
      INTRINSIC ABS
      F202 = ZERO
      IF (M.EQ.1) THEN
         C = ONE + A(2)*X + A(3)*Y + A(4)*X*X + A(5)*X*Y + A(6)*Y*Y
         IF (ABS(C).GT.RTOL) F202 = A(1)*X*Y/C
      ELSEIF (M.EQ.2) THEN
         X2 = X*X
         Y2 = Y*Y
         XY = X*Y
         X2Y = X2*Y
         XY2 = X*Y2
         C = ONE + A(4)*X + A(5)*Y + A(6)*X2 + A(7)*XY + A(8)*Y2 +
     +           A(9)*X2*X + A(10)*X2Y + A(11)*XY2 + A(12)*Y2*Y
         IF (ABS(C).GT.RTOL) F202 = (A(1)*XY + A(2)*X2Y + A(3)*XY2)/C
      ELSEIF (M.EQ.3) THEN
         C = ONE + A(3)*X + A(4)*Y
         IF (ABS(C).GT.RTOL) THEN
            D = A(1)*X + A(2)*Y
            IF (CONST) D = D + A(5)
            F202 = D/C
         ENDIF
      ELSEIF (M.EQ.4) THEN
         XY = X*Y
         X2 = X*X
         Y2 = Y*Y
         C = ONE + A(6)*X + A(7)*Y + A(8)*X2 + A(9)*XY + A(10)*Y2
         IF (ABS(C).GT.RTOL) THEN
            D = A(1)*X + A(2)*Y + A(3)*X2 + A(4)*XY + A(5)*Y2
            IF (CONST) D = D + A(11)
            F202 = D/C
         ENDIF
      ENDIF
      END
C
C
      FUNCTION F203 (M, N, A, ENEG, EPOS, RTOL, X, Y)
C      ... Enzyme kinetics
      IMPLICIT NONE
      INTEGER  M, N
      DOUBLE PRECISION A(N)
      DOUBLE PRECISION C, D, E, F203
      DOUBLE PRECISION X, Y
      DOUBLE PRECISION ENEG, EPOS, RTOL
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL MIDDLE
      INTRINSIC ABS, EXP
      F203 = ZERO
      IF (M.EQ.1) THEN
         C = X*A(4)
         D = Y*A(2)
         E = A(2)*A(4) + C + D
         IF (ABS(E).GT.RTOL) F203 = (A(1)*C - A(3)*D)/E
      ELSEIF (M.LE.5) THEN
         C = A(1)*A(3)*X
         IF (M.EQ.2) THEN
            D = A(2)*(A(3) + Y) + A(3)*X
         ELSEIF (M.EQ.3) THEN
            D = A(2)*A(3) + X*(A(3) + Y)
         ELSEIF (M.EQ.4) THEN
            D = (A(3) + Y)*(A(2) + X)
         ELSEIF (M.EQ.5) THEN
            C = A(4)*C
            D = A(2)*A(4)*(A(3) + Y) + A(3)*X*(A(4) + Y)
         ENDIF
         IF (ABS(D).GT.RTOL) F203 = C/D
      ELSEIF (M.LE.7) THEN
         C = X*Y
         D = C + A(3)*X + A(2)*Y
         IF (M.EQ.7) D = D + A(3)*A(4)
         IF (ABS(D).GT.RTOL) F203 = A(1)*C/D
      ELSEIF (M.EQ.8) THEN
         IF (ABS(Y).LE.RTOL) RETURN
         C = ONE + A(3)/Y
         IF (ABS(C).LE.RTOL) RETURN
         D = - A(2)*X/C
         CALL MIDDLE (ENEG, D, EPOS)
         F203 = A(1)*EXP(D)
      ELSEIF (M.EQ.9) THEN
         C = X*A(3)
         D = Y*A(2)
         E = A(2)*A(3) + C + D
         IF (ABS(E).GT.RTOL) F203 = A(1)*C/E
      ELSEIF (M.EQ.10) THEN
         IF (Y.LE.RTOL .OR. A(3).LT.RTOL .OR. A(5).LT.RTOL) RETURN
         C = ONE + Y/A(3) + A(4)/Y
         D = ONE + Y/A(5) + A(6)/Y
         E = A(2)*C + D*X
         IF (E.GT.RTOL) THEN
            F203 = A(1)*X/E
         ENDIF
      ENDIF
      END
C
C
      FUNCTION F210 (NPAR, A, ENEG, EPOS, X, Y, CONST)
C     ... Biological
      IMPLICIT   NONE
      INTEGER    NPAR
      DOUBLE PRECISION A(NPAR), ENEG, EPOS, X, Y
      DOUBLE PRECISION F210
      DOUBLE PRECISION POLY
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      LOGICAL    CONST
      EXTERNAL   MIDDLE
      INTRINSIC  EXP
      POLY = - (A(2) + A(3)*X + A(4)*Y + A(5)*X*Y)
      CALL MIDDLE (ENEG, POLY, EPOS)
      F210 = A(1)/(ONE + EXP(POLY))
      IF (CONST) F210 = F210 + A(NPAR)
      END
C
C
      FUNCTION F213 (NPAR, A, RTOL, X, Y)
C     ... Physical
      IMPLICIT  NONE
      INTEGER   NPAR
      INTEGER   I
      DOUBLE PRECISION A(NPAR), RTOL, X, Y
      DOUBLE PRECISION F213
      DOUBLE PRECISION ARG1, ARG2
      DOUBLE PRECISION S15ADF$
      DOUBLE PRECISION ZERO, HALF
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00)
      EXTERNAL   S15ADF$
      INTRINSIC  SQRT
      F213 = ZERO
C     ... Diffusion
         IF (A(2).LE.RTOL .OR. X.LT.ZERO .OR. Y.LE.ZERO) RETURN
         ARG1 = SQRT(A(2)*Y)
         IF (ARG1.GT.RTOL) THEN
            ARG2 = HALF*X/ARG1
            I = 1
            F213 = A(1)*S15ADF$(ARG2, I)
         ENDIF
      END
C
C
      FUNCTION F214 (NMOD, NPAR, A, ENEG, EPOS, EPSI, RTOL, X, Y, CONST)
C     ... Statistical
C     27/12/2016 corrected missing multiplication by A(6) in bivariate normal 
      IMPLICIT  NONE
      INTEGER   NMOD, NPAR
      INTEGER   I
      DOUBLE PRECISION A(NPAR), ENEG, EPOS, EPSI, RTOL, X, Y
      DOUBLE PRECISION F214
      DOUBLE PRECISION ARGX, ARGY, ARGR, DENOM, Q
      DOUBLE PRECISION ZERO, ONE, TWO, TWOPI
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           TWOPI = 6.2831853D+00)
      DOUBLE PRECISION S15ABF$
      LOGICAL    CONST
      EXTERNAL   S15ABF$
      EXTERNAL   MIDDLE
      INTRINSIC  SQRT, EXP
      F214 = ZERO
      IF (NMOD.EQ.1) THEN
C     ... bivariate normal
         ARGX = ONE - EPSI
         ARGY = - ARGX
         IF (A(2).LE.RTOL .OR. A(4).LE.RTOL .OR. A(5).GT.ARGX .OR.
     +       A(5).LT.ARGY) RETURN
         ARGX = (X - A(1))/A(2)
         ARGY = (Y - A(3))/A(4)
         ARGR = ONE - A(5)**2
         Q = - (ARGX**2 - TWO*A(5)*ARGX*ARGY + ARGY**2)/(TWO*ARGR)
         CALL MIDDLE (ENEG, Q, EPOS)
         DENOM = TWOPI*A(2)*A(4)*SQRT(ARGR)
         IF (DENOM.GT.RTOL) F214 = A(6)*EXP(Q)/DENOM
         IF (CONST) F214 = F214 + A(NPAR)
      ELSEIF (NMOD.EQ.2) THEN
C     ... Logit in two variables
         Q = - (A(1) + A(2)*X + A(3)*Y)
         CALL MIDDLE (ENEG, Q, EPOS)
         F214 = ONE/(ONE + EXP(Q))
      ELSEIF (NMOD.EQ.3) THEN
C     .... Probit
         Q = A(1) + A(2)*X + A(3)*Y
         I = 1
         F214 = S15ABF$(Q, I)
      ENDIF
      END
C
C
