C
C QNLIB3 : Functions of three variables for MAKDAT, QNFIT etc.
C To be consistent this version must have MODNAM dimensioned MODNAM(24)*80
C This version dimensions using KMAX_A, KMAX_F, KMAX_J and KMAX_Y
C ADVICE : Subroutine MIDDLE makes sure result returned is limited in range
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          29/12/1994 added user supplied models
C          10/02/1998 revised for win32 version
C          30/08/2000 added MWC
C          14/10/2001 dimensioned MODNAM(24)*80
C          04/01/2010 added NAG E04FYF example
C
      FUNCTION QNLIB3(MODEL, NMOD, NPAR, NX,
     +                A, B, ENEG, EPOS, EPSI, RTOL, X, XTOL, Y, Z, ZTOL, 
     +                CONST)
      IMPLICIT   NONE
      INTEGER    MODEL, NMOD, NPAR, NX
      INTEGER    ISEND, NEQN, NVAR
      PARAMETER (ISEND = 2, NEQN = 1, NVAR = 3)
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      PARAMETER (KMAX_F = NEQN, KMAX_J = NEQN**2, KMAX_Y = NEQN)
      DOUBLE PRECISION A(NX), B(NX), ENEG, EPOS, EPSI, RTOL, X, XTOL,
     +                 Y, Z, ZTOL
      DOUBLE PRECISION QNLIB3
      DOUBLE PRECISION F(NEQN), YDE(NEQN), YJA(NEQN**2)
      DOUBLE PRECISION F301, F303, F310, F314, F315
      CHARACTER  MODNAM(24)*80
      LOGICAL    CONST
      LOGICAL    ABORT, DEQN
      PARAMETER (DEQN = .FALSE.)
      EXTERNAL   MIDDLE
      EXTERNAL   F301, F303, F310, F314, F315
      EXTERNAL   QNUSER
      IF (MODEL.EQ.1) THEN
         QNLIB3 = F301 (NPAR, A, X, Y, Z, CONST)
      ELSEIF (MODEL.EQ.3) THEN
         QNLIB3 = F303 (NMOD, NPAR, A, B, RTOL, X, Y, Z)
      ELSEIF (MODEL.EQ.10) THEN
         QNLIB3 = F310 (NPAR, A, ENEG, EPOS, X, Y, Z, CONST)
      ELSEIF (MODEL.EQ.14) THEN
         QNLIB3 = F314 (NMOD, NPAR, A, ENEG, EPOS, X, Y, Z)
      ELSEIF (MODEL.EQ.15) THEN
         QNLIB3 = F315 (NPAR,
     +                  A, RTOL, X, Y, Z)   
      ELSEIF (MODEL.EQ.17) THEN
         KMAX_A = NX
         CALL QNUSER (ISEND,
     +                KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                NEQN, NPAR, NVAR, NX, A, F, X, Y, YDE, YJA,
     +                Z, MODNAM, ABORT, DEQN)
         QNLIB3 = F(1)
      ELSE
C     ... Dummy code to silence FTN95
         QNLIB3 = EPSI
      ENDIF
      CALL MIDDLE (XTOL, QNLIB3, ZTOL)
      END
C
C
      FUNCTION F301(N, A, X, Y, Z, CONST)
C      ... Polynomials
      IMPLICIT NONE
      INTEGER  N
      DOUBLE PRECISION A(N), X, Y, Z
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      DOUBLE PRECISION F301
      LOGICAL  CONST
      F301 = ZERO
C*****IF (M.EQ.1) THEN
         F301 = A(1)*X + A(2)*Y + A(3)*Z
C*****ELSEIF (M.EQ.2) THEN
C********F201 = A(1)*X + A(2)*Y + A(3)*X*X + A(4)*X*Y + A(5)*Y*Y
C*****ELSEIF (M.EQ.3) THEN
C********C = X*X
C********D = Y*Y
C********F201 = A(1)*X + A(2)*Y + A(3)*C + A(4)*X*Y + A(5)*D +
C****+          A(6)*C*X + A(7)*C*Y + A(8)*D*X + A(9)*D*Y
C*****ENDIF
      IF (CONST) F301 = F301 + A(N)
      END
C
C

      FUNCTION F303(NMOD, NPAR, A, B, RTOL, X, Y, Z)
C     ... Enzyme kinetics
      IMPLICIT   NONE
      INTEGER    NMOD, NPAR
      INTEGER    NTEMP
      DOUBLE PRECISION A(NPAR), B(NPAR), RTOL, X, Y, Z
      DOUBLE PRECISION C, D, E, F, G, H
      DOUBLE PRECISION BOT, TOP
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION F303
      INTRINSIC  NINT
      F303 = ZERO
      IF (NMOD.EQ.1) THEN
         C = A(1)*X
         D = A(2)*Y
         E = A(3)*Z
         F = ONE + C
         IF (F.LT.RTOL) RETURN
         G = ONE + D
         IF (G.LT.RTOL) RETURN
         H = ONE + E
         IF (H.LT.RTOL) RETURN
         NTEMP = NINT(B(1))
         IF (NTEMP.LT.1) RETURN
         TOP = A(4)*B(1)*C*(F**(NTEMP - 1))
         BOT = F**NTEMP + A(5)*(G**NTEMP)/(H**NTEMP)
         IF (BOT.GT.RTOL .AND. TOP.GT.RTOL) F303 = TOP/BOT
      ENDIF
      END
C
C
      FUNCTION F310(NPAR, A, ENEG, EPOS, X, Y, Z, CONST)
C     ... Biological
      IMPLICIT   NONE
      INTEGER    NPAR
      DOUBLE PRECISION A(NPAR), ENEG, EPOS, X, Y, Z
      DOUBLE PRECISION F310
      DOUBLE PRECISION POLY
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      LOGICAL    CONST
      EXTERNAL   MIDDLE
      INTRINSIC  EXP
      POLY = - (A(2) + A(3)*X + A(4)*Y + A(5)*Z + A(6)*X*Y + A(7)*X*Z +
     +          A(8)*Y*Z + A(9)*X*Y*Z)
      CALL MIDDLE (ENEG, POLY, EPOS)
      F310 = A(1)/(ONE + EXP(POLY))
      IF (CONST) F310 = F310 + A(NPAR)
      END
C
C
      FUNCTION F314(NMOD, NPAR, A, ENEG, EPOS, X, Y, Z)
C     ... Statistical
      IMPLICIT   NONE
      INTEGER    NMOD, NPAR
      INTEGER    I
      DOUBLE PRECISION A(NPAR), ENEG, EPOS, X, Y, Z
      DOUBLE PRECISION C
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      DOUBLE PRECISION S15ABF$
      DOUBLE PRECISION F314
      EXTERNAL   MIDDLE, S15ABF$
      INTRINSIC  EXP
      IF (NMOD.EQ.1) THEN
C     ... Logit
         C = - (A(1) + A(2)*X + A(3)*Y + A(4)*Z)
         CALL MIDDLE (ENEG, C, EPOS)
         F314 = ONE/(ONE + EXP(C))
      ELSEIF (NMOD.EQ.2) THEN
C     ... Probit
         C = A(1) + A(2)*X + A(3)*Y + A(4)*Z
         I = 1
         F314 = S15ABF$(C, I)
      ENDIF
      END
C
C
      FUNCTION F315(NPAR, 
     +              A, RTOL, X, Y, Z)
C     ... Empirical
      IMPLICIT NONE
      INTEGER  NPAR
      DOUBLE PRECISION F315
      DOUBLE PRECISION A(NPAR), RTOL, X, Y, Z
      DOUBLE PRECISION DENOM
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      INTRINSIC ABS
      DENOM = A(2)*Y + A(3)*Z
      IF (ABS(DENOM).LE.RTOL) THEN
         IF (DENOM.GE.ZERO) THEN
            DENOM = RTOL
         ELSE
            DENOM = - RTOL
         ENDIF
      ENDIF        
      F315 = A(1) + X/DENOM
      END
C
C                  
