C
C
C File QNLIBD.FOR : subroutines for single differential eqns. as used by QNFIT
C ================          YDERIV
C                           PEDERV
C To be consistent this version must have MODNAM dimensioned MODNAM(24)*80
C This version dimensions using KMAX_A, KMAX_F, KMAX_J and KMAX_Y
C DVODE version : All the parameters are communicated through IP and P
C =============   so subroutine QMODSV is not required
C
      SUBROUTINE YDERIV (NEQ, T, Y, F, P, IP)
C
C ACTION : Define the derivative as in dy/dt = f(y, t| p, ip)
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 22/12/94
C          09/10/1997 DVODE version
C          14/10/2001 dimensioned MODNAM(24)*80
C          04/09/2009 minor editing  
C          04/01/2010 added modified allometric equation
C
C          NEQ: (input/unchanged) number of equations (only 1 in this version)
C            T: (input/unchanged) time point
C            Y: (input/unchanged) y value as in y(t)
C            F: (output)          function value as in dy/dt = f(y, t| p, ip)
C            P: (input/unchanged) double precision parameters as used to define f  
C           IP: (input/unchanged) integer parameters as used to define f
C
C ADVICE : NX defines maximum stack size in QNUSER (equations/parameters)
C          IP is used to communicate MODEL, NMOD, NPAR
C          NEQ is not used except for dimensioning (uses NEQN = 1 in PARAMETER)
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: IP(*), NEQ
      DOUBLE PRECISION, INTENT (IN)  :: T, Y(NEQ), P(*)
      DOUBLE PRECISION, INTENT (OUT) :: F(NEQ)
C
C Locals
C      
      INTEGER    MODEL, NMOD, NPAR
      INTEGER    NX
      PARAMETER (NX = 100)
      INTEGER    JSEND, NEQN, NVAR
      PARAMETER (JSEND = 2, NEQN = 1, NVAR = 1)
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      PARAMETER (KMAX_F = NEQN, KMAX_J = NEQN**2, KMAX_Y = NEQN)
      DOUBLE PRECISION YJA(NEQN**2)
      DOUBLE PRECISION BOT, FACTOR, TEMP, TOP
      DOUBLE PRECISION YY, ZZ
      DOUBLE PRECISION ZERO, YMIN, ZMIN
      PARAMETER (ZERO = 0.0D+00, YMIN = 1.0D-50, ZMIN = 1.0D-50)
      DOUBLE PRECISION ENEG, EPOS
      PARAMETER (EPOS = 50.0D+00, ENEG = -EPOS)
      DOUBLE PRECISION PMAX, YMAX 
      PARAMETER (PMAX = 5.0D+00, YMAX = 1.0D06)
      DOUBLE PRECISION  EXFAC, Y1P2, Y1P4
      CHARACTER (LEN = 80) :: MODNAM(24)
      LOGICAL    ABORT
      LOGICAL    DEQN
      PARAMETER (DEQN = .TRUE.)
      EXTERNAL   QNUSER
      INTRINSIC  ABS
C
C Pick up MODEL, NMOD, NPAR from IP supplied
C
      MODEL = IP(1)
      NMOD = IP(2)
      NPAR = IP(4)
C
C Branch to model depending on MODEL and NMOD
C
      IF (MODEL.EQ.1) THEN
         IF (NMOD.EQ.1) THEN
            BOT = P(1) + Y(1)
            IF (ABS(BOT).LE.YMIN) THEN
               IF (BOT.LT.ZERO) THEN
                  BOT = - YMIN
               ELSE
                  BOT = YMIN
               ENDIF
            ENDIF
            TOP = P(2)*Y(1)
            F(1) = - TOP/BOT
         ELSEIF (NMOD.EQ.2) THEN
            TEMP = P(3) - Y(1)
            BOT = P(1) + TEMP
            IF (ABS(BOT).LE.YMIN) THEN
               IF (BOT.LT.ZERO) THEN
                  BOT = - YMIN
               ELSE
                  BOT = YMIN
               ENDIF
            ENDIF
            TOP = P(2)*TEMP
            F(1) = TOP/BOT
         ELSEIF (NMOD.EQ.3) THEN
            BOT = P(1) + Y(1)
            IF (ABS(BOT).LE.YMIN) THEN
               IF (BOT.LT.ZERO) THEN
                  BOT = - YMIN
               ELSE
                  BOT = YMIN
               ENDIF
            ENDIF
            TOP = P(2)*Y(1)
            F(1) = - TOP/BOT - P(3)*Y(1) - P(4)
         ELSEIF (NMOD.EQ.4) THEN
            TEMP = P(5) - Y(1)
            BOT = P(1) + TEMP
            IF (ABS(BOT).LE.YMIN) THEN
               IF (BOT.LT.ZERO) THEN
                  BOT = - YMIN
               ELSE
                  BOT = YMIN
               ENDIF
            ENDIF
            TOP = P(2)*TEMP
            F(1) = TOP/BOT + P(3)*TEMP + P(4)
         ELSEIF (NMOD.EQ.5) THEN
            BOT = Y(1)*(P(1) + Y(1)) + P(2)
            IF (ABS(BOT).LE.YMIN) THEN
               IF (BOT.LT.ZERO) THEN
                  BOT = - YMIN
               ELSE
                  BOT = YMIN
               ENDIF
            ENDIF
            TOP = P(3)*(Y(1) - P(4))
            F(1) = TOP/BOT
         ENDIF
      ELSEIF (MODEL.EQ.2) THEN
         IF (Y(1).GE.YMAX .OR. Y(1).LE.YMIN .OR. 
     +       P(2).GT.PMAX .OR. P(4).GT.PMAX) THEN
            F(1) = ZMIN
            RETURN
         ENDIF
         Y1P2 = Y(1)**P(2)
         Y1P4 = Y(1)**P(4)     
         IF (NMOD.EQ.1) THEN
            IF (Y(1).GE.ZMIN) THEN
C               F(1) = P(1)*(Y(1)**P(2)) - P(3)*(Y(1)**P(4))
                
                F(1) = P(1)*Y1P2 - P(3)*Y1P4
            ELSE
               F(1) = ZMIN
            ENDIF
         ELSEIF (NMOD.EQ.2) THEN
            IF (Y(1).GE.ZMIN .AND. T.GE.ZERO) THEN  
               FACTOR = -P(5)*T
               IF (FACTOR.LT.ENEG) THEN
                  FACTOR = ENEG
               ELSEIF (FACTOR.GT.EPOS) THEN
                  FACTOR = EPOS
               ENDIF
               
C               F(1) = EXP(FACTOR)*P(1)*(Y(1)**P(2)) - P(3)*(Y(1)**P(4))
              
               EXFAC = EXP(FACTOR)
               F(1) = EXFAC*P(1)*Y1P2 - P(3)*Y1P4   
            ELSE
               F(1) = ZMIN
            ENDIF      
         ENDIF
      ELSEIF (MODEL.EQ.17) THEN
         KMAX_A = NPAR
         CALL QNUSER (JSEND,
     +                KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                NEQN, NPAR, NVAR, NX, 
     +                P, F, T, YY, Y, YJA, ZZ,
     +                MODNAM,
     +                ABORT, DEQN)
      ENDIF
      END
C
C
      SUBROUTINE PEDERV (NEQ, T, Y, ML, MU, PW, NROWPW, P, IP)
C
C ACTION : Jacobian for YDERIV
C AUTHOR : W. G. Bardsley, University of manchester, U.K., 22/12/94
C          09/10/1997 DVODE version
C          14/10/2001 dimensioned MODNAM(24)*80
C          04/09/2009 minor editing
C          04/01/2010 added modified allometric equation
C
C          NEQ: (input/unchanged) number of equations (only 1 in this version)
C            T: (input/unchanged) time point
C            Y: (input/unchanged) y value as in y(t)
C           ML: (input/unchanged) parameter for DVODE    
C           MU: (input/unchanged) parameter for DVODE    
C           PW: (output)          Jacobian
C       NROWPW: (input/unchanged) leading dimension of Jacobian matrix
C            P: (input/unchanged) double precision parameters as used to define f  
C           IP: (input/unchanged) integer parameters as used to define f
C
C ADVICE : NX defines maximum stack size in QNUSER (equations/parameters)
C          IP is used to communicate MODEL, NMOD, NPAR
C          NEQ is not used (uses NEQN = 1 in PARAMETER)
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: IP(*), ML, MU, NEQ, NROWPW
      DOUBLE PRECISION, INTENT (IN)  :: T, Y(NEQ), P(*)
      DOUBLE PRECISION, INTENT (OUT) :: PW(NROWPW,NEQ)
C
C Locals
C      
      INTEGER    MODEL, NMOD, NPAR
      INTEGER    NX
      PARAMETER (NX = 100)
      INTEGER    JSEND, NEQN, NVAR
      PARAMETER (JSEND = 3, NEQN = 1, NVAR = 1)
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      PARAMETER (KMAX_F = NEQN, KMAX_J = NEQN**2, KMAX_Y = NEQN)
      DOUBLE PRECISION BOT, FACTOR, TOP
      DOUBLE PRECISION F(NEQN)
      DOUBLE PRECISION YJA(NEQN**2)
      DOUBLE PRECISION YY, ZZ
      DOUBLE PRECISION ZERO, ONE, TWO, YMIN, ZMIN
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           YMIN = 1.0D-50, ZMIN = 1.0D-50)
      DOUBLE PRECISION ENEG, EPOS
      PARAMETER (EPOS = 50.0D+00, ENEG = -EPOS)
      DOUBLE PRECISION PMAX, YMAX
      PARAMETER (PMAX = 5.0D+00, YMAX = 1.0D06)
      DOUBLE PRECISION  EXFAC, P2M1, P4M1, Y1P2M1, Y1P4M1
      CHARACTER (LEN = 80) :: MODNAM(24)
      LOGICAL    ABORT
      LOGICAL    DEQN
      PARAMETER (DEQN = .TRUE.)
      EXTERNAL   QNUSER
      INTRINSIC  ABS
C
C ML and Mu are not used in this version
C      
      MODEL = ML!to silence ftn95
      MODEL = MU!to silence ftn95
C
C Pick up MODEL, NMOD, NPAR from IP supplied
C
      MODEL = IP(1)
      NMOD = IP(2)
      NPAR = IP(4)
C
C Branch to model depending on MODEL and NMOD
C
      IF (MODEL.EQ.1) THEN
         IF (NMOD.EQ.1) THEN
            BOT = P(1) + Y(1)
            IF (ABS(BOT).LE.YMIN) BOT = YMIN
            TOP = P(1)*P(2)
            PW(1,1) = - TOP/(BOT**2)
         ELSEIF (NMOD.EQ.2) THEN
            BOT = P(1) + P(3) - Y(1)
            IF (ABS(BOT).LE.YMIN) BOT = YMIN
            TOP = P(1)*P(2)
            PW(1,1) = - TOP/(BOT**2)
         ELSEIF (NMOD.EQ.3) THEN
            BOT = P(1) + Y(1)
            IF (ABS(BOT).LE.YMIN) BOT = YMIN
            TOP = P(1)*P(2)
            PW(1,1) = - TOP/(BOT**2) - P(3)
         ELSEIF (NMOD.EQ.4) THEN
            BOT = P(1) + P(5) - Y(1)
            IF (ABS(BOT).LE.YMIN) BOT = YMIN
            TOP = P(1)*P(2)
            PW(1,1) = - TOP/(BOT**2) - P(3)
         ELSEIF (NMOD.EQ.5) THEN
            BOT = Y(1)*(Y(1) + P(1)) + P(2)
            IF (ABS(BOT).LE.YMIN) BOT = YMIN
            TOP = P(3)*(Y(1)*(TWO*P(4) - Y(1)) + P(2) + P(1)*P(4))
            PW(1,1) = TOP/(BOT**2)
         ENDIF
      ELSEIF (MODEL.EQ.2) THEN
         IF (Y(1).GE.YMAX .OR. Y(1).LE.YMIN  .OR. 
     +       P(2).GT.PMAX .OR. P(4).GT.PMAX) THEN
            PW(1,1) = ZMIN
            RETURN
         ENDIF   
         P2M1 = P(2) - ONE
         P4M1 = P(4) - ONE  
         Y1P2M1 = Y(1)**P2M1
         Y1P4M1 = Y(1)**P4M1
         IF (NMOD.EQ.1) THEN
            IF (Y(1).GT.ZMIN) THEN
              
C               PW(1,1) = P(1)*P(2)*(Y(1)**(P(2) - ONE))
C     +                 - P(3)*P(4)*(Y(1)**(P(4) - ONE))
              
               PW(1,1) = P(1)*P(2)*Y1P2M1 - P(3)*P(4)*Y1P4M1 
            ELSE
               PW(1,1) = ZMIN
            ENDIF
         ELSEIF (NMOD.EQ.2) THEN 
            IF (Y(1).GT.ZMIN .AND. T.GE.ZERO) THEN
               FACTOR = -P(5)*T
               IF (FACTOR.LT.ENEG) THEN
                  FACTOR = ENEG
               ELSEIF (FACTOR.GT.EPOS) THEN
                  FACTOR = EPOS
               ENDIF     
               
C               PW(1,1) = EXP(FACTOR)*P(1)*P(2)*(Y(1)**(P(2) - ONE))
C     +                 - P(3)*P(4)*(Y(1)**(P(4) - ONE))

               EXFAC = EXP(FACTOR) 
               PW(1,1) =  EXFAC*P(1)*P(2)*Y1P2M1 - P(3)*P(4)*Y1P4M1
            ELSE
               PW(1,1) = ZMIN
            ENDIF  
         ENDIF
      ELSEIF (MODEL.EQ.17) THEN
C
C Next call problematical with /f_stdcall + /checkmate so used YJA
C      
         KMAX_A = NPAR
         CALL QNUSER (JSEND,
     +                KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                NEQN, NPAR, NVAR, NX,
     +                P, F, T, YY, Y, YJA, ZZ,
     +                MODNAM,
     +                ABORT, DEQN)
C
C Copy Jacobian from YJA into PW
C     
         PW(1,1) = YJA(1)
      ENDIF
      END
C
C
