C
C QNSUB1 : Subroutines for functions of one variable for MAKDAT, QNFIT ETC.
C To be consistent this version must have MODNAM dimensioned MODNAM(24)*80
C This version dimensions using KMAX_A, KMAX_F, KMAX_J and KMAX_Y
C ACTION : Define MODEL, NFIX, NMOD, NPAR, B, MODNAM, CONST
C AUTHOR : W. G. Bardsley, University of manchester, U. K.
C          29/12/1994 Added user supplied models
C          14/03/1995 added NEQN, YDE, YJA
C          25/05/1995 Menu version and several improvements
C          13/01/1997 Revised Weibull/Gompertz survival and gamma-like
C          30/08/2000 Added Michaelis pH functions
C          01/09/2000 Added [Hot]/[Cold] alternatives
C          01/09/2000 Extensive revision
C          14/10/2001 Dimensioned MODNAM(24)*80
C          18/04/2002 added trigonometric functions
C          22/12/2022 added TITLE_CHECKER 
C
      SUBROUTINE QNSUB1 (MODEL, NFIX, NMOD, NPAR, NX, B, MODNAM, CONST,
     +                   DEQN)
      IMPLICIT   NONE
      INTEGER    MODEL, NFIX, NMOD, NPAR, NX
      INTEGER    ISEND, NEQN, NVAR
      PARAMETER (ISEND = 1, NEQN = 1, NVAR = 1)
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      PARAMETER (KMAX_F = NEQN, KMAX_J = NEQN**2, KMAX_Y = NEQN)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMCOL, NUMDEC, NUMROW,
     +           NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NUMCOL = 0,
     +           NUMOPT = 18, NUMROW = 0)
      INTEGER    NUMBLD(20), NUMPOS(NUMOPT)
      INTEGER    I, JSEND,  NTYPE_SAV
      PARAMETER (JSEND = 2)
      INTEGER    NEQN_TEMP, NVAR_TEMP
      DOUBLE PRECISION B(NX)
      DOUBLE PRECISION F(NEQN), X, Y, YDE(NEQN), YJA(NEQN**2), Z
      CHARACTER (LEN = 80) MODNAM(24), TITLE_SAV(24)
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    CONST
      LOGICAL    ABORT, DEQN, YES
      LOGICAL    DEQN_TEMP
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01, YESNO1, PUTFAT
      EXTERNAL   QNS101, QNS102, QNS103, QNS104, QNS105, QNS106,
     +           QNS107, QNS108, QNS109, QNS110, QNS111, QNS112,
     +           QNS113, QNS114, QNS115, QNS116
      EXTERNAL   QNUSER
      EXTERNAL   TITLE_CHECKER
      SAVE       DEQN_TEMP
      DATA       NUMBLD / 1*1, 19*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Initialise MODNAM then save DEQN and get MODEL
C
      DEQN_TEMP = DEQN
   20 CONTINUE
      DO I = 1, 4
         MODNAM(I) = BLANK
      ENDDO
      WRITE (TEXT,100)
      NUMDEC = NUMOPT
      NSTART = 3
      NTEXT = 20
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +             NUMOPT, NUMPOS, NSTART, NTEXT, TEXT,
     +             BORDER, FLASH, HIGH)
      MODEL = NUMDEC
C
C Set NFIX = 0, NMOD = 1 and CONST = .FALSE.
C
      NFIX = 0
      NMOD = 1
      CONST = .FALSE.
C
C Get NMOD and details of the model
C
      IF (MODEL.EQ.1) THEN
         CALL QNS101 (NFIX, NMOD, NPAR, NX,    MODNAM, CONST)
      ELSEIF (MODEL.EQ.2) THEN
         CALL QNS102 (NFIX, NMOD, NPAR, NX,    MODNAM, CONST)
      ELSEIF (MODEL.EQ.3) THEN
         CALL QNS103 (NFIX, NMOD, NPAR, NX, B, MODNAM, CONST)
      ELSEIF (MODEL.EQ.4) THEN
         CALL QNS104 (NFIX, NMOD, NPAR, NX, B, MODNAM, CONST)
      ELSEIF (MODEL.EQ.5) THEN
         CALL QNS105 (NFIX, NMOD, NPAR, NX, B, MODNAM, CONST)
      ELSEIF (MODEL.EQ.6) THEN
         CALL QNS106 (NFIX, NMOD, NPAR, NX, B, MODNAM, CONST)
      ELSEIF (MODEL.EQ.7) THEN
         CALL QNS107 (NFIX, NMOD, NPAR, NX, B, MODNAM, CONST)
      ELSEIF (MODEL.EQ.8) THEN
         CALL QNS108 (NFIX, NMOD, NPAR, NX, B, MODNAM, CONST)
      ELSEIF (MODEL.EQ.9) THEN
         CALL QNS109 (NFIX, NMOD, NPAR, NX, B, MODNAM, CONST)
      ELSEIF (MODEL.EQ.10) THEN
         CALL QNS110 (NFIX, NMOD, NPAR, NX, B, MODNAM, CONST)
      ELSEIF (MODEL.EQ.11) THEN
         CALL QNS111 (NFIX, NMOD, NPAR, NX, B, MODNAM, CONST)
      ELSEIF (MODEL.EQ.12) THEN
         CALL QNS112 (NFIX, NMOD, NPAR, NX, B, MODNAM, CONST)
      ELSEIF (MODEL.EQ.13) THEN
         CALL QNS113 (      NMOD, NPAR,        MODNAM       )
      ELSEIF (MODEL.EQ.14) THEN
         CALL QNS114 (      NMOD, NPAR,        MODNAM       )
      ELSEIF (MODEL.EQ.15) THEN
         CALL QNS115 (NFIX, NMOD, NPAR, NX, B, MODNAM, CONST)
      ELSEIF (MODEL.EQ.16) THEN
         CALL QNS116 (NFIX, NMOD, NPAR, NX, B, MODNAM, CONST)
      ELSEIF (MODEL.EQ.17) THEN
         KMAX_A = NX
         NEQN_TEMP = NEQN
         NVAR_TEMP = NVAR
         DEQN_TEMP = DEQN
         CALL QNUSER (ISEND,
     +                KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                NEQN_TEMP, NPAR, NVAR_TEMP, NX,
     +                B, F, X, Y, YDE, YJA,
     +                Z, MODNAM, ABORT, DEQN_TEMP)
         IF (ABORT) GOTO 20
         IF (NEQN_TEMP.NE.NEQN .OR. NVAR_TEMP.NE.NVAR) THEN
            ABORT = .TRUE.
            CALL PUTFAT (
     +'Model file must define one function of one variable') 
            GOTO 20
         ENDIF  
         IF (.NOT.DEQN .AND. DEQN_TEMP) THEN
            CALL PUTFAT (
     +'Model file must not be a differential equation file')
            GOTO 20
         ENDIF    
         IF (DEQN .AND. .NOT.DEQN_TEMP) THEN
            CALL PUTFAT (
     +'Model file must be a differential equation file')
            GOTO 20
         ENDIF         
      ELSEIF (MODEL.EQ.NUMOPT) THEN
         MODEL = - 1
         RETURN
      ENDIF
C
C If a model has not been chosen (NMOD = - 1) then try again
C
      IF (NMOD.LT.1) GOTO 20
C
C Check if model chosen is the correct one
C
      NTEXT = 6
      IF (MODEL.EQ.17) THEN
         CALL TITLE_CHECKER (JSEND, NTYPE_SAV,
     +                       TITLE_SAV)
         DO I = 1, MIN(NTYPE_SAV,4)
            MODNAM(I) = TITLE_SAV(I)
         ENDDO 
      ENDIF  
      WRITE (TEXT,200) MODNAM(1), MODNAM(2), MODNAM(3), MODNAM(4)
      NTEXT = NTEXT + 1
      TEXT(NTEXT) = BLANK
      IF (MODEL.LE.9) THEN
         WRITE (LINE,300) NMOD
      ELSE
         LINE = BLANK
      ENDIF
      NTEXT = NTEXT + 1
      TEXT(NTEXT) = LINE
      WRITE (LINE,400) NPAR
      NTEXT = NTEXT + 1
      TEXT(NTEXT) = LINE
      IF (CONST) THEN
         WRITE (LINE,500)
      ELSE
         IF (NFIX.EQ.1) THEN
            WRITE (LINE,600)
         ELSE
            LINE = BLANK
         ENDIF
      ENDIF
      NTEXT = NTEXT + 1
      TEXT(NTEXT) = LINE
      NTEXT = NTEXT + 1
      TEXT(NTEXT) = BLANK
      WRITE (LINE,700)
      YES = .FALSE.
      CALL YESNO1 (ICOLOR, IXL, IYL, LSHADE, NUMCOL, NUMROW, NTEXT,
     +             LINE, TEXT,
     +             BORDER, FLASH, HIGH, YES)
      IF (.NOT.YES) GOTO 20
  100 FORMAT ('Library : Functions of 1 variable (Version 2.0)'/
     +/'Line, quadratic or polynomial degree n (+ deconvolution)'
     +/'Rational function of order n:n'
     +/'Sum of n Michaelis-Menten functions (+ deconvolution)'
     +/'Sum of n High/Low affinity sites (+ deconvolution)'
     +/'Ligand binding functions (n Association constants)'
     +/'Ligand binding functions (n Adair constants)'
     +/'Sum of n exponential functions (+ deconvolution)'
     +/'Sum of n trigonometric functions (+ deconvolution)'
     +/'Sum of n Gaussian functions (+ deconvolution)'
     +/'Biological models'
     +/'Biochemical models'
     +/'Chemical models'
     +/'Physical models'
     +/'Statistical models'
     +/'Empirical models'
     +/'Mathematical models'
     +/'User-supplied-model from an ASCII text file'
     +/'Cancel')
  200 FORMAT ('Model:'//A/A/A/A)
  300 FORMAT ('n =',I2)
  400 FORMAT ('Number of parameters =',I3)
  500 FORMAT ('Constant included')
  600 FORMAT ('Constant set to 0')
  700 FORMAT ('Is this the correct model ? ')
      END
C
C
