C
C QNSUB2 : Subroutines for functions of two variables for MAKDAT, QNFIT etc.
C To be consistent this version must have MODNAM dimensioned MODNAM(24)*80
C This version dimensions using KMAX_A, KMAX_F, KMAX_J and KMAX_Y
C ACTION : Define MODEL, NFIX, NMOD, NPAR, B, MODNAM, CONST
C AUTHOR : W. G. Bardsley, University of manchester, U. K.
C          29/12/1994 Added user supplied models
C          14/03/1995 Added NEQN, YDE, YJA
C          26/05/1995 Menu version
C          30/08/2000 added MM competing and pH dependent models
C          14/10/2001 dimensioned MODNAM(24)*80
C          03/06/2005 added logistic growth model
C          22/12/2022 added call to TITLE_CHECKER
C
      SUBROUTINE QNSUB2 (MODEL, NFIX, NMOD, NPAR, NX, B, MODNAM, CONST)
      IMPLICIT   NONE
      INTEGER    MODEL, NFIX, NMOD, NPAR, NX
      INTEGER    I, NTITLE
      INTEGER    ISEND, JSEND, NEQN, NVAR
      PARAMETER (ISEND = 1, JSEND = 2, NEQN = 1, NVAR = 2)
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      PARAMETER (KMAX_F = NEQN, KMAX_J = NEQN**2, KMAX_Y = NEQN)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 18)
      INTEGER    NUMCOL, NUMROW
      PARAMETER (NUMCOL = 0, NUMROW = 0)
      INTEGER    NUMBLD(20), NUMPOS(20)
      INTEGER    NEQN_TEMP, NVAR_TEMP
      DOUBLE PRECISION B(NX)
      DOUBLE PRECISION F(NEQN), X, Y, YDE(NEQN), YJA(NEQN**2), Z
      CHARACTER (LEN = 80) MODNAM(24), TITLE(24)
      CHARACTER  BLANK
      PARAMETER (BLANK = ' ')
      CHARACTER  LINE*100, TEXT(30)*100
      LOGICAL    CONST
      LOGICAL    YES
      LOGICAL    ABORT, DEQN, DEQN_TEMP
      PARAMETER (DEQN = .FALSE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   PUTFAT
      EXTERNAL   QNS201, QNS202, QNS203, QNS210, QNS213, QNS214
      EXTERNAL   QNUSER
      EXTERNAL   LBOX01, YESNO1
      EXTERNAL   TITLE_CHECKER
      DATA NUMBLD / 20*0 /
      DATA NUMPOS / 20*1 /
C
C Initialise MODNAM then get MODEL
C
   20 CONTINUE
      DO I = 1, 4
         MODNAM(I) = BLANK
      ENDDO
      WRITE (TEXT,100)
      NSTART = 3
      NTEXT = 20
      NUMDEC = NUMOPT
      NUMBLD(1) = 1
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, TEXT, BORDER, FLASH, HIGH)
      MODEL = NUMDEC
C
C Set NFIX = 0, NMOD = 1 and CONST = .FALSE.
C
      NFIX = 0
      NMOD = 1
      CONST = .FALSE.
C
C Get NMOD and details of models
C
      IF (MODEL.EQ.1) THEN
         CALL QNS201 (NFIX, NMOD, NPAR, MODNAM, CONST)
      ELSEIF (MODEL.EQ.2) THEN
         CALL QNS202 (NFIX, NMOD, NPAR, MODNAM, CONST)
      ELSEIF (MODEL.EQ.3) THEN
         CALL QNS203 (NMOD, NPAR, MODNAM)
      ELSEIF (MODEL.EQ.10) THEN
         CALL QNS210 (NFIX, NPAR, MODNAM, CONST)
      ELSEIF (MODEL.EQ.13) THEN
         CALL QNS213 (NPAR, MODNAM)
      ELSEIF (MODEL.EQ.14) THEN
         CALL QNS214 (NFIX, NMOD, NPAR, MODNAM, CONST)
      ELSEIF (MODEL.EQ.17) THEN
         KMAX_A = NX
         NEQN_TEMP = NEQN
         NVAR_TEMP = NVAR
         DEQN_TEMP = DEQN
         CALL QNUSER (ISEND,
     +                KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                NEQN_TEMP, NPAR, NVAR_TEMP, NX,
     +                B, F, X, Y, YDE, YJA,
     +                Z, MODNAM, ABORT, DEQN_TEMP)
         IF (ABORT) GOTO 20
         IF (NEQN_TEMP.NE.NEQN .OR. NVAR_TEMP.NE.NVAR .OR.
     +       DEQN_TEMP) THEN
            ABORT = .TRUE.
            CALL PUTFAT (
     +'Model file must define one function of two variables')
            GOTO 20
         ENDIF
      ELSEIF (MODEL.EQ.NUMOPT) THEN
         MODEL = - 1
         RETURN
      ELSE
         CALL PUTFAT ('Not available in this version')
         GOTO 20
      ENDIF
C
C If no model selected then NMOD = - 1
C
      IF (NMOD.LT.1) GOTO 20
      IF (NPAR.GT.NX) THEN
         CALL PUTFAT ('Model requested has too many parameters')
         GOTO 20
      ENDIF
      NTEXT = 6
      IF (MODEL.EQ.17) THEN
         CALL TITLE_CHECKER (JSEND, NTITLE,
     +                       TITLE)
         DO I = 1, MIN(4,NTITLE)
            MODNAM(I) = TITLE(I)
         ENDDO
      ENDIF     
      WRITE (TEXT,200) MODNAM(1), MODNAM(2), MODNAM(3), MODNAM(4)
      NTEXT = NTEXT + 1
      TEXT(NTEXT) = BLANK
      WRITE (LINE,300) NPAR
      NTEXT = NTEXT + 1
      TEXT(NTEXT) = LINE
      IF (CONST) THEN
         WRITE (LINE,400)
      ELSE
         IF (NFIX.EQ.1) THEN
            WRITE (LINE,500)
         ELSE
            LINE = BLANK
         ENDIF
      ENDIF
      NTEXT = NTEXT + 1
      TEXT(NTEXT) = LINE
      NTEXT = NTEXT + 1
      TEXT(NTEXT) = BLANK
      WRITE (LINE,600)
      YES = .FALSE.
      CALL YESNO1 (ICOLOR, IXL, IYL, LSHADE, NUMCOL, NUMROW, NTEXT,
     +             LINE, TEXT, BORDER, FLASH, HIGH, YES)
      IF (.NOT.YES) GOTO 20
  100 FORMAT ('Library : Functions of 2 variables (Version 2.0)'/
     +/'Polynomials'
     +/'Rational functions'
     +/'Enzyme kinetics'
     +/'... (NA)'
     +/'... (NA)'
     +/'... (NA)'
     +/'... (NA)'
     +/'... (NA)'
     +/'... (NA)'
     +/'Biological'
     +/'Biochemical (NA)'
     +/'Chemical (NA)'
     +/'Physical'
     +/'Statistical'
     +/'Empirical (NA)'
     +/'Mathematical (NA)'
     +/'User-supplied-model from an ASCII text file'
     +/'Cancel')
  200 FORMAT ('Model selected'//A/A/A/A)
  300 FORMAT ('Number of parameters =',I3)
  400 FORMAT ('Constant included')
  500 FORMAT ('Constant set to 0')
  600 FORMAT ('Is this the correct model ?')
      END
C
C
      SUBROUTINE QNS201 (NFIX, NMOD, NPAR, Z, CONST)
C      ... Polynomials
      IMPLICIT   NONE
      INTEGER    NFIX, NMOD, NPAR
      INTEGER    N0, N3
      PARAMETER (N0 = 0, N3 = 3)
      CHARACTER  Z(24)*80
      LOGICAL    CONST
      EXTERNAL   GETJM1, ADDCON
      NMOD = 1
      CALL GETJM1 (N0, NMOD, N3,
     +'Degree required for polynomial (i.e. n, or n = 0 for no model)')
      IF (NMOD.EQ.1) THEN
         Z(1) = 'Degree 1 polynomial: C = p(3)'
         Z(3) = 'p(1)x + p(2)y + C'
         NPAR = 2
      ELSEIF (NMOD.EQ.2) THEN
         Z(1) = 'Degree 2 polynomial: C = p(6)'
         Z(3) = 'p(1)x + p(2)y + p(3)x^2 + p(4)xy + p(5)y^2 + C'
         NPAR = 5
      ELSEIF (NMOD.EQ.3) THEN
         Z(1) = 'Degree 3 polynomial: C = p(10)'
         Z(3) = 'p(1)x + p(2)y + p(3)x^2 + p(4)xy + p(5)y^2 +'
         Z(4) = 'p(6)x^3 + p(7)x^2y + p(8)xy^2 + p(9)y^3 + C'
         NPAR = 9
      ELSE
         NMOD = - 1
         RETURN
      ENDIF
      CALL ADDCON (NFIX, NPAR, CONST)
      END
C
C
      SUBROUTINE QNS202 (NFIX, NMOD, NPAR, Z, CONST)
C      ... Rational functions
      IMPLICIT   NONE
      INTEGER    NFIX, NMOD, NPAR
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(20), NUMPOS(20)
      CHARACTER  Z(24)*80
      CHARACTER  TEXT(30)*100
      LOGICAL    CONST
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   ADDCON, LBOX01
      DATA NUMBLD / 20*0 /
      DATA NUMPOS / 20*1 /
      WRITE (TEXT,100)
      NSTART = 1
      NUMOPT = 5
      NTEXT = 5
      NUMDEC = NUMOPT
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, TEXT, BORDER, FLASH, HIGH)
      NMOD = NUMDEC
      IF (NMOD.EQ.1) THEN
         NPAR = 6
         Z(1) = '2:2 rational; f(0,0) = 0'
         Z(2) = 'g(x,x) = p(1)xy'
         Z(3) =
     +  'h(x,y) = 1 + p(2)x + p(3)y + p(4)x^2 + p(5)xy + p(6)y^2'
         Z(4) = 'f(x,y) = g(x,y)/h(x,y)'
      ELSEIF (NMOD.EQ.2) THEN
         NPAR = 12
         Z(1) = '3:3 rational; f(0,0) = 0'
         Z(2) = 'g = p1xy + p2(x^2)y + p3x(y^2)'
         Z(3) =
     +   'h = 1+p4x+p5y+p6x^2+p7xy+p8y^2+p9x^3+p10x^2y p11xy^2+p12y^3'
         Z(4) = 'f = g/h'
      ELSEIF (NMOD.EQ.3) THEN
         Z(1) = '1:1 rational; C = p(5)'
         Z(2) = 'g(x,y) = C + p(1)x + p(2)y'
         Z(3) = 'h(x,y) = 1 + p(3)x + p(4)y'
         Z(4) = 'f(x,y) = g(x,y)/h(x,y)'
         NPAR = 4
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.4) THEN
         Z(1) = '2:2 rational; C = p(11)'
         Z(2) =
     +   'g(x,y) = C + p(1)x + p(2)y + p(3)x^2 + p(4)xy + p(5)y^2'
         Z(3) =
     +   'h(x,y) = 1 + p(6)x + p(7)y + p(8)x^2 + p(9)xy + p(10)y^2'
         Z(4) = 'f(x,y) = g(x,y)/h(x,y)'
         NPAR = 10
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSE
         NMOD = - 1
      ENDIF
  100 FORMAT (
     + 'Rational fn. order 2:2; f(0,0) = zero'
     +/'Rational fn. order 3:3; f(0,0) = zero'
     +/'Rational fn. order 1:1'
     +/'Rational fn. order 2:2'
     +/'Cancel')
      END
C
C
      SUBROUTINE QNS203 (NMOD, NPAR, Z)
C      ... Enzyme kinetics
      IMPLICIT   NONE
      INTEGER    NMOD, NPAR
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(20), NUMPOS(20)
      CHARACTER  Z(24)*80
      CHARACTER  TEXT(30)*100
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01
      DATA NUMBLD / 20*0 /
      DATA NUMPOS / 20*1 /
      WRITE (TEXT,100)
      NSTART = 1
      NUMOPT = 11
      NTEXT = 11
      NUMDEC = NUMOPT
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, TEXT, BORDER, FLASH, HIGH)
      NMOD = NUMDEC
      IF (NMOD.EQ.1) THEN
         NPAR = 4
         Z(1) =
     +'Reversible M-M (x=S,y=P,p(1)=Vs,p(2)=Ks,p(3)=Vp,p(4)=Kp)'
         Z(2) = 'g(x,y) = p(1)x/p(2) - p(3)y/p(4)'
         Z(3) = 'h(x,y) = 1 + [x/p(2)] + [y/p(4)]'
         Z(4) = 'f(x,y) = g(x,y)/h(x,y)'
      ELSEIF (NMOD.EQ.2) THEN
         NPAR = 3
         Z(1) =
     +'Competitive inhibition (S=x,I=y,Vmax=p(1),Km=p(2),Ki=p(3))'
         Z(2) = 'f(x,y) = p(1)x/{p(2)[1 + y/p(3)] + x}'
      ELSEIF (NMOD.EQ.3) THEN
         NPAR = 3
         Z(1) =
     +'Uncompetitive inhibition (S=x,I=y,Vmax=p(1),Km=p(2),Ki=p(3))'
         Z(2) = 'f(x,y) = p(1)x/{p(2) + x[1 + y/p(3)]}'
      ELSEIF (NMOD.EQ.4) THEN
         NPAR = 3
         Z(1) =
     +'Noncompetitive inhibition (S=x,I=y,Vmax=p(1),Km=p(2),Ki=p(3))'
         Z(2) = 'f(x,y) = p(1)x/{[1 + y/p(3)](p(2) + x)}'
      ELSEIF (NMOD.EQ.5) THEN
         NPAR = 4
         Z(1) =
     +'Mixed inhibition (S=x,I=y,Vmax=p(1),Km=p(2),Kis=p(3),Kii=p(4))'
         Z(2) = 'f(x,y) = p(1)x/{p(2)[1 + y/p(3)] + x[1 + y/p(4)]}'
      ELSEIF (NMOD.EQ.6) THEN
         NPAR = 3
         Z(1) =
     +'Ping Pong Bi Bi (A=x,B=y,Vmax=p(1),Ka=p(2),Kb=p(3))'
         Z(2) = 'f(x,y) = p(1)xy/{p(3)x + p(2)y + xy}'
      ELSEIF (NMOD.EQ.7) THEN
         NPAR = 4
         Z(1) =
     +'Ordered Bi Bi (A=x,B=y,Vmax=p(1),Ka=p(2),Kb=p(3),Kia=p(4))'
         Z(2) = 'f(x,y) = p(1)xy/{p(3)p(4) + p(3)x + p(2)y + xy}'
      ELSEIF (NMOD.EQ.8) THEN
         NPAR = 3
         Z(1) =
     +'f(x,y) = active enzyme (E + EI), x = time, y = inhibitor'
         Z(2) = 'p(1) = E0 (total enzyme), p(2) = k3 (rate constant),'
         Z(3) = 'p(3) = Ki (inhibitor constant)'
         Z(4) = 'f(x,y) = p(1)*exp[-p(2)*x/(1 + p(3)/y)]'
      ELSEIF (NMOD.EQ.9) THEN
         NPAR = 3
         Z(1) =
     +'M-M Competing Substrate (x=[S1],y=[S2],p(1)=V1,p(2)=K1,p(3)=K2)'
         Z(2) = 'g(x,y) = p(1)[x/p(2)]'
         Z(3) = 'h(x,y) = 1 + [x/p(2)] + [y/p(3)]'
         Z(4) = 'f(x,y) = g(x,y)/h(x,y)'
      ELSEIF (NMOD.EQ.10) THEN
         NPAR = 6
         Z(1) =
     +'pH dependent M-M (x=[S], y=[H], p(1)=V, p(2)=K, p(3)=K1e,'
         Z(2) =
     +'p(4)=K2e, p(5)=K1es, p(6)=K2es, y = f(y)x/(g(y) + x)'
         Z(3) =
     +   'f(y) = V/(1 + H/K1es + K2es/H)'
         Z(4) =
     +   'g(y) = K(1 + H/K1e + K2e/H)/(1 + H/K1es + K2es/H)'
      ELSE
         NMOD = - 1
      ENDIF
  100 FORMAT (
     + 'Reversible Michaelis-Menten: Vs,Vp,Ks,Kp,S & P'
     +/'Competitive inhibition (slope effect: one Ki)'
     +/'Uncompetitive inhibition (intercept effect: one Ki)'
     +/'Noncompetitive inhibition (slope/intercept: same Ki)'
     +/'Mixed inhibition (slope/intercept: two Ki values)'
     +/'Ping Pong Bi Bi (no denominator term)'
     +/'Ordered Bi Bi (with denominator term)'
     +/'Time-dependent inhibition (Kitz and Wilson)'
     +/'Inhibition by competing substrate'
     +/'Michaelis-Menten: pH dependendent Vmax and Km'
     +/'Cancel')
      END
C
C
      SUBROUTINE QNS210 (NFIX, NPAR, Z, CONST)
C      ... Biological
      IMPLICIT   NONE
      INTEGER    NFIX, NPAR
      CHARACTER  Z(24)*80
      LOGICAL    CONST
      EXTERNAL   PUTADV, ADDCON
      CALL PUTADV ('The only current model is logistic growth')
      NPAR = 5
      Z(1) = 'Logistic growth with two variables'
      Z(2) = 'g(x,y) = p(2) + p(3)x + p(4)y + p(5)xy'
      Z(3) = 'f(x,Y) = p(1)/{1 + exp[-g(x,y)]} + p(6)'
      CALL ADDCON (NFIX, NPAR, CONST)
      END
C
C
      SUBROUTINE QNS213 (NPAR, Z)
C      ... Physical
      IMPLICIT   NONE
      INTEGER    NPAR
      CHARACTER  Z(24)*80
      EXTERNAL   PUTADV
      CALL PUTADV ('The only current model is diffusion in a tube')
         NPAR = 2
         Z(1) = 'f(x,y) = p(1)*erfc{0.5*x/sqrt[p(2)*y]}'
         Z(2) =
     +   'f(x) = concentration: x = distance from interface at time y'
         Z(3) =
     +   'Note that p(1) = f(0,y) and p(2) = D, the diffusion constant'
         Z(4) =
     +   'Also x >= 0, y >= 0, p(1) > 0 and p(2) > 0'
      END
C
C
C
C
      SUBROUTINE QNS214 (NFIX, NMOD, NPAR, Z, CONST)
C      ... Statistical
      IMPLICIT   NONE
      INTEGER    NFIX, NMOD, NPAR
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(20), NUMPOS(20)
      CHARACTER  Z(24)*80
      CHARACTER  TEXT(30)*100
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    CONST
      EXTERNAL   ADDCON, LBOX01
      DATA NUMBLD / 20*0 /
      DATA NUMPOS / 20*1 /
      WRITE (TEXT,100)
      NSTART = 1
      NUMOPT = 3
      NTEXT = 3
      NUMDEC = NUMOPT
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, TEXT, BORDER, FLASH, HIGH)
      NMOD = NUMDEC
      IF (NMOD.EQ.1) THEN
         NPAR = 6
         Z(1) =
     +   'f(x,y) = p(6)*N2(x,y) + p(7), N2(x,y) = bivariate normal pdf'
         Z(2) =
     +   'p(1) = mu_x, p(2) = sigma_x (> 0)'
         Z(3) =
     +   'p(3) = mu_y, p(4) = sigma_y (> 0), p(5) = rho (-1 < rho < 1)'
         Z(4) =
     +   'p(6) = arbitrary scaling factor, p(7) = arbitrary constant'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.2) THEN
         NPAR = 3
         Z(1) = 'Logit model in exponential format'
         Z(3) = '1/{1 + exp[-(p(1) + p(2)x + p(3)y)]}'
         Z(4) = 'Note: 0 =< f(x,y) =< 1'
      ELSEIF (NMOD.EQ.3) THEN
         NPAR = 3
         Z(1) = 'Probit model in cdf format'
         Z(3) = 'Phi[p(1) + p(2)x + p(3)y)] where Phi(.) = normal cdf'
         Z(4) = 'Note: 0 =< f(x,y) =< 1'
      ENDIF
  100 FORMAT (
     + 'Bivariate normal pdf (scaled plus constant)'
     +/'Logit (0 =< f(x,y) =< 1 parameterization)'
     +/'Probit (0 =< f(x,y) =< 1 parameterization)')
      END
C
C
