C
C QNSUB3 : Subroutines for functions of three variables for MAKDAT, QNFIT etc.
C To be consistent this version must have MODNAM dimensioned MODNAM(24)*80
C This version dimensions using KMAX_A, KMAX_F, KMAX_J and KMAX_Y
C ACTION : Define MODEL, NFIX, NMOD, NPAR, B, MODNAM, CONST
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          29/12/1994 Added user supplied functions
C          14/03/1995 (Added NEQN, YDE, YJA)
C          02/09/2000 extensive revision
C          14/10/2001 dimensioned MODNAM(24)*80
C          03/06/2005 added logistic growth
C          04/01/2010 added E04FYF
C          22/11/2022 added TITLE_CHECKER
C
      SUBROUTINE QNSUB3 (MODEL, NFIX, NMOD, NPAR, NX,
     +                   B,
     +                   MODNAM,
     +                   CONST)
      IMPLICIT   NONE
      INTEGER    MODEL, NFIX, NMOD, NPAR, NX
      INTEGER    I, NTITLE_SAV
      INTEGER    ISEND, JSEND, NEQN, NVAR
      PARAMETER (ISEND = 1, JSEND = 2, NEQN = 1, NVAR = 3)
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      PARAMETER (KMAX_F = NEQN, KMAX_J = NEQN**2, KMAX_Y = NEQN)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 18)
      INTEGER    NUMBLD(20), NUMPOS(20)
      INTEGER    NUMCOL, NUMROW
      PARAMETER (NUMCOL = 0, NUMROW = 0)
      INTEGER    NEQN_TEMP, NVAR_TEMP
      DOUBLE PRECISION B(NX)
      DOUBLE PRECISION F(NEQN), X, Y, YDE(NEQN), YJA(NEQN**2), Z
      CHARACTER (LEN = 80) MODNAM(24), TITLE_SAV(24)
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      CHARACTER  LINE*100, TEXT(30)*100
      LOGICAL    CONST
      LOGICAL    YES
      LOGICAL    ABORT, DEQN, DEQN_TEMP
      PARAMETER (DEQN = .FALSE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   PUTFAT
      EXTERNAL   QNS301, QNS303, QNS310, QNS314, QNS315
      EXTERNAL   QNUSER
      EXTERNAL   LBOX01, YESNO1
      EXTERNAL   TITLE_CHECKER
      DATA NUMBLD / 20*0 /
      DATA NUMPOS / 20*1 /
C
C Initialise MODNAM then get MODEL
C
   20 CONTINUE
      DO I = 1, 4
         MODNAM(I) = BLANK
      ENDDO
      WRITE (TEXT,100)
      NSTART = 3
      NTEXT = 20
      NUMDEC = NUMOPT
      NUMBLD(1) = 1
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      MODEL = NUMDEC
C
C Set NFIX = 0, NMOD = 1 and CONST = .FALSE.
C
      NFIX = 0
      NMOD = 1
      CONST = .FALSE.
C
C Get details about the models
C
      IF (MODEL.EQ.1) THEN
         CALL QNS301 (NFIX, NMOD, NPAR, MODNAM, CONST)
      ELSEIF (MODEL.EQ.3) THEN
         CALL QNS303 (NMOD, NPAR, NX, B, MODNAM)
      ELSEIF (MODEL.EQ.10) THEN
         CALL QNS310 (NFIX, NPAR, MODNAM, CONST)
      ELSEIF (MODEL.EQ.14) THEN
         CALL QNS314 (NMOD, NPAR, MODNAM)
      ELSEIF (MODEL.EQ.15) THEN
         CALL QNS315 (NPAR, MODNAM)    
      ELSEIF (MODEL.EQ.17) THEN
         KMAX_A = NX
         NEQN_TEMP = NEQN
         NVAR_TEMP = NVAR
         DEQN_TEMP = DEQN
         CALL QNUSER (ISEND,
     +                KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                NEQN_TEMP, NPAR, NVAR_TEMP, NX,
     +                B, F, X, Y, YDE, YJA,
     +                Z, MODNAM, ABORT, DEQN_TEMP)
         IF (ABORT) GOTO 20
         IF (NEQN_TEMP.NE.NEQN .OR. NVAR_TEMP.NE.NVAR .OR.
     +       DEQN_TEMP) THEN
            ABORT = .TRUE.
            CALL PUTFAT (
     +'Model file must define one function of three variables')  
            GOTO 20     
         ENDIF 
      ELSEIF (MODEL.EQ.NUMOPT) THEN
         MODEL = - 1
         RETURN
      ELSE
         CALL PUTFAT ('Not available in this version')
         GOTO 20
      ENDIF
C
C If no model has been selected then NMOD = - 1
C
      IF (NMOD.LT.1) GOTO 20
      IF (NPAR.GT.NX) THEN
         CALL PUTFAT ('Model requested has too many parameters')
         GOTO 20
      ENDIF
      NTEXT = 6
      IF (MODEL.EQ.17) THEN
         CALL TITLE_CHECKER(JSEND, NTITLE_SAV,
     +                      TITLE_SAV)         
         DO I = 1, MIN(4,NTITLE_SAV)
           MODNAM(I) = TITLE_SAV(I)
         ENDDO
      ENDIF     
      WRITE (TEXT,200) MODNAM(1), MODNAM(2), MODNAM(3), MODNAM(4)
      NTEXT = NTEXT + 1
      TEXT(NTEXT) = BLANK
      WRITE (LINE,300) NPAR
      NTEXT = NTEXT + 1
      TEXT(NTEXT) = LINE
      IF (CONST) THEN
         WRITE (LINE,400)
      ELSE
         IF (NFIX.EQ.1) THEN
            WRITE (LINE,500)
         ELSE
            LINE = BLANK
         ENDIF
      ENDIF
      NTEXT = NTEXT + 1
      TEXT(NTEXT) = LINE
      NTEXT = NTEXT + 1
      TEXT(NTEXT) = BLANK
      WRITE (LINE,600)
      YES = .FALSE.
      CALL YESNO1 (ICOLOR, IXL, IYL, LSHADE, NUMCOL, NUMROW, NTEXT,
     +             LINE, TEXT, BORDER, FLASH, HIGH, YES)
      IF (.NOT.YES) GOTO 20
  100 FORMAT ('LIBRARY : Functions of 3 variables (Version 2.0)'/
     +/'Polynomials'
     +/'... (NA)'
     +/'Enzyme kinetics'
     +/'... (NA)'
     +/'... (NA)'
     +/'... (NA)'
     +/'... (NA)'
     +/'... (NA)'
     +/'... (NA)'
     +/'Biological'
     +/'Biochemical (NA)'
     +/'Chemical (NA)'
     +/'Physical (NA)'
     +/'Statistical'
     +/'Empirical'
     +/'Mathematical (NA)'
     +/'User-supplied-model from an ASCII text file'
     +/'Cancel')
  200 FORMAT ('Model selected'//A/A/A/A)
  300 FORMAT ('Number of parameters =',I3)
  400 FORMAT ('Constant included')
  500 FORMAT ('Constant set to 0')
  600 FORMAT ('Is this the correct model ?')
      END
C
C
      SUBROUTINE QNS301 (NFIX, NMOD, NPAR, Z, CONST)
C      ... Polynomials
      IMPLICIT   NONE
      INTEGER    NFIX, NMOD, NPAR
      INTEGER    N0, N1
      PARAMETER (N0 = 0, N1 = 1)
      CHARACTER  Z(24)*80
      LOGICAL    CONST
      EXTERNAL   GETJM1, ADDCON
      NMOD = 1
      CALL GETJM1 (N0, NMOD, N1,
     +'Degree required for polynomial (i.e. 1, or n = 0 for no model)')
      IF (NMOD.EQ.1) THEN
         Z(1) = 'Degree 1 polynomial: C = p(4)'
         Z(3) = 'p(1)x + p(2)y + p(3)z + C'
         NPAR = 3
C*****ELSEIF (NMOD.EQ.2) THEN
C********CALL PUTFAT ('Not available ... Upgrade your DLL')
C********GOTO 20
C********Z(1) = 'Degree 2 polynomial: C = p(6)'
C********Z(3) = 'p(1)x + p(2)y + p(3)x^2 + p(4)xy + p(5)y^2 + C'
C********NPAR = 5
C*****ELSEIF (NMOD.EQ.3) THEN
C********CALL PUTFAT ('Not available ... Upgrade your DLL')
C********GOTO 20
C********Z(1) = 'Degree 3 polynomial: C = p(10)'
C********Z(3) = 'p(1)x + p(2)y + p(3)x^2 + p(4)xy + p(5)y^2 +'
C********Z(4) = 'p(6)x^3 + p(7)x^2y + p(8)xy^2 + p(9)y^3 + C'
C********NPAR = 9
      ELSE
         NMOD = - 1
         RETURN
      ENDIF
      CALL ADDCON (NFIX, NPAR, CONST)
      END
C
C
      SUBROUTINE QNS303 (NMOD, NPAR, NX, B, Z)
C      ... Enzyme kinetics
      IMPLICIT   NONE
      INTEGER    NMOD, NPAR, NX
      INTEGER    NTEMP
      INTEGER    N1, N2, N20
      PARAMETER (N1 = 1, N2 = 2, N20 = 20)
      DOUBLE PRECISION B(NX)
      CHARACTER  Z(24)*80
      CHARACTER  LABEL*2
      INTRINSIC  DBLE
      EXTERNAL   GETJM1, PUTADV
      CALL PUTADV ('The only current model is MWC activator/inhibitor')
      NMOD = N1
      IF (NMOD.EQ.1) THEN
         NTEMP = N2
         CALL GETJM1 (N2, NTEMP, N20,
     +'Degree (no. sites) required for MWC activator/inhibitor model')
         WRITE (LABEL,'(I2)') NTEMP
         B(1) = DBLE(NTEMP)
         Z(1) =
     +'MWC activator/inhibitor (p(1)=Ks,p(2)=Ki,p(3)=Ka,p(4)=V,p(5)=L)'
         Z(2) =
     +'x=[S],y=[I],z=[A],a=Ks[S],b=Ki[I],c=Ka[A],h(x,y,z)=f(x)/g(h,y,z)'
         Z(3) =
     +'f(x) = V*n*a*(1 + a)^{n-1}, n = '//LABEL
         Z(4) =
     +'g(x,y,z) = (1 + a)^n + L*[(1 + b)/(1 + c)]^n'
         NPAR = 5
      ELSE
         NMOD = - 1
         RETURN
      ENDIF
      END
C
C
      SUBROUTINE QNS310 (NFIX, NPAR, Z, CONST)
C     ... Biological
C
      IMPLICIT  NONE
      INTEGER   NFIX, NPAR
      CHARACTER Z(24)*80
      LOGICAL   CONST
      EXTERNAL  ADDCON, PUTADV
      CALL PUTADV ('The only current model is logistic growth')
      NPAR = 9
      Z(1) = 'The logistic growth model with three variables'
      Z(2) = 'g(x,y,z) = p(2) + p(3)x + p(4)y + p(5)z + p(6)xy'
      Z(3) = '                + p(7)xz + p(8)yz + p(9)xyz'
      Z(4) = 'f(x,y,z) = p(1)/{1 + exp[-g(x,y,z)]} + p(10)'
      CALL ADDCON (NFIX, NPAR, CONST)
      END
C
      SUBROUTINE QNS314 (NMOD, NPAR, Z)
C      ... Statistical
      IMPLICIT   NONE
      INTEGER    NMOD, NPAR
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(20), NUMPOS(20)
      CHARACTER  Z(24)*80
      CHARACTER  TEXT(30)*100
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01
      DATA NUMBLD / 20*0 /
      DATA NUMPOS / 20*1 /
      NMOD = 1
      NSTART = 1
      NTEXT = 2
      NUMOPT = 2
      WRITE (TEXT,100)
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NMOD, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (NMOD.EQ.1) THEN
         NPAR = 4
         Z(1) = 'Logit model in exponential format'
         Z(3) = '1/{1 + exp[-{p(1) + p(2)x + p(3)y + p(4)z}]}'
         Z(4) = 'Note: 0 =< f(x,y,z) =< 1'
      ELSEIF (NMOD.EQ.2) THEN
         NPAR = 4
         Z(1) = 'Probit model in cdf format'
         Z(3) =
     + 'Phi[p(1) + p(2)x + p(3)y + p(4)z] where Phi(.) = Normal cdf'
         Z(4) = 'Note: 0 =< f(x,y,z) =< 1'
      ENDIF
  100 FORMAT (
     + 'Logit (0 =< f(x,y,z) =< 1 parameterization)'
     +/'Probit (0 =< f(x,y,z) =< 1 parameterization)')
      END
C
C
      SUBROUTINE QNS315 (NPAR, Z)
C     ... Empirical
C
      IMPLICIT  NONE
      INTEGER   NPAR
      CHARACTER Z(24)*80
      EXTERNAL  PUTADV
      CALL PUTADV ('The only current model is the NAG E04FYF-model')
      NPAR = 3
      Z(1) = 'Example model for NAG E04FYF'
      Z(2) = ' '
      Z(3) = 'f(x,y,z) = p(1) + x/[p(2)y + p(3)z]'
      Z(4) = ' '
      END      
C
C
