C
C
C QNSUBD : Differential equations for MAKDAT, QNFIT etc.
C To be consistent this version must have MODNAM dimensioned MODNAM(24)*80
C This version dimensions using KMAX_A, KMAX_F, KMAX_J and KMAX_Y
C ACTION : Define MODEL, NFIX, NMOD, NPAR, B, MODNAM, CONST
C          ********************************************************
C          This subroutine works in conjunction with:
C          QMODEL, QMODEX, YDERIV and PEDERV
C WARNING: The integration constant YZERO must be defined as the final
C          parameter
C          ********************************************************
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          29/12/1994 Added user supplied function
C          09/10/1997 win32 version
C          14/10/2001 dimensioned MODNAM(24)*80
C          04/01/2010 added modified allometric model
C          22/12/2022 added TITLE_CHECKER
C
      SUBROUTINE QNSUBD (MODEL, NFIX, NMOD, NPAR, NX, 
     +                   B,
     +                   MODNAM,
     +                   CONST)
      IMPLICIT   NONE
      INTEGER    MODEL, NFIX, NMOD, NPAR, NX
      INTEGER    I,NTITLE_SAV
      INTEGER    ISEND, JSEND, NEQN, NVAR
      PARAMETER (ISEND = 1, JSEND = 2, NEQN = 1, NVAR = 1)
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      PARAMETER (KMAX_F = NEQN, KMAX_J = NEQN**2, KMAX_Y = NEQN)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 13)
      INTEGER    JCOLOR
      PARAMETER (JCOLOR = 9)
      INTEGER    NUMBLD(20), NUMPOS(20)
      INTEGER    NUMCOL, NUMROW
      PARAMETER (NUMCOL = 0, NUMROW = 0)
      INTEGER    NEQN_TEMP, NVAR_TEMP
      DOUBLE PRECISION B(NX)
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      DOUBLE PRECISION F(NEQN), X, Y, YDE(NEQN), YJA(NEQN**2), Z
      CHARACTER (LEN = 80) MODNAM(24), TITLE_SAV(24)
      CHARACTER  BLANK
      PARAMETER (BLANK = ' ')
      CHARACTER  LINE*100, TEXT(30)*100
      LOGICAL    CONST
      LOGICAL    YES
      LOGICAL    ABORT, DEQN_TEMP
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   PUTFAT
      EXTERNAL   QNDE01, QNDE02
      EXTERNAL   QNUSER
      EXTERNAL   LBOX01, YESNO1
      EXTERNAL   TITLE_CHECKER
      DATA NUMBLD / 20*0 /
      DATA NUMPOS / 20*1 /
C
C Initialise MODNAM and B then request a model to set parameter MODEL
C
   20 CONTINUE
      DO I = 1, 4
         MODNAM(I) = BLANK
      ENDDO
      DO I = 1, NX
         B(I) = ONE
      ENDDO
      WRITE (TEXT,100)
      NSTART = 8
      NTEXT = NSTART + NUMOPT - 1
      NUMDEC = NUMOPT
      NUMBLD(1) = 1
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (NUMDEC.EQ.12) THEN
         MODEL = 17
      ELSE
         MODEL = NUMDEC
      ENDIF
C
C Blank the screen then initialise NFIX = 0, NMOD = 1 and CONST = .FALSE.
C
      NFIX = 0
      NMOD = 1
      CONST = .FALSE.
C
C Now call the differential equation routines for details
C
      IF (MODEL.EQ.1) THEN
         CALL QNDE01 (NFIX, NMOD, NPAR, NX, B, MODNAM, CONST)
      ELSEIF (MODEL.EQ.2) THEN
         CALL QNDE02 (NFIX, NMOD, NPAR, NX, B, MODNAM, CONST)
      ELSEIF (MODEL.EQ.17) THEN
         KMAX_A = NX
         NEQN_TEMP = NEQN
         NVAR_TEMP = NVAR
         DEQN_TEMP = .TRUE.
         CALL QNUSER (ISEND,
     +                KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                NEQN_TEMP, NPAR, NVAR_TEMP, NX, 
     +                B, F, X, Y, YDE, YJA,
     +                Z, MODNAM, ABORT, DEQN_TEMP)
         IF (ABORT) GOTO 20
         IF (NVAR_TEMP.EQ.0) NVAR_TEMP = 1  
         IF (NEQN_TEMP.NE.NEQN .OR. NVAR_TEMP.NE.NVAR .OR.
     +       .NOT.DEQN_TEMP) THEN
            ABORT = .TRUE.
            CALL PUTFAT (
     +     'Model file must define a single differential equation')
            GOTO 20 
         ENDIF             
      ELSE
C
C Further routines here as required or quit etc.
C
         IF (MODEL.EQ.NUMOPT) THEN
            MODEL = - 1
            RETURN
         ELSE
            CALL PUTFAT ('Not available in this version')
            GOTO 20
         ENDIF
      ENDIF
C
C If no model has been selected then NMOD = - 1
C
      IF (NMOD.LT.0) GOTO 20
C
C Check the number of parameters requested then check if model is OK
C
      IF (NPAR.GT.NX) THEN
         CALL PUTFAT ('Model requested has too many parameters')
         GOTO 20
      ENDIF
      NTEXT = 6
      IF (MODEL.EQ.17) THEN
         CALL TITLE_CHECKER (JSEND, NTITLE_SAV,
     +                       TITLE_SAV)
          DO I = 1, MIN(4,NTITLE_SAV)
             MODNAM(I) = TITLE_SAV(I)
          ENDDO
      ENDIF       
      WRITE (TEXT,200) MODNAM(1), MODNAM(2), MODNAM(3), MODNAM(4)
      NTEXT = NTEXT + 1
      TEXT(NTEXT) = BLANK
      WRITE (LINE,300) NPAR
      NTEXT = NTEXT + 1
      TEXT(NTEXT) = LINE
      NTEXT = NTEXT + 1
      TEXT(NTEXT) = BLANK
      WRITE (LINE,400)
      YES = .FALSE.
      CALL YESNO1 (JCOLOR, IXL, IYL, LSHADE, NUMCOL, NUMROW, NTEXT,
     +             LINE, TEXT,
     +             BORDER, FLASH, HIGH, YES)
      IF (.NOT.YES) GOTO 20
  100 FORMAT ('Library: Differential equations (Version 2.0)'
     +/
     +/'Warning: Differential equations are integrated from x = 0 and'
     +/'all f(x) will be set = f(0) if ANY x is < 0. Fitting may be'
     +/'slow if the BDF method is used (to allow for stiff systems).'
     +/'Use DEQSOL for fitting systems of differential eqns.'
     +/
     +/'Transport/Progress curves'
     +/'Growth/Survival curves'
     +/'... (NA)'
     +/'... (NA)'
     +/'Biological (NA)'
     +/'Biochemical (NA)'
     +/'Chemical (NA)'
     +/'Physical (NA)'
     +/'Statistical (NA)'
     +/'Empirical (NA)'
     +/'Mathematical (NA)'
     +/'User-supplied-model from an ASCII text file'
     +/'Cancel')
  200 FORMAT ('Model selected'//A/A/A/A)
  300 FORMAT ('Number of parameters =',I3)
  400 FORMAT ('Is this the correct model ?')
      END
C
C
      SUBROUTINE QNDE01 (NFIX, NMOD, NPAR, NX, B, Z, CONST)
C      ... Transport/Progress curves
      IMPLICIT   NONE
      INTEGER    NFIX, NMOD, NPAR, NX
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(20), NUMPOS(20)
      DOUBLE PRECISION B(NX)
      CHARACTER  Z(24)*80
      CHARACTER  TEXT(30)*100
      LOGICAL    CONST
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      INTRINSIC  NINT
      EXTERNAL   LBOX01
      DATA NUMBLD / 20*0 /
      DATA NUMPOS / 20*1 /
      IF (CONST) THEN!to silence ftn95
         NSTART = NFIX
         NSTART = NINT(B(1))
      ENDIF
      WRITE (TEXT,100)
      NSTART = 11
      NUMOPT = 6
      NTEXT = NSTART + NUMOPT - 1
      NUMDEC = NUMOPT
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      NMOD = NUMDEC
      IF (NMOD.EQ.1) THEN
         Z(1) =
     +'Michaelis Menten irreversible S depletion curve: y = S and x = t'
         Z(2) =
     +'dy/dx = -p(2)y/[p(1) + y] (y(0) = p(3) and product = 0 at t = 0)'
         Z(3) =
     +'p(1)=Km, p(2)=Vmax and p(3)=S(0) (the integration constant)'
         Z(4) =
     +'Recommended technique: BDF method using an explicit Jacobian'
         NPAR = 3
      ELSEIF (NMOD.EQ.2) THEN
         Z(1) =
     +'Michaelis Menten irreversible P accumulation curve:y = P & x = t'
         Z(2) =
     +'dy/dx = p(2)(p(3)-y)/[p(1) + (p(3)-y)](S(0)=p(3) and P=0 at t=0)'
         Z(3) =
     +'p(1)=Km, p(2)=Vmax and p(3)=S(0) (the integration constant)'
         Z(4) =
     +'Recommended technique: BDF method using an explicit Jacobian'
         NPAR = 3
      ELSEIF (NMOD.EQ.3) THEN
         Z(1) =
     +'Generalised irreversible Substrate depeletion curve: y=S and x=t'
         Z(2) =
     +'dy/dx = -p(2)y/[p(1) + y] - p(3)y - p(4) (product=0 at t=0)'
         Z(3) =
     +'p(1)=Km, p(2)=Vmax and p(5)=S(0) (the integration constant)'
         Z(4) =
     +'Recommended technique: BDF method using an explicit Jacobian'
         NPAR = 5
      ELSEIF (NMOD.EQ.4) THEN
         Z(1) =
     +'Generalised irreversible Product accumulation curve: y=P and x=t'
         Z(2) =
     +'dy/dx = p(2)z/[p(1) + z]+ p(3)z + p(4) (z=p(5)-y and P=0 at t=0)'
         Z(3) =
     +'p(1)=Km, p(2)=Vmax and p(5)=S(0) (the integration constant)'
         Z(4) =
     +'Recommended technique: BDF method using an explicit Jacobian'
         NPAR = 5
      ELSEIF (NMOD.EQ.5) THEN
         Z(1) =
     +'Comprehensive transport to equilibrium (allowing volume changes)'
         Z(2) =
     +'dy/dx = p(3)[y - p(4)]/[y^2 + p(1)y + p(2)], p(4)=y_equilibrium'
         Z(3) =
     +'p(5) = y(0) Note: p(4) and p(5) can be estimated or fixed'
         Z(4) =
     +'Recommended technique: BDF method using an explicit Jacobian'
         NPAR = 5
      ELSE
         NMOD = - 1
      ENDIF
  100 FORMAT (
     + 'Advice`1. is Michaelis-Menten substrate depletion'
     +/'      `2. is Michaelis-Menten product accumulation'
     +/'      `3. adds extra terms for substrate depletion'
     +/'      `4. adds extra terms for product accumulation'
     +/'      `5. accomodates solute induced volume changes'
     +/'Integration constants can either be fixed or estimated.'
     +/'You can also use the integrated forms for 1 and 2 in the'
     +/'library of functions of 1 variable (biochemical models)'
     +/'where the equations are solved numerically.'
     +/
     +/'1. dy/dx = -V*y/[K + y], y(0) estimated'
     +/'2. dy/dx =  V*z/[K + z], z = S(0) - y, S(0) estimated'
     +/'3. dy/dx = -V*y/[K + y] - Ay - B, y(0) estimated'
     +/'4. dy/dx =  V*z/[K + z] + Az + B, z = S(0) - y, S(0) estimated'
     +/'5. dy/dx = C[y - D]/[y^2 + A*y + B], D and y(0) estimated'
     +/'Cancel')
      END
C
C
      SUBROUTINE QNDE02 (NFIX, NMOD, NPAR, NX,
     +                   B,
     +                   Z,
     +                   CONST)
C      ... Growth/Survival curves
      IMPLICIT   NONE
      INTEGER    NFIX, NMOD, NPAR, NX
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(20), NUMPOS(20)
      DOUBLE PRECISION B(NX)
      CHARACTER  Z(24)*80
      CHARACTER  TEXT(30)*100
      LOGICAL    CONST
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      INTRINSIC  NINT
      EXTERNAL   LBOX01
      DATA NUMBLD / 20*0 /
      DATA NUMPOS / 20*1 /
      IF (CONST) THEN!to silence ftn95
         NSTART = NFIX
         NSTART = NINT(B(1))
      ENDIF
      WRITE (TEXT,100)
      NSTART = 9
      NUMOPT = 3
      NTEXT = NSTART + NUMOPT - 1
      NUMDEC = NUMOPT
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      NMOD = NUMDEC
      IF (NMOD.EQ.1) THEN
         Z(1) =
     +'The von Bertalanffy generalised power law: y=Size etc. and x=t'
         Z(2) =
     +'dy/dx = p(1)y^p(2) - p(3)y^p(4) (all p(i) > 0 and p(4) > p(2)))'
         Z(3) =
     +'You must have p(5) = y(0) > 0 (the estimated initial size)'
         Z(4) =
     +'Recommended technique: BDF method using an explicit Jacobian'
         NPAR = 5
      ELSEIF (NMOD.EQ.2) THEN
         Z(1) =
     +'Modified von Bertalanffy allometric model: y=Size etc. and x=t'
         Z(2) =
     +'dy/dx = exp[-p(5)*x]p(1)y^p(2) - p(3)y^p(4), p(i)>0, p(4)>p(2))'
         Z(3) =
     +'You must have p(6) = y(0) > 0 (the estimated initial size)'
         Z(4) =
     +'Recommended technique: BDF method using an explicit Jacobian'
         NPAR = 6         
      ELSE
         NMOD = - 1
      ENDIF
  100 FORMAT (
     + 'The first equation is the von Bertalanffy power law'
     +/'which must have A, B, m and n positive and n > m, and'
     +/'parameters must be chosen so that y > 0. In particular'
     +/'the initial condition MUST satisfy y(0) = p(5) > 0.'
     +/'The second has the anabolic term modified to allow for'
     +/'growth followed by decay. It may be necessary to fix m'
     +/'and n as these equations are rather over-parameterised.'
     +/
     +/'dy/dx = A*y^m - B*y^n, where y(x) > 0'
     +/'dy/dx = exp[-kx]A*y^m - B*y^n, where y(x) > 0'
     +/'Cancel')
      END
C
C
