C
C =====================================================================
C QNUSER ... the main routine for a user-defined model
C =====================================================================
C
C QNUSER
C QNFILE
C DEUSE
C JACUSE
C
C To be consistent this version must have MODNAM dimensioned MODNAM(24)*80
C This version dimensions using KMAX_A, KMAX_F, KMAX_J and KMAX_Y
C
C This is the win32 version of the following DBOS files:
C MAKDAT7.INS = QNFIT7.INS = DEQSOL5.INS = QNUSER.FOR
C
C This version uses full word length and is only suitable for use in
C defining a single equation as in MAKDAT, QNFIT or a set of simple
C equations with no Jacobian as in USERMOD
C
C The dimensions must be consistent with USER01, USER02, USER03,
C USER04, etc.
C
C =====================================================================
C
C In this version the COMMON blocks are removed and, to save on DLL
C storage space, the following word lengths must be preserved for the
C variables that have to be saved statically between calls to QNUSER:-
C
C INTEGER   INDEX_1, INDEX_2, NUMBER_1, NUMBER_2
C DOUBLE PRECISION DATA_1, DATA_2
C
C This version is only sufficient for about 100 simple equations and would
C have to be increased in dimensions and word length for large equation sets.
C
C This version also differs in that DATA_1 and DATA_2 are only filled up
C and used as required for each model step that actually requires a constant.
C Note the use of IADD1 to do this in the USER0? routines.
C
C
      SUBROUTINE QNUSER (ISEND,
     +                   KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                   NEQN, NPAR, NVAR, NX,
     +                   A, F, X, Y, YDE, YJA, Z,
     +                   MODNAM,
     +                   ABORT, DEQN)
C
C ACTION : User defined model
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 29/12/94
C          14/10/1997 restored integer*1 and real*4 to full word length
C          01/03/1999 changed YDE dimension to YDE(*) to allow functions of
C                     many variables to be used as f = f(yde(1), yde(2), ..., yde(m))
C          16/12/1999 made all dimensions (*) since neqn can be read off
C                     file as well as NPAR
C          14/10/2001 Dimensioned MODNAM(N24)*(N80) and intialised to
C                     BLANK if ISEND = 1 and introduced KMAX_A, KMAX_F,
C                     KMAX_J and KMAX_Y
C          18/10/2001 added ISEND = 4, ISEND = 5 and QNFILE
C          04/09/2009 minor editing
C          02/04/2016 removed call to QNFILE
C
C          ISEND = 1: Read in and parse the model
C          ISEND = 2: Evaluate the model
C          ISEND = 3: Evaluate the Jacobian
C          ISEND = 4: Evaluate the model when called from program USERMOD
C          ISEND = 5: Evaluate the jacobian whem called from program USERMOD
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER ISEND,
     +        KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +        NEQN, NPAR, NVAR, NX
      DOUBLE PRECISION A(KMAX_A), F(KMAX_F), X, Y, YDE(KMAX_Y),
     +                 YJA(KMAX_J), Z
      CHARACTER (LEN = 80) :: MODNAM(24)
      LOGICAL ABORT, DEQN
C
C Locals
C
      INTEGER    NIN, N1, N10, N24
      PARAMETER (NIN = 11, N1 = 1, N10 = 10, N24 = 24)
      INTEGER    I, NEQSAV
C
C Data for user defined model
C
C NXX controls maximum length of stack
C NXX**2 = length of USED (check all parameters/eqns./Jacobians defined)
C NSTACK_1 = length of equation stack
C NSTACK_2 = length of Jacobian stack
C Since this will only be called for 1 DEQ we can set NSTACK_2 = NSTACK_1
C and dimension STACK(NSTACK_1) since NSTACK will alwys be =< NSTACK_1
C
      INTEGER    NSTACK_1, NSTACK_2, NXX
      PARAMETER (NXX = 100, NSTACK_1 = 100*NXX, NSTACK_2 = NSTACK_1)
      INTEGER    NLINES_1, NLINES_2
      INTEGER    INDEX_1(NSTACK_1), INDEX_2(NSTACK_2),
     +           NUMBER_1(NSTACK_1), NUMBER_2(NSTACK_2)
      DOUBLE PRECISION DATA_1(NSTACK_1/N10), DATA_2(NSTACK_2/N10)
      DOUBLE PRECISION STACK(NSTACK_1)
      CHARACTER (LEN = 1024) FNAME
      CHARACTER (LEN = 1   ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    USED(NSTACK_1)
      LOGICAL    DEQSAV
      LOGICAL    STORE
      PARAMETER (STORE = .TRUE.)
C
C Externals and SAVED variables
C
      EXTERNAL   PUTFAT
      EXTERNAL   USER_FILE, USER_MODEL, USER_MODEL_1
      EXTERNAL   MODEL_PARAMETERS
      SAVE       INDEX_1, INDEX_2, NUMBER_1, NUMBER_2
      SAVE       NLINES_1, NLINES_2
      SAVE       DATA_1, DATA_2
      SAVE       DEQSAV, NEQSAV
C
C Initialise the program if ISEND = 1
C
      IF (ISEND.EQ.1) THEN
         IF (NX.GT.NXX) THEN
            CALL PUTFAT ('NX > NXX in QNUSER')
            ABORT = .TRUE.
            RETURN
         ENDIF
C
C Read in a model
C
         DO I = N1, N24
            MODNAM(I) = BLANK
         ENDDO
         NEQSAV = NEQN
         DEQSAV = DEQN
         CALL USER_FILE (INDEX_1, INDEX_2, NEQSAV, NIN, NLINES_1,
     +                   NLINES_2, NPAR, NSTACK_1, NSTACK_2, NUMBER_1,
     +                   NUMBER_2, NVAR, NXX,
     +                   DATA_1, DATA_2,
     +                   FNAME, MODNAM,
     +                   ABORT, DEQSAV, USED)
         NEQN = NEQSAV
c         DEQN = DEQSAV
         CALL MODEL_PARAMETERS (NEQN, NPAR, NVAR,
     +                          DEQN, STORE)         
      ELSEIF (ISEND.EQ.2) THEN
C
C Evaluate the model if ISEND is equal to 2
C
         CALL USER_MODEL (INDEX_1,
     +                    KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                    NEQSAV, NLINES_1, NPAR, NSTACK_1, NUMBER_1,
     +                    NVAR,
     +                    A, DATA_1, F, STACK, X, Y, YDE, YJA, Z)
      ELSEIF (ISEND.EQ.3) THEN
C
C Evaluate the Jacobian if ISEND is equal to 3
C
         CALL USER_MODEL (INDEX_2,
     +                    KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                    NEQSAV, NLINES_2, NPAR, NSTACK_2, NUMBER_2,
     +                    NVAR,
     +                    A, DATA_2, F, STACK, X, Y, YDE, YJA, Z)
      ELSEIF (ISEND.EQ.4) THEN
C
C Evaluate the model with table of operations if ISEND is equal to 4
C
         CALL USER_MODEL_1 (INDEX_1,
     +                      KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                      NEQSAV, NLINES_1, NPAR, NSTACK_1, NUMBER_1,
     +                      NVAR,
     +                      A, DATA_1, F, STACK, X, Y, YDE, YJA, Z)
      ELSEIF (ISEND.EQ.5) THEN
C
C Evaluate the Jacobian with table of operations if ISEND is equal to 5
C
         CALL USER_MODEL_1 (INDEX_2,
     +                      KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                      NEQSAV, NLINES_2, NPAR, NSTACK_2, NUMBER_2,
     +                      NVAR,
     +                      A, DATA_2, F, STACK, X, Y, YDE, YJA, Z)
      ENDIF
      END
C
C
      SUBROUTINE QNFILE (FNAME,
     +                   STORE)
C
C ACTION: Save/Re-set the model filename from QNUSER
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 19/10/2001
C         04/09/2009 minor editing
C         02/04/2016 added INTENT and checked for BLANK or NO_FILE or file existence
C
      IMPLICIT NONE
C
C Arguments
C      
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME
      LOGICAL,             INTENT (IN)    :: STORE
C
C Locals
C      
      INTEGER    IOS
      CHARACTER (LEN = 1024) FSAVE
      CHARACTER (LEN = 7   ) NO_FILE
      CHARACTER (LEN = 1   ) BLANK
      PARAMETER (BLANK = ' ', NO_FILE = 'No File')
      LOGICAL    THERE
      SAVE       FSAVE
      DATA       FSAVE / NO_FILE /
      IF (STORE) THEN
         IF (FNAME.EQ.BLANK .OR. FNAME.EQ.NO_FILE) THEN
            FSAVE = NO_FILE
         ELSE   
            INQUIRE (FILE = FNAME, EXIST = THERE, IOSTAT = IOS)
            IF (IOS.EQ.0 .AND. THERE) FSAVE = FNAME
         ENDIF     
      ELSE
         INQUIRE (FILE = FSAVE, EXIST = THERE, IOSTAT = IOS)
         IF (IOS.EQ.0 .AND. .NOT.THERE) FSAVE = NO_FILE
         FNAME = FSAVE
      ENDIF
      END
C
C
      SUBROUTINE DEQUSE (NEQ, T, Y, F, P, IP)
C
C ACTION : The differential equations for user supplied model
C ADVICE : DVODE version
C          PW(1) since only 1 deqn. allowed in QNFIT
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER    IP(*), NEQ
      DOUBLE PRECISION F(NEQ), P(*), T, Y(NEQ)
C
C Locals
C      
      INTEGER    JSEND, NVAR
      PARAMETER (JSEND = 2, NVAR = 1)
      INTEGER    M, MODEL, NYMAX
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      DOUBLE PRECISION PW(1), TEMP1, TEMP2
      CHARACTER (LEN = 80) :: MODNAM(24)
      LOGICAL    ABORT, DEQN
      PARAMETER (DEQN = .TRUE.)
      EXTERNAL   QNUSER
      MODEL = IP(1)
C*****NMOD = IP(2)
      NYMAX = IP(3)
      M = IP(4)
      KMAX_A = M
      KMAX_F = NEQ
      KMAX_J = 1
      KMAX_Y = NEQ
      CALL QNUSER (JSEND,
     +             KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +             MODEL, M, NVAR, NYMAX,
     +             P, F, T, TEMP1, Y, PW, TEMP2,
     +             MODNAM,
     +             ABORT, DEQN)
      END
C
C
      OPTIONS (SILENT)
      SUBROUTINE JACUSE (NEQ, X, Y, ML, MU, PW, NROWPW, P, IP)
C
C ACTION : The Jacobian matrix for user supplied models
C ADVICE : DVODE version
C          F(1) since only 1 deqn. allowed in QNFIT
C          Silent option since ML and MU are not going to be used    
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER    IP(*), ML, MU, NEQ, NROWPW
      DOUBLE PRECISION P(*), PW(NROWPW,NEQ), X, Y(NEQ)
C
C Locals
C      
      INTEGER    JSEND, NVAR
      PARAMETER (JSEND = 3, NVAR = 1)
      INTEGER    M, MODEL, NYMAX
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      DOUBLE PRECISION F(1), TEMP1, TEMP2
      DOUBLE PRECISION YJA(1)
      CHARACTER (LEN = 80) :: MODNAM(24)
      LOGICAL    ABORT, DEQN
      PARAMETER (DEQN = .TRUE.)
      EXTERNAL   QNUSER
      MODEL = IP(1)
C*****NMOD = IP(2)
      NYMAX = IP(3)
      M = IP(4)
      KMAX_A = M
      KMAX_F = 1
      KMAX_J = 1
      KMAX_Y = 1
      CALL QNUSER (JSEND,
     +             KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +             MODEL, M, NVAR, NYMAX,
     +             P, F, X, TEMP1, Y, YJA, TEMP2,
     +             MODNAM,
     +             ABORT, DEQN)
      PW(1,1) = YJA(1)
      END
C
C
