C
C =====================================================================
C USER_SUBMOD4 ... the main routine for a user-defined sub model no. 4
C =====================================================================
C
C Editing required to extend the series from 1 to N:-
C
C USER_SUBMOD1...to...USER_SUBMODN
C   NUMMOD = 1...to...NUMMOD = N
C EVAL_SUBMOD1...to...EVAL_SUBMODN
C
C 04/12/2001 derived from QNUSER but note that FNAME = f$xmod0?.tmp is
C now an argument used to read in from a temporary file.
C It should never be called for NEQN > 1 or DEQN = .TRUE.
C
C
      SUBROUTINE USER_SUBMOD4 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                         F, X, Y, YDE, Z,
     +                         FNAME,
     +                         ABORT)
C
C ACTION : User defined submodel
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 04/12/2001
C          Date of this version 04/12/2001
C
C          ISEND = 0: initialise the sub-model
C          ISEND = 1: Read in and parse the model
C          ISEND = 2: Evaluate the sub-model
C
      IMPLICIT   NONE
C
C Argument list
C
      INTEGER    ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR
      DOUBLE PRECISION F(KMAX_F), X, Y, YDE(KMAX_Y), Z
      LOGICAL    ABORT
C
C Local variables
C
      INTEGER    NUMMOD
      PARAMETER (NUMMOD = 4)
      INTEGER    NIN, N10
      PARAMETER (NIN = 12, N10 = 10)
C
C Data for user defined model
C
C NXX controls maximum length of stack
C NXX**2 = length of USED (check all parameters/eqns. defined)
C NSTACK = length of equation stack
C
      INTEGER    NSTACK, NXX
      PARAMETER (NXX = 100, NSTACK = 100*NXX)
      INTEGER    NLINES
      INTEGER    INDEX1(NSTACK), NUMBER(NSTACK)
      DOUBLE PRECISION DATA1(NSTACK/N10)
      DOUBLE PRECISION STACK(NSTACK)
      CHARACTER  FNAME*(*)
      LOGICAL    READY, USED(NSTACK)
C
C Externals and SAVED variables
C
      EXTERNAL   PUTFAT
      EXTERNAL   SUBMOD_FILE, EVAL_SUBMOD4
      SAVE       INDEX1, NLINES, NUMBER
      SAVE       DATA1
      SAVE       READY
      DATA       READY / .FALSE. /
C
C Set READY = .FALSE. to initialise
C
      IF (ISEND.LT.1 .OR. ISEND.GT.2) THEN
         READY = .FALSE.
         RETURN
      ENDIF
C
C Initialise the program if ISEND = 1
C
      IF (ISEND.EQ.1) THEN
C
C Read in a model
C
         CALL SUBMOD_FILE (INDEX1, NEQN, NIN, NLINES,
     +                     NPAR, NSTACK, NUMBER, NUMMOD,
     +                     NVAR, NXX, DATA1,
     +                     FNAME, ABORT, USED)
         IF (ABORT) THEN
            CALL PUTFAT ('USER_SUBMOD4: cannot parse sub-model')
            READY = .FALSE.
         ELSE
            READY = .TRUE.
         ENDIF
      ELSEIF (ISEND.EQ.2) THEN
C
C Evaluate the model if ISEND is equal to 2
C
         IF (.NOT.READY) THEN
             CALL PUTFAT (
     +      'USER_SUBMOD4: sub-model has not been initialised')
             RETURN
         ENDIF
         CALL EVAL_SUBMOD4 (INDEX1, KMAX_F, KMAX_Y, NVAR,
     +                      NEQN, NLINES, NPAR, NSTACK, NUMBER,
     +                      DATA1, F, STACK, X, Y, YDE, Z)
      ENDIF
      END
C
C
      SUBROUTINE EVAL_SUBMOD4 (INDEX1, KMAX_F, KMAX_Y, NVAR,
     +                         NEQN, NLINES, NPAR, NSTACK, NUMBER,
     +                         DATA, F, STACK, X, Y, YDE, Z)
C
C ACTION : Evaluate user supplied sub-model parsed by SUBMOD_FILE
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          Date of this version 27/05/2003
C
      IMPLICIT   NONE
      INCLUDE   'global.ins'
      INTEGER    KMAX_F, KMAX_Y, NSTACK
      INTEGER    NEQN, NLINES, NPAR, NVAR
      INTEGER    INDEX1(NSTACK), NUMBER(NSTACK)
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      INTEGER    NLIMIT
      PARAMETER (NLIMIT = 20)
      INTEGER    I, IADD1, ICASE, ICOUNT, IFAIL, J, K, K1, K2, K3
      DOUBLE PRECISION ENEG, EPOS, PI, RTOL, TEN, ZERO, ONE
      PARAMETER (ENEG = -174.2D+00, EPOS = 174.2D+00,
     +           PI = 3.14159265359D+00, RTOL = 1.0D-300,
     +           TEN = 10.0D+00, ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION BOT, TOP
      PARAMETER (TOP = 1.0D+03, BOT = - TOP)
      DOUBLE PRECISION DATA(NSTACK/10)
      DOUBLE PRECISION F(KMAX_F), X, Y, YDE(KMAX_Y), Z
      DOUBLE PRECISION STACK(NSTACK), TEMP, XBOT, XMID, XTOP, VALUE
      DOUBLE PRECISION S14AAF$, S14ABF$, S15ABF$, S15ADF$
      DOUBLE PRECISION BLIM(NLIMIT), TLIM(NLIMIT)
      DOUBLE PRECISION EPSABS, EPSREL
      LOGICAL    OMIT
      CHARACTER  LINE*100
      EXTERNAL   PUTFAT
      EXTERNAL   S14AAF$, S14ABF$, S15ABF$, S15ADF$
      EXTERNAL   SUB_QUAD, SUB_ROOT, SUB_VALU, SPECIAL_FUNCTIONS,
     +           SUB_CONV
      INTRINSIC  ABS, EXP, SQRT, LOG, LOG10, NINT, SIN, COS, TAN,
     +           ASIN, ACOS, ATAN, SINH, COSH, TANH, MIN, MAX, MOD
      SAVE       EPSABS, EPSREL
      SAVE       BLIM, TLIM
      DATA       EPSABS, EPSREL / 1.0D-06, 1.0D-03 /
      DATA       BLIM, TLIM / NLIMIT*BOT, NLIMIT*TOP /
      IADD1 = N0
      ICOUNT = N0
      OMIT = .FALSE.
      DO I = N1, NLINES
         IF (OMIT) THEN
            ICASE = N0
         ELSE
            ICASE = INDEX1(I)
         ENDIF
         SELECT CASE (ICASE)
         CASE (0)
C***********PRINT*,'line omitted'
            OMIT = .FALSE.
         CASE (1)
C***********PRINT*,'put x on the stack'
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = X
         CASE (2)
C***********PRINT*,'put y on the stack'
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = Y
         CASE (3)
C***********PRINT*,'put z on the stack'
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = Z
         CASE (4)
C***********PRINT*,'add top stack element to next-to-top'
            ICOUNT = ICOUNT - N1
            STACK(ICOUNT) = STACK(ICOUNT) + STACK(ICOUNT + N1)
         CASE (5)
C***********PRINT*,'subtract top stack element from next-to-top'
            ICOUNT = ICOUNT - N1
            STACK(ICOUNT) = STACK(ICOUNT) - STACK(ICOUNT + N1)
         CASE (6)
C***********PRINT*,'multiply top 2 stack elements'
            ICOUNT = ICOUNT - N1
            STACK(ICOUNT) = STACK(ICOUNT)*STACK(ICOUNT + N1)
         CASE (7)
C***********PRINT*,'divide next-to-top stack element by top'
            TEMP = STACK(ICOUNT)
            IF (ABS(TEMP).LE.RTOL) THEN
               IF (TEMP.LT.ZERO) THEN
                  TEMP = - RTOL
               ELSE
                  TEMP = RTOL
               ENDIF
            ENDIF
            ICOUNT = ICOUNT - N1
            STACK(ICOUNT) = STACK(ICOUNT)/TEMP
         CASE (8)
C***********WRITE (*,'(A,I3)')
C****+      ' number of parameter to place on the stack is:', NUMBER(I)
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = PARAM(NUMBER(I))
         CASE (9)
C***********WRITE (*,'(A,I3)')
C****+      ' number of model to evaluate from the stack is:', NUMBER(I)
            F(NUMBER(I)) = STACK(ICOUNT)
            ICOUNT = ICOUNT - N1
         CASE (10)
C***********PRINT*,'raise next-to-top element to power of top'
            ICOUNT = ICOUNT - N1
            TEMP = STACK(ICOUNT)
            IF (TEMP.LT.ZERO) THEN
               STACK(ICOUNT) = TEMP**NINT(STACK(ICOUNT + N1))
            ELSEIF (TEMP.LE.RTOL) THEN
               STACK(ICOUNT) = RTOL**(STACK(ICOUNT + N1))
            ELSE
               STACK(ICOUNT) = TEMP**(STACK(ICOUNT + N1))
            ENDIF
         CASE (11)
C***********PRINT*,'replace top element by the square root'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.RTOL) TEMP = RTOL
            STACK(ICOUNT) = SQRT(TEMP)
         CASE (12)
C***********PRINT*,'replace top element by the exponential'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.ENEG) THEN
               TEMP = ENEG
            ELSEIF (TEMP.GE.EPOS) THEN
               TEMP = EPOS
            ENDIF
            STACK(ICOUNT) = EXP(TEMP)
         CASE (13)
C***********PRINT*,'replace top element by ten-to-the-power'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.ENEG) THEN
               TEMP = ENEG
            ELSEIF (TEMP.GT.EPOS) THEN
               TEMP = EPOS
            ENDIF
            STACK(ICOUNT) = TEN**TEMP
         CASE (14)
C***********PRINT*,'replace top element by natural log'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.RTOL) TEMP = RTOL
            STACK(ICOUNT) = LOG(TEMP)
         CASE (15)
C***********PRINT*,'replace top element by log-to-base-ten'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.RTOL) TEMP = RTOL
            STACK(ICOUNT) = LOG10(TEMP)
         CASE (16)
C***********PRINT*,'put pi on the stack (pi = 3.1415927)'
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = PI
         CASE (17)
C***********PRINT*,'replace top element by sine    *** radians!'
            STACK(ICOUNT) = SIN(STACK(ICOUNT))
         CASE (18)
            STACK(ICOUNT) = COS(STACK(ICOUNT))
C***********PRINT*,'replace top element by cosine  *** radians!'
         CASE (19)
C***********PRINT*,'replace top element by tangent *** radians!'
            STACK(ICOUNT) = TAN(STACK(ICOUNT))
         CASE (20)
C***********PRINT*,'replace top element by arcsin  *** radians!'
            STACK(ICOUNT) = ASIN(STACK(ICOUNT))
         CASE (21)
C***********PRINT*,'replace top element by arccos  *** radians!'
            STACK(ICOUNT) = ACOS(STACK(ICOUNT))
         CASE (22)
C***********PRINT*,'replace top element by arctan  *** radians!'
            STACK(ICOUNT) = ATAN(STACK(ICOUNT))
         CASE (23)
C***********PRINT*,'replace top element by sinh'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.ENEG) THEN
               TEMP = ENEG
            ELSEIF (TEMP.GT.EPOS) THEN
                TEMP = EPOS
            ENDIF
            STACK(ICOUNT) = SINH(TEMP)
         CASE (24)
C***********PRINT*,'replace top element by cosh'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.ENEG) THEN
               TEMP = ENEG
            ELSEIF (TEMP.GT.EPOS) THEN
                TEMP = EPOS
            ENDIF
            STACK(ICOUNT) = COSH(TEMP)
         CASE (25)
C***********PRINT*,'replace top element by tanh'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.ENEG) THEN
               TEMP = ENEG
            ELSEIF (TEMP.GT.EPOS) THEN
                TEMP = EPOS
            ENDIF
            STACK(ICOUNT) = TANH(TEMP)
         CASE (26)
C***********PRINT*,'duplicate top element'
            TEMP = STACK(ICOUNT)
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = TEMP
         CASE (27)
C***********PRINT*,'exchange top two elements on stack (swap)'
            TEMP = STACK(ICOUNT)
            STACK(ICOUNT) = STACK(ICOUNT - N1)
            STACK(ICOUNT - N1) = TEMP
         CASE (28)
C***********PRINT*,'pop top element off the stack (delete)'
            ICOUNT = ICOUNT - N1
         CASE (29)
C***********PRINT*,'replace top element of stack by absolute value'
            STACK(ICOUNT) = ABS(STACK(ICOUNT))
         CASE (30)
C***********PRINT*,'change sign of top element of the stack'
            STACK(ICOUNT) = - STACK(ICOUNT)
         CASE (31)
C***********PRINT*,'replace top 2 elements by the smallest'
            ICOUNT = ICOUNT - N1
            STACK(ICOUNT) = MIN(STACK(ICOUNT),STACK(ICOUNT + N1))
         CASE (32)
C***********PRINT*,'replace top two 2 elements by the largest'
            ICOUNT = ICOUNT - N1
            STACK(ICOUNT) = MAX(STACK(ICOUNT),STACK(ICOUNT + N1))
         CASE (33)
C***********PRINT*,'replace top element by gamma function'
            IFAIL = N1
            STACK(ICOUNT) = S14AAF$(STACK(ICOUNT), IFAIL)
         CASE (34)
C***********PRINT*,'replace top element by ln(gamma function)'
            IFAIL = N1
            STACK(ICOUNT) = S14ABF$(STACK(ICOUNT), IFAIL)
         CASE (35)
C***********PRINT*,'replace top element by unit normal integral'
            IFAIL = N1
            STACK(ICOUNT) = S15ABF$(STACK(ICOUNT), IFAIL)
         CASE (36)
C***********PRINT*,'replace top element by erfc'
            IFAIL = N1
            STACK(ICOUNT) = S15ADF$(STACK(ICOUNT), IFAIL)
         CASE (37)
C***********WRITE (*,'(A,I3)')
C****+      ' number of y(i) to place on the the stack is:', NUMBER(I)
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = YDE(NUMBER(I))
         CASE (38)
            CALL PUTFAT ('INDEX = 38 not allowed in subsidiary models')
C***********WRITE (*,'(A,I3)')
C****+      ' number of j(i) to evaluate from the stack is:', NUMBER(I)
C           YJA(NUMBER(I)) = STACK(ICOUNT)
C***********ICOUNT = ICOUNT - N1
         CASE (39)
C***********WRITE (*,'(A,I3,A,1P,E14.6)')
C****+      ' put(', NUMBER(I), ') =', STACK(ICOUNT)
            STORE(NUMBER(I)) = STACK(ICOUNT)
            ICOUNT = ICOUNT - N1
         CASE (40)
C***********WRITE (*,'(A,I3,A,1P,E14.6)')
C****+      ' get(', NUMBER(I), ') =', STORE(NUMBER(I))
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = STORE(NUMBER(I))
         CASE (41)
C***********WRITE (*,'(A,I3,A,1P,E14.6)')
C****+      ' blim(', NUMBER(I), ') =', STACK(ICOUNT)
            BLIM(NUMBER(I)) = STACK(ICOUNT)
            ICOUNT = ICOUNT - N1
         CASE (42)
C***********WRITE (*,'(A,I3,A,1P,E14.6)')
C****+      ' tlim(', NUMBER(I), ') =', STACK(ICOUNT)
            TLIM(NUMBER(I)) = STACK(ICOUNT)
            ICOUNT = ICOUNT - N1
         CASE (43)
C***********WRITE (*,'(A,1P,E11.3)') 'epsabs =', STACK(ICOUNT)
            IF (STACK(ICOUNT).GE.ZERO) EPSABS = STACK(ICOUNT)
            ICOUNT = ICOUNT - N1
         CASE (44)
C***********WRITE (*,'(A,1P,E11.3)') 'epsrel =', STACK(ICOUNT)
            IF (STACK(ICOUNT).GE.ZERO) EPSREL = STACK(ICOUNT)
            ICOUNT = ICOUNT - N1
         CASE (45)
            K1 = NUMBER(I)
            IADD1 = IADD1 + N1
            K2 = NINT(DATA(IADD1))
            IADD1 = IADD1 + N1
            K3 = NINT(DATA(IADD1))
            IF (STACK(ICOUNT).LT.-RTOL) THEN
               K = K1
            ELSEIF (ABS(STACK(ICOUNT)).LE.RTOL) THEN
               K = K2
            ELSE
               K = K3
            ENDIF
C***********WRITE (*,'(A,I3,A,1P,E14.6)')
C****+      ' get3(',K, ') =', STORE(K)
            STACK(ICOUNT) = STORE(K)
         CASE (46)
            CALL SUB_QUAD (NLIMIT, NUMBER(I),
     +                     BLIM, EPSABS, EPSREL, TLIM, VALUE)
C***********WRITE (*,'(A,1P,E14.6)')
C****+      ' value of integral to be placed on the stack is:', VALUE
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = VALUE
         CASE (47)
            CALL SUB_ROOT (NUMBER(I),
     +                     BLIM(1), EPSABS, EPSREL, TLIM(1), VALUE)
C***********WRITE (*,'(A,1P,E14.6)')
C****+      ' value of root to be placed on the stack is:', VALUE
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = VALUE
         CASE (48)
            CALL SUB_VALU (KMAX_Y, NUMBER(I), NVAR,
     +                     VALUE, X, Y, YDE, Z)
C***********WRITE (*,'(A,1P,E14.6)')
C****+      ' value of model to be placed on the stack is:', VALUE
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = VALUE
         CASE (49)
            CALL PUTFAT ('INDEX = 49 not allowed in subsidiary models')
C***********IF (NPAR.GT.N0) THEN
C              DO J = N1, NPAR
C                 PARAM(J) = A(J)
C              ENDDO
C**************WRITE (*,'(A,I4,A)')
C***********' All',NPAR,' parameters stored by put for use by get'
C***********ENDIF
         CASE (50)
            XBOT = MIN(STACK(ICOUNT),STACK(ICOUNT - N2))
            XMID = STACK(ICOUNT - N1)
            XTOP = MAX(STACK(ICOUNT),STACK(ICOUNT - N2))
            IF (XMID.LT.XBOT) THEN
               XMID = XBOT
            ELSEIF (XMID.GT.XTOP) THEN
               XMID = XTOP
            ENDIF
            ICOUNT = ICOUNT - N2
            STACK(ICOUNT) = XMID
C***********WRITE (LINE,'(A,1P,E14.6)')
C****+      'middle of 3 numbers to be placed on the stack is:', XMID
         CASE (51)
            K1 = MOD(NUMBER(I),1000)
            K2 = MOD(NUMBER(I),1000000)/1000
            K3 = NUMBER(I)/1000000
            IF (STACK(ICOUNT).LT.-RTOL) THEN
               K = K1
            ELSEIF (ABS(STACK(ICOUNT)).LE.RTOL) THEN
               K = K2
            ELSE
               K = K3
            ENDIF
            CALL SUB_VALU (KMAX_Y, K, NVAR,
     +                     VALUE, X, Y, YDE, Z)
C***********WRITE (*,'(A,I3,A,1P,E14.6)')
C****+      ' value3(',K,') =', VALUE
            STACK(ICOUNT) = VALUE
         CASE (52)
            IADD1 = IADD1 + N1
C***********WRITE (*,'(A,1P,E14.6)')
C****+      ' value of number to be placed on the stack is:', DATA(IADD1)
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = DATA(IADD1)
         CASE (53)
            XBOT = MIN(STACK(ICOUNT - N2), STACK(ICOUNT))
            XMID = STACK(ICOUNT - N1)
            XTOP = MAX(STACK(ICOUNT - N2), STACK(ICOUNT))
            ICOUNT = ICOUNT - N2
            IF (XMID.LE.XBOT) THEN
               STACK(ICOUNT) = - ONE
            ELSEIF (XMID.LE.XTOP) THEN
               STACK(ICOUNT) = ZERO
            ELSE
               STACK(ICOUNT) = ONE
            ENDIF
C***********WRITE (*,'(A,I3)')
C****+      ' order placed on stack =', NINT(STACK(ICOUNT))
         CASE (54)
            J = NINT(STORE(NUMBER(I)))
C***********WRITE (*,'(A,I3)') '  logical value stored =', J
            IF (J.EQ.N1) THEN
               OMIT = .FALSE.
            ELSE
               OMIT = .TRUE.
            ENDIF
         CASE (55)
            J = NINT(STORE(NUMBER(I)))
C***********WRITE (*,'(A,I3)') '  logical value stored =', J
            IF (J.EQ.N1) THEN
               OMIT = .TRUE.
            ELSE
               OMIT = .FALSE.
            ENDIF
         CASE (56)
            CALL SUB_CONV (NLIMIT, NUMBER(I),
     +                     BLIM, EPSABS, EPSREL, TLIM, VALUE)
C***********WRITE (*,'(A,1P,E14.6)')
C****+' value of convolution to be placed on the stack is:', VALUE
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = VALUE
         CASE DEFAULT
            CALL SPECIAL_FUNCTIONS (ICOUNT, INDEX1(I), NSTACK,
     +                              STACK)
         END SELECT
C
C Check that stack index is ok
C
         IF (ICOUNT.LT.N0) THEN
            WRITE (LINE,100) ICOUNT, I
            CALL PUTFAT (LINE)
            RETURN
         ENDIF
      ENDDO
C
C Check that stack is empty
C
      IF (ICOUNT.NE.N0) THEN
         I = NEQN!to silence ftn95
         I = NPAR!to silence ftn95
         WRITE (LINE,200) ICOUNT
         CALL PUTFAT (LINE)
      ENDIF
  100 FORMAT (
     +'EVAL_SUBMOD4: stack index =',I3,' at operation line',I3)
  200 FORMAT (
     +'EVAL_SUBMOD4: number of elements left on the stack =',I3)
      END
C
C
