C
C
      SUBROUTINE SPECIAL_FUNCTIONS (ICOUNT, INDEX1, NSTACK, STACK)
C
C ACTION: Evaluate special functions for user-defined models
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 14/12/2001
C         27/05/2003 added Heaviside
C         02/06/2003 added impulse functions
C         Date of this version 02/06/2003
C
      IMPLICIT NONE
      INCLUDE 'global.ins'
C
C Arguments
C
      INTEGER  ICOUNT, INDEX1, NSTACK
      DOUBLE PRECISION STACK(NSTACK)
C
C Local variables
C
      INTEGER    I, IFAIL, L, M, N, NMOD, NVAR
      INTEGER    N0, N1, N2, N3
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3)
      INTEGER    KMAX_Y
      PARAMETER (KMAX_Y = 3)
      DOUBLE PRECISION A, ABSX, ANS(N2), B, CN, DF, DF1, DF2, DM, DN, P,
     +                 PDF, Q, R, SN, VALUE, X, Y, YDE(KMAX_Y), Z
      DOUBLE PRECISION RELERR, TOL, ZERO, ONE, TWO, RTOL
      PARAMETER (TOL = 1.0D-06, ZERO = 0.0D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00, RTOL = 1.0D-300)
      DOUBLE PRECISION PI, PIBY2, PIBY3, PIBY4, TWOPI, ROOT2PI,
     +                 DEG2RAD, RAD2DEG, ROOT2, ROOT3, EULER, LNEULER
      PARAMETER (PI =  3.141592653589793D+00,
     +        PIBY2 =  1.570796326794897D+00,
     +        PIBY3 =  1.047197551196598D+00,
     +        PIBY4 =  7.853981633974483D-01,
     +        TWOPI =  6.283185307179586D+00,
     +      ROOT2PI =  2.506628274631000D+00,
     +      DEG2RAD =  1.745329251994330D-02,
     +      RAD2DEG =  5.729577951308232D+01,
     +        ROOT2 =  1.414213562373095D+00,
     +        ROOT3 =  1.732050807568877D+00,
     +        EULER =  5.772156649015329D-01,
     +      LNEULER = -5.495393129816448D-01)
      DOUBLE PRECISION ABRAMZ, CLAUSN, DBINOM, DCSEVL, DE1, DEBYE0,
     +                 DSPENC, KUMMER, POLLEG, STRUVE
      DOUBLE PRECISION G01EBF$, G01ECF$, G01EDF$, G01EFF$
      DOUBLE PRECISION G01FAF$, G01FBF$, G01FCF$, G01FDF$, G01FEF$,
     +                 G01FFF$
      DOUBLE PRECISION S01BAF$
      DOUBLE PRECISION S11AAF$, S11ABF$, S11ACF$
      DOUBLE PRECISION S13AAF$, S13ACF$, S13ADF$
      DOUBLE PRECISION S14AAF$, S14ABF$
      DOUBLE PRECISION S15ABF$, S15ACF$, S15ADF$, S15AEF$, S15AFF$
      DOUBLE PRECISION S17AEF$, S17AFF$, S17ACF$, S17ADF$
      DOUBLE PRECISION S18ACF$, S18ADF$, S18AEF$, S18AFF$
      DOUBLE PRECISION S17AGF$, S17AJF$, S17AHF$, S17AKF$
      DOUBLE PRECISION S19AAF$, S19ABF$, S19ACF$, S19ADF$
      DOUBLE PRECISION S21BAF$, S21BBF$, S21BCF$, S21BDF$
      DOUBLE PRECISION S20ACF$, S20ADF$
      DOUBLE PRECISION BETA_PDF
      CHARACTER  TAIL*1
      PARAMETER (TAIL = 'L')
      EXTERNAL   PUTADV, PUTFAT
      EXTERNAL   ABRAMZ, CLAUSN, DBINOM, DCSEVL, DE1, DEBYE0, DSPENC,
     +           FERMID, KUMMER, POLLEG, STRUVE
      EXTERNAL   G01EBF$, G01ECF$, G01EDF$, G01EEF$, G01EFF$
      EXTERNAL   G01FAF$, G01FBF$, G01FCF$, G01FDF$, G01FEF$,
     +           G01FFF$
      EXTERNAL   S01BAF$
      EXTERNAL   S11AAF$, S11ABF$, S11ACF$
      EXTERNAL   S13AAF$, S13ACF$, S13ADF$
      EXTERNAL   S14AAF$, S14ABF$
      EXTERNAL   S14ADF$, S14BAF$
      EXTERNAL   S15ABF$, S15ACF$, S15ADF$, S15AEF$, S15AFF$
      EXTERNAL   S17AEF$, S17AFF$, S17ACF$, S17ADF$
      EXTERNAL   S17AGF$, S17AJF$, S17AHF$, S17AKF$
      EXTERNAL   S18ACF$, S18ADF$, S18AEF$, S18AFF$
      EXTERNAL   S19AAF$, S19ABF$, S19ACF$, S19ADF$
      EXTERNAL   S20ACF$, S20ADF$
      EXTERNAL   S21BAF$, S21BBF$, S21BCF$, S21BDF$
      EXTERNAL   S21CAF$
      EXTERNAL   SUB_VALU
      EXTERNAL   BETA_PDF
      INTRINSIC  NINT, ABS, SQRT, INT, DBLE, EXP, MOD, SIN
      IFAIL = 1
      IF (INDEX1.LT.174 .OR. INDEX1.GT.185) THEN
C
C Assign X since a function is required not a constant
C
         X = STACK(ICOUNT)
      ELSE
C
C Increment ICOUNT since a constant is required not a function
C
         ICOUNT = ICOUNT + N1
      ENDIF
      SELECT CASE (INDEX1)
      CASE (101)
         STACK(ICOUNT) = S17AGF$(X, IFAIL)
      CASE (102)
         STACK(ICOUNT) = S17AJF$(X, IFAIL)
      CASE (103)
         STACK(ICOUNT) = S17AHF$(X, IFAIL)
      CASE (104)
         STACK(ICOUNT) = S17AKF$(X, IFAIL)
      CASE (105)
         STACK(ICOUNT) = S17AEF$(X, IFAIL)
      CASE (106)
         STACK(ICOUNT) = S17AFF$(X, IFAIL)
      CASE (107)
         STACK(ICOUNT) = S17ACF$(X, IFAIL)
      CASE (108)
         STACK(ICOUNT) = S17ADF$(X, IFAIL)
      CASE (109)
         STACK(ICOUNT) = S15ACF$(X, IFAIL)
      CASE (110)
         STACK(ICOUNT) = S15ADF$(X, IFAIL)
      CASE (111)
         STACK(ICOUNT) = S13ACF$(X, IFAIL)
      CASE (112)
         STACK(ICOUNT) = S15ABF$(X, IFAIL)
      CASE (113)
         ICOUNT = ICOUNT - N1
         Y = STACK(ICOUNT)
         STACK(ICOUNT) = S21BAF$(X, Y, IFAIL)
      CASE (114)
         ICOUNT = ICOUNT - N1
         Y = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         Z = STACK(ICOUNT)
         STACK(ICOUNT) = S21BBF$(X, Y, Z, IFAIL)
      CASE (115)
         ICOUNT = ICOUNT - N1
         Y = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         Z = STACK(ICOUNT)
         STACK(ICOUNT) = S21BCF$(X, Y, Z, IFAIL)
      CASE (116)
         ICOUNT = ICOUNT - N1
         Y = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         Z = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         R = STACK(ICOUNT)
         STACK(ICOUNT) = S21BDF$(X, Y, Z, R, IFAIL)
      CASE (117)
         STACK(ICOUNT) = S15AEF$(X, IFAIL)
      CASE (118)
         STACK(ICOUNT) = S13AAF$(X, IFAIL)
      CASE (119)
         STACK(ICOUNT) = S14AAF$(X, IFAIL)
      CASE (120)
         STACK(ICOUNT) = S20ADF$(X, IFAIL)
      CASE (121)
         STACK(ICOUNT) = S20ACF$(X, IFAIL)
      CASE (122)
         STACK(ICOUNT) = S19ABF$(X, IFAIL)
      CASE (123)
         STACK(ICOUNT) = S19AAF$(X, IFAIL)
      CASE (124)
         STACK(ICOUNT) = S19ADF$(X, IFAIL)
      CASE (125)
         STACK(ICOUNT) = S19ACF$(X, IFAIL)
      CASE (126)
         STACK(ICOUNT) = S14ABF$(X, IFAIL)
      CASE (127)
         STACK(ICOUNT) = S18AEF$(X, IFAIL)
      CASE (128)
         STACK(ICOUNT) = S18AFF$(X, IFAIL)
      CASE (129)
         STACK(ICOUNT) = S18ACF$(X, IFAIL)
      CASE (130)
         STACK(ICOUNT) = S18ADF$(X, IFAIL)
      CASE (131)
         STACK(ICOUNT) = S13ADF$(X, IFAIL)
      CASE (132)
         CALL S14ADF$(X, N0, N1, ANS, IFAIL)
         STACK(ICOUNT) = - ANS(1)
      CASE (133)
         CALL S14ADF$(X, N0, N2, ANS, IFAIL)
         STACK(ICOUNT) = ANS(2)
      CASE (134)
         ICOUNT = ICOUNT - N1
         DM = STACK(ICOUNT)
         CALL S21CAF$(X, DM, SN, CN, DN, IFAIL)
         STACK(ICOUNT) = SN
      CASE (135)
         ICOUNT = ICOUNT - N1
         DM = STACK(ICOUNT)
         CALL S21CAF$(X, DM, SN, CN, DN, IFAIL)
         STACK(ICOUNT) = CN
      CASE (136)
         ICOUNT = ICOUNT - N1
         DM = STACK(ICOUNT)
         CALL S21CAF$(X, DM, SN, CN, DN, IFAIL)
         STACK(ICOUNT) = DN
      CASE (137)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         CALL S14BAF$(A, X, TOL, P, Q, IFAIL)
         STACK(ICOUNT) = P
      CASE (138)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         CALL S14BAF$(A, X, TOL, P, Q, IFAIL)
         STACK(ICOUNT) = Q
      CASE (139)
         ICOUNT = ICOUNT - N1
         DF = STACK(ICOUNT)
         STACK(ICOUNT) = G01EBF$(TAIL, X, DF, IFAIL)
      CASE (140)
         ICOUNT = ICOUNT - N1
         DF = STACK(ICOUNT)
         STACK(ICOUNT) = G01ECF$(TAIL, X, DF, IFAIL)
      CASE (141)
         ICOUNT = ICOUNT - N1
         DF1 = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         DF2 = STACK(ICOUNT)
         STACK(ICOUNT) = G01EDF$(TAIL, X, DF1, DF2, IFAIL)
      CASE (142)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         B = STACK(ICOUNT)
         CALL G01EEF$(X, A, B, TOL, P, Q, PDF, IFAIL)
         STACK(ICOUNT) = P
      CASE (143)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         B = STACK(ICOUNT)
         STACK(ICOUNT) = G01EFF$(TAIL, X, A, B, IFAIL)
      CASE (144)
         STACK(ICOUNT) = G01FAF$(TAIL, X, IFAIL)
      CASE (145)
         ICOUNT = ICOUNT - N1
         DF = STACK(ICOUNT)
         STACK(ICOUNT) = G01FBF$(TAIL, X, DF, IFAIL)
      CASE (146)
         ICOUNT = ICOUNT - N1
         DF = STACK(ICOUNT)
         STACK(ICOUNT) = G01FCF$(X, DF, IFAIL)
      CASE (147)
         ICOUNT = ICOUNT - N1
         DF1 = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         DF2 = STACK(ICOUNT)
         STACK(ICOUNT) = G01FDF$(X, DF1, DF2, IFAIL)
      CASE (148)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         B = STACK(ICOUNT)
         STACK(ICOUNT) = G01FEF$(X, A, B, TOL, IFAIL)
      CASE (149)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         B = STACK(ICOUNT)
         STACK(ICOUNT) = G01FFF$(X, A, B, TOL, IFAIL)
      CASE (150)
         STACK(ICOUNT) = S15AFF$(X, IFAIL)
      CASE (151)
         STACK(ICOUNT) = DSPENC(X)
      CASE (152)
         STACK(ICOUNT) = S11AAF$(X, IFAIL)
      CASE (153)
         STACK(ICOUNT) = S11ABF$(X, IFAIL)
      CASE (154)
         STACK(ICOUNT) = S11ACF$(X, IFAIL)
      CASE (155)
         ICOUNT = ICOUNT - N1
         IFAIL = NINT(STACK(ICOUNT))
         STACK(ICOUNT) = DEBYE0 (X, IFAIL)
      CASE (156)
         STACK(ICOUNT) = CLAUSN (X)
      CASE (157)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         RELERR = TOL
         CALL FERMID (A, X, RELERR, P, IFAIL)
         STACK(ICOUNT) = P
      CASE (158)
         STACK(ICOUNT) = - DE1(-X)
      CASE (159)
         ICOUNT = ICOUNT - N1
         IFAIL = NINT(STACK(ICOUNT))
         STACK(ICOUNT) = STRUVE (X, N1, IFAIL)
      CASE (160)
         ICOUNT = ICOUNT - N1
         IFAIL = NINT(STACK(ICOUNT))
         STACK(ICOUNT) = STRUVE (X, N2, IFAIL)
      CASE (161)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         B = STACK(ICOUNT)
         STACK(ICOUNT) = KUMMER (N1, A, B, X)
      CASE (162)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         B = STACK(ICOUNT)
         STACK(ICOUNT) = KUMMER (N2, A, B, X)
      CASE (163)
         STACK(ICOUNT) = S01BAF$(X, IFAIL)
      CASE (164)
         N = NINT(X)
         ICOUNT = ICOUNT - N1
         M = NINT(STACK(ICOUNT))
         IF (M.GE.N0 .AND. N.GE.N0 .AND. M.LE.N) THEN
            STACK(ICOUNT) = DBINOM(N,M)
         ELSE
            STACK(ICOUNT) = ZERO
         ENDIF
      CASE (165)
         ICOUNT = ICOUNT - N1
         M = NINT(STACK(ICOUNT))
         ICOUNT = ICOUNT - N1
         N = NINT(STACK(ICOUNT))
         STACK(ICOUNT) = POLLEG (M, N, X)
      CASE (166)
         ICOUNT = ICOUNT - N1
         IFAIL = NINT(STACK(ICOUNT))
         STACK(ICOUNT) = ABRAMZ (IFAIL, X)
      CASE (167)
         ICOUNT = ICOUNT - N1
         M = NINT(STACK(ICOUNT))
         ICOUNT = ICOUNT - N1
         N = NINT(STACK(ICOUNT))
         IFAIL = N + M - N1
         IF (N.GE.N1 .AND. M.GT.N0 .AND. IFAIL.LE.NSTORE) THEN
            A = STORE(IFAIL)
            DO I = N1, M - N2
               IFAIL = IFAIL - N1
               A = A*X + STORE(IFAIL)
            ENDDO
            STACK(ICOUNT) = A*X + STORE(N)
         ELSE
            STACK(ICOUNT) = ZERO
         ENDIF
      CASE (168)
         ICOUNT = ICOUNT - N1
         M = NINT(STACK(ICOUNT))
         ICOUNT = ICOUNT - N1
         N = NINT(STACK(ICOUNT))
         IFAIL = N + M - N1
         IF (N.GE.N1 .AND. M.GT.N0 .AND. IFAIL.LE.NSTORE .AND.
     +       ABS(X).LE.ONE) THEN
            STACK(ICOUNT) = DCSEVL(X, STORE(N), M)
         ELSE
            STACK(ICOUNT) = ZERO
         ENDIF
      CASE (169)
         M = NINT(X)
         ICOUNT = ICOUNT - N1
         N = NINT(STACK(ICOUNT))
         IFAIL = N + M - N1
         IF (N.GE.N1 .AND. M.GT.N0 .AND. IFAIL.LE.NSTORE) THEN
            A = ZERO
            DO I = N, IFAIL
               A = A + ABS(STORE(I))
            ENDDO
            STACK(ICOUNT) = A
         ELSE
            STACK(ICOUNT) = ZERO
         ENDIF
      CASE (170)
         M = NINT(X)
         ICOUNT = ICOUNT - N1
         N = NINT(STACK(ICOUNT))
         IFAIL = N + M - N1
         IF (N.GE.N1 .AND. M.GT.N0 .AND. IFAIL.LE.NSTORE) THEN
            A = ZERO
            DO I = N, IFAIL
               A = A + STORE(I)*STORE(I)
            ENDDO
            STACK(ICOUNT) = SQRT(A)
         ELSE
            STACK(ICOUNT) = ZERO
         ENDIF
      CASE (171)
         M = NINT(X)
         ICOUNT = ICOUNT - N1
         N = NINT(STACK(ICOUNT))
         IFAIL = N + M - N1
         IF (N.GE.N1 .AND. M.GT.N0 .AND. IFAIL.LE.NSTORE) THEN
            A = ABS(STORE(N))
            IF (N.GT.N1) THEN
               DO I = N + N1, IFAIL
                  B = ABS(STORE(I))
                  IF (B.GT.A) A = B
               ENDDO
            ENDIF
            STACK(ICOUNT) = A
         ELSE
            STACK(ICOUNT) = ZERO
         ENDIF
      CASE (172)
         M = NINT(X)
         ICOUNT = ICOUNT - N1
         N = NINT(STACK(ICOUNT))
         STACK(ICOUNT) = ZERO
         IFAIL = N + M - N1
         IF (N.GE.N1 .AND. M.GT.N0 .AND. IFAIL.LE.NSTORE) THEN
            DO I = N, IFAIL
               STACK(ICOUNT) = STACK(ICOUNT) + STORE(I)
            ENDDO
         ENDIF
      CASE (173)
         M = NINT(X)
         ICOUNT = ICOUNT - N1
         N = NINT(STACK(ICOUNT))
         STACK(ICOUNT) = ZERO
         IFAIL = N + M - N1
         IF (N.GE.N1 .AND. M.GT.N0 .AND. IFAIL.LE.NSTORE) THEN
            DO I = N, IFAIL
               STACK(ICOUNT) = STACK(ICOUNT) + STORE(I)*STORE(I)
            ENDDO
         ENDIF
C
C 174 to 185 so just add constants ... ICOUNT has already been incremented
C
      CASE (174)
         STACK(ICOUNT) = PI
      CASE (175)
         STACK(ICOUNT) = PIBY2
      CASE (176)
         STACK(ICOUNT) = PIBY3
      CASE (177)
         STACK(ICOUNT) = PIBY4
      CASE (178)
         STACK(ICOUNT) = TWOPI
      CASE (179)
         STACK(ICOUNT) = ROOT2PI
      CASE (180)
         STACK(ICOUNT) = DEG2RAD
      CASE (181)
         STACK(ICOUNT) = RAD2DEG
      CASE (182)
         STACK(ICOUNT) = ROOT2
      CASE (183)
         STACK(ICOUNT) = ROOT3
      CASE (184)
         STACK(ICOUNT) = EULER
      CASE (185)
         STACK(ICOUNT) = LNEULER
      CASE (186)
         L = NINT(X)
         ICOUNT = ICOUNT - N1
         M = NINT(STACK(ICOUNT))
         ICOUNT = ICOUNT - N1
         N = NINT(STACK(ICOUNT))
         Q = ZERO
         IF (L.GT.N0 .AND. M.GT.N0 .AND. N.GT.N0 .AND.
     +       M + L - N1.LE.NSTORE  .AND. N + L - N1.LE.NSTORE) THEN
            DO I = N1, L
               Q = Q + STORE(M)*STORE(N)
               M = M + N1
               N = N + N1
            ENDDO
         ENDIF
         STACK(ICOUNT) = Q
      CASE (187)
         L = INT(X)
         STACK(ICOUNT) = DBLE(L)
      CASE (188)
         L = NINT(X)
         STACK(ICOUNT) = DBLE(L)
      CASE (189)
         IF (X.LT.ZERO) THEN
           STACK(ICOUNT) = - ONE
         ELSEIF (X.GT.ZERO) THEN
           STACK(ICOUNT) = ONE
         ELSE
           STACK(ICOUNT) = ZERO
         ENDIF
      CASE (190)
         ICOUNT = ICOUNT - N1
         NMOD = NINT(STACK(ICOUNT))
         NVAR = N1
         CALL SUB_VALU (KMAX_Y, NMOD, NVAR, VALUE, X, Y, YDE, Z)
         STACK(ICOUNT) = VALUE
      CASE (191)
         ICOUNT = ICOUNT - N1
         Y = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         NMOD = NINT(STACK(ICOUNT))
         NVAR = N2
         CALL SUB_VALU (KMAX_Y, NMOD, NVAR, VALUE, X, Y, YDE, Z)
         STACK(ICOUNT) = VALUE
      CASE (192)
         ICOUNT = ICOUNT - N1
         Y = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         Z = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         NMOD = NINT(STACK(ICOUNT))
         NVAR = N3
         CALL SUB_VALU (KMAX_Y, NMOD, NVAR, VALUE, X, Y, YDE, Z)
         STACK(ICOUNT) = VALUE
      CASE (193)
         IF (X.LT.ZERO) THEN
            STACK(ICOUNT) = ONE
         ELSE
            STACK(ICOUNT) = ZERO
         ENDIF
      CASE (194)
         IF (X.LE.ZERO) THEN
            STACK(ICOUNT) = ONE
         ELSE
            STACK(ICOUNT) = ZERO
         ENDIF
      CASE (195)
         IF (X.LT.ZERO .OR. X.GT.ZERO) THEN
            STACK(ICOUNT) = ZERO
         ELSE
            STACK(ICOUNT) = ONE
         ENDIF
      CASE (196)
         IF (X.GE.ZERO) THEN
            STACK(ICOUNT) = ONE
         ELSE
            STACK(ICOUNT) = ZERO
         ENDIF
      CASE (197)
         IF (X.GT.ZERO) THEN
            STACK(ICOUNT) = ONE
         ELSE
            STACK(ICOUNT) = ZERO
         ENDIF
      CASE (198)
         M = NINT(X)
         IF (M.EQ.N1) THEN
            STACK(ICOUNT) = ZERO
         ELSEIF (M.EQ.N0) THEN
            STACK(ICOUNT) = ONE
         ELSE
            CALL PUTFAT ('not(m) encountered but m not 0 or 1')
         ENDIF
      CASE (199)
         M = NINT(X)
         ICOUNT = ICOUNT - N1
         N = NINT(STACK(ICOUNT))
         IF (M.EQ.N1 .AND. N.EQ.N1) THEN
            STACK(ICOUNT) = ONE
         ELSEIF (M.EQ.N0 .AND. N.EQ.N1) THEN
            STACK(ICOUNT) = ZERO
         ELSEIF (M.EQ.N1 .AND. N.EQ.N0) THEN
            STACK(ICOUNT) = ZERO
         ELSEIF (M.EQ.N0 .AND. N.EQ.N0) THEN
            STACK(ICOUNT) = ZERO
         ELSE
            CALL PUTFAT ('and(m,n) encountered but m, n not 0 or 1')
         ENDIF
      CASE (200)
         M = NINT(X)
         ICOUNT = ICOUNT - N1
         N = NINT(STACK(ICOUNT))
         IF (M.EQ.N1 .AND. N.EQ.N0) THEN
            STACK(ICOUNT) = ONE
         ELSEIF (M.EQ.N0 .AND. N.EQ.N1) THEN
            STACK(ICOUNT) = ONE
         ELSEIF (M.EQ.N1 .AND. N.EQ.N1) THEN
            STACK(ICOUNT) = ONE
         ELSEIF (M.EQ.N0 .AND. N.EQ.N0) THEN
            STACK(ICOUNT) = ZERO
         ELSE
            CALL PUTFAT ('or(m,n) used but m, n not 0 or 1')
         ENDIF
      CASE (201)
         M = NINT(X)
         ICOUNT = ICOUNT - N1
         N = NINT(STACK(ICOUNT))
         IF (M.EQ.N1 .AND. N.EQ.N0) THEN
            STACK(ICOUNT) = ONE
         ELSEIF (M.EQ.N0 .AND. N.EQ.N1) THEN
            STACK(ICOUNT) = ONE
         ELSEIF (M.EQ.N1 .AND. N.EQ.N1) THEN
            STACK(ICOUNT) = ZERO
         ELSEIF (M.EQ.N0 .AND. N.EQ.N0) THEN
            STACK(ICOUNT) = ZERO
         ELSE
            CALL PUTFAT ('xor(m,n) used but m, n not 0 or 1')
         ENDIF
      CASE (202)
         ICOUNT = ICOUNT - N1
         IF (X.GE.STACK(ICOUNT)) THEN
            STACK(ICOUNT) = ONE
         ELSE
            STACK(ICOUNT) = ZERO
         ENDIF
      CASE (203)
         A = X
         ICOUNT = ICOUNT - N1
         B = NINT(STACK(ICOUNT))
         IF (ABS(A - B).LE.RTOL) THEN
            STACK(ICOUNT) = ONE
         ELSE
            STACK(ICOUNT) = ZERO
         ENDIF
      CASE (204)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         B = STACK(ICOUNT)
         IF (B.LE.RTOL .OR. X.LT.A - B .OR. X.GT.A + B) THEN
            STACK(ICOUNT) = ZERO
         ELSE
            STACK(ICOUNT) = ONE/(TWO*B)
         ENDIF
      CASE (205)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         B = STACK(ICOUNT)
         IF (B.LE.RTOL .OR. X.LT.A - B .OR. X.GT.A + B) THEN
            STACK(ICOUNT) = ZERO
         ELSEIF (X.LE.A) THEN
            STACK(ICOUNT) = (X + B - A)/B**2
         ELSE
            STACK(ICOUNT) = (A + B - X)/B**2
         ENDIF
      CASE (206)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         B = STACK(ICOUNT)
         IF (B.LE.RTOL) THEN
            STACK(ICOUNT) = ZERO
         ELSE
            R = - ((X - A)/B)**2/TWO
            STACK(ICOUNT) = EXP(R)/(ROOT2PI*B)
         ENDIF
      CASE (207)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         IF (A.GT.ZERO) THEN
            IF (X.GE.ZERO) THEN
               R = X/A
            ELSE
               R = ABS(X - A)/A
            ENDIF
            L = MOD(INT(R), N2)
            IF (L.EQ.N0) THEN
               STACK(ICOUNT) = ONE
            ELSE
               STACK(ICOUNT) = - ONE
            ENDIF
         ELSE
            STACK(ICOUNT) = ZERO
         ENDIF
      CASE (208)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         IF (A.GT.ZERO) THEN
            ABSX = ABS(X)
            R = ABSX/A
            M = INT(R)
            L = MOD(M, N2)
            B = ABSX - A*DBLE(M)
            IF (L.EQ.N0) THEN
               STACK(ICOUNT) = B/A
            ELSE
               STACK(ICOUNT) = ONE - B/A
            ENDIF
         ELSE
            STACK(ICOUNT) = ZERO
         ENDIF
      CASE (209)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         IF (A.GT.ZERO) THEN
            IF (X.GE.ZERO) THEN
               R = X/A
            ELSE
               R = ABS(X - A)/A
            ENDIF
            L = MOD(INT(R), N2)
            IF (L.EQ.N0) THEN
               STACK(ICOUNT) = ONE
            ELSE
               STACK(ICOUNT) = ZERO
            ENDIF
         ELSE
            STACK(ICOUNT) = ZERO
         ENDIF
      CASE (210)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         IF (A.GT.ZERO) THEN
            IF (X.GE.ZERO) THEN
               R = X/A
               M = INT(R)
               B = X - A*M
            ELSE
               ABSX = ABS(X)
               R = ABSX/A
               M = INT(R)
               B = A*DBLE(M + 1) - ABSX
            ENDIF
            STACK(ICOUNT) = B/A
         ELSE
            STACK(ICOUNT) = ZERO
         ENDIF
      CASE (211)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         STACK(ICOUNT) = ABS(SIN(A*X))
      CASE (212)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         B = SIN(A*X)
         IF (B.GT.ZERO) THEN
            STACK(ICOUNT) = B
         ELSE
            STACK(ICOUNT) = ZERO
         ENDIF
      CASE (213)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         B = STACK(ICOUNT)
         IF (A.GT.ZERO .AND. B.GT.ZERO) THEN
            ABSX = ABS(X)
            R = ABSX/A
            M = NINT(R)
            P = ABSX - A*DBLE(M)
            IF (ABS(P).LE.B) THEN
               STACK(ICOUNT) = ONE/(TWO*B)
            ELSE
               STACK(ICOUNT) = ZERO
            ENDIF
         ELSE
            STACK(ICOUNT) = ZERO
         ENDIF
      CASE (214)
         ICOUNT = ICOUNT - N1
         A = STACK(ICOUNT)
         ICOUNT = ICOUNT - N1
         B = STACK(ICOUNT)
         STACK(ICOUNT) = BETA_PDF (A, B, X)
      CASE DEFAULT
         IF (ICOUNT.LE.N0) THEN
            CALL PUTFAT ('Empty stack encountered in SPECIAL_FUNCTIONS')
         ELSE
            STACK(ICOUNT) = ZERO
            CALL PUTADV ('Bad syntax encountered in SPECIAL_FUNCTIONS')
         ENDIF
      END SELECT
      END
C
C
