C
C Sublevel 1 routines for QNSUB1
C ==============================
C To be consistent this version must have MODNAM dimensioned MODNAM(24)*80
C 14/10/2001 changed Z(*)*(*) to Z(24)*80
C
C
      SUBROUTINE QNS101 (NFIX, NMOD, NPAR, NX, Z, CONST)
C      ... Polynomial of degree N - 1
      IMPLICIT  NONE
      INTEGER   NFIX, NMOD, NPAR, NX
      CHARACTER Z(24)*80
      LOGICAL   CONST
      EXTERNAL  GETJM1, ADDCON
      INTRINSIC MIN
      Z(1) = 'Polynomial; C = p(n+1)'
      Z(2) = 'p(1)x + p(2)x^2 +...+ p(n)x^n + C'
      Z(3) = 'Reduced major and major regression allowed with lines'
      NPAR = 0
      NMOD = 1
      CALL GETJM1 (NPAR, NMOD, MIN(20,NX - 1),
     +'Degree n required (e.g. 1 for a line, 2 for a quadratic, etc.)')
      NPAR = NMOD
      IF (NMOD.EQ.0) THEN
         NPAR = 1
         CONST = .TRUE.
      ELSE
         CALL ADDCON (NFIX, NPAR, CONST)
      ENDIF
      END
C
C
      SUBROUTINE QNS102 (NFIX, NMOD, NPAR, NX, Z, CONST)
C      ... Rational function of order N:N
      IMPLICIT  NONE
      INTEGER   NFIX, NMOD, NPAR, NX
      CHARACTER Z(24)*80
      LOGICAL   CONST
      EXTERNAL  GETJM1, ADDCON
      INTRINSIC MIN
      Z(1) = 'n:n rational; C = p(2n+1)'
      Z(2) = 'g(x) = C + p(1)x + p(2)x^2 +...+ p(n)x^n'
      Z(3) = 'h(x) = 1 + p(n+1)x + p(n+2)x^2 +...+ p(2n)x^n'
      Z(4) = 'f(x) = g(x)/h(x)'
      NPAR = 1
      NMOD = 1
      CALL GETJM1 (NPAR, NMOD, MIN(10,(NX - 1)/2),
     +'Order required for the n:n rational function (i.e. n)')
      NPAR = 2*NMOD
      CALL ADDCON (NFIX, NPAR, CONST)
      END
C
C
      SUBROUTINE QNS103 (NFIX, NMOD, NPAR, NX, B, Z, CONST)
C      ... Sum of Michaelis-Menten functions plus a constant
      IMPLICIT   NONE
      INTEGER    NFIX, NMOD, NPAR, NX
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(12), NUMPOS(4)
      DOUBLE PRECISION B(NX)
      DOUBLE PRECISION ZERO, TWO, FOUR
      PARAMETER (ZERO = 0.0D+00, TWO = 2.0D+00, FOUR = 4.0D+00)
      CHARACTER  Z(24)*80
      CHARACTER  TEXT(30)*100, WORD3*3, WORD10*10
      LOGICAL    CONST
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   GETJM1, ADDCON, LBOX01, GETRGT
      INTRINSIC MIN
      DATA NUMBLD / 1*1, 11*0 /
      DATA NUMPOS / 4*1 /
      WRITE (TEXT,100)
      NSTART = 9
      NUMOPT = 3
      NTEXT = 11
      NUMDEC = 1
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +             NUMOPT, NUMPOS, NSTART, NTEXT, TEXT,
     +             BORDER, FLASH, HIGH)
      NPAR = 1
      NMOD = 1
      CALL GETJM1 (NPAR, NMOD, MIN(10,(NX - 1)/2),
     +'Number of MM terms required in the summation (i.e. n)')
      NPAR = 2*NMOD
      WRITE (WORD3,'(I3)') NMOD
      IF (NUMDEC.EQ.1) THEN
         B(1) = ZERO
         B(2) = ZERO
         Z(1) =
     +   'Sum of n M-Ms; C = p(2n+1), x = S, y = dP/dt'
         Z(2) = 'f(x) = p(1)x/[p(n+1) + x] + p(2)x/[p(n+2) + x]'
         Z(3) = '         +...+ p(n)x/[p(2n) + x] + C, n ='//WORD3
         Z(4) = 'p(i) = Vmax(i), p(n + i) = Km(i), for i = 1 to n'
      ELSEIF (NUMDEC.EQ.2) THEN
         B(1) = TWO
         CALL GETRGT (B(2), ZERO,
     +'Fixed [Hot], i.e. constant labelled substrate conc. used')
         WRITE (WORD10,'(1P,E10.3)') B(2)
         Z(1) =
     +'Sum of n M-Ms; C=p(2n+1), x=[Cold], y=[Hot], z=x+y, f(x)=dy/dt'
         Z(2) = 'f(x) = y{p(1)/[p(n+1) + z] + p(2)/[p(n+2) + z]'
         Z(3) = '         +...+ p(n)/[p(2n) + z]} + C, n ='//WORD3
         Z(4) =
     +  'p(i) = Vmax(i), p(n+i) = Km(i), [Hot] (input) ='//WORD10
      ELSE
         B(1) = FOUR
         B(2) = ZERO
         Z(1) =
     +'Sum of n M-Ms; C=p(2n+1), x=[Cold], y=[Hot], f(x)=dy/dt'
         Z(2) = 'f(x) = {p(1)/[p(n+1) + x] + p(2)/[p(n+2) + x]'
         Z(3) = '         +...+ p(n)/[p(2n) + x]} + C, n ='//WORD3
         Z(4) =
     +  'p(i) = Vmax(i)*y, p(n+i) = Km(i) + y, [Hot] subsumed'
      ENDIF
      CALL ADDCON (NFIX, NPAR, CONST)
  100 FORMAT (
     + 'This model can be used in one of three alternative modes.'
     +/
     +/'The variable x can be free substrate when f(x) would be the'
     +/'initial rate dP/dt, or x can be unlabelled substrate used'
     +/'to compete with a fixed labelled substrate, i.e. f(x) would'
     +/'be initial rate for labelled substrate. Fixed [Hot] can be'
     +/'input or subsumed into parameters. Avoid adding a constant,'
     +/'if possible, by data transformation.'
     +/'x=[Free substrate], f(x)=d[P]/dt'
     +/'x=[Cold], f(x)=d[Hot]/dt, [Hot] input'
     +/'x=[Cold], f(x)=d[Hot]/dt, [Hot] subsumed')
      END
C
C
      SUBROUTINE QNS104 (NFIX, NMOD, NPAR, NX, B, Z, CONST)
C      ... Sum of High/Low affinity binding sites plus a constant
      IMPLICIT   NONE
      INTEGER    NFIX, NMOD, NPAR, NX
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(12), NUMPOS(4)
      DOUBLE PRECISION B(NX)
      DOUBLE PRECISION ZERO, TWO, FOUR
      PARAMETER (ZERO = 0.0D+00, TWO = 2.0D+00, FOUR = 4.0D+00)
      CHARACTER  Z(24)*80
      CHARACTER  TEXT(30)*100, WORD3*3, WORD10*10
      LOGICAL    CONST
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   GETJM1, ADDCON, LBOX01, GETRGT
      INTRINSIC  MIN
      DATA NUMBLD / 1*1, 11*0 /
      DATA NUMPOS / 4*1 /
      WRITE (TEXT,100)
      NSTART = 9
      NUMOPT = 3
      NTEXT = 11
      NUMDEC = 1
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +             NUMOPT, NUMPOS, NSTART, NTEXT, TEXT,
     +             BORDER, FLASH, HIGH)
      NPAR = 1
      NMOD = 1
      CALL GETJM1 (NPAR, NMOD, MIN(10,(NX - 1)/2),
     +'Number of H/L terms required in the summation (i.e. n)')
      NPAR = 2*NMOD
      WRITE (WORD3,'(I3)') NMOD
      IF (NUMDEC.EQ.1) THEN
         B(1) = ZERO
         B(2) = ZERO
         Z(1) =
     +   'Sum of n H/Ls; C = p(2n+1), x = [Free ligand], y = saturation'
         Z(2) =
     +   'f(x) = p(1)p(n+1)x/[1 + p(n+1)x] + p(2)p(n+2)x/[1 + p(n+2)x]'
         Z(3) =
     +   '        + ... + p(n)p(2n)x/[1 + p(2n)x] + C, n ='//WORD3
         Z(4) = 'p(i) = fraction(i), p(n + i) = Ka, for i = 1 to n'
      ELSEIF (NUMDEC.EQ.2) THEN
         B(1) = TWO
         CALL GETRGT (B(2), ZERO,
     +'Fixed [Hot], i.e. constant labelled ligand conc. used')
         WRITE (WORD10,'(1P,E10.3)') B(2)
         Z(1) =
     +   'Sum of n H/Ls; C=p(2n+1), x=[Cold], y=fixed [Hot], z=x+y'
         Z(2) =
     +   'f(x) = y{p(1)p(n+1)/[1 + p(n+1)z] + p(2)p(n+2)/[1 + p(n+2)z]'
         Z(3) =
     +  '+ ... + p(n)p(2n)/[1 + p(2n)z]} + C, p(i) = fracn., n ='//WORD3
         Z(4) = 'p(n + i) = Ka(i), for i = 1 to n, [Hot] ='//WORD10
      ELSE
         B(1) = FOUR
         B(2) = ZERO
         Z(1) =
     +   'Sum of n H/Ls; C=p(2n+1), x=[Cold], y=fixed [Hot]'
         Z(2) =
     +   'f(x) = {p(1)p(n+1)/[1 + p(n+1)x] + p(2)p(n+2)/[1 + p(n+2)x]'
         Z(3) =
     +  '+ ... + p(n)p(2n)/[1 + p(2n)x]} + C, p(i)=y*fracn.,n ='//WORD3
         Z(4) =
     +  'p(n + i) = Ka(i)/(1 + y*Ka(i)), [Hot] subsumed'
      ENDIF
      CALL ADDCON (NFIX, NPAR, CONST)
  100 FORMAT (
     + 'This model can be used in one of three alternative modes.'
     +/
     +/'The variable x can be free ligand when f(x) would be the'
     +/'saturation function, or x can be unlabelled substrate used'
     +/'to compete with a fixed labelled substrate, i.e. f(x) would'
     +/'be the saturation for labelled substrate. Fixed [Hot] can be'
     +/'input or subsumed into parameters. Avoid adding a constant,'
     +/'if possible, by data transformation.'
     +/'x=[Free ligand], f(x)=satn. function'
     +/'x=[Cold], f(x)=satn. [Hot] input'
     +/'x=[Cold], f(x)=satn. [Hot] subsumed')
      END
C
C
      SUBROUTINE QNS105 (NFIX, NMOD, NPAR, NX, B, Z, CONST)
C      ... Saturation function plus a constant (Association)
      IMPLICIT   NONE
      INTEGER    NFIX, NMOD, NPAR, NX
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(10), NUMPOS(2)
      DOUBLE PRECISION B(NX)
      DOUBLE PRECISION ZERO, TWO
      PARAMETER (ZERO = 0.0D+00, TWO = 2.0D+00)
      CHARACTER  Z(24)*80
      CHARACTER  TEXT(30)*100, WORD3*3, WORD10*10
      LOGICAL    CONST
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   GETJM1, ADDCON, GETRGT, LBOX01
      INTRINSIC MIN
      DATA NUMBLD / 1*1, 9*0 /
      DATA NUMPOS / 2*1 /
      WRITE (TEXT,100)
      NSTART = 9
      NUMOPT = 2
      NTEXT = 10
      NUMDEC = 1
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +             NUMOPT, NUMPOS, NSTART, NTEXT, TEXT,
     +             BORDER, FLASH, HIGH)
      NPAR = 1
      NMOD = 1
      CALL GETJM1 (NPAR, NMOD, MIN(10,NX - 2),
     +'Order of the binding function required (i.e. n)')
      NPAR = NMOD + 1
      WRITE (WORD3,'(I3)') NMOD
      IF (NUMDEC.EQ.1) THEN
         B(1) = ZERO
         Z(1) =
     +   'Order n sat.fn.; C = p(n+2), n ='//WORD3
         Z(2) = 'g(x) = p(n+1)[p(1)x + 2p(2)x^2 +...+ np(n)x^n]'
         Z(3) = 'h(x) = n[1 + p(1)x + p(2)x^2 +...+  p(n)x^n]'
         Z(4) = 'f(x) = g(x)/h(x) + C'
      ELSE
         B(1) = TWO
         CALL GETRGT (B(2), ZERO,
     +'Fixed [Hot], i.e. constant labelled ligand concentration used')
         WRITE (WORD10,'(1P,E10.3)') B(2)
         Z(1) =
     +'Order n sat.fn.; x = [Cold], y = [Hot], z = x + y, n ='//WORD3
         Z(2) = 'g(x) = p(n+1)y[p(1) + 2p(2)z +...+ np(n)z^{n-1}]'
         Z(3) = 'h(x) = n[1 + p(1)z + p(2)z^2 +...+  p(n)z^n]'
         Z(4) = 'f(x) = g(x)/h(x) + C, C = p(n+2), [Hot] ='//WORD10
      ENDIF
      CALL ADDCON (NFIX, NPAR, CONST)
  100 FORMAT (
     + 'This model can be used in one of two alternative modes.'
     +/
     +/'The variable x can be free ligand when f(x) would be the'
     +/'saturation function, or x can be unlabelled ligand used'
     +/'to displace a fixed labelled ligand, i.e. f(x) would be a'
     +/'saturation function for labelled species. The saturation'
     +/'functions can be scaled and displaced if required, but'
     +/'this should be avoided if possible by data scaling.'
     +/'x=[Free ligand], f(x)=Ligand saturation curve'
     +/'x=[Cold], f(x)=Hot-satn. inhibited by Cold')
      END
C
C
      SUBROUTINE QNS106 (NFIX, NMOD, NPAR, NX, B, Z, CONST)
C      ... Saturation function plus a constant (Adair)
      IMPLICIT   NONE
      INTEGER    NFIX, NMOD, NPAR, NX
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(10), NUMPOS(2)
      DOUBLE PRECISION B(NX)
      DOUBLE PRECISION ZERO, TWO
      PARAMETER (ZERO = 0.0D+00, TWO = 2.0D+00)
      CHARACTER  Z(24)*80
      CHARACTER  TEXT(30)*100, WORD3*3, WORD10*10
      LOGICAL    CONST
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL  GETJM1, ADDCON, GETRGT, LBOX01
      INTRINSIC MIN
      DATA NUMBLD / 1*1, 9*0 /
      DATA NUMPOS / 2*1 /
      WRITE (TEXT,100)
      NSTART = 9
      NUMOPT = 2
      NTEXT = 10
      NUMDEC = 1
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +             NUMOPT, NUMPOS, NSTART, NTEXT, TEXT,
     +             BORDER, FLASH, HIGH)
      NPAR = 1
      NMOD = 1
      CALL GETJM1 (NPAR, NMOD, MIN(10,NX - 2),
     +'Order of the binding function required (i.e. n)')
      NPAR = NMOD + 1
      WRITE (WORD3,'(I3)') NMOD
      IF (NUMDEC.EQ.1) THEN
         B(1) = ZERO
         Z(1) =
     +   'Order n sat.fn.; C = p(n+2), n ='//WORD3
         Z(2) =
     +   'As for model 5 but p(i) are Adair coefficients'
         Z(3) =
     +   'f(x) = [1/n]p(n+1){dlog[q(x)]/dlog(x)} + C; where'
         Z(4) =
     +   'q(x) = 1 + p(1)x + p(1)p(2)x^2 +...+ p(1)p(2)...p(n)x^n'
      ELSE
         B(1) = TWO
         CALL GETRGT (B(2), ZERO,
     +'Fixed [Hot], i.e. constant labelled ligand concentration used')
         WRITE (WORD10,'(1P,E10.3)') B(2)
         Z(1) =
     +'Order n sat.fn.; C=p(n+2), x=[Cold], y=[Hot], z=x+y, n ='//WORD3
         Z(2) =
     +'As for model 5 but p(i) are Adair coefficients, [Hot]='//WORD10
         Z(3) =
     +   'f(x) = [y/z][1/n]p(n+1){dlog[q(z)]/dlog(z)} + C; where'
         Z(4) =
     +   'q(z) = 1 + p(1)z + p(1)p(2)z^2 +...+ p(1)p(2)...p(n)z^n'
      ENDIF
      CALL ADDCON (NFIX, NPAR, CONST)
  100 FORMAT (
     + 'This model can be used in one of two alternative modes.'
     +/
     +/'The variable x can be free ligand when f(x) would be the'
     +/'saturation function, or x can be unlabelled ligand used'
     +/'to displace a fixed labelled ligand, i.e. f(x) would be a'
     +/'saturation function for labelled species. The saturation'
     +/'functions can be scaled and displaced if required, but'
     +/'this should be avoided if possible by data scaling.'
     +/'x=[Free ligand], f(x)=Ligand saturation curve'
     +/'x=[Cold], f(x)=Hot-satn. inhibited by Cold')
      END
C
C
      SUBROUTINE QNS107 (NFIX, NMOD, NPAR, NX, B, Z, CONST)
C      ... Exponential functions plus a constant
      IMPLICIT   NONE
      INTEGER    NFIX, NMOD, NPAR, NX
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(2), NUMPOS(2)
      DOUBLE PRECISION B(NX)
      DOUBLE PRECISION ZERO, TWO
      PARAMETER (ZERO = 0.0D+00, TWO = 2.0D+00)
      CHARACTER  Z(24)*80
      CHARACTER  TEXT(30)*100
      LOGICAL    CONST
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   GETJM1, ADDCON, LBOX01
      INTRINSIC  MIN
      DATA NUMBLD / 2*0 /
      DATA NUMPOS / 2*1 /
      WRITE (TEXT,100)
      NSTART = 1
      NUMOPT = 2
      NTEXT = 2
      NUMDEC = 1
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +             NUMOPT, NUMPOS, NSTART, NTEXT, TEXT,
     +             BORDER, FLASH, HIGH)
      NMOD = NUMDEC
      IF (NMOD.EQ.1) THEN
         B(1) = ZERO
         Z(1) = 'Sum of n exponentials; C = p(2n+1)'
         Z(3) = 'p(1)exp[-p(n+1)x] + p(2)exp[-p(n+2)x] +...+'
         Z(4) = 'p(n)exp[-p(2n)x] + C'
      ELSE
         B(1) = TWO
         Z(1) = 'Sum of n exponentials; C = p(2n+1)'
         Z(3) = 'p(1){1-exp[-p(n+1)x]} + p(2){1-exp[-p(n+2)x]} +...+'
         Z(4) = 'p(n){1-exp[-p(2n)x]} + C'
      ENDIF
      NPAR = 1
      NMOD = 1
      CALL GETJM1 (NPAR, NMOD, MIN(10,(NX - 1)/2),
     +'No. of exponential terms required in the summation (i.e. n)')
      NPAR = 2*NMOD
      CALL ADDCON (NFIX, NPAR, CONST)
  100 FORMAT (
     + 'Fit p(i)exp(-p(n+i)x) + ...'
     +/'Fit p(i)[1 - exp(-p(n+i)x)] +...')
      END
C
C
      SUBROUTINE QNS108 (NFIX, NMOD, NPAR, NX, B, Z, CONST)
C      ... Sum of trigonometrics plus a constant
      IMPLICIT   NONE
      INTEGER    NFIX, NMOD, NPAR, NX
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(2), NUMPOS(2)
      DOUBLE PRECISION B(NX)
      DOUBLE PRECISION ZERO, TWO
      PARAMETER (ZERO = 0.0D+00, TWO = 2.0D+00)
      CHARACTER  Z(24)*80
      CHARACTER  TEXT(30)*100
      LOGICAL    CONST
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   ADDCON, GETJM1, LBOX01
      INTRINSIC  MIN
      DATA NUMBLD / 2*0 /
      DATA NUMPOS / 2*1 /
      WRITE (TEXT,100)
      NSTART = 1
      NUMOPT = 2
      NTEXT = 2
      NUMDEC = 1
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +             NUMOPT, NUMPOS, NSTART, NTEXT, TEXT,
     +             BORDER, FLASH, HIGH)
      NMOD = NUMDEC
      IF (NMOD.EQ.1) THEN
         B(1) = ZERO
         Z(1) = 'Sum of n sines: C = p(3n+1)'
         Z(2) = 'p(1)sin[p(n+1)x + p(2n+1)] +'
         Z(3) = 'p(2)sin[p(n+2)x + p(2n+2)] +...+'
         Z(4) = 'p(n)sin[p(2n)x + p(3n)] + C'
      ELSE
         B(1) = TWO
         Z(1) = 'Sum of n cosines: C = p(3n+1)'
         Z(2) = 'p(1)cos[p(n+1)x + p(2n+1)] +'
         Z(3) = 'p(2)cos[p(n+2)x + p(2n+2)] +...+'
         Z(4) = 'p(n)cos[p(2n)x + p(3n)] + C'
      ENDIF
      NSTART = 1
      NMOD = 1
      CALL GETJM1 (NSTART, NMOD, MIN(10,(NX - 1)/3),
     +'No. of trigonometrics required in the summation (i.e. n)')
      NPAR = 3*NMOD
      CALL ADDCON (NFIX, NPAR, CONST)
  100 FORMAT (
     + 'Fit p(i)sin[p(n+i)x + p(2n+i)] +...'
     +/'Fit p(i)cos[p(n+i)x + p(2n+i)] +...')
      END
C
C
      SUBROUTINE QNS109 (NFIX, NMOD, NPAR, NX, B, Z, CONST)
C      ... Sum of Gaussians plus a constant
c      ... parameter B(1) returns the model type       
      IMPLICIT   NONE
      INTEGER    NFIX, NMOD, NPAR, NX
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IXL = 0, IYL = 0, LSHADE = 1, NUMOPT = 6,
     +           NSTART = 17, NTEXT = NUMOPT + NSTART - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    KVALUE(NUMOPT), KLIM_1(NUMOPT), KLIM_2(NUMOPT)
      DOUBLE PRECISION B(NX)
      DOUBLE PRECISION XVALUE(NUMOPT)
      DOUBLE PRECISION ZERO, TWO
      PARAMETER (ZERO = 0.0D+00, TWO = 2.0D+00)
      CHARACTER  Z(24)*80
      CHARACTER  TEXT(30)*100
      CHARACTER (LEN = 1) BLANK, SVALUE(NUMOPT) 
      PARAMETER (BLANK = ' ')
      LOGICAL    CONST
      LOGICAL    FIXED, FULL, HIGH
      PARAMETER (FIXED = .FALSE., FULL = .FALSE., HIGH = .TRUE.)
      EXTERNAL   GET00X 
      INTRINSIC  MIN
      DATA NUMBLD / NTEXT*0 /
      DATA NUMPOS / NUMOPT*1 /
      DATA XVALUE / NUMOPT*ZERO /
      DATA SVALUE / NUMOPT*BLANK /
      DATA KVALUE / 1*1, 5*0 /
      DATA KLIM_1 / NUMOPT*1 /
      DATA KLIM_2 / NUMOPT*3 /
      DATA NUMPOS / 4*6, 1*8, 1*9 /
      KVALUE(1) = 1
      KVALUE(2) = 0
      KVALUE(3) = 0
      KVALUE(4) = 0
      KLIM_2(6) = MIN(10,NX/3 - 1)
      KVALUE(6) = MIN(3,KLIM_2(6))
      WRITE (TEXT,100)
      NUMBLD(1) = 4
      NUMBLD(3) = 1
      CALL GET00X (ICOLOR, IXL,IYL, KVALUE, KLIM_1, KLIM_2, LSHADE,
     +             NUMBLD, NUMOPT, NUMPOS, NSTART, NTEXT,
     +             XVALUE,
     +             SVALUE, TEXT,
     +             FIXED, FULL, HIGH) 
      IF (KVALUE(1).EQ.1) THEN
         B(1) = ZERO
         Z(1) = 'Sum of n Gauss pdfs: Z = sqrt(2pi)'
         Z(2) = '[p(1)/{Zp(2n+1)}]exp{-0.5[(x - p(n+1))/p(2n+1)]^2} +'
         Z(3) =
     +'[p(2)/{Zp(2n+2)}]exp{-0.5[(x - p(n+2))/p(2n+2)]^2} +...+'
         Z(4) = '[p(n)/{Zp(3n)}]exp{-0.5[(x - p(2n))/p(3n)]^2}'
      ELSEIF (KVALUE(2).EQ.1) THEN
         B(1) = ZERO
         Z(1) = 'Sum of n Gauss pdfs: Z = sqrt(2pi), C = p(3n+1)'
         Z(2) = '[p(1)/{Zp(2n+1)}]exp{-0.5[(x - p(n+1))/p(2n+1)]^2} +'
         Z(3) =
     +'[p(2)/{Zp(2n+2)}]exp{-0.5[(x - p(n+2))/p(2n+2)]^2} +...+'
         Z(4) = '[p(n)/{Zp(3n)}]exp{-0.5[(x - p(2n))/p(3n)]^2} + C'   
      ELSEIF (KVALUE(3).EQ.1) THEN
         B(1) = TWO
         Z(1) = 'Sum of n Gauss cdfs: Z = sqrt(2pi)'
         Z(2) =
     +  'INTEGRAL[p(1)/{Zp(2n+1)}]exp{-0.5[(x - p(n+1))/p(2n+1)]^2} +'
         Z(3) =
     +'INTEGRAL[p(2)/{Zp(2n+2)}]exp{-0.5[(x - p(n+2))/p(2n+2)]^2} +...+'
         Z(4) =
     +   'INTEGRAL[p(n)/{Zp(3n)}]exp{-0.5[(x - p(2n))/p(3n)]^2}'   
      ELSE
         B(1) = TWO
         Z(1) = 'Sum of n Gauss cdfs: Z = sqrt(2pi), C = p(3n+1)'
         Z(2) =
     +  'INTEGRAL[p(1)/{Zp(2n+1)}]exp{-0.5[(x - p(n+1))/p(2n+1)]^2} +'
         Z(3) =
     +'INTEGRAL[p(2)/{Zp(2n+2)}]exp{-0.5[(x - p(n+2))/p(2n+2)]^2} +...+'
         Z(4) =
     +   'INTEGRAL[p(n)/{Zp(3n)}]exp{-0.5[(x - p(2n))/p(3n)]^2} + C'
      ENDIF
      
      NMOD = KVALUE(NUMOPT)
      NPAR = 3*KVALUE(NUMOPT) 
     
      IF (KVALUE(1).EQ.1 .OR. KVALUE(3).EQ.3) THEN
         CONST = .FALSE.
         NFIX = 1
      ELSE
         CONST = .TRUE.
         NFIX = 0
         NPAR = NPAR + 1
      ENDIF
      
  100 FORMAT (
     + 'Fitting sums of Gaussian models (normal distributions)'
     +/
     +/'Note the following advice.'
     +/
     +/'1.`Standard deviations must be constrained to be positive'
     +/'2.`Means and standard deviations occur in exponential'
     +/'  `arguments and must be constrained to prevent overflow' 
     +/'3.`Fit pdfs to histogram type grouped data'
     +/'4.`Fit cdfs to sample cumulative type data'
     +/'5.`Variable amplitudes are provided to fit samples from'
     +/'  `unknown arbitrary mixtures of distributions'
     +/'6.`Otherwise fix amplitudes to the known proportions' 
     +/'7.`A constant term can be added for background correction' 
     +/'8.`Random samples for single models are best fitted'
     +/'  `using the Simfit statistical options'
     +/
     +/'Fit pdfs (spikes, i.e. derivatives)'
     +/'Fit pdfs (spikes, i.e. derivatives) plus a background constant'
     +/'Fit cdfs (sigmoids, i.e. integrals)'
     +/'Fit cdfs (sigmoids, i.e. integrals) plus a background constant'
     +/
     +/'Number of Gaussians required')
      END
C
C

     