C
C Sublevel 2 routines for QNSUB1
C ==============================
C To be consistent this version must have MODNAM dimensioned MODNAM(24)*80
C 14/10/2001 changed Z(*)*(*) to Z(24)*80
C 04/06/2005 new logistic growth parameterisation
C 05/01/2010 added substrate depletion
C
C
      SUBROUTINE QNS110 (NFIX, NMOD, NPAR, NX, B, Z, CONST)
C      ... Selection A ... Biological
      IMPLICIT   NONE
      INTEGER    NFIX, NMOD, NPAR, NX
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(20), NUMPOS(20)
      DOUBLE PRECISION B(NX)
      DOUBLE PRECISION ZERO, TWO, FOUR, SIX
      PARAMETER (ZERO = 0.0D+00, TWO = 2.0D+00, FOUR = 4.0D+00,
     +           SIX = 6.0D+00)
      CHARACTER  Z(24)*80
      CHARACTER  TEXT(30)*100
      LOGICAL    CONST
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   ADDCON, LBOX01
      DATA NUMBLD / 20*0 /
      DATA NUMPOS / 20*1 /
      CONST = .FALSE.
      WRITE (TEXT,100)
      NSTART = 4
      NUMOPT = 9
      NTEXT = NSTART + NUMOPT - 1
      NUMDEC = NUMOPT
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      NMOD = NUMDEC
      IF (NMOD.EQ.1) THEN
         NPAR = 2
         WRITE (TEXT,200)
         NSTART = 3
         NUMOPT = 3
         NTEXT = NSTART + NUMOPT - 1
         NUMDEC = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         Z(1) = 'Exponential model; C = p(3)'
         IF (NUMDEC.EQ.1) THEN
            B(1) = ZERO
            Z(3) = 'f(x) = p(1)exp[-p(2)x]} + C'
         ELSEIF (NUMDEC.EQ.2) THEN
            B(1) = TWO
            Z(3) = 'f(x) = exp[p(1) - p(2)x] + C'
         ELSE
            B(1) = FOUR
            Z(3) = 'f(x) = {p(1) - C}exp[-p(2)x] + C'
         ENDIF
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.2) THEN
         NPAR = 2
         Z(1) = 'Monomolecular model; C = p(3)'
         Z(3) = 'p(1){1 - exp[-p(2)x]} + C'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.3) THEN
         NPAR = 3
         WRITE (TEXT,300)
         NSTART = 3
         NUMOPT = 4
         NTEXT = NSTART + NUMOPT - 1
         NUMDEC = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT, 
     +                BORDER, FLASH, HIGH)
         Z(1) = 'Logistic model; C = p(4)'
         IF (NUMDEC.EQ.1) THEN
            B(1) = ZERO
            Z(3) = 'f(x) = p(1)/{1 + p(2)exp[-p(3)x]} + C'
         ELSEIF (NUMDEC.EQ.2) THEN
            B(1) = TWO
            Z(3) = 'f(x) = p(1)/{1 + exp[p(2) - p(3)x]} + C'
         ELSEIF (NUMDEC.EQ.3) THEN
            B(1) = FOUR
            Z(3) = 'f(x) = p(1)/{1 + exp[-p(3)(x - p(2)]} + C'
         ELSE
            B(1) = SIX
            Z(3) = 'f(x) = p(1)/{1 + exp-[p(2) + p(3)x]} + C'
         ENDIF
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.4) THEN
         NPAR = 3
         Z(1) = 'Gompertz model; C = p(4)'
         Z(3) = 'p(1)*exp{-p(2)exp[-p(3)x]} + C'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.5) THEN
         NPAR = 4
         Z(1) = 'Richards model; C = p(5)'
         Z(2) =
     + 'f(x) = {p(1)^(1-m) - p(2)exp[-p(3)x]}^[1/(1-m)] + C'
         Z(3) = 'm = p(4) (fix at m = 2/3 for Von Bertalannfy 2/3)'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.6) THEN
         NPAR = 5
         Z(1) = 'Preece and Baines model 1'
         Z(2) =
     + 'g(x) = exp{p(1)[x - p(3)]} + exp{p(2)[x - p(3)]}'
         Z(3) = 'f(x) = p(4) - 2[p(4) - p(5)]/g(x)'
      ELSEIF (NMOD.EQ.7) THEN
         NPAR = 3
         WRITE (TEXT,400)
         NSTART = 3
         NUMOPT = 4
         NTEXT = NSTART + NUMOPT - 1
         NUMDEC = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         Z(1) =
     +'Weibull survival model, where x is time and f(x) is the number'
         Z(2) = 'or else the % of population still surviving at time x'
         IF (NUMDEC.EQ.1) THEN
            B(1) = ZERO
            Z(3) =
     +'f(x) = p(1)*exp-{p(2)*[x]^p(3)} + p(4): fix p(4)=0, p(3)=1'
         ELSEIF (NUMDEC.EQ.2) THEN
            Z(3) =
     +'f(x) = p(1)*exp-{[x]^p(3)/p(2)} + p(4): fix p(4)=0, p(3)=1'
            B(1) = TWO
         ELSEIF (NUMDEC.EQ.3) THEN
            B(1) = FOUR
            Z(3) =
     +'f(x) = p(1)*exp-{[p(2)*x]^p(3)} + p(4): fix p(4)=0, p(3)=1'
         ELSE
            B(1) = SIX
            Z(3) =
     +'f(x) = p(1)*exp-{exp(p(2))*[x]^p(3)}+p(4): fix p(4)=0, p(3)=1'
         ENDIF
         Z(4) =
     +'for exponential survival, fix p(1)=100 for 100% survival at x=0'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.8) THEN
         NPAR = 3
         Z(1) =
     +'Gompertz survival model, where x is time and f(x) is the number'
         Z(2) = 'or else the % of population still surviving at time x'
         Z(3) =
     +'f(x) = p(1)*exp-[p(2)/p(3)]{exp(p(3)*x) - 1} + p(4):  p(i) >= 0'
         Z(4) = 'fix p(1) = 100, p(4) = 0 for 100% survival at x = 0'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.9) THEN
         NMOD = - 1
      ENDIF
  100 FORMAT (
     + 'GCFIT fits growth curves 1 to 6'
     +/'Fix m=p(4)=2/3 in 5 for Von Bertalannfy 2/3'
     +/
     +/'Exponential growth/decay model'
     +/'Monomolecular growth model'
     +/'Logistic growth model'
     +/'Gompertz growth model'
     +/'Richards growth model'
     +/'Preece and Baines growth model'
     +/'Weibull survival model'
     +/'Gompertz survival model'
     +/'Cancel')
  200 FORMAT (
     + 'Choose the parameterization required'
     +/
     +/'p(1)exp-[p(2)x] + p(3)'
     +/'exp[p(1) - p(2)x] + p(3)'
     +/'{p(1) - p(3)}exp-[p(2)x] + p(3)')

  300 FORMAT (
     + 'Choose the parameterization required'
     +/
     +/'p(1)/{1 + p(2)*exp-[p(3)x]} + p(4)'
     +/'p(1)/{1 + exp[p(2) - p(3)x]} + p(4)'
     +/'p(1)/{1 + exp-[p(3)(x - p(2))]} + p(4)'
     +/'p(1)/{1 + exp-[p(2) + p(3)x]} + p(4)')
  400 FORMAT (
     + 'Choose the parameterization required'
     +/
     +/'p(1)*exp-{p(2)[x]^p(3)} + p(4)'
     +/'p(1)*exp-{[x]^p(3)/p(2)} + p(4)'
     +/'p(1)*exp-{[p(2)*x]^p(3)} + p(4)'
     +/'p(1)*exp-{exp(p(2))*[x]^p(3)} + p(4)')
      END
C
C
      SUBROUTINE QNS111 (NFIX, NMOD, NPAR, NX,
     +                   B, Z,
     +                   CONST)
C      ... Selection B ... Biochemical
      IMPLICIT   NONE
      INTEGER    NFIX, NMOD, NPAR, NX
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NTEMP, NUMBLD(20), NUMPOS(20)
      INTEGER    N1, N20
      PARAMETER (N1 = 1, N20 = 20)
      DOUBLE PRECISION B(NX)
      DOUBLE PRECISION ZERO, TWO, FOUR
      PARAMETER (ZERO = 0.0D+00, TWO = 2.0D+00, FOUR = 4.0D+00)
      CHARACTER  Z(24)*80
      CHARACTER  LABEL*2, TEXT(30)*100, word10*10
      LOGICAL    CONST
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      INTRINSIC  DBLE
      EXTERNAL   ADDCON, GETJM1, LBOX01, GETRGT
      DATA NUMBLD / 20*0 /
      DATA NUMPOS / 20*1 /
      WRITE (TEXT,100)
      NSTART = 8
      NUMOPT = 8
      NTEXT = NSTART + NUMOPT - 1
      NUMDEC = NUMOPT
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      NMOD = NUMDEC
      IF (NMOD.EQ.1) THEN
         NTEMP = 1
         CALL GETJM1 (N1, NTEMP, N20,
     +'Degree n required (i.e. no. sites)')
         WRITE (LABEL,'(I2)') NTEMP
         B(1) = DBLE(NTEMP)
         NPAR = 4
         Z(1) =
     +  'Monod Wyman Changeux: K=p(1), c=p(2) < 1, L=p(3), Vmax=p(4)'
         Z(2) =
     +   'g(x) = p(1)p(4)x{[1+p(1)x]^n-1 + p(2)p(3)[1+p(1)p(2)x]^n-1)}'
         Z(3) = 'h(x) = [1 + p(1)x]^n + p(3)[1 + p(1)p(2)x]^n'
         Z(4) = 'f(x) = g(x)/h(x), degree n = '//LABEL
      ELSEIF (NMOD.EQ.2) THEN
         NPAR = 3
         Z(1) = 'Lag phase to steady state model; C = p(4)'
         Z(3) = 'p(1)x + p(2){1 - exp[-p(3)x]} + C'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.3) THEN
         NPAR = 2
         Z(1) =
     +  'Set of identical binding sites: x = TOTAL ligand conc.,'
         Z(2) =
     +  'dissociation const. Kd = p(1), total conc. sites = p(2)'
         Z(3) =
     +  'f(x) = 0.5{A - sqrt[A^2 - 4p(2)x]}/p(2), note 0=<f(x)=<1'
         Z(4) =
     +  '   A = [x + p(1) + p(2)]; p(2) can be fixed or varied'
      ELSEIF (NMOD.EQ.4) THEN
         NPAR = 3
         Z(1) =
     +  'Irreversible M-M P(t) progress curve (P(0) = 0)'
         Z(2) =
     +  'p(1) = Km, p(2) = Vmax, p(3) = Initial substrate conc.'
         Z(3) =
     +  'f(x) = product conc. (Note: f(0) = 0 and k-2 = 0)'
         Z(4) =
     +  'p(1)*ln[p(3)/(p(3) - f(x))] + f(x) - p(2)*x = 0'
      ELSEIF (NMOD.EQ.5) THEN
         NPAR = 3
         Z(1) =
     +  'Irreversible M-M S(t) depletion curve (P(0) = 0)'
         Z(2) =
     +  'p(1) = Km, p(2) = Vmax, p(3) = Initial substrate conc.'
         Z(3) =
     +  'f(x) = product conc. (Note: f(0) = 0 and k-2 = 0)'
         Z(4) =
     +  'p(1)*ln[f(x)/p(3)] + f(x) - p(3) + p(2)*x = 0'     
      ELSEIF (NMOD.EQ.6) THEN
         WRITE (TEXT,200)
         NSTART = 10
         NUMOPT = 3
         NTEXT = NSTART + NUMOPT - 1
         NUMDEC = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NPAR = 3
         IF (NUMDEC.EQ.1) THEN
            B(1) = ZERO
            B(2) = ZERO
            Z(1) =
     +'Michaelis-Menten plus diffusion, x = [S], f(x) = dP/dt'
            Z(2) = 'f(x) = p(1)x/[p(2) + x] + p(3)x'
            Z(3) = 'p(1) = Vmax, p(2) = Km'
            Z(4) = 'p(3) = D'
         ELSEIF (NUMDEC.EQ.2) THEN
            B(1) = TWO
            CALL GETRGT (B(2), ZERO,
     +'Fixed [Hot], i.e. constant labelled substrate conc. used')
            WRITE (WORD10,'(1P,E10.3)') B(2)
            Z(1) =
     +'Michaelis-Menten plus diffusion, y=[Hot], x=[Cold], f(x) = dy/dt'
            Z(2) = 'f(x) = p(1)y/[p(2) + y + x] + p(3)y'
            Z(3) = 'p(1) = Vmax, p(2) = Km'
            Z(4) = 'p(3) = D, [Hot] (input) ='//WORD10
         ELSE
            B(1) = FOUR
            B(2) = ZERO
            Z(1) =
     +'Michaelis-Menten plus diffusion, y=[Hot], x=[Cold], f(x) = dy/dt'
            Z(2) = 'f(x) = p(1)/[p(2) + x] + p(3)'
            Z(3) = 'p(1) = Vmax*y, p(2) = Km + y'
            Z(4) = 'p(3) = D*y, [Hot] subsumed'
         ENDIF
      ELSEIF (NMOD.EQ.6) THEN
         NPAR = 2
         Z(1) =
     +  'Generalized model-free inhibition curve'
         Z(2) = 'p(1)/[p(2) + x]'
         Z(3) = 'x = [Inhibitor]'
      ELSE
         NMOD = - 1
      ENDIF
  100 FORMAT (
     + 'Program INRATE may be easier to use to fit model 2.'
     +/'The equations for models 4 and 5 are solved numerically but'
     +/'they can also be fitted as differential equations. In both'
     +/'cases use units such that S(0) and time are of order unity and'
     +/'constrain Vmax, Km and S(0) to be > 0. Note that P(0) = 0.'
     +/'Model 7 can be competitive/uncompetitive, etc.'
     +/
     +/'1. Monod Wyman Changeux allosterism'
     +/'2. Lag phase to steady-state (coupled assay)'
     +/'3. Identical sites: x = TOTAL ligand conc.'
     +/'4. Michaelis-Menten P(t) progress curve (P(0) = 0, k-2 = 0)'
     +/'5. Michaelis-Menten S(t) depletion curve (P(0) = 0, k-2 = 0)'
     +/'6. Michaelis-Menten transport plus a diffusion term'
     +/'7. Generalized inhibitor model, x = [inhibitor]'
     +/'Cancel')
  200 FORMAT (
     + 'This model can be used in one of three alternative modes.'
     +/
     +/'The variable x can be free substrate when f(x) would be the'
     +/'initial rate dP/dt, or x can be unlabelled substrate used'
     +/'to compete with a fixed labelled substrate, i.e. f(x) would'
     +/'be initial rate for labelled substrate. Fixed [Hot] can be'
     +/'input or subsumed into parameters.'
     +/'The model has three parameters, Vmax, Km, and D.'
     +/
     +/'x=[Free substrate], f(x)=d[P]/dt'
     +/'x=[Cold], f(x)=d[Hot]/dt, [Hot] input'
     +/'x=[Cold], f(x)=d[Hot]/dt, [Hot] subsumed')
      END
C
C
      SUBROUTINE QNS112 (NFIX, NMOD, NPAR, NX, B, Z, CONST)
C      ... Selection C ... Chemistry
      IMPLICIT   NONE
      INTEGER    NFIX, NMOD, NPAR, NX
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(20), NUMPOS(20)
      DOUBLE PRECISION B(NX)
      DOUBLE PRECISION ZERO, TWO, FOUR
      PARAMETER (ZERO = 0.0D+00, TWO = 2.0D+00, FOUR = 4.0D+00)
      CHARACTER  Z(24)*80
      CHARACTER  TEXT(30)*100
      LOGICAL    CONST
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01, ADDCON
      DATA NUMBLD / 20*0 /
      DATA NUMPOS / 20*1 /
      WRITE (TEXT,100)
      NSTART = 1
      NUMOPT = 8
      NTEXT = 8
      NUMDEC = NUMOPT
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      NMOD = NUMDEC
      IF (NMOD.EQ.1) THEN
         NPAR = 2
         Z(1) = 'Arrhenius rate constant law: x = T (deg. Kelvin)'
         Z(2) = 'p(1)exp[-p(2)/x]'
         Z(3) =
     +   'p(1) = pre-exponential factor (temperature independent)'
         Z(4) =
     +   'p(2) = Ea/R (activation energy/gas constant)'
      ELSEIF (NMOD.EQ.2) THEN
         NPAR = 3
         Z(1) =
     +   'f(x) = p(1){x^p(3)}exp[-p(2)/x]: x = T (deg. Kelvin)'
         Z(2) =
     +   'p(1) = transition state pre-exponential factor'
         Z(3) =
     +   'p(2) = deltaG(act)/R i.e. activation free energy/gas constant'
         Z(4) =
     +   'p(3) = exponent to be fixed as required (e.g. 1) or varied'
      ELSEIF (NMOD.EQ.3) THEN
         NPAR = 4
         Z(1) =
     +'f(x)=B in A-->B-->C, p(1)=k1, p(2)=k2, p(3)=A0, p(4)=B0'
         Z(2) =
     +'[k1*A0/(k2-k1)]exp(-k1*x) + [B0 - k1*A0/(k2-k1)]exp(-k2*x)'
         Z(3) =
     +'[k*A0*x + B0]exp(-k*x); k1=k2=k'
      ELSEIF (NMOD.EQ.4) THEN
         NPAR = 5
         Z(1) =
     +'f(x)=C in A-->B-->C, p(1)=k1, p(2)=k2, p(3)=A0, p(4)=B0, p(5)=C0'
         Z(2) = 'A0 + B0 + C0 - [k2*A0/(k2-k1)]exp(-k1*x)'
         Z(3) = '- [B0 - k1*A0/(k2-k1)]exp(-k2*x)'
         Z(4) =
     +'A0 + B0 + C0 + [k*A0x + A0 + B0]exp(-k*x); k1=k2=k'
      ELSEIF (NMOD.EQ.5) THEN
         NPAR = 4
         Z(1) =
     +'f(x)=B in A<==>B, p(1)=k1, p(2)=k-1, p(3)=A0, p(4)=B0'
         Z(3) =
     +'{k1(A0 + B0) + (k-1*B0 - k1*A0)exp[-(k1 + k-1)x]}/(k1 + k-1)'
      ELSEIF (NMOD.EQ.6) THEN
         NPAR = 3
         WRITE (TEXT,200)
         NSTART = 1
         NUMOPT = 3
         NTEXT = 3
         NUMDEC = NUMOPT
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         Z(1) = 'x = [H], p(1) = K_1, p(2) = K_2'
         IF (NUMDEC.EQ.1) THEN
            B(1) = ZERO
            Z(3) = 'p(3)(1 + p(1)/x + p(1)p(2)/x^2) + p(4)'
         ELSEIF (NUMDEC.EQ.2) THEN
            B(1) = TWO
            Z(3) = 'p(3)(1 + x/p(1) + p(2)/x) + p(4)'
         ELSEIF (NUMDEC.EQ.3) THEN
            B(1) = FOUR
            Z(3) = 'p(3)(1 + x/p(2) + x^2/(p(1)p(2))) + p(4)'
         ENDIF
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.7) THEN
         NPAR = 2
         Z(1) = 'Freundlich binding isotherm'
         Z(3) = 'p(1)x^{1/p(2)} + p(3)'
         Z(4) = 'p(2) can be fixed or varied and p(3) is optional'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSE
         NMOD = - 1
      ENDIF
  100 FORMAT (
     + 'Rate constant as f(T) (Arrhenius)'
     +/'Rate constant as f(T) (Transition state)'
     +/'B in A-->B-->C irreversibly'
     +/'C in A-->B-->C irreversibly'
     +/'B in A-->B reversibly'
     +/'Michaelis pH functions'
     +/'Freundlich binding isotherm'
     +/'Cancel')
  200 FORMAT (
     + 'f0 = alpha(1 + K1/[H] + K1K2/[H]^2) + beta'
     +/'f1 = alpha(1 + [H]/K1 + K2/[H]) + beta'
     +/'f2 = alpha(1 + [H]/K2 + [H]^2/(K1K2)) + beta')
      END
C
C
      SUBROUTINE QNS113 (NMOD, NPAR, Z)
C      ... Selection D ... Physical models
      IMPLICIT   NONE
      INTEGER    NMOD, NPAR
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(20), NUMPOS(20)
      CHARACTER  Z(24)*80
      CHARACTER  TEXT(30)*100
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01
      DATA NUMBLD / 20*0 /
      DATA NUMPOS / 20*1 /
      WRITE (TEXT,100)
      NSTART = 1
      NUMOPT = 8
      NTEXT = 8
      NUMDEC = NUMOPT
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      NMOD = NUMDEC
      IF (NMOD.EQ.1) THEN
         NPAR = 2
         Z(1) = 'f(x) = p(1)*erfc{0.5*x/sqrt[p(2)]}'
         Z(2) =
     +   'f(x) = concentration: x = distance from interface at time t'
         Z(3) =
     +   'Note that p(1) = f(0) and p(2) = Dt i.e. D = p(2)/t'
         Z(4) =
     +   'Divide p(2), s.e.p(2) by t for estimates of D and s.e.D'
      ELSEIF (NMOD.EQ.2) THEN
         NPAR = 3
         Z(1) = 'Full Mualen equation with m and n varied'
         Z(2) = 'f(x) = {1/[1 +  (alpha*x)^n]}^m'
         Z(4) = 'alpha = p(1), n = p(2) and m = p(3)'
      ELSEIF (NMOD.EQ.3) THEN
         NPAR = 2
         Z(1) = 'Short Mualen equation with m = 1 - 1/n'
         Z(2) = 'f(x) = {1/[1 +  (alpha*x)^n]}^m'
         Z(4) = 'alpha = p(1), n = p(2) and m = 1 - 1/n'
      ELSEIF (NMOD.EQ.4) THEN
         NPAR = 4
         Z(1) = 'Brittle-Ductile transformation'   
         Z(2) = 'from Charpy test data'   
         Z(4) = 'f(x) = p(1) + p(2)*tanh[(x- p(4))/p(3)]'   
      ELSEIF (NMOD.GE.5 .AND. NMOD.LE.7) THEN
         NPAR = 3
         IF (NMOD.EQ.5) THEN 
            Z(1) = 'Scaled Pabst-Einstein equation'
            Z(2) = 'f(x) = p(3)(1 - x/p(1))**(-p(1)p(2))' 
      Z(4) ='x < p(1), p(1) = phi_m, p(2) = B, p(3) is a scaling factor'  
         ELSEIF (NMOD.EQ.6) THEN 
            Z(1) = 'log_e Scaled Pabst-Einstein equation'
            Z(2) = 'f(x) = p(3)(1 - x/p(1))**(-p(1)p(2))' 
      Z(4) ='x < p(1), p(1) = phi_m, p(2) = B, p(3) is a scaling factor'  
         ELSEIF (NMOD.EQ.7) THEN 
            Z(1) = 'log_10 Scaled Pabst-Einstein equation'
            Z(2) = 'f(x) = log_10[p(3)(1 - x/p(1))**(-p(1)p(2))]' 
      Z(4) ='x < p(1), p(1) = phi_m, p(2) = B, p(3) is a scaling factor' 
         ENDIF 
      ELSE
         NMOD = - 1
      ENDIF
  100 FORMAT (
     + 'Estimation of a diffusion constant'
     +/'Mualen equation, m and n estimated',
     +/'Mualen equation, m = 1 - 1/n'
     +/'Brittle-Ductile transformation'
     +/'Scaled Pabst-Einstein equation'
     +/'log_e[Scaled Pabst-Einstein equation]'
     +/'log_10[Scaled Pabst-Einstein equation]'
     +/'Cancel')
      END
C
C
      SUBROUTINE QNS114 (NMOD, NPAR, Z)
C      ... Selection E ... Statistical
      IMPLICIT   NONE
      INTEGER    NMOD, NPAR
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(20), NUMPOS(20)
      CHARACTER  Z(24)*80
      CHARACTER  TEXT(30)*100
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01
      DATA NUMBLD / 20*0 /
      DATA NUMPOS / 20*1 /
      WRITE (TEXT,100)
      NSTART = 1
      NUMOPT = 7
      NTEXT = 7
      NUMDEC = NUMOPT
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      NMOD = NUMDEC
      IF (NMOD.EQ.1) THEN
C    ... pdfs for 1, 2, ..., 100
         WRITE (TEXT,200)
         NSTART = 1
         NUMOPT = 11
         NTEXT = 11
         NUMDEC = NUMOPT
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NMOD = NUMDEC
         IF (NMOD.EQ.1) THEN
            NPAR = 3
            Z(1) = 'Normal pdf'
            Z(2) =
     +      '{p(3)/(sqrt[2*pi]p(2))}exp{-0.5[(x - p(1))/p(2)]^2}'
            Z(3) = 
     +      'mu = p(1), sigma = p(2) > 0, p(3) = scaling factor > 0'
            Z(4) = 'Fix p(3) = 1 for Area(-infinity,infinity) = 1'
         ELSEIF (NMOD.EQ.2) THEN
            NPAR = 3
            Z(1) = 'Beta pdf, 0 =< x =< 1'
            Z(2) =
     +      '{p(3)Gamma(a+b)/Gamma(a)Gamma(b)}x^(a-1)[1 - x]^(b-1)'
         Z(3) = 'a = p(1) > 0, b = p(2) > 0, p(3) = scaling factor > 0'
            Z(4) = 'Fix p(3) = 1 for area = 1'
         ELSEIF (NMOD.EQ.3) THEN
            NPAR = 2
            Z(2) =
     +     'Exponential pdf: p(1)p(2)exp[-p(1)x]; p(1) > 0, x >= 0'
            Z(4) = 'Fix p(2) = 1 for area = 1'
         ELSEIF (NMOD.EQ.4) THEN
            NPAR = 3
            Z(1) = 'Cauchy pdf; p(2) > 0'
            Z(3) = 'p(3)/(pi*p(2)[1 + {[x - p(1)]/p(2)}^2])'
            Z(4) = 'Fix p(3) = 1 for area = 1'
         ELSEIF (NMOD.EQ.5) THEN
            NPAR = 3
            Z(1) = 'Logistic pdf; p(2) > 0'
            Z(3) =
     +     'p(3)exp{[x-p(1)]/p(2)}/{p(2)[1 + exp{[x-p(1)]/p(2)}]^2}'
            Z(4) = 'Fix p(3) = 1 for area = 1'
         ELSEIF (NMOD.EQ.6) THEN
            NPAR = 3
            Z(1) = 'Lognormal pdf; p(2) > 0, x > 0'
            Z(3) =
     +'{p(3)/[p(2)*x*sqrt(2*pi)]}exp{-0.5[(ln(x) - p(1))/p(2)]^2}'
            Z(4) = 'Fix p(3) = 1 for area = 1'
         ELSEIF (NMOD.EQ.7) THEN
            NPAR = 3
            Z(1) = 'Gamma pdf; p(1) > 0, p(2) > 0, x > 0'
            Z(3) = 'p(3)[p(1)^p(2)]*{x^[p(2)-1]}exp[-p(1)x]/gamma[p(2)]'
            Z(4) = 'Fix p(3) = 1 for area = 1'
         ELSEIF (NMOD.EQ.8) THEN
            NPAR = 2
            Z(1) = 'Rayleigh pdf; p(1) > 0, x > 0'
            Z(3) = 'p(2){x/[p(1)^2]}exp{-0.5[x/p(1)]^2}'
            Z(4) = 'Fix p(2) = 1 for area = 1'
         ELSEIF (NMOD.EQ.9) THEN
            NPAR = 2
            Z(1) = 'Maxwell pdf; p(1) > 0, x > 0'
            Z(3) = 'p(2)[sqrt(2/pi)]{x^2/[p(1)^3]}exp{-0.5[x/p(1)]^2}'
            Z(4) = 'Fix p(2) = 1 for area = 1'
         ELSEIF (NMOD.EQ.10) THEN
            NPAR = 3
            Z(1) = 'Weibull pdf; p(1) > 0, p(2) > 0, x >= 0'
            Z(3) =
     + 'p(3)[p(1)/p2]x^[p(1) - 1]exp{-[x^p(1)]/p(2)}'
            Z(4) = 'Fix p(3) = 1 for area = 1'
         ELSE
            NMOD = - 1
         ENDIF
      ELSEIF (NMOD.EQ.2) THEN
C     ... cdfs FOR 101, 102, 103, ..., 200
         WRITE (TEXT,300)
         NSTART = 1
         NUMOPT = 8
         NTEXT = 8
         NUMDEC = NUMOPT
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NMOD = NUMDEC
         NMOD = NMOD + 100
         IF (NMOD.EQ.101) THEN
            NPAR = 3
            Z(1) = 'Normal cdf'
            Z(2) = 'p(3)Phi((x - p(1))/p(2))): Phi(.) = normal cdf'
            Z(3) =
     +      'mu = p(1), sigma = p(2) > 0, p(3) = scaling factor > 0'
            Z(4) = 'Fix p(3) = 1 for 0 =< f(x) =< 1'
         ELSEIF (NMOD.EQ.102) THEN
            NPAR = 3
            Z(1) = 'Beta cdf'
            Z(2) = 'p(3)*integral(0 to x) of Beta pdf with'
            Z(3) =
     +      'a = p(1) > 0, b = p(2) > 0, p(3) = scaling factor > 0'
            Z(4) = 'Fix p(3) = 1 for f(1) = 1'
         ELSEIF (NMOD.EQ.103) THEN
            NPAR = 2
            Z(2) =
     +     'Exponential cdf: p(2){1 - exp[-p(1)x]}; p(1) > 0, x >= 0'
            Z(4) = 'Fix p(2) = 1 for f(infinity) = 1'
         ELSEIF (NMOD.EQ.104) THEN
            NPAR = 3
            Z(1) = 'Cauchy cdf; p(2) > 0'
            Z(3) = 'p(3)(0.5 + (1/pi)*arctan{[x - p(1)]/p(2)})'
            Z(4) = 'Fix p(3) = 1 for f(infinity) = 1'
         ELSEIF (NMOD.EQ.105) THEN
            NPAR = 3
            Z(1) = 'Logistic cdf; p(2) > 0'
            Z(3) = 'p(3)exp{[x-p(1)]/p(2)}/(1 + exp{[x-p(1)]/p(2)})'
            Z(4) = 'Fix p(3) = 1 for f(infinity) = 1'
         ELSEIF (NMOD.EQ.106) THEN
            NPAR = 3
            Z(1) = 'Lognormal cdf; p(2) > 0, x >= 0'
            Z(2) = 'p(3)*integral(0 to x) of Lognormal pdf with'
            Z(3) =
     +'mu = p(1), sigma = p(2) > 0, p(3) = scaling factor > 0, i.e.'
            Z(4) =
     +'log(x) distrb. N(mu,sigma^2). Fix p(3) = 1 for f(infinity) = 1'
         ELSEIF (NMOD.EQ.107) THEN
            NPAR = 3
            Z(1) = 'Weibull cdf; p(1) > 0, p(2) > 0, x >= 0'
            Z(3) = 'p(3){1 - exp(-[x^p(1)]/p(2))}'
            Z(4) = 'Fix p(3) = 1 for f(infinity) = 1'
         ELSE
            NMOD = - 1
         ENDIF
      ELSEIF (NMOD.EQ.3) THEN
C     .... Scope for further statistical models 201, 202, ...
         NMOD = 201
         NPAR = 2
         Z(1) = 'Logit Model in exponential format'
         Z(3) = '1/{1 + exp[-(p(1) + p(2)x)]}'
         Z(4) = 'Note: 0 =< f(x) =< 1'
      ELSEIF (NMOD.EQ.4) THEN
C     .... Scope for further statistical models 201, 202, ...
         NMOD = 202
         NPAR = 2
         Z(1) = 'Probit model in cdf format'
         Z(3) = 'Phi[p(1) + p(2)x] where Phi(.) = normal cdf'
         Z(4) = 'Note: 0 =< f(x) =< 1'
      ELSEIF (NMOD.EQ.5) THEN
C     .... Scope for further statistical models 201, 202, ...
         NMOD = 203
         NPAR = 5
         Z(1) = 'Sum of 2 Normal pdfs'
         Z(2) =
     +      '{p(3)/(sqrt[2*pi]p(2))}exp{-0.5[(x - p(1))/p(2)]^2} +'
         Z(3) =
     +'{[1 - p(3)]/(sqrt[2*pi]p(5))}exp{-0.5[(x - p(4))/p(5)]^2}'
         Z(4) = 
     +'Constrain 0 =< p(3) =< 1 for Area(-infinity,infinity) = 1'
      ELSEIF (NMOD.EQ.6) THEN
C     .... Scope for further statistical models 201, 202, ...
         NMOD = 204
         NPAR = 5
         Z(1) = 'Sum of 2 Normal cdfs'
         Z(2) = '     p(3)Phi[(x - p(1))/p(2)] +'
         Z(3) = '(1 - p(3)Phi[(x - p(4))/p(5)]: Phi(.) = Normal cdf' 
         Z(4) = 'Constrain 0 =< p(3) =< 1 for 0 =< f(x) =< 1'         
      ELSE
         NMOD = - 1
      ENDIF
  100 FORMAT (
     + 'Probability density functions'
     +/'Cumulative distribution functions'
     +/'Logit (0 =< f(x) =< 1 parameterization)'
     +/'Probit (0 =< f(x) =< 1 parameterization)'
     +/'Sum of 2 normal pdfs (0 =< Area =< 1 parameterization)'
     +/'Sum of 2 normal cfds (0 =< f(x) =< 1 parameterization)'
     +/'Cancel')
  200 FORMAT ('Normal pdf'
     +/'Beta pdf'
     +/'Exponential pdf'
     +/'Cauchy pdf'
     +/'Logistic pdf'
     +/'Lognormal pdf'
     +/'Gamma pdf'
     +/'Rayleigh pdf'
     +/'Maxwell pdf'
     +/'Weibull pdf'
     +/'Cancel')
  300 FORMAT ('Normal cdf'
     +/'Beta cdf'
     +/'Exponential cdf'
     +/'Cauchy cdf'
     +/'Logistic cdf'
     +/'Lognormal cdf'
     +/'Weibull cdf'
     +/'Cancel')
      END
C
C
      SUBROUTINE QNS115 (NFIX, NMOD, NPAR, NX, B, Z, CONST)
C      ... Selection F ... Empirical models
      IMPLICIT   NONE
      INTEGER    NFIX, NMOD, NPAR, NX
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(20), NUMPOS(20)
      DOUBLE PRECISION B(NX)
      CHARACTER  Z(24)*80
      CHARACTER  TEXT(30)*100
      LOGICAL    CONST
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   GETR01, ADDCON, LBOX01
      DATA NUMBLD / 20*0 /
      DATA NUMPOS / 20*1 /
      WRITE (TEXT,100)
      NSTART = 4
      NUMOPT = 12
      NTEXT = 15
      NUMDEC = NUMOPT
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      NMOD = NUMDEC
      IF (NMOD.EQ.1) THEN
         NPAR = 2
         Z(1) = 'Hill equation with n fixed; C = p(3), x > 0'
         Z(2) = 'f(x) = p(1)[x^n]/{p(2)^n + [x^n]} + C'
         Z(3) = 'i.e. with n fixed'
         CALL GETR01 (B(1),'Hill exponent n required')
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.2) THEN
         NPAR = 3
         Z(1) = 'Hill equation with n varied; C = p(4), x > 0'
         Z(2) = 'f(x) = p(1)[x^p(3)]/{p(2)^p(3) + [x^p(3)]} + C'
         Z(3) = 'i.e. with n varied'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.3) THEN
         NPAR = 2
         Z(1) = 'Power law; C = p(3), x > 0'
         Z(3) = 'p(1)[x^p(2)] + C'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.4) THEN
         NPAR = 1
         Z(1) = 'log10 law; C = p(2), x > 0'
         Z(3) = 'p(1)*log10(x) + C'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.5) THEN
         NPAR = 3
         Z(1) = 'Up/Down exponential; C = p(4)'
         Z(3) = 'p(3){exp[-p(1)x] - exp[-p(2)x]} + C'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.6) THEN
         NPAR = 5
         Z(1) = 'Up/Down logistic; C = p(6)'
         Z(3) = 'p(1)/{1 + exp[p(2)-p(3)x] + exp[p(4)+p(5)x]} + C'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.7) THEN
         NPAR = 6
         Z(1) = 'Double exponential plus quadratic'
         Z(3) =
     +'p(1)exp[-p(2)x] + p(3)exp[-p(4)x] + p(5)x^2 + p(6)x + p(7)'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.8) THEN
         NPAR = 6
         Z(1) = 'Double logistic, C = p(7)'
         Z(3) =
     +'p(1)/[1 + exp(p(2)-p(3)x)] + p(4)/[1 + exp(p(5)-p(6)x)]'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.9) THEN
         NPAR = 2
         Z(1) = 'Linear plus reciprocal, C = p(3)'
         Z(3) = 'p(1)x + p(2)/x + C'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.10) THEN
         NPAR = 5
         Z(1) = 'Gaussian plus exponential'
         Z(2) = 'p(3)/{p(2)*sqrt(2*pi)}*exp(-1/2)[(x-p(1))/p(2)]^2'
         Z(3) = '+ p(5)*exp(-p(4)*x) + p(6)'
         Z(4) = 'Note: sigma = p(2) must be > 0'
         CALL ADDCON (NFIX, NPAR, CONST) 
      ELSEIF (NMOD.EQ.11) THEN
         NPAR = 4
         Z(1) = 'Gaussian times exponential'
         Z(2) = 'p(3)/{p(2)*sqrt(2*pi)}*exp(-1/2)[(x-p(1))/p(2)]^2'
         Z(3) = '*exp(-p(4)*x) + p(5)'
         Z(4) = 'Note: sigma = p(2) must be > 0'
         CALL ADDCON (NFIX, NPAR, CONST)      
      ELSE
         NMOD = - 1
      ENDIF
  100 FORMAT (
     + 'INRATE fits the Hill eqn.'
     +/'EXFIT fits exponentials'
     +/
     +/'Hill equation: n fixed'
     +/'Hill equation: n varied'
     +/'Power law, y=A(x^B) + C, x>=0'
     +/'log10 law, y=A*log10(x) + C, x>=0'
     +/'Up/Down exponentials + C'
     +/'Up/Down logistic + C'
     +/'Double exponential plus quadratic'
     +/'Double logistic + C'
     +/'Linear plus reciprocal + C'
     +/'Gaussian plus exponential + C'
     +/'Gaussian times exponential + C'
     +/'Cancel')
      END
C
C
      SUBROUTINE QNS116 (NFIX, NMOD, NPAR, NX, B, Z, CONST)
C      ... Selection G ... Mathematical models, X01AAF = PI
      IMPLICIT   NONE
      INTEGER    NFIX, NMOD, NPAR, NX
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(20), NUMPOS(20)
      DOUBLE PRECISION B(NX)
      DOUBLE PRECISION X01AAF$
      DOUBLE PRECISION ONE, TWO, F360
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, F360 = 360.0D+00)
      CHARACTER Z(24)*80
      CHARACTER  TEXT(30)*100
      LOGICAL    CONST
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   X01AAF$
      EXTERNAL   ADDCON, LBOX01
      DATA NUMBLD / 20*0 /
      DATA NUMPOS / 20*1 /
      WRITE (TEXT,100)
      NSTART = 3
      NUMOPT = 9
      NTEXT = 11
      NUMDEC = NUMOPT
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      NMOD = NUMDEC
      IF (NMOD.LE.2) THEN
         WRITE (TEXT,200)
         NSTART = 1
         NUMOPT = 2
         NTEXT = 2
         NUMDEC = NUMOPT
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMDEC.EQ.1) THEN
            B(1) = ONE
         ELSE
            B(1) = - ONE
         ENDIF
      ELSEIF (NMOD.EQ.3 .OR. NMOD.EQ.4) THEN
         WRITE (TEXT,300)
         NSTART = 1
         NUMOPT = 2
         NTEXT = 2
         NUMDEC = NUMOPT
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMDEC.EQ.1) THEN
            B(1) = ONE
         ELSE
            B(1) = TWO*X01AAF$(B(2))/F360
         ENDIF
      ELSEIF (NMOD.EQ.5) THEN
         WRITE (TEXT,400)
         NSTART = 1
         NUMOPT = 2
         NTEXT = 2
         NUMDEC = NUMOPT
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMDEC.EQ.1) THEN
            B(1) = ONE
         ELSE
            B(1) = F360/(TWO*X01AAF$(B(2)))
         ENDIF
      ENDIF
      IF (NMOD.EQ.1) THEN
         NPAR = 3
         Z(1) = 'Semi-circle [x-p(1)]^2 + [y-p(2)]^2 = p(3)^2'
         Z(3) = 'p(2) (+/-) sqrt[p(3)^2 - [x-p(1)]^2]'
      ELSEIF (NMOD.EQ.2) THEN
         NPAR = 4
         Z(1) = 'Semi-ellipse'
         Z(2) = '[(x-p(1))/p(3)]^2 + [(y-p(2))/p(4)]^2 = 1'
         Z(3) = 'p(2) (+/-) p(4)*sqrt{1 - [(x-p(1))/p(3)]^2}'
      ELSEIF (NMOD.EQ.3) THEN
         NPAR = 3
         Z(1) = 'A*sin(w*x) + B*cos(w*x) + C'
         Z(3) = 'A = p(1), B = p(2), w = p(3), C = p(4)'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.4) THEN
         NPAR = 4
         Z(1) = 'exp(-kt)*{A*sin(w*x) + B*cos(w*x)} + C'
         Z(3) = 'A = p(1), B = p(2), w = p(3), k = p(4), C = p(5)'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.5) THEN
         NPAR = 2
         Z(1) = 'A*arctan(w*x) + C'
         Z(3) = 'A = p(1), w = p(2), C = p(3)'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.6) THEN
         NPAR = 3
         Z(1) = 'A*x^B*exp(-k*x) + C'
         Z(3) = 'A = p(1), B = p(2), k = p(3), C = p(4)'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.7) THEN
         NPAR = 3
         Z(1) = 'A*sinh(w*x) + B*cosh(w*x) + C'
         Z(3) = 'A = p(1), B = p(2), w = p(3), C = p(4)'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSEIF (NMOD.EQ.8) THEN
         NPAR = 2
         Z(1) = 'A*tanh(w*x) + C'
         Z(3) = 'A = p(1), w = p(2), C = p(3)'
         CALL ADDCON (NFIX, NPAR, CONST)
      ELSE
         NMOD = - 1
      ENDIF
  100 FORMAT (
     +'Keep sqrt argument > 0 for circles and ellipses'
     +/
     +/'Upper or lower semi-circle'
     +/'Upper or lower semi-ellipse'
     +/'Sine/cosine law (simple harmonic motion)'
     +/'Damped simple harmonic motion'
     +/'Arctangent'
     +/'Gamma type'
     +/'Sinh/cosh (hyperbolics)'
     +/'Tanh (hyperbolic)'
     +/'Cancel')
  200 FORMAT ('Use + sign (upper branch)'
     +/'Use - sign (lower branch)')
  300 FORMAT ('x measured in radians'
     +/'x measured in degrees')
  400 FORMAT ('f(x) calculated in radians'
     +/'f(x) calculated in degrees')
      END
C
C
