C
C Subroutines and functions for user-defined sub-models
C =====================================================
C
C SUB_QUAD
C SUB_CONV
C SUB_ROOT
C SUB_VALU
C USER_QUAD_1
C USER_QUAD_2
C USER_QUAD_N
C USER_ROOT_1
C
      SUBROUTINE SUB_QUAD (NLIMIT, NUMMOD,
     +                     BLIM, EPSABS, EPSREL, TLIM, VALUE)
C
C ACTION: Quadrature
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 10/11/2001
C
      IMPLICIT   NONE
      INCLUDE   'global.ins'
C
C Argument list
C
      INTEGER    NLIMIT, NUMMOD
      DOUBLE PRECISION BLIM(NLIMIT), EPSABS, EPSREL,
     +                 TLIM(NLIMIT), VALUE
C
C COMMON block and local parameters
C
      INTEGER    NLIM1
      PARAMETER (NLIM1 = 20)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
C
C Workspace for D01AJF
C
      INTEGER    LW, LIW, N1
      PARAMETER (LW = 1000, LIW = LW/4, N1 = 1)
      INTEGER    IFAIL, IW(LIW)
      DOUBLE PRECISION A, ABSERR, B, EPABS1, EPREL1, W(LW)
C
C Workspace for D01EAF
C
C
C Specify the maximum possible number of equations and variables
C
      INTEGER    NEMAX, NVMAX
      PARAMETER (NEMAX = 20, NVMAX = 20)
C
C These then define NRMAX
C
      INTEGER    NRMAX
      PARAMETER (NRMAX = 1 + NVMAX*(4*NVMAX**2 - 6*NVMAX + 14)/3)
C
C These then define MAXCLS and LENWRK
C
      INTEGER    MINCLS, MAXCLS, LENWRK
      PARAMETER (MINCLS = 10, MAXCLS = NRMAX,
     +           LENWRK = 10*(6*NVMAX + 9*NEMAX +
     +          (NVMAX + NEMAX + 2)*(1 + MAXCLS/NRMAX)))
      INTEGER    NDIM, NFUN
      DOUBLE PRECISION ABSEST(NLIM1), FINEST(NLIM1), WRKSTR(LENWRK),
     +                 ABSREQ, RELREQ
      DOUBLE PRECISION USER_QUAD_1
      EXTERNAL  PUTFAT
      EXTERNAL  USER_QUAD_1, USER_QUAD_N
      EXTERNAL  D01AJF$, D01EAF$
      VALUE = ZERO
      NQUAD = NUMMOD
      IF (NVARS(NQUAD).EQ.N1) THEN
C
C 1-dimensional
C
         A = BLIM(1)
         B = TLIM(1)
         EPABS1 = EPSABS
         EPREL1 = EPSREL
         IFAIL = N1
         CALL D01AJF$(USER_QUAD_1,
     +                A, B, EPABS1, EPREL1, VALUE, ABSERR, W, LW, IW,
     +                LIW, IFAIL)
      ELSEIF (NVARS(NQUAD).GT.N1 .AND. NVARS(NQUAD).LE.NEMAX) THEN
C
C n-dimensional
C
         NDIM = NVARS(NQUAD)
         NFUN = NEQNS(NQUAD)
         ABSREQ = EPSABS
         RELREQ = EPSREL
         IFAIL = N1
         CALL D01EAF$(NDIM, BLIM, TLIM, MINCLS, MAXCLS, NFUN,
     +                USER_QUAD_N,
     +                ABSREQ, RELREQ, LENWRK, WRKSTR, FINEST, ABSEST,
     +                IFAIL)
         VALUE = FINEST(1)
      ELSE
         CALL PUTFAT ('SUB_QUAD called with no. variables out of range')
      ENDIF
      END
C
C
      SUBROUTINE SUB_CONV (NLIMIT, NUMMOD,
     +                     BLIM, EPSABS, EPSREL, TLIM, VALUE)
C
C ACTION: Quadrature
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 10/11/2001
C
      IMPLICIT   NONE
      INCLUDE   'global.ins'
C
C Argument list
C
      INTEGER    NLIMIT, NUMMOD
      DOUBLE PRECISION BLIM(NLIMIT), EPSABS, EPSREL,
     +                 TLIM(NLIMIT), VALUE
C
C COMMON block and local parameters
C
      INTEGER    K1, K2
      INTEGER    N100
      PARAMETER (N100 = 100)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
C
C Workspace for D01AJF
C
      INTEGER    LW, LIW, N1
      PARAMETER (LW = 1000, LIW = LW/4, N1 = 1)
      INTEGER    IFAIL, IW(LIW)
      DOUBLE PRECISION A, ABSERR, B, EPABS1, EPREL1, W(LW)
      DOUBLE PRECISION USER_QUAD_2
      EXTERNAL  USER_QUAD_2
      EXTERNAL  D01AJF$
      VALUE = ZERO
C
C NUMMOD = SUB_MODEL1 + 100*SUB_MODEL2
C
      K2 = NUMMOD/N100
      K1 = NUMMOD - N100*K2
      NCONV1 = K1
      NCONV2 = K2
      A = BLIM(1)
      B = TLIM(1)
      EPABS1 = EPSABS
      EPREL1 = EPSREL
      TOPLIM = TLIM(1)
      IFAIL = N1
      CALL D01AJF$(USER_QUAD_2,
     +                A, B, EPABS1, EPREL1, VALUE, ABSERR, W, LW, IW,
     +                LIW, IFAIL)
      END
C
C
      SUBROUTINE SUB_ROOT (NUMMOD,
     +                     BLIM, EPSABS, EPSREL, TLIM, VALUE)
C
C ACTION: Find a root using C05AZF
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 10/11/2001
C
      IMPLICIT   NONE
      INCLUDE   'global.ins'
      INTEGER    NUMMOD
      INTEGER    ICOUNT, IFAIL, IR, IND
      INTEGER    NREPS, N0, N1, N2
      PARAMETER (NREPS = 10, N0 = 0, N1 = 1, N2 = 2)
      DOUBLE PRECISION BLIM, EPSABS, EPSREL, TLIM, VALUE
      DOUBLE PRECISION C(17), F1, F2, FX, TEMP, TOLX, X1, X2
      DOUBLE PRECISION USER_ROOT_1
      DOUBLE PRECISION FREPS, ZERO
      PARAMETER (FREPS = 10.0D+00, ZERO = 0.0D+00)
      EXTERNAL   USER_ROOT_1
      EXTERNAL   C05AZF$
      EXTERNAL   PUTFAT
C
C Initialise and check that NVAR = 1
C
      VALUE = ZERO
      NROOT = NUMMOD
      IF (NVARS(NROOT).NE.N1) THEN
         CALL PUTFAT ('SUB_ROOT called with no. variables not equal 1')
         RETURN
      ENDIF
      X1 = EPSABS!to silence ftn95...may be needed for multiple roots later
      X1 = BLIM
      X2 = TLIM
      IF (X1.GT.X2) THEN
         TEMP = X2
         X2 = X1
         X1 = TEMP
      ENDIF
      ICOUNT = 0
C
C Try to bracket a root by expanding the interval if necessary
C
   20 CONTINUE
      F1 = USER_ROOT_1(X1)
      F2 = USER_ROOT_1(X2)
      IF (F1*F2.GT.ZERO) THEN
         ICOUNT = ICOUNT + 1
         IF (ICOUNT.LE.NREPS) THEN
            IF (X1.GE.ZERO) THEN
               X1 = X1/FREPS
            ELSE
               X1 = X1*FREPS
            ENDIF
            IF (X2.GE.ZERO) THEN
               X2 = X2*FREPS
            ELSE
               X2 = X2/FREPS
            ENDIF
            GOTO 20
         ELSE
            GOTO 50
         ENDIF
      ENDIF
C
C Initialise the root finder
C
      TOLX = EPSREL
      IR = N2
      IND = N1
      IFAIL = N1
C
C Enter the root finder...from now on X1 and X2 are varied by C05AZF
C
   30 CONTINUE
      CALL C05AZF$(X1, X2, FX, TOLX, IR, C, IND, IFAIL)
      IF (IND.EQ.0) GOTO 40
      IF (IND.LT.2 .OR. IND.GT.4) GOTO 50
      FX = USER_ROOT_1(X1)
      GOTO 30
C
C Exit the root finder
C
   40 CONTINUE
      IF (IFAIL.EQ.N0) THEN
         VALUE = X1
         RETURN
      ENDIF
C
C Crash so return VALUE = 0
C
   50 CONTINUE
      END
C
C
      SUBROUTINE SUB_VALU (KMAX_Y, NUMMOD, NVAR,
     +                     VALUE, X, Y, YDE, Z)
C
C ACTION: Return a value
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 10/11/2001
C
      IMPLICIT   NONE
      INCLUDE   'global.ins'
      INTEGER    KMAX_Y, NUMMOD, NVAR
      INTEGER    ISEND, KMAX_F
      PARAMETER (ISEND = 2, KMAX_F = 1)
      DOUBLE PRECISION VALUE, X, Y, YDE(KMAX_Y), Z
      DOUBLE PRECISION F(KMAX_F)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  FNAME*1024
      LOGICAL    ABORT
      EXTERNAL   PUTFAT
      EXTERNAL   USER_SUBMOD1, USER_SUBMOD2, USER_SUBMOD3,
     +           USER_SUBMOD4, USER_SUBMOD5, USER_SUBMOD6,
     +           USER_SUBMOD7, USER_SUBMOD8
      VALUE = ZERO
      NEVAL = NUMMOD
      IF (NUMMOD.EQ.1) THEN
         IF (NVAR.LT.NVARS(1)) THEN
            CALL PUTFAT (
     +     'SUB_VALU: value(1) called with too few variables')
         ELSE
            CALL USER_SUBMOD1 (ISEND, KMAX_F, KMAX_Y,
     +                         NEQNS(1), NPARS(1), NVARS(1),
     +                         F, X, Y, YDE, Z,
     +                         FNAME,
     +                         ABORT)
            VALUE = F(1)
         ENDIF
      ELSEIF (NUMMOD.EQ.2) THEN
         IF (NVAR.LT.NVARS(2)) THEN
            CALL PUTFAT (
     +     'SUB_VALU: value(2) called with too few variables')
         ELSE
            CALL USER_SUBMOD2 (ISEND, KMAX_F, KMAX_Y,
     +                         NEQNS(2), NPARS(2), NVARS(2),
     +                         F, X, Y, YDE, Z,
     +                         FNAME,
     +                         ABORT)
            VALUE = F(1)
         ENDIF
      ELSEIF (NUMMOD.EQ.3) THEN
         IF (NVAR.LT.NVARS(3)) THEN
            CALL PUTFAT (
     +     'SUB_VALU: value(3) called with too few variables')
         ELSE
            CALL USER_SUBMOD3 (ISEND, KMAX_F, KMAX_Y,
     +                         NEQNS(3), NPARS(3), NVARS(3),
     +                         F, X, Y, YDE, Z,
     +                         FNAME,
     +                         ABORT)
            VALUE = F(1)
         ENDIF
      ELSEIF (NUMMOD.EQ.4) THEN
         IF (NVAR.LT.NVARS(4)) THEN
            CALL PUTFAT (
     +     'SUB_VALU: value(4) called with too few variables')
         ELSE
            CALL USER_SUBMOD4 (ISEND, KMAX_F, KMAX_Y,
     +                         NEQNS(4), NPARS(4), NVARS(4),
     +                         F, X, Y, YDE, Z,
     +                         FNAME,
     +                         ABORT)
            VALUE = F(1)
         ENDIF
      ELSEIF (NUMMOD.EQ.5) THEN
         IF (NVAR.LT.NVARS(5)) THEN
            CALL PUTFAT (
     +     'SUB_VALU: value(5) called with too few variables')
         ELSE
            CALL USER_SUBMOD5 (ISEND, KMAX_F, KMAX_Y,
     +                         NEQNS(5), NPARS(5), NVARS(5),
     +                         F, X, Y, YDE, Z,
     +                         FNAME,
     +                         ABORT)
            VALUE = F(1)
         ENDIF
      ELSEIF (NUMMOD.EQ.6) THEN
         IF (NVAR.LT.NVARS(6)) THEN
            CALL PUTFAT (
     +     'SUB_VALU: value(6) called with too few variables')
         ELSE
            CALL USER_SUBMOD6 (ISEND, KMAX_F, KMAX_Y,
     +                         NEQNS(6), NPARS(6), NVARS(6),
     +                         F, X, Y, YDE, Z,
     +                         FNAME,
     +                         ABORT)
            VALUE = F(1)
         ENDIF
      ELSEIF (NUMMOD.EQ.7) THEN
         IF (NVAR.LT.NVARS(7)) THEN
            CALL PUTFAT (
     +     'SUB_VALU: value(7) called with too few variables')
         ELSE
            CALL USER_SUBMOD7 (ISEND, KMAX_F, KMAX_Y,
     +                         NEQNS(7), NPARS(7), NVARS(7),
     +                         F, X, Y, YDE, Z,
     +                         FNAME,
     +                         ABORT)
            VALUE = F(1)
         ENDIF
      ELSEIF (NUMMOD.EQ.8) THEN
         IF (NVAR.LT.NVARS(8)) THEN
            CALL PUTFAT (
     +     'SUB_VALU: value(8) called with too few variables')
         ELSE
            CALL USER_SUBMOD8 (ISEND, KMAX_F, KMAX_Y,
     +                         NEQNS(8), NPARS(8), NVARS(8),
     +                         F, X, Y, YDE, Z,
     +                         FNAME,
     +                         ABORT)
            VALUE = F(1)
         ENDIF
      ELSE
         CALL PUTFAT ('SUB_VALU called with NUMMOD out of range')
      ENDIF
      END
C
C
      DOUBLE PRECISION FUNCTION USER_QUAD_1 (X)
C
C ACTION: Return a function value for D01AJF
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 04/12/2001
C
      IMPLICIT   NONE
      INCLUDE   'global.ins'
      INTEGER    ISEND, KMAX_F, KMAX_Y
      PARAMETER (ISEND = 2, KMAX_F = 1, KMAX_Y = 1)
      INTEGER    NUMMOD
      DOUBLE PRECISION X
      DOUBLE PRECISION X1, Y1, YDE(KMAX_Y), Z1
      DOUBLE PRECISION F(KMAX_F)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  FNAME*1024
      LOGICAL    ABORT
      EXTERNAL   PUTFAT
      EXTERNAL   USER_SUBMOD1, USER_SUBMOD2, USER_SUBMOD3,
     +           USER_SUBMOD4, USER_SUBMOD5, USER_SUBMOD6,
     +           USER_SUBMOD7, USER_SUBMOD8
      USER_QUAD_1 = ZERO
      X1 = X
      NUMMOD = NQUAD
      IF (NUMMOD.EQ.1) THEN
         CALL USER_SUBMOD1 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(1), NPARS(1), NVARS(1),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_1 = F(1)
      ELSEIF (NUMMOD.EQ.2) THEN
         CALL USER_SUBMOD2 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(2), NPARS(2), NVARS(2),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_1 = F(1)
      ELSEIF (NUMMOD.EQ.3) THEN
         CALL USER_SUBMOD3 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(3), NPARS(3), NVARS(3),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_1 = F(1)
      ELSEIF (NUMMOD.EQ.4) THEN
         CALL USER_SUBMOD4 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(4), NPARS(4), NVARS(4),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_1 = F(1)
      ELSEIF (NUMMOD.EQ.5) THEN
         CALL USER_SUBMOD5 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(5), NPARS(5), NVARS(5),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_1 = F(1)
      ELSEIF (NUMMOD.EQ.6) THEN
         CALL USER_SUBMOD6 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(6), NPARS(6), NVARS(6),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_1 = F(1)
      ELSEIF (NUMMOD.EQ.7) THEN
         CALL USER_SUBMOD7 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(7), NPARS(7), NVARS(7),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_1 = F(1)
      ELSEIF (NUMMOD.EQ.8) THEN
         CALL USER_SUBMOD8 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(8), NPARS(8), NVARS(8),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_1 = F(1)
      ELSE
         CALL PUTFAT ('USER_QUAD_1 called with NUMMOD out of range')
      ENDIF
      END
C
C
C
C
      DOUBLE PRECISION FUNCTION USER_QUAD_2 (X)
C
C ACTION: Return a function value for D01AJF
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 24/05/2003
C         return the convolution integrand for f*g with respect to u where
C         f = f(u)     ... for sub_model f index NCONV1
C         g = g(t - u) ... for sub_model g index NCONV2
C         t = upper limit of integration = tlim(1)
C         Note: NCONV1, NCONV2, TOPLIM are set by the calling program SUB_CONV
C
      IMPLICIT   NONE
      INCLUDE   'global.ins'
      INTEGER    ISEND, KMAX_F, KMAX_Y
      PARAMETER (ISEND = 2, KMAX_F = 1, KMAX_Y = 1)
      INTEGER    NUMMOD
      DOUBLE PRECISION X
      DOUBLE PRECISION X1, Y1, YDE(KMAX_Y), Z1
      DOUBLE PRECISION F(KMAX_F)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  FNAME*1024
      LOGICAL    ABORT
      EXTERNAL   PUTFAT
      EXTERNAL   USER_SUBMOD1, USER_SUBMOD2, USER_SUBMOD3,
     +           USER_SUBMOD4, USER_SUBMOD5, USER_SUBMOD6,
     +           USER_SUBMOD7, USER_SUBMOD8
      USER_QUAD_2 = ZERO
C
C First evaluate f(u)
C
      X1 = X
      NUMMOD = NCONV1
      IF (NUMMOD.EQ.1) THEN
         CALL USER_SUBMOD1 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(1), NPARS(1), NVARS(1),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_2 = F(1)
      ELSEIF (NUMMOD.EQ.2) THEN
         CALL USER_SUBMOD2 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(2), NPARS(2), NVARS(2),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_2 = F(1)
      ELSEIF (NUMMOD.EQ.3) THEN
         CALL USER_SUBMOD3 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(3), NPARS(3), NVARS(3),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_2 = F(1)
      ELSEIF (NUMMOD.EQ.4) THEN
         CALL USER_SUBMOD4 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(4), NPARS(4), NVARS(4),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_2 = F(1)
      ELSEIF (NUMMOD.EQ.5) THEN
         CALL USER_SUBMOD5 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(5), NPARS(5), NVARS(5),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_2 = F(1)
      ELSEIF (NUMMOD.EQ.6) THEN
         CALL USER_SUBMOD6 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(6), NPARS(6), NVARS(6),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_2 = F(1)
      ELSEIF (NUMMOD.EQ.7) THEN
         CALL USER_SUBMOD7 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(7), NPARS(7), NVARS(7),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_2 = F(1)
      ELSEIF (NUMMOD.EQ.8) THEN
         CALL USER_SUBMOD8 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(8), NPARS(8), NVARS(8),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_2 = F(1)
      ELSE
         CALL PUTFAT ('USER_QUAD_2 called with NUMMOD out of range')
      ENDIF
C
C Now work out g(t - u) and return f(u)*g(t - u)
C
      X1 = TOPLIM - X
      NUMMOD = NCONV2
      IF (NUMMOD.EQ.1) THEN
         CALL USER_SUBMOD1 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(1), NPARS(1), NVARS(1),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_2 = F(1)*USER_QUAD_2
      ELSEIF (NUMMOD.EQ.2) THEN
         CALL USER_SUBMOD2 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(2), NPARS(2), NVARS(2),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_2 = F(1)*USER_QUAD_2
      ELSEIF (NUMMOD.EQ.3) THEN
         CALL USER_SUBMOD3 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(3), NPARS(3), NVARS(3),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_2 = F(1)*USER_QUAD_2
      ELSEIF (NUMMOD.EQ.4) THEN
         CALL USER_SUBMOD4 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(4), NPARS(4), NVARS(4),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_2 = F(1)*USER_QUAD_2
      ELSEIF (NUMMOD.EQ.5) THEN
         CALL USER_SUBMOD5 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(5), NPARS(5), NVARS(5),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_2 = F(1)*USER_QUAD_2
      ELSEIF (NUMMOD.EQ.6) THEN
         CALL USER_SUBMOD6 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(6), NPARS(6), NVARS(6),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_2 = F(1)*USER_QUAD_2
      ELSEIF (NUMMOD.EQ.7) THEN
         CALL USER_SUBMOD7 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(7), NPARS(7), NVARS(7),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_2 = F(1)*USER_QUAD_2
      ELSEIF (NUMMOD.EQ.8) THEN
         CALL USER_SUBMOD8 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(8), NPARS(8), NVARS(8),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_QUAD_2 = F(1)*USER_QUAD_2
      ELSE
         CALL PUTFAT ('USER_QUAD_2 called with NUMMOD out of range')
      ENDIF
      END
C
C
      SUBROUTINE USER_QUAD_N (NDIM, Z, NFUN, FUN)
C
C ACTION: Return a function value for D01EAF
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 04/12/2001
C
      IMPLICIT   NONE
      INCLUDE   'global.ins'
      INTEGER    NDIM, NFUN
      INTEGER    ISEND, KMAX_F, KMAX_Y
      PARAMETER (ISEND = 2, KMAX_F = 1, KMAX_Y = 1)
      INTEGER    I, NUMMOD
      DOUBLE PRECISION Z(NDIM), FUN(NFUN)
      DOUBLE PRECISION X1, Y1, YDE(KMAX_Y), Z1
      DOUBLE PRECISION F(KMAX_F)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  FNAME*1024
      LOGICAL    ABORT
      EXTERNAL   PUTFAT
      EXTERNAL   USER_SUBMOD1, USER_SUBMOD2, USER_SUBMOD3,
     +           USER_SUBMOD4, USER_SUBMOD5, USER_SUBMOD6,
     +           USER_SUBMOD7, USER_SUBMOD8
      FUN(1) = ZERO
      IF (NDIM.EQ.2) THEN
         X1 = Z(1)
         Y1 = Z(2)
      ELSEIF (NDIM.EQ.3) THEN
         X1 = Z(1)
         Y1 = Z(2)
         Z1 = Z(3)
      ELSE
         DO I = 1, NDIM
            YDE(I) = Z(I)
         ENDDO
      ENDIF
      NUMMOD = NQUAD
      IF (NUMMOD.EQ.1) THEN
         CALL USER_SUBMOD1 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(1), NPARS(1), NVARS(1),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         FUN(1) = F(1)
      ELSEIF (NUMMOD.EQ.2) THEN
         CALL USER_SUBMOD2 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(2), NPARS(2), NVARS(2),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         FUN(1) = F(1)
      ELSEIF (NUMMOD.EQ.3) THEN
         CALL USER_SUBMOD3 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(3), NPARS(3), NVARS(3),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         FUN(1) = F(1)
      ELSEIF (NUMMOD.EQ.4) THEN
         CALL USER_SUBMOD4 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(4), NPARS(4), NVARS(4),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         FUN(1) = F(1)
      ELSEIF (NUMMOD.EQ.5) THEN
         CALL USER_SUBMOD5 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(5), NPARS(5), NVARS(5),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         FUN(1) = F(1)
      ELSEIF (NUMMOD.EQ.6) THEN
         CALL USER_SUBMOD6 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(6), NPARS(6), NVARS(6),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         FUN(1) = F(1)
      ELSEIF (NUMMOD.EQ.7) THEN
         CALL USER_SUBMOD7 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(7), NPARS(7), NVARS(7),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         FUN(1) = F(1)
      ELSEIF (NUMMOD.EQ.8) THEN
         CALL USER_SUBMOD8 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(8), NPARS(8), NVARS(8),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         FUN(1) = F(1)
      ELSE
         CALL PUTFAT ('USER_QUAD_N called with NUMMOD out of range')
      ENDIF
      END
C
C
      DOUBLE PRECISION FUNCTION USER_ROOT_1 (X)
C
C ACTION: Return a function value for C05AZF
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 04/12/2001
C
      IMPLICIT   NONE
      INCLUDE   'global.ins'
      INTEGER    ISEND, KMAX_F, KMAX_Y
      PARAMETER (ISEND = 2, KMAX_F = 1, KMAX_Y = 1)
      INTEGER    NUMMOD
      DOUBLE PRECISION X
      DOUBLE PRECISION X1, Y1, YDE(KMAX_Y), Z1
      DOUBLE PRECISION F(KMAX_F)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  FNAME*1024
      LOGICAL    ABORT
      EXTERNAL   PUTFAT
      EXTERNAL   USER_SUBMOD1, USER_SUBMOD2, USER_SUBMOD3,
     +           USER_SUBMOD4, USER_SUBMOD5, USER_SUBMOD6,
     +           USER_SUBMOD7, USER_SUBMOD8
      USER_ROOT_1 = ZERO
      X1 = X
      NUMMOD = NROOT
      IF (NUMMOD.EQ.1) THEN
         CALL USER_SUBMOD1 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(1), NPARS(1), NVARS(1),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_ROOT_1 = F(1)
      ELSEIF (NUMMOD.EQ.2) THEN
         CALL USER_SUBMOD2 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(2), NPARS(2), NVARS(2),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_ROOT_1 = F(1)
      ELSEIF (NUMMOD.EQ.3) THEN
         CALL USER_SUBMOD3 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(3), NPARS(3), NVARS(3),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_ROOT_1 = F(1)
      ELSEIF (NUMMOD.EQ.4) THEN
         CALL USER_SUBMOD4 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(4), NPARS(4), NVARS(4),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_ROOT_1 = F(1)
      ELSEIF (NUMMOD.EQ.5) THEN
         CALL USER_SUBMOD5 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(5), NPARS(5), NVARS(5),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_ROOT_1 = F(1)
      ELSEIF (NUMMOD.EQ.6) THEN
         CALL USER_SUBMOD6 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(6), NPARS(6), NVARS(6),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_ROOT_1 = F(1)
      ELSEIF (NUMMOD.EQ.7) THEN
         CALL USER_SUBMOD7 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(7), NPARS(7), NVARS(7),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_ROOT_1 = F(1)
      ELSEIF (NUMMOD.EQ.8) THEN
         CALL USER_SUBMOD8 (ISEND, KMAX_F, KMAX_Y,
     +                      NEQNS(8), NPARS(8), NVARS(8),
     +                      F, X1, Y1, YDE, Z1,
     +                      FNAME,
     +                      ABORT)
         USER_ROOT_1 = F(1)
      ELSE
         CALL PUTFAT ('USER_ROOT_1 called with NUMMOD out of range')
      ENDIF
      END
C
C
