C
C
      SUBROUTINE USER_FILE (INDEX_1, INDEX_2, NEQN, NIN,
     +                      NLINES_1, NLINES_2, NPAR, NSTACK_1,
     +                      NSTACK_2, NUMBER_1, NUMBER_2,
     +                      NVAR, NX, DATA_1, DATA_2, FNAME, MODNAM,
     +                      ABORT, DEQN, USED)
C
C ACTION : Open a file with a user defined model
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 24/12/94
C          The file must be correctly formatted in reverse Polish
C ADVICE : If the file cannot be interpreted ABORT is returned as .TRUE.
C
C          Be very careful with word length consistency as follows:
C
C          INTEGER INDEX_1, INDEX_2, NUMBER_1, NUMBER_2
C          DOUBLE PRECISION DATA_1, DATA_2
C          ===============================
C
C          14/10/1997 Restored full precision
C          01/03/1999 altered to accomodate functions of many variables
C          24/06/1999 introduced MODEL_ERROR to switch off repeated error
C                     messages from PARSE_FILE
C          16/03/2001 dimensioned the arrays
C          14/10/2001 also dimensioned MODNAM and toned down warning about
C                     undefined j(i) values
C          25/01/2010 added close if abort = .true. from ofiles and intermediate returns
C          28/01/2016 added call to XPRESS in case expressions are in the model file
C          26/06/2016 added MAIN_MODEL to prevent re-initialisation with jacobians 
C
      IMPLICIT   NONE
      INTEGER    NEQN, NIN, NPAR, NVAR
      INTEGER    NLINES_1, NLINES_2, NSTACK_1,
     +           NSTACK_2, NX
      INTEGER    INDEX_1(NSTACK_1), NUMBER_1(NSTACK_1)
      INTEGER    INDEX_2(NSTACK_2), NUMBER_2(NSTACK_2)
      INTEGER    N0_S, N1_S, N2_S, N3_S, N8_S, N9_S, N37_S, N38_S,
     +           N48_S, N49_S, N51_S
      PARAMETER (N0_S = 0, N1_S = 1, N2_S = 2, N3_S = 3, N8_S = 8,
     +           N9_S = 9, N37_S = 37, N38_S = 38, N48_S = 48,
     +           N49_S = 49, N51_S = 51)
      INTEGER    I, IOS, J, NSTART
      INTEGER    IADD1, JADD1, KADD1
      INTEGER    N0, N1, N2, N3, N6, N10, N24, N25, N80
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N6 = 6, N10 = 10,
     +           N24 = 24, N25 = 25, N80 = 80)
      DOUBLE PRECISION DATA_1(NSTACK_1/N10), DATA_2(NSTACK_2/N10)
      DOUBLE PRECISION ZERO_S
      PARAMETER (ZERO_S = 0.0D+00)
      CHARACTER (LEN = 1024 ) FNAME, FILE_IN, FILE_OUT
      CHARACTER (LEN = N80  ) LINE, MODNAM(N24), TEMP
      CHARACTER (LEN = 6    ) WORD6
      LOGICAL    USED(NSTACK_1)
      LOGICAL    ABORT, DEQN
      LOGICAL    VUSED(100), XUSED, YUSED, ZUSED
      LOGICAL    MODEL_ERROR
      LOGICAL    STORE
      LOGICAL    MAIN_MODEL
      EXTERNAL   PARSE_FILE, EXTRA_MODELS, QNFILE
      EXTERNAL   PUTFAT, OFILES, PUTADV, LCASE1, TRIML1, PUTWAR
      EXTERNAL   XPRESS, MODEL_CHECKER
      INTRINSIC  INDEX
C
C Set default logicals then open file containing the model and re-set ABORT
C
      ABORT = .TRUE.
      MODEL_ERROR = .FALSE.
      IADD1 = N0
      JADD1 = N0
      KADD1 = N0
      I = N3
      CLOSE (UNIT = NIN)
C     Retrieve the current filename      
      STORE = .FALSE.
      CALL QNFILE (FNAME,
     +             STORE)
C
C If user has requested a temporary file open it directly, otherwise use normal file open 
C     
      IF (INDEX(FNAME, '\model_') .GT.0 .AND.
     +    INDEX(FNAME, '.tmp')    .GT. 0) THEN
         OPEN (UNIT = NIN, FILE = FNAME, IOSTAT = IOS)
         IF (IOS.EQ.0) ABORT = .FALSE.        
      ELSE 
         CALL OFILES (I, NIN,
     +                FNAME,
     +                ABORT)
      ENDIF
      CLOSE (UNIT = NIN)
      IF (ABORT) RETURN
C
C Check the current file
C        
      CALL MODEL_CHECKER (NEQN, NPAR, NVAR,
     +                    FNAME, 
     +                    ABORT, DEQN)
      IF (ABORT) RETURN
      FILE_IN = FNAME
      CALL XPRESS (FILE_IN, FILE_OUT,
     +             ABORT)
      IF (ABORT) RETURN
      ABORT = .TRUE.  
      OPEN (UNIT = NIN, FILE = FILE_OUT, IOSTAT = IOS)
      IF (IOS.NE.N0) THEN
         CLOSE (UNIT = NIN)
         RETURN        
      ENDIF   
C
C Read in the model name and details
C
      J = N1
      READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
      CALL TRIML1 (LINE)
      IF (LINE(N1:N1).NE.'%') THEN
         CALL PUTFAT ('Model file must start with % symbol')
         GOTO 40
      ENDIF
      IF (IOS.NE.0) GOTO 40
      DO I = N1, N25
         J = J + N1
         READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
         IF (IOS.NE.N0) GOTO 40
         TEMP = LINE
         CALL TRIML1 (TEMP)
         IF (TEMP(N1:N1).EQ.'%') THEN
C
C Escape from model text since % encountered
C
            GOTO 10
         ELSE
            MODNAM(J - N1) = LINE
         ENDIF
         IF (I.EQ.N25) THEN
            CALL PUTFAT ('Model can only have up to 24 text lines')
            GOTO 40
         ENDIF
      ENDDO
   10 CONTINUE
C
C Read the number of equations
C
      J = J + N1
      READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
      IF (IOS.NE.N0) GOTO 40
      CALL TRIML1 (LINE)
      CALL LCASE1 (LINE)
      NSTART = INDEX(LINE, 'eq')
      IF (NSTART.GT.N1) THEN
         READ (LINE(N1:NSTART - N1),*,END=40,ERR=40,IOSTAT=IOS) I
         IF (IOS.NE.N0) GOTO 40
      ELSE
         CALL PUTFAT (
     +   'This line must be the no. of equations, e.g. 1 equation')
         GOTO 40
      ENDIF
      IF (I.LE.0) THEN
         CALL PUTFAT ('Cannot have number of equations < 1')
         GOTO 40
      ENDIF
      IF (NEQN.LE.0) THEN
C
C This should only happen if called from DEQSOL which sets NEQN = 0
C
         NEQN = I
      ELSEIF (I.NE.NEQN) THEN
C
C Usually NEQN is set before the call and this cross checks the model file
C
         CALL PUTFAT ('Wrong number of equations declared in file')
         GOTO 40
      ENDIF
C
C Read the type identifier line, e.g. 1 variable, differential equation
C
      J = J + N1
      READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
      IF (IOS.NE.N0) GOTO 40
      CALL TRIML1 (LINE)
      CALL LCASE1 (LINE)
      WORD6 = LINE(N1:N6)
      IF (WORD6.EQ.'differ') THEN
         IF (.NOT.DEQN) THEN
            CALL PUTFAT ('Line indicates a differential equation')
            GOTO 40
         ENDIF
      ELSE
         NSTART = INDEX(LINE, 'var')
         IF (NSTART.GT.N1) THEN
            READ (LINE(N1:NSTART - N1),*,END=40,ERR=40,IOSTAT=IOS) I
            IF (IOS.NE.N0) GOTO 40
         ELSE
            CALL PUTFAT (
     +      'This line must be the no. of variables, e.g. 1 variable')
            GOTO 40
         ENDIF
         IF (I.NE.NVAR) THEN
            CALL PUTFAT ('Wrong number of variables declared in file')
            GOTO 40
         ENDIF
      ENDIF
C
C Read the number of parameters
C
      J = J + N1
      READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
      IF (IOS.NE.N0) GOTO 40
      CALL TRIML1 (LINE)
      CALL LCASE1 (LINE)
      NSTART = INDEX(LINE, 'par')
      IF (NSTART.GT.N1) THEN
         READ (LINE(N1:NSTART - N1),*,END=40,ERR=40,IOSTAT=IOS) NPAR
         IF (IOS.NE.N0) GOTO 40
      ELSE
         CALL PUTFAT (
     +   'This line must be the no. of parameters, e.g. 3 parameters')
         GOTO 40
      ENDIF
      IF (NPAR.LT.N1) THEN
         NPAR = N0
         CALL PUTADV ('Model has no parameters .. fitting impossible')
      ENDIF
C
C Check for begin model sign
C
      J = J + N1
      READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
      IF (IOS.NE.N0) GOTO 40
      CALL TRIML1 (LINE)
      IF (LINE(N1:N1).NE.'%') THEN
         CALL PUTFAT ('Start of model must be indicated by %')
         GOTO 40
      ENDIF
C
C Initialise INDEX, NUMBER, NLINES and DATA
C
      DO I = N1, NSTACK_1
         INDEX_1(I) = N0_S
         NUMBER_1(I) = N0_S
      ENDDO
      DO I = N1, NSTACK_1/N10
         DATA_1(I) = ZERO_S
      ENDDO
      DO I = N1, NSTACK_2
         INDEX_2(I) = N0_S
         NUMBER_2(I) = N0_S
      ENDDO
      DO I = N1, NSTACK_2/N10
         DATA_2(I) = ZERO_S
      ENDDO
      NLINES_1 = N0
      NLINES_2 = N0
      MAIN_MODEL = .TRUE.
      CALL PARSE_FILE (INDEX_1, J, NEQN, NIN, NLINES_1, NPAR, NSTACK_1,
     +                 NUMBER_1, NVAR, NX,
     +                 DATA_1,
     +                 MODEL_ERROR, DEQN, MAIN_MODEL)
      MAIN_MODEL = .FALSE.
      IF (MODEL_ERROR) GOTO 40
      IF (DEQN) THEN
         CALL PARSE_FILE (INDEX_2, J, NEQN, NIN, NLINES_2, NPAR,
     +                    NSTACK_2,
     +                    NUMBER_2, NVAR, NX,
     +                    DATA_2, 
     +                    MODEL_ERROR, DEQN, MAIN_MODEL)
         IF (NLINES_2.LE.N0) THEN
            CALL PUTADV (
     +'No Jacobian ...use Adams method or BDF method with no Jacobian')
            NLINES_2 = N0
         ENDIF
         IF (MODEL_ERROR) GOTO 40
      ENDIF
      CALL EXTRA_MODELS (NIN, MODEL_ERROR)
      IF (MODEL_ERROR) GOTO 40
      CLOSE (UNIT = NIN)
C*****WRITE (LINE,300) NLINES_1 + NLINES_2
C*****CALL PUTADV (LINE)
      IF (NLINES_1.LT.N1) GOTO 40
C
C Check if x, y, z and all parameters have been used
C
      ABORT = .TRUE.
      XUSED = .FALSE.
      YUSED = .FALSE.
      ZUSED = .FALSE.
      DO I = N1, NPAR
         USED(I) = .FALSE.
      ENDDO
      IF (DEQN .OR. NVAR.LE.3) THEN
         DO I = N1, NLINES_1
            IF (INDEX_1(I).EQ.N1_S) XUSED = .TRUE.
            IF (INDEX_1(I).EQ.N2_S) YUSED = .TRUE.
            IF (INDEX_1(I).EQ.N3_S) ZUSED = .TRUE.
            IF (INDEX_1(I).EQ.N8_S) USED(NUMBER_1(I)) = .TRUE.
            IF (INDEX_1(I).EQ.N48_S .OR. INDEX_1(I).EQ.N51_S) THEN
               XUSED = .TRUE.
               YUSED = .TRUE.
               ZUSED = .TRUE.
            ENDIF
            IF (INDEX_1(I).EQ.N49_S) THEN
               DO J = N1, NPAR
                  USED(J) = .TRUE.
               ENDDO
            ENDIF
         ENDDO
      ELSE
         DO I = N1, NVAR
            VUSED(I) = .FALSE.
         ENDDO
         DO I = N1, NLINES_1
            IF (INDEX_1(I).EQ.N37_S) VUSED(NUMBER_1(I)) = .TRUE.
            IF (INDEX_1(I).EQ.N8_S) USED(NUMBER_1(I)) = .TRUE.
            IF (INDEX_1(I).EQ.N48_S .OR. INDEX_1(I).EQ.N51_S) THEN
               DO J = N1, NVAR
                  VUSED(J) = .TRUE.
               ENDDO
            ENDIF
            IF (INDEX_1(I).EQ.N49_S) THEN
               DO J = N1, NPAR
                  USED(J) = .TRUE.
               ENDDO
            ENDIF
         ENDDO
         XUSED = VUSED(1)
         YUSED = VUSED(2)
         ZUSED = VUSED(3)
      ENDIF
C
C Check for the number of unused parameters
C
      J = N0
      IF (DEQN) THEN
         DO I = N1, NPAR - NEQN
            IF (USED(I)) THEN
               J = J + N1
            ELSE
              IADD1 = IADD1 + N1
              IF (IADD1.EQ.N1) THEN 
                 WRITE (LINE,300) I
                 CALL PUTWAR (LINE)
              ENDIF   
            ENDIF
         ENDDO
         IF (J.EQ.NPAR - NEQN) ABORT = .FALSE.
      ELSE
         DO I = N1, NPAR
            IF (USED(I)) THEN
               J = J + N1
            ELSE
              IADD1 = IADD1 + N1
              IF (IADD1.EQ.N1) THEN 
                 WRITE (LINE,300) I
                 CALL PUTWAR (LINE)
               ENDIF   
            ENDIF
         ENDDO
         IF (J.EQ.NPAR) ABORT = .FALSE.
      ENDIF
      IF (IADD1.GT.N1) THEN
         WRITE (LINE,350) IADD1
         CALL PUTWAR (LINE)
      ENDIF   	
C
C Check for the number of unused variables 
C      
      IF (.NOT.DEQN .AND. NVAR.LE.3) THEN
         IF (.NOT.XUSED) THEN
            JADD1 = JADD1 + N1
            CALL PUTFAT ('x has not been used in the model')
            ABORT = .TRUE.
         ENDIF
         IF (NVAR.GT.N1 .AND. .NOT.YUSED) THEN
            JADD1 = JADD1 + N1
            CALL PUTFAT ('y has not been used in the model')
            ABORT = .TRUE.
         ENDIF
         IF (NVAR.GT.N2 .AND. .NOT.ZUSED) THEN
            JADD1 = JADD1 + N1
            CALL PUTFAT ('z has not been used in the model')
            ABORT = .TRUE.
         ENDIF
      ELSEIF (.NOT.DEQN .AND. NVAR.GT.3) THEN
         DO I = N1, NVAR
            IF (.NOT.VUSED(I)) THEN
               ABORT = .TRUE.
               JADD1 = JADD1 + N1
               IF (JADD1.EQ.N1) THEN
                  WRITE (LINE,400) I
                  CALL PUTFAT (LINE)
               ENDIF   
            ENDIF
         ENDDO
      ENDIF
      IF (JADD1.GT.N1) THEN
         WRITE (LINE,450) JADD1
         CALL PUTFAT (LINE)
      ENDIF   	
      IF (ABORT) THEN
         CLOSE (UNIT = NIN)
         GOTO 40
      ENDIF  
C
C Check if all equations have been defined
C
      ABORT = .TRUE.
      DO I = N1, NEQN
         USED(I) = .FALSE.
      ENDDO
      DO I = N1, NLINES_1
         IF (INDEX_1(I).EQ.N9_S) USED(NUMBER_1(I)) = .TRUE.
      ENDDO
      J = N0
      DO I = N1, NEQN
         IF (USED(I)) THEN
            J = J + N1
         ELSE
           KADD1 = KADD1 + N1
           IF (KADD1.EQ.N1) THEN
              WRITE (LINE,500) I
              CALL PUTFAT (LINE)
            ENDIF  
         ENDIF
      ENDDO
      IF (KADD1.GT.N1) THEN
         WRITE (LINE,550) KADD1
         CALL PUTFAT (LINE)
      ENDIF   
      IF (J.EQ.NEQN) ABORT = .FALSE.
      IF (ABORT) THEN
         CLOSE (UNIT = NIN)
         GOTO 40
      ENDIF   
C
C If DEQN check if all Jacobian has been defined
C
      IF (DEQN .AND. NLINES_2.GT.N0) THEN
         DO I = N1, NEQN**2
            USED(I) = .FALSE.
         ENDDO
         DO I = N1, NLINES_2
            IF (INDEX_2(I).EQ.N38_S) USED(NUMBER_2(I)) = .TRUE.
         ENDDO
         J = N0
         DO I = N1, NEQN**2
            IF (USED(I)) J = J + N1
         ENDDO
         IF (J.LT.NEQN**2) THEN
            WRITE (LINE,600) NEQN**2 - J
            CALL PUTADV (LINE)
         ENDIF
      ENDIF
      CLOSE (UNIT = NIN)
C
C Make sure the current filename is stored
C      
      STORE = .TRUE.
      CALL QNFILE (FNAME,
     +             STORE) 
      RETURN
C
C Error trapping
C
   40 CONTINUE
      CLOSE (UNIT = NIN)
      ABORT = .TRUE.
      IF (.NOT.MODEL_ERROR) THEN
         WRITE (LINE,700) J
         CALL PUTFAT (LINE)
      ENDIF
C*100 FORMAT ('Number of parameters =',I3,' parameter requested =',I3)
C*200 FORMAT ('Number of equations =',I3,' equation requested =',I3)
C*300 FORMAT ('Number of lines defining the model is',I3)
  300 FORMAT ('Parameter number',I4,' has not been used')
  350 FORMAT ('Total number of unused parameters =',I4)
  400 FORMAT ('Variable number',I4,' has not been used')
  450 FORMAT ('Total number of unused variables =',I4)
  500 FORMAT ('Equation number',I4,' has not been defined')
  550 FORMAT ('Total number of undefined equations =',I4)
  600 FORMAT (I4,' undefined Jacobian components will be set = 0')
  700 FORMAT ('Error in file ... Check the model at line number',I6)
      END
C
C
