C
C
      SUBROUTINE USER_MODEL (INDEX1,
     +                       KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                       NEQN, NLINES, NPAR, NSTACK, NUMBER,
     +                       NVAR,
     +                       A, DATA, F, STACK, X, Y, YDE, YJA, Z)
C
C ACTION : Evaluate user supplied model parsed by USER_FILE
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 27/12/94
C          Added the counter IADD1 to use DATA elements sequentially
C          01/03/99 used YDE(*) to allow NVAR > 3 and checked for ICOUNT < 0
C          24/06/99 edited for put and get
C                   Note: NSTORE must agree with PARSE_FILE
C          27/12/99 used (*) everywhere to allow call for F without J and
C                   vice versa
C          16/10/2001 Introduced KMAX_A, KMAX_F, KMAX_J, KMAX_Y, NSTACK
C                     for dimensioning
C          18/10/2001 edited for EPSABS and EPSREL, GLOBAL_STORE
C          02/11/2001 made STORE global
C          05/11/2001 added get3 for 3-way get
C          10/11/2001 added quad and root
C          04/12/2001 added PARAM(NPARAM) and NVAR
C          06/12/2001 introduced SELECT CASE, middle and value3
C          14/12/2001 added SPECIAL_FUNCTIONS
C          28/12/2001 added 53 = 'order '
C          23/05/2003 added 56 = 'convolute'
C          Date of this version 23/05/2003
C
      IMPLICIT   NONE
      INCLUDE   'global.ins'
      INTEGER    KMAX_A, KMAX_F, KMAX_J, KMAX_Y, NSTACK
      INTEGER    NEQN, NLINES, NPAR, NVAR
      INTEGER    INDEX1(NSTACK), NUMBER(NSTACK)
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      INTEGER    NLIMIT
      PARAMETER (NLIMIT = 20)
      INTEGER    I, IADD1, ICASE, ICOUNT, IFAIL, J, K, K1, K2, K3
      DOUBLE PRECISION ENEG, EPOS, PI, RTOL, TEN, ZERO, ONE
      PARAMETER (ENEG = -174.2D+00, EPOS = 174.2D+00,
     +           PI = 3.14159265359D+00, RTOL = 1.0D-300,
     +           TEN = 10.0D+00, ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION BOT, TOP
      PARAMETER (TOP = 1.0D+03, BOT = - TOP)
      DOUBLE PRECISION DATA(NSTACK/10)
      DOUBLE PRECISION A(KMAX_A), F(KMAX_F), X, Y,
     +                 YDE(KMAX_Y), YJA(KMAX_J), Z
      DOUBLE PRECISION STACK(NSTACK), TEMP, XBOT, XMID, XTOP, VALUE
      DOUBLE PRECISION S14AAF$, S14ABF$, S15ABF$, S15ADF$
      DOUBLE PRECISION BLIM(NLIMIT), TLIM(NLIMIT)
      DOUBLE PRECISION EPSABS, EPSREL
      CHARACTER  LINE*80
      LOGICAL    OMIT
      EXTERNAL   PUTFAT
      EXTERNAL   S14AAF$, S14ABF$, S15ABF$, S15ADF$
      EXTERNAL   SUB_QUAD, SUB_ROOT, SUB_VALU, SPECIAL_FUNCTIONS,
     +           SUB_CONV
      INTRINSIC  ABS, EXP, SQRT, LOG, LOG10, NINT, SIN, COS, TAN,
     +           ASIN, ACOS, ATAN, SINH, COSH, TANH, MIN, MAX, MOD
      SAVE       EPSABS, EPSREL
      SAVE       BLIM, TLIM
      DATA       EPSABS, EPSREL / 1.0D-06, 1.0D-03 /
      DATA       BLIM, TLIM / NLIMIT*BOT, NLIMIT*TOP /
      IADD1 = N0
      ICOUNT = N0
      OMIT = .FALSE.
      DO I = N1, NLINES
         IF (OMIT) THEN
            ICASE = N0
         ELSE
            ICASE = INDEX1(I)
         ENDIF
         SELECT CASE (ICASE)
         CASE (0)
C***********PRINT*,'line omitted'
            OMIT = .FALSE.
         CASE (1)
C***********PRINT*,'put x on the stack'
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = X
         CASE (2)
C***********PRINT*,'put y on the stack'
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = Y
         CASE (3)
C***********PRINT*,'put z on the stack'
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = Z
         CASE (4)
C***********PRINT*,'add top stack element to next-to-top'
            ICOUNT = ICOUNT - N1
            STACK(ICOUNT) = STACK(ICOUNT) + STACK(ICOUNT + N1)
         CASE (5)
C***********PRINT*,'subtract top stack element from next-to-top'
            ICOUNT = ICOUNT - N1
            STACK(ICOUNT) = STACK(ICOUNT) - STACK(ICOUNT + N1)
         CASE (6)
C***********PRINT*,'multiply top 2 stack elements'
            ICOUNT = ICOUNT - N1
            STACK(ICOUNT) = STACK(ICOUNT)*STACK(ICOUNT + N1)
         CASE (7)
C***********PRINT*,'divide next-to-top stack element by top'
            TEMP = STACK(ICOUNT)
            IF (ABS(TEMP).LE.RTOL) THEN
               IF (TEMP.LT.ZERO) THEN
                  TEMP = - RTOL
               ELSE
                  TEMP = RTOL
               ENDIF
            ENDIF
            ICOUNT = ICOUNT - N1
            STACK(ICOUNT) = STACK(ICOUNT)/TEMP
         CASE (8)
C***********WRITE (*,'(A,I3)')
C****+      ' number of parameter to place on the stack is:', NUMBER(I)
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = A(NUMBER(I))
         CASE (9)
C***********WRITE (*,'(A,I3)')
C****+      ' number of model to evaluate from the stack is:', NUMBER(I)
            F(NUMBER(I)) = STACK(ICOUNT)
            ICOUNT = ICOUNT - N1
         CASE (10)
C***********PRINT*,'raise next-to-top element to power of top'
            ICOUNT = ICOUNT - N1
            TEMP = STACK(ICOUNT)
            IF (TEMP.LT.ZERO) THEN
               STACK(ICOUNT) = TEMP**NINT(STACK(ICOUNT + N1))
            ELSEIF (TEMP.LE.RTOL) THEN
               STACK(ICOUNT) = RTOL**(STACK(ICOUNT + N1))
            ELSE
               STACK(ICOUNT) = TEMP**(STACK(ICOUNT + N1))
            ENDIF
         CASE (11)
C***********PRINT*,'replace top element by the square root'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.RTOL) TEMP = RTOL
            STACK(ICOUNT) = SQRT(TEMP)
         CASE (12)
C***********PRINT*,'replace top element by the exponential'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.ENEG) THEN
               TEMP = ENEG
            ELSEIF (TEMP.GE.EPOS) THEN
                TEMP = EPOS
            ENDIF
            STACK(ICOUNT) = EXP(TEMP)
         CASE (13)
C***********PRINT*,'replace top element by ten-to-the-power'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.ENEG) THEN
               TEMP = ENEG
            ELSEIF (TEMP.GT.EPOS) THEN
                TEMP = EPOS
            ENDIF
            STACK(ICOUNT) = TEN**TEMP
         CASE (14)
C***********PRINT*,'replace top element by natural log'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.RTOL) TEMP = RTOL
            STACK(ICOUNT) = LOG(TEMP)
         CASE (15)
C***********PRINT*,'replace top element by log-to-base-ten'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.RTOL) TEMP = RTOL
            STACK(ICOUNT) = LOG10(TEMP)
         CASE (16)
C***********PRINT*,'put pi on the stack (pi = 3.1415927)'
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = PI
         CASE (17)
C***********PRINT*,'replace top element by sine    *** radians!'
            STACK(ICOUNT) = SIN(STACK(ICOUNT))
         CASE (18)
            STACK(ICOUNT) = COS(STACK(ICOUNT))
C***********PRINT*,'replace top element by cosine  *** radians!'
         CASE (19)
C***********PRINT*,'replace top element by tangent *** radians!'
            STACK(ICOUNT) = TAN(STACK(ICOUNT))
         CASE (20)
C***********PRINT*,'replace top element by arcsin  *** radians!'
            STACK(ICOUNT) = ASIN(STACK(ICOUNT))
         CASE (21)
C***********PRINT*,'replace top element by arcos   *** radians!'
            STACK(ICOUNT) = ACOS(STACK(ICOUNT))
         CASE (22)
C***********PRINT*,'replace top element by arctan  *** radians!'
            STACK(ICOUNT) = ATAN(STACK(ICOUNT))
         CASE (23)
C***********PRINT*,'replace top element by sinh'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.ENEG) THEN
               TEMP = ENEG
            ELSEIF (TEMP.GT.EPOS) THEN
                TEMP = EPOS
            ENDIF
            STACK(ICOUNT) = SINH(TEMP)
         CASE (24)
C***********PRINT*,'replace top element by cosh'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.ENEG) THEN
               TEMP = ENEG
            ELSEIF (TEMP.GT.EPOS) THEN
                TEMP = EPOS
            ENDIF
            STACK(ICOUNT) = COSH(TEMP)
         CASE (25)
C***********PRINT*,'replace top element by tanh'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.ENEG) THEN
               TEMP = ENEG
            ELSEIF (TEMP.GT.EPOS) THEN
                TEMP = EPOS
            ENDIF
            STACK(ICOUNT) = TANH(TEMP)
         CASE (26)
C***********PRINT*,'duplicate top element'
            TEMP = STACK(ICOUNT)
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = TEMP
         CASE (27)
C***********PRINT*,'exchange top two elements on stack (swap)'
            TEMP = STACK(ICOUNT)
            STACK(ICOUNT) = STACK(ICOUNT - N1)
            STACK(ICOUNT - N1) = TEMP
         CASE (28)
C***********PRINT*,'pop top element off the stack (delete)'
            ICOUNT = ICOUNT - N1
         CASE (29)
C***********PRINT*,'replace top element of stack by absolute value'
            STACK(ICOUNT) = ABS(STACK(ICOUNT))
         CASE (30)
C***********PRINT*,'change sign of top element of the stack'
            STACK(ICOUNT) = - STACK(ICOUNT)
         CASE (31)
C***********PRINT*,'replace top 2 elements by the smallest'
            ICOUNT = ICOUNT - N1
            STACK(ICOUNT) = MIN(STACK(ICOUNT),STACK(ICOUNT + N1))
         CASE (32)
C***********PRINT*,'replace top two 2 elements by the largest'
            ICOUNT = ICOUNT - N1
            STACK(ICOUNT) = MAX(STACK(ICOUNT),STACK(ICOUNT + N1))
         CASE (33)
C***********PRINT*,'replace top element by gamma function'
            IFAIL = N1
            STACK(ICOUNT) = S14AAF$(STACK(ICOUNT), IFAIL)
         CASE (34)
C***********PRINT*,'replace top element by ln(gamma function)'
            IFAIL = N1
            STACK(ICOUNT) = S14ABF$(STACK(ICOUNT), IFAIL)
         CASE (35)
C***********PRINT*,'replace top element by unit normal integral'
            IFAIL = N1
            STACK(ICOUNT) = S15ABF$(STACK(ICOUNT), IFAIL)
         CASE (36)
C***********PRINT*,'replace top element by erfc'
            IFAIL = N1
            STACK(ICOUNT) = S15ADF$(STACK(ICOUNT), IFAIL)
         CASE (37)
C***********WRITE (*,'(A,I3)')
C****+      ' number of y(i) to place on the the stack is:', NUMBER(I)
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = YDE(NUMBER(I))
         CASE (38)
C***********WRITE (*,'(A,I3)')
C****+      ' number of j(i) to evaluate from the stack is:', NUMBER(I)
            YJA(NUMBER(I)) = STACK(ICOUNT)
            ICOUNT = ICOUNT - N1
         CASE (39)
C***********WRITE (*,'(A,I3,A,1P,E14.6)')
C****+      ' put(', NUMBER(I), ') =', STACK(ICOUNT)
            STORE(NUMBER(I)) = STACK(ICOUNT)
            ICOUNT = ICOUNT - N1
         CASE (40)
C***********WRITE (*,'(A,I3,A,1P,E14.6)')
C****+      ' get(', NUMBER(I), ') =', STORE(NUMBER(I))
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = STORE(NUMBER(I))
         CASE (41)
C***********WRITE (*,'(A,I3,A,1P,E14.6)')
C****+      ' blim(', NUMBER(I), ') =', STACK(ICOUNT)
            BLIM(NUMBER(I)) = STACK(ICOUNT)
            ICOUNT = ICOUNT - N1
         CASE (42)
C***********WRITE (*,'(A,I3,A,1P,E14.6)')
C****+      ' tlim(', NUMBER(I), ') =', STACK(ICOUNT)
            TLIM(NUMBER(I)) = STACK(ICOUNT)
            ICOUNT = ICOUNT - N1
         CASE (43)
C***********WRITE (*,'(A,1P,E11.3)') 'epsabs =', STACK(ICOUNT)
            IF (STACK(ICOUNT).GE.ZERO) EPSABS = STACK(ICOUNT)
            ICOUNT = ICOUNT - N1
         CASE (44)
C***********WRITE (*,'(A,1P,E11.3)') 'epsrel =', STACK(ICOUNT)
            IF (STACK(ICOUNT).GE.ZERO) EPSREL = STACK(ICOUNT)
            ICOUNT = ICOUNT - N1
         CASE (45)
            K1 = NUMBER(I)
            IADD1 = IADD1 + N1
            K2 = NINT(DATA(IADD1))
            IADD1 = IADD1 + N1
            K3 = NINT(DATA(IADD1))
            IF (STACK(ICOUNT).LT.-RTOL) THEN
               K = K1
            ELSEIF (ABS(STACK(ICOUNT)).LE.RTOL) THEN
               K = K2
            ELSE
               K = K3
            ENDIF
C***********WRITE (*,'(A,I3,A,1P,E14.6)')
C****+      ' get3(',K, ') =', STORE(K)
            STACK(ICOUNT) = STORE(K)
         CASE (46)
            CALL SUB_QUAD (NLIMIT, NUMBER(I),
     +                     BLIM, EPSABS, EPSREL, TLIM, VALUE)
C***********WRITE (*,'(A,1P,E14.6)')
C****+      ' value of integral to be placed on the stack is:', VALUE
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = VALUE
         CASE (47)
            CALL SUB_ROOT (NUMBER(I),
     +                     BLIM(1), EPSABS, EPSREL, TLIM(1), VALUE)
C***********WRITE (*,'(A,1P,E14.6)')
C****+      ' value of root to be placed on the stack is:', VALUE
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = VALUE
         CASE (48)
            CALL SUB_VALU (KMAX_Y, NUMBER(I), NVAR,
     +                     VALUE, X, Y, YDE, Z)
C***********WRITE (*,'(A,1P,E14.6)')
C****+      ' value of model to be placed on the stack is:', VALUE
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = VALUE
         CASE (49)
            IF (NPAR.GT.N0) THEN
               DO J = N1, NPAR
                  PARAM(J) = A(J)
               ENDDO
C**************WRITE (*,'(A,I4,A)')
C****+      ' All',NPAR,' parameters stored by put for use by get'
            ENDIF
         CASE (50)
            XBOT = MIN(STACK(ICOUNT),STACK(ICOUNT - N2))
            XMID = STACK(ICOUNT - N1)
            XTOP = MAX(STACK(ICOUNT),STACK(ICOUNT - N2))
            IF (XMID.LT.XBOT) THEN
               XMID = XBOT
            ELSEIF (XMID.GT.XTOP) THEN
               XMID = XTOP
            ENDIF
            ICOUNT = ICOUNT - N2
            STACK(ICOUNT) = XMID
C***********WRITE (LINE,'(A,1P,E14.6)')
C****+      'middle of 3 numbers to be placed on the stack is:', XMID
         CASE (51)
            K1 = MOD(NUMBER(I),1000)
            K2 = MOD(NUMBER(I),1000000)/1000
            K3 = NUMBER(I)/1000000
            IF (STACK(ICOUNT).LT.-RTOL) THEN
               K = K1
            ELSEIF (ABS(STACK(ICOUNT)).LE.RTOL) THEN
               K = K2
            ELSE
               K = K3
            ENDIF
            CALL SUB_VALU (KMAX_Y, K, NVAR,
     +                     VALUE, X, Y, YDE, Z)
C***********WRITE (*,'(A,I3,A,1P,E14.6)')
C****+      ' value3(',K,') =', VALUE
            STACK(ICOUNT) = VALUE
         CASE (52)
            IADD1 = IADD1 + N1
C***********WRITE (*,'(A,1P,E14.6)')
C****+      ' value of number to be placed on the stack is:', DATA(IADD1)
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = DATA(IADD1)
         CASE (53)
            XBOT = MIN(STACK(ICOUNT - N2), STACK(ICOUNT))
            XMID = STACK(ICOUNT - N1)
            XTOP = MAX(STACK(ICOUNT - N2), STACK(ICOUNT))
            ICOUNT = ICOUNT - N2
            IF (XMID.LE.XBOT) THEN
               STACK(ICOUNT) = - ONE
            ELSEIF (XMID.LE.XTOP) THEN
               STACK(ICOUNT) = ZERO
            ELSE
               STACK(ICOUNT) = ONE
            ENDIF
C***********WRITE (*,'(A,I3)')
C****+      ' order placed on stack =', NINT(STACK(ICOUNT))
         CASE (54)
            J = NINT(STORE(NUMBER(I)))
C***********WRITE (*,'(A,I3)') '  logical value stored =', J
            IF (J.EQ.N1) THEN
               OMIT = .FALSE.
            ELSE
               OMIT = .TRUE.
            ENDIF
         CASE (55)
            J = NINT(STORE(NUMBER(I)))
C***********WRITE (*,'(A,I3)') '  logical value stored =', J
            IF (J.EQ.N1) THEN
               OMIT = .TRUE.
            ELSE
               OMIT = .FALSE.
            ENDIF
         CASE (56)
            CALL SUB_CONV (NLIMIT, NUMBER(I),
     +                     BLIM, EPSABS, EPSREL, TLIM, VALUE)
C***********WRITE (*,'(A,1P,E14.6)')
C****+' value of convolution to be placed on the stack is:', VALUE
            ICOUNT = ICOUNT + N1
            STACK(ICOUNT) = VALUE
         CASE DEFAULT
            CALL SPECIAL_FUNCTIONS (ICOUNT, INDEX1(I), NSTACK,
     +                              STACK)
         END SELECT
C
C Check that stack index is ok
C
         IF (ICOUNT.LT.N0) THEN
            WRITE (LINE,100) ICOUNT, I
            CALL PUTFAT (LINE)
            RETURN
         ENDIF
      ENDDO
C
C Check that stack is empty
C
      IF (ICOUNT.NE.N0) THEN
         I = NEQN!to silence ftn95
         I = NPAR!to silence ftn95
         WRITE (LINE,200) ICOUNT
         CALL PUTFAT (LINE)
      ENDIF
  100 FORMAT ('Stack index =',I3,' at operation line',I3)
  200 FORMAT ('Number of elements left on the stack =',I3)
      END
C
C
