C
C
      SUBROUTINE USER_MODEL_1 (INDEX1,
     +                         KMAX_A, KMAX_F, KMAX_J, KMAX_Y,
     +                         NEQN, NLINES, NPAR, NSTACK, NUMBER,
     +                         NVAR,
     +                         A, DATA, F, STACK, X, Y, YDE, YJA, Z)
C
C ACTION : Evaluate user supplied model parsed by USER_FILE
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 27/12/94
C          19/9/95 changed name to USER_MODEL_1
C          23/5/96 introduced call to TABLE1
C          8/7/97 win32 version ... Note use of IADD1 to index DATA
C          24/6/99 edited for put and get
C          Note: NSTORE must agree with PARSE_FILE
C          16/10/2001 introduced KMAX_A, KMAX_F, KMAX_J, KMAX_Y, NSTACK
C                     for dimensioning
C          18/10/2001 introduced EPSABS, EPSREL, GLOBAL_STORE, BLIM, ULIM
C          02/11/2001 made STORE global
C          05/11/2001 added get3 for 3-way get
C          15/11/2001 added quad, root, value, putpar
C          04/12/2001 added PARAM(NPARAM) and NVAR
C          06/12/2001 added middle
C          14/12/2001 added SPECIAL_FUNCTIONS
C          28/12/2001 added 'order '
C          17/04/2002 added if(.) and ifnot(.)
C          23/05/2003 added 56 = convolute(.,.)
C          11/04/2016 replaced PUTFAT calls by TABLE1 at lines 452 and 462 and left TABLE1 open
C          28/07/2022 added INTENTS, E_NUMBERS, and E_FORMATS_1, etc. 
C
      IMPLICIT   NONE
      INCLUDE   'global.ins'
C
C arguments
C      
      INTEGER,          INTENT (IN) :: KMAX_A, KMAX_F, KMAX_J, KMAX_Y
      INTEGER,          INTENT (IN) :: NEQN, NLINES, NPAR, NSTACK, NVAR
      INTEGER,          INTENT (IN) :: INDEX1(NSTACK), NUMBER(NSTACK)
      DOUBLE PRECISION, INTENT (IN)    :: A(KMAX_A), X, Y, Z
      DOUBLE PRECISION, INTENT (INOUT) :: DATA(NSTACK/10), F(KMAX_F),
     +                                    YDE(KMAX_Y), YJA(KMAX_J), 
     +                                    STACK(NSTACK)
C
C locals
C
      INTEGER    I, ICOLOR, ICOUNT, IFAIL, J, K, K1, K2, K3
      INTEGER    IADD1
      INTEGER    NLIMIT
      PARAMETER (NLIMIT = 20)
      DOUBLE PRECISION ENEG, EPOS, PI, RTOL, TEN, ZERO, ONE
      PARAMETER (ENEG = -174.2D+00, EPOS = 174.2D+00,
     +           PI = 3.1415927D+00, RTOL = 1.0D-200, TEN = 10.0D+00,
     +           ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION  BOT, TOP
      PARAMETER (TOP = 1.0D+03, BOT = - TOP)
      DOUBLE PRECISION TEMP, XBOT, XMID, XTOP, VALUE
      DOUBLE PRECISION S14AAF$, S14ABF$, S15ABF$, S15ADF$
      DOUBLE PRECISION BLIM(NLIMIT), TLIM(NLIMIT)
      DOUBLE PRECISION EPSABS, EPSREL
      CHARACTER (LEN = 13) D13, SHOWLJ 
      CHARACTER (LEN = 100) LINE
      LOGICAL    E_NUMBERS, E_FORMATS_1
      LOGICAL    OMIT
      EXTERNAL   E_FORMATS_1, SHOWLJ
      EXTERNAL   TABLE1
      EXTERNAL   SUB_QUAD, SUB_ROOT, SUB_VALU, SPECIAL_FUNCTIONS,
     +           SUB_CONV
      EXTERNAL   S14AAF$, S14ABF$, S15ABF$, S15ADF$
      INTRINSIC  ABS, EXP, SQRT, LOG, LOG10, NINT, SIN, COS, TAN,
     +           ASIN, ACOS, ATAN, SINH, COSH, TANH, MIN, MAX, MOD
      SAVE       BLIM, TLIM
      SAVE       EPSABS, EPSREL
      DATA       EPSABS, EPSREL / 1.0D-06, 1.0D-03 /
      DATA       BLIM, TLIM / NLIMIT*BOT, NLIMIT*TOP /
      E_NUMBERS = E_FORMATS_1()
      I = NEQN!to silence ftn95
      I = NPAR!to silence ftn95
      IADD1 = 0
      ICOUNT = 0
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      ICOLOR = 4
      CALL TABLE1 (ICOLOR, 'Checking the stack operations')
      CALL TABLE1 (ICOLOR, '.............................')
      OMIT = .FALSE.
      DO I = 1, NLINES
         ICOLOR = 0
         IF (OMIT) THEN
            WRITE (LINE,'(A)') 'Command ignored'
            OMIT = .FALSE.
         ELSEIF (INDEX1(I).EQ.1) THEN
            WRITE (LINE,'(A)') 'put x on the stack'
            ICOUNT = ICOUNT + 1
            STACK(ICOUNT) = X
         ELSEIF (INDEX1(I).EQ.2) THEN
            WRITE (LINE,'(A)') 'put y on the stack'
            ICOUNT = ICOUNT + 1
            STACK(ICOUNT) = Y
         ELSEIF (INDEX1(I).EQ.3) THEN
            WRITE (LINE,'(A)') 'put z on the stack'
            ICOUNT = ICOUNT + 1
            STACK(ICOUNT) = Z
         ELSEIF (INDEX1(I).EQ.4) THEN
            WRITE (LINE,'(A)') 'add top stack element to next-to-top'
            ICOUNT = ICOUNT - 1
            STACK(ICOUNT) = STACK(ICOUNT) + STACK(ICOUNT + 1)
         ELSEIF (INDEX1(I).EQ.5) THEN
            WRITE (LINE,'(A)')
     +            'subtract top stack element from next-to-top'
            ICOUNT = ICOUNT - 1
            STACK(ICOUNT) = STACK(ICOUNT) - STACK(ICOUNT + 1)
         ELSEIF (INDEX1(I).EQ.6) THEN
            WRITE (LINE,'(A)') 'multiply top 2 stack elements'
            ICOUNT = ICOUNT - 1
            STACK(ICOUNT) = STACK(ICOUNT)*STACK(ICOUNT + 1)
         ELSEIF (INDEX1(I).EQ.7) THEN
            WRITE (LINE,'(A)')
     +            'divide next-to-top stack element by top'
            TEMP = STACK(ICOUNT)
            IF (ABS(TEMP).LE.RTOL) THEN
               IF (TEMP.LT.ZERO) THEN
                  TEMP = - RTOL
               ELSE
                  TEMP = RTOL
               ENDIF
            ENDIF
            ICOUNT = ICOUNT - 1
            STACK(ICOUNT) = STACK(ICOUNT)/TEMP
         ELSEIF (INDEX1(I).EQ.8) THEN
            ICOLOR = 1
            WRITE (LINE,'(A,I4)')
     +'number of PARAMETER to place on the stack is:', NUMBER(I)
            ICOUNT = ICOUNT + 1
            STACK(ICOUNT) = A(NUMBER(I))
         ELSEIF (INDEX1(I).EQ.9) THEN
            ICOLOR = 4
            WRITE (LINE,'(A,I4)')
     +'number of MODEL to evaluate off the stack is:', NUMBER(I)
            F(NUMBER(I)) = STACK(ICOUNT)
            ICOUNT = ICOUNT - 1
         ELSEIF (INDEX1(I).EQ.10) THEN
            WRITE (LINE,'(A)')
     +            'raise next-to-top element to power of top'
            ICOUNT = ICOUNT - 1
            TEMP = STACK(ICOUNT)
            IF (TEMP.LT.ZERO) THEN
               STACK(ICOUNT) = TEMP**NINT(STACK(ICOUNT + 1))
            ELSEIF (TEMP.LE.RTOL) THEN
               STACK(ICOUNT) = RTOL**(STACK(ICOUNT + 1))
            ELSE
               STACK(ICOUNT) = TEMP**(STACK(ICOUNT + 1))
            ENDIF
         ELSEIF (INDEX1(I).EQ.11) THEN
            WRITE (LINE,'(A)') 'replace top element by the square root'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.RTOL) TEMP = RTOL
            STACK(ICOUNT) = SQRT(TEMP)
         ELSEIF (INDEX1(I).EQ.12) THEN
            WRITE (LINE,'(A)') 'replace top element by the exponential'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.ENEG) THEN
               TEMP = ENEG
            ELSEIF (TEMP.GE.EPOS) THEN
                TEMP = EPOS
            ENDIF
            STACK(ICOUNT) = EXP(TEMP)
         ELSEIF (INDEX1(I).EQ.13) THEN
            WRITE (LINE,'(A)')
     +            'replace top element by ten-to-the-power'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.ENEG) THEN
               TEMP = ENEG
            ELSEIF (TEMP.GT.EPOS) THEN
                TEMP = EPOS
            ENDIF
            STACK(ICOUNT) = TEN**TEMP
         ELSEIF (INDEX1(I).EQ.14) THEN
            WRITE (LINE,'(A)') 'replace top element by natural log'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.RTOL) TEMP = RTOL
            STACK(ICOUNT) = LOG(TEMP)
         ELSEIF (INDEX1(I).EQ.15) THEN
            WRITE (LINE,'(A)') 'replace top element by log-to-base-ten'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.RTOL) TEMP = RTOL
            STACK(ICOUNT) = LOG10(TEMP)
         ELSEIF (INDEX1(I).EQ.16) THEN
            WRITE (LINE,'(A)') 'put pi on the stack (pi = 3.1415927)'
            ICOUNT = ICOUNT + 1
            STACK(ICOUNT) = PI
         ELSEIF (INDEX1(I).EQ.17) THEN
            WRITE (LINE,'(A)')
     +            'replace top element by sine    *** radians!'
            STACK(ICOUNT) = SIN(STACK(ICOUNT))
         ELSEIF (INDEX1(I).EQ.18) THEN
            STACK(ICOUNT) = COS(STACK(ICOUNT))
            WRITE (LINE,'(A)')
     +            'replace top element by cosine  *** radians!'
         ELSEIF (INDEX1(I).EQ.19) THEN
            WRITE (LINE,'(A)')
     +            'replace top element by tangent *** radians!'
            STACK(ICOUNT) = TAN(STACK(ICOUNT))
         ELSEIF (INDEX1(I).EQ.20) THEN
            WRITE (LINE,'(A)')
     +            'replace top element by arcsin  *** radians!'
            STACK(ICOUNT) = ASIN(STACK(ICOUNT))
         ELSEIF (INDEX1(I).EQ.21) THEN
            WRITE (LINE,'(A)')
     +            'replace top element by arcos   *** radians!'
            STACK(ICOUNT) = ACOS(STACK(ICOUNT))
         ELSEIF (INDEX1(I).EQ.22) THEN
            WRITE (LINE,'(A)')
     +            'replace top element by arctan  *** radians!'
            STACK(ICOUNT) = ATAN(STACK(ICOUNT))
         ELSEIF (INDEX1(I).EQ.23) THEN
            WRITE (LINE,'(A)') 'replace top element by sinh'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.ENEG) THEN
               TEMP = ENEG
            ELSEIF (TEMP.GT.EPOS) THEN
                TEMP = EPOS
            ENDIF
            STACK(ICOUNT) = SINH(TEMP)
         ELSEIF (INDEX1(I).EQ.24) THEN
            WRITE (LINE,'(A)') 'replace top element by cosh'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.ENEG) THEN
               TEMP = ENEG
            ELSEIF (TEMP.GT.EPOS) THEN
                TEMP = EPOS
            ENDIF
            STACK(ICOUNT) = COSH(TEMP)
         ELSEIF (INDEX1(I).EQ.25) THEN
            WRITE (LINE,'(A)') 'replace top element by tanh'
            TEMP = STACK(ICOUNT)
            IF (TEMP.LE.ENEG) THEN
               TEMP = ENEG
            ELSEIF (TEMP.GT.EPOS) THEN
                TEMP = EPOS
            ENDIF
            STACK(ICOUNT) = TANH(TEMP)
         ELSEIF (INDEX1(I).EQ.26) THEN
            WRITE (LINE,'(A)') 'duplicate top element'
            TEMP = STACK(ICOUNT)
            ICOUNT = ICOUNT + 1
            STACK(ICOUNT) = TEMP
         ELSEIF (INDEX1(I).EQ.27) THEN
            WRITE (LINE,'(A)')
     +            'exchange top two elements on stack (swap)'
            TEMP = STACK(ICOUNT)
            STACK(ICOUNT) = STACK(ICOUNT - 1)
            STACK(ICOUNT - 1) = TEMP
         ELSEIF (INDEX1(I).EQ.28) THEN
            WRITE (LINE,'(A)') 'pop top element off the stack (delete)'
            ICOUNT = ICOUNT - 1
         ELSEIF (INDEX1(I).EQ.29) THEN
            WRITE (LINE,'(A)')
     +            'replace top element of stack by absolute value'
            STACK(ICOUNT) = ABS(STACK(ICOUNT))
         ELSEIF (INDEX1(I).EQ.30) THEN
            WRITE (LINE,'(A)')
     +            'change sign of top element of the stack'
            STACK(ICOUNT) = - STACK(ICOUNT)
         ELSEIF (INDEX1(I).EQ.31) THEN
            WRITE (LINE,'(A)') 'replace top 2 elements by the smaller'
            ICOUNT = ICOUNT - 1
            STACK(ICOUNT) = MIN(STACK(ICOUNT),STACK(ICOUNT + 1))
         ELSEIF (INDEX1(I).EQ.32) THEN
            WRITE (LINE,'(A)')
     +            'replace top two 2 elements by the larger'
            ICOUNT = ICOUNT - 1
            STACK(ICOUNT) = MAX(STACK(ICOUNT),STACK(ICOUNT + 1))
         ELSEIF (INDEX1(I).EQ.33) THEN
            WRITE (LINE,'(A)') 'replace top element by gamma function'
            IFAIL = 1
            STACK(ICOUNT) = S14AAF$(STACK(ICOUNT), IFAIL)
         ELSEIF (INDEX1(I).EQ.34) THEN
            WRITE (LINE,'(A)')
     +            'replace top element by ln(gamma function)'
            IFAIL = 1
            STACK(ICOUNT) = S14ABF$(STACK(ICOUNT), IFAIL)
         ELSEIF (INDEX1(I).EQ.35) THEN
            WRITE (LINE,'(A)')
     +            'replace top element by unit normal integral'
            IFAIL = 1
            STACK(ICOUNT) = S15ABF$(STACK(ICOUNT), IFAIL)
         ELSEIF (INDEX1(I).EQ.36) THEN
            WRITE (LINE,'(A)') 'replace top element by erfc'
            IFAIL = 1
            STACK(ICOUNT) = S15ADF$(STACK(ICOUNT), IFAIL)
         ELSEIF (INDEX1(I).EQ.37) THEN
            WRITE (LINE,'(A,I4)')
     +'number of the  Y(i) to place on the stack is:', NUMBER(I)
            ICOUNT = ICOUNT + 1
            STACK(ICOUNT) = YDE(NUMBER(I))
         ELSEIF (INDEX1(I).EQ.38) THEN
            ICOLOR = 4
            WRITE (LINE,'(A,I4)')
     +'number of J(i) to evaluate from the stack is:', NUMBER(I)
            YJA(NUMBER(I)) = STACK(ICOUNT)
            ICOUNT = ICOUNT - 1
         ELSEIF (INDEX1(I).EQ.39) THEN
            IF (E_NUMBERS) THEN
               WRITE (LINE,'(A,I4,A,1P,E14.6)')
     +      'put(', NUMBER(I), ') =', STACK(ICOUNT)
            ELSE
               D13 = SHOWLJ(STACK(ICOUNT))
               WRITE (LINE,'(A,I4,A,1X,A)')
     +      'put(', NUMBER(I), ') =', D13
            ENDIF  
            STORE(NUMBER(I)) = STACK(ICOUNT)
            ICOUNT = ICOUNT - 1
         ELSEIF (INDEX1(I).EQ.40) THEN
            IF (E_NUMBERS) THEN
               WRITE (LINE,'(A,I4,A,1P,E14.6)')
     +      'get(', NUMBER(I), ') =', STORE(NUMBER(I))
            ELSE
               D13 = SHOWLJ(STORE(NUMBER(I)))
               WRITE (LINE,'(A,I4,A,1X,A)')
     +      'get(', NUMBER(I), ') =', D13
            ENDIF  
            ICOUNT = ICOUNT + 1
            STACK(ICOUNT) = STORE(NUMBER(I))
         ELSEIF (INDEX1(I).EQ.41) THEN
            IF (E_NUMBERS) THEN
               WRITE (LINE,'(A,I3,A,1P,E14.6)')
     +      'blim(', NUMBER(I), ') =', STACK(ICOUNT)
            ELSE
               D13 = SHOWLJ(STACK(ICOUNT))
               WRITE (LINE,'(A,I3,A,1X,A)')
     +      'blim(', NUMBER(I), ') =', D13
            ENDIF  
            BLIM(NUMBER(I)) = STACK(ICOUNT)
            ICOUNT = ICOUNT - 1
         ELSEIF (INDEX1(I).EQ.42) THEN
            IF (E_NUMBERS) THEN
               WRITE (LINE,'(A,I3,A,1P,E14.6)')
     +      'tlim(', NUMBER(I), ') =', STACK(ICOUNT)
            ELSE
               D13 = SHOWLJ(STACK(ICOUNT))
               WRITE (LINE,'(A,I3,A,1X,A)')
     +      'tlim(', NUMBER(I), ') =', D13 
            ENDIF  
            TLIM(NUMBER(I)) = STACK(ICOUNT)
            ICOUNT = ICOUNT - 1
         ELSEIF (INDEX1(I).EQ.43) THEN
            IF (STACK(ICOUNT).GE.ZERO) THEN
               IF (E_NUMBERS) THEN
                  WRITE (LINE,'(A,1P,E11.3)') 'epsabs =', STACK(ICOUNT)
               ELSE
                  D13 = SHOWLJ(STACK(ICOUNT)) 
                  WRITE (LINE,'(A,1X,A)') 'epsabs =', D13
               ENDIF  
               EPSABS = STACK(ICOUNT)
            ELSE
               WRITE (LINE,'(A)') '***ERROR: epsabs cannot be negative'
            ENDIF
            ICOUNT = ICOUNT - 1
         ELSEIF (INDEX1(I).EQ.44) THEN
            IF (STACK(ICOUNT).GE.ZERO) THEN
               IF (E_NUMBERS) THEN
                  WRITE (LINE,'(A,1P,E11.3)') 'epsrel =', STACK(ICOUNT)
               ELSE
                  D13 = SHOWLJ(STACK(ICOUNT))  
                  WRITE (LINE,'(A,1X,A)') 'epsrel =', D13 
               ENDIF  
               EPSREL = STACK(ICOUNT)
            ELSE
               WRITE (LINE,'(A)') '***ERROR: epsrel cannot be negative'
            ENDIF
            ICOUNT = ICOUNT - 1
         ELSEIF (INDEX1(I).EQ.45) THEN
            K1 = NUMBER(I)
            IADD1 = IADD1 + 1
            K2 = NINT(DATA(IADD1))
            IADD1 = IADD1 + 1
            K3 = NINT(DATA(IADD1))
            IF (STACK(ICOUNT).LT.-RTOL) THEN
               K = K1
            ELSEIF (ABS(STACK(ICOUNT)).LE.RTOL) THEN
               K = K2
            ELSE
               K = K3
            ENDIF
            IF (E_NUMBERS) THEN
               WRITE (LINE,'(A,I4,A,1P,E14.6)') 'get3(',K,') =',STORE(K)
            ELSE
               D13 = SHOWLJ(STORE(K))
               WRITE (LINE,'(A,I4,A,1X,A)') 'get3(',K,') =', D13 
            ENDIF  
            STACK(ICOUNT) = STORE(K)
         ELSEIF (INDEX1(I).EQ.46) THEN
            CALL SUB_QUAD (NLIMIT, NUMBER(I),
     +                     BLIM, EPSABS, EPSREL, TLIM, VALUE)
            ICOUNT = ICOUNT + 1
            IF (E_NUMBERS) THEN
               WRITE (LINE,'(A,1P,E14.6)')
     +'value of INTEGRAL  to be put on the stack is:', VALUE
            ELSE
               D13 = SHOWLJ(VALUE)
               WRITE (LINE,'(A,1X,A)')
     +'value of INTEGRAL  to be put on the stack is:', D13
            ENDIF  
            STACK(ICOUNT) = VALUE
         ELSEIF (INDEX1(I).EQ.47) THEN
            CALL SUB_ROOT (NUMBER(I),
     +                     BLIM(1), EPSABS, EPSREL, TLIM(1), VALUE)
            ICOUNT = ICOUNT + 1
            IF (E_NUMBERS) THEN
               WRITE (LINE,'(A,1P,E14.6)')
     +'value of  ROOT  to be placed on the stack is:', VALUE
            ELSE
               D13 = SHOWLJ(VALUE) 
               WRITE (LINE,'(A,1X,A)')
     +'value of  ROOT  to be placed on the stack is:', D13 
            ENDIF  
            STACK(ICOUNT) = VALUE
         ELSEIF (INDEX1(I).EQ.48) THEN
            CALL SUB_VALU (KMAX_Y, NUMBER(I), NVAR,
     +                     VALUE, X, Y, YDE, Z)
            ICOUNT = ICOUNT + 1
            IF (E_NUMBERS) THEN
               WRITE (LINE,'(A,1P,E14.6)')
     +'value of MODEL  to be placed on the stack is:', VALUE
            ELSE
               D13 = SHOWLJ(VALUE) 
               WRITE (LINE,'(A,1X,A)')
     +'value of MODEL  to be placed on the stack is:', D13 
            ENDIF  
            STACK(ICOUNT) = VALUE
         ELSEIF (INDEX1(I).EQ.49) THEN
            IF (NPAR.GT.0) THEN
               DO J = 1, NPAR
                  PARAM(J) = A(J)
               ENDDO
               WRITE (LINE,'(A,I4,A)')
     +      'All',NPAR,' parameters stored by put for use by get'
            ENDIF
         ELSEIF (INDEX1(I).EQ.50) THEN
            XBOT = MIN(STACK(ICOUNT),STACK(ICOUNT - 2))
            XMID = STACK(ICOUNT - 1)
            XTOP = MAX(STACK(ICOUNT),STACK(ICOUNT - 2))
            IF (XMID.LT.XBOT) THEN
               XMID = XBOT
            ELSEIF (XMID.GT.XTOP) THEN
               XMID = XTOP
            ENDIF
            ICOUNT = ICOUNT - 2
            STACK(ICOUNT) = XMID
            IF (E_NUMBERS) THEN
               WRITE (LINE,'(A,1P,E14.6)')
     +'MIDDLE of 3 numbers to put onto the stack is:', XMID
            ELSE
               D13 = SHOWLJ(XMID)
               WRITE (LINE,'(A,1X,A)')
     +'MIDDLE of 3 numbers to put onto the stack is:', D13
            ENDIF
            
         ELSEIF (INDEX1(I).EQ.51) THEN
            K1 = MOD(NUMBER(I),1000)
            K2 = MOD(NUMBER(I),1000000)/1000
            K3 = NUMBER(I)/1000000
            IF (STACK(ICOUNT).LT.-RTOL) THEN
               K = K1
            ELSEIF (ABS(STACK(ICOUNT)).LE.RTOL) THEN
               K = K2
            ELSE
               K = K3
            ENDIF
            CALL SUB_VALU (KMAX_Y, K, NVAR,
     +                     VALUE, X, Y, YDE, Z)
            IF (E_NUMBERS) THEN
               WRITE (LINE,'(A,I3,A,1P,E14.6)')
     +      'value3(',K,') =', VALUE
            ELSE
               D13 = SHOWLJ(VALUE)
               WRITE (LINE,'(A,I3,A,1X,A)')
     +      'value3(',K,') =', D13
            ENDIF  
            STACK(ICOUNT) = VALUE
         ELSEIF (INDEX1(I).EQ.52) THEN
            IADD1 = IADD1 + 1
            ICOUNT = ICOUNT + 1
            IF (E_NUMBERS) THEN
               WRITE (LINE,'(A,1P,E14.6)')
     +'value of NUMBER to be placed on the stack is:', DATA(IADD1)
            ELSE
               D13 = SHOWLJ(DATA(IADD1))
               WRITE (LINE,'(A,1X,A)')
     +'value of NUMBER to be placed on the stack is:', D13
            ENDIF  
            STACK(ICOUNT) = DATA(IADD1)
         ELSEIF (INDEX1(I).EQ.53) THEN
            XBOT = MIN(STACK(ICOUNT - 2), STACK(ICOUNT))
            XMID = STACK(ICOUNT - 1)
            XTOP = MAX(STACK(ICOUNT - 2), STACK(ICOUNT))
            ICOUNT = ICOUNT - 2
            IF (XMID.LE.XBOT) THEN
               STACK(ICOUNT) = - ONE
            ELSEIF (XMID.LE.XTOP) THEN
               STACK(ICOUNT) = ZERO
            ELSE
               STACK(ICOUNT) = ONE
            ENDIF
            WRITE (LINE,'(A,I3)')
     +'order of w in stack...a,w,b at levels a,b is:',
     +      NINT(STACK(ICOUNT))
         ELSEIF (INDEX1(I).EQ.54) THEN
            J = NINT(STORE(NUMBER(I)))
            WRITE (LINE,'(A,I3)') '  logical value stored =', J
            IF (J.EQ.1) THEN
               OMIT = .FALSE.
            ELSE
               OMIT = .TRUE.
            ENDIF
         ELSEIF (INDEX1(I).EQ.55) THEN
            J = NINT(STORE(NUMBER(I)))
            WRITE (LINE,'(A,I3)') '  logical value stored =', J
            IF (J.EQ.1) THEN
               OMIT = .TRUE.
            ELSE
               OMIT = .FALSE.
            ENDIF
         ELSEIF (INDEX1(I).EQ.56) THEN
            CALL SUB_CONV (NLIMIT, NUMBER(I),
     +                     BLIM, EPSABS, EPSREL, TLIM, VALUE)
            ICOUNT = ICOUNT + 1
            IF (E_NUMBERS) THEN
               WRITE (LINE,'(A,1P,E14.6)')
     +'value of CONVOLUTION to be put on the stack is:', VALUE
            ELSE
               D13 = SHOWLJ(VALUE) 
               WRITE (LINE,'(A,1X,A)')
     +'value of CONVOLUTION to be put on the stack is:', D13 
            ENDIF  
            STACK(ICOUNT) = VALUE
         ELSE
            CALL SPECIAL_FUNCTIONS (ICOUNT, INDEX1(I), NSTACK,
     +                              STACK)
            IF (E_NUMBERS) THEN
               WRITE (LINE,'(A,1P,E14.6)')
     +'SPECIAL FUNCTION  put at top of the stack is:', STACK(ICOUNT)
            ELSE
               D13 = SHOWLJ(STACK(ICOUNT))
               WRITE (LINE,'(A,1X,A)')
     +'SPECIAL FUNCTION  put at top of the stack is:', D13
            ENDIF  
         ENDIF
         CALL TABLE1 (ICOLOR, LINE)
         
         IF (ICOUNT.LT.0) THEN
            ICOLOR = 4
            CALL TABLE1 (ICOLOR, '  ')
            WRITE (LINE,100) ICOUNT, I
            CALL TABLE1 (ICOLOR, LINE)
            CALL TABLE1 (ICOLOR, '  ')
            RETURN
         ENDIF
      ENDDO

      IF (ICOUNT.NE.0) THEN
         ICOLOR = 4
         CALL TABLE1 (ICOLOR, '  ')
         WRITE (LINE,200) ICOUNT
         CALL TABLE1 (ICOLOR, LINE)
         CALL TABLE1 (ICOLOR, '  ')
      ENDIF
  100 FORMAT ('Stack index =',I4,' at operation line',I4)
  200 FORMAT ('Number of elements left on the stack =',I4)
      END
C
C
