C
C
      SUBROUTINE EXTRA_MODELS (NIN, MODEL_ERROR)
C
C ACTION: Check for extra sub-models at the end of the model file
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 04/12/2001
C         18/01/2011 added call to SIM256 
C
C         Note: the PUTADV code can be activated if required for
C               use in the development of new-model checking
C               MAXMOD sets the upper limit for number of sub-models
C
      IMPLICIT   NONE
      INCLUDE   'global.ins'
      INTEGER    NIN
      INTEGER    KMAX_F, KMAX_Y
      PARAMETER (KMAX_F = 1, KMAX_Y = 100)
      INTEGER    N0, N1
      PARAMETER (N0 = 0, N1 = 1)
      INTEGER    NEQN, NPAR, NVAR
      INTEGER    I, ICOUNT, IOS, ISEND, L, NOUT
      DOUBLE PRECISION F(KMAX_F), X, Y, YDE(KMAX_Y), Z
      LOGICAL    MODEL_ERROR
      CHARACTER  XSTART(10)*16, XSTOP(10)*14
      CHARACTER  LINE*1024, WORD14*14, WORD16*16
      CHARACTER  FNAMES(10)*1024, STUBS(10)*12
      CHARACTER  SIM256*1024
      CHARACTER (LEN = 80) TRIM80, WORD80 
      LOGICAL    ABORT, READY(10)
      LOGICAL    ASKIF, THERE
      PARAMETER (ASKIF = .FALSE.)
      EXTERNAL   DELEET, LCASE1, TRIML1, GETNOU, PUTFAT, SIM256, TRIM80
C********************************************************
C*****PUTADV code can be activated for new-model checking
C*****EXTERNAL   PUTADV
C********************************************************
      EXTERNAL   USER_SUBMOD1, USER_SUBMOD2, USER_SUBMOD3,
     +           USER_SUBMOD4, USER_SUBMOD5, USER_SUBMOD6,
     +           USER_SUBMOD7, USER_SUBMOD8, USER_SUBMOD9,
     +           USER_SUBMOD10
      DATA XSTART / 'begin{model(1)} ',
     +              'begin{model(2)} ',
     +              'begin{model(3)} ',
     +              'begin{model(4)} ',
     +              'begin{model(5)} ',
     +              'begin{model(6)} ',
     +              'begin{model(7)} ',
     +              'begin{model(8)} ',
     +              'begin{model(9)} ',
     +              'begin{model(10)}' /
      DATA XSTOP / 'end{model(1)} ',
     +             'end{model(2)} ',
     +             'end{model(3)} ',
     +             'end{model(4)} ',
     +             'end{model(5)} ',
     +             'end{model(6)} ',
     +             'end{model(7)} ',
     +             'end{model(8)} ',
     +             'end{model(9)} ',
     +             'end{model(10)}' /
      DATA STUBS  / 'f$xmod01.tmp',
     +              'f$xmod02.tmp',
     +              'f$xmod03.tmp',
     +              'f$xmod04.tmp',
     +              'f$xmod05.tmp',
     +              'f$xmod06.tmp',
     +              'f$xmod07.tmp',
     +              'f$xmod08.tmp',
     +              'f$xmod09.tmp',
     +              'f$xmod10.tmp' /
C
C Initialise the subsidiary models
C
      DO I = 1, 10
         FNAMES(I) = SIM256 (STUBS(I))
      ENDDO   
      ISEND = N0
      NEQN = N0
      NPAR = N0
      NVAR = N0
      CALL USER_SUBMOD1 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                   F, X, Y, YDE, Z, FNAMES(1), ABORT)
      CALL USER_SUBMOD2 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                   F, X, Y, YDE, Z, FNAMES(2), ABORT)
      CALL USER_SUBMOD3 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                   F, X, Y, YDE, Z, FNAMES(3), ABORT)
      CALL USER_SUBMOD4 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                   F, X, Y, YDE, Z, FNAMES(4), ABORT)
      CALL USER_SUBMOD5 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                   F, X, Y, YDE, Z, FNAMES(5), ABORT)
      CALL USER_SUBMOD6 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                   F, X, Y, YDE, Z, FNAMES(6), ABORT)
      CALL USER_SUBMOD7 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                   F, X, Y, YDE, Z, FNAMES(7), ABORT)
      CALL USER_SUBMOD8 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                   F, X, Y, YDE, Z, FNAMES(8), ABORT)
      CALL USER_SUBMOD9 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                   F, X, Y, YDE, Z, FNAMES(9), ABORT)
      CALL USER_SUBMOD10(ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                   F, X, Y, YDE, Z, FNAMES(10), ABORT)
C
C Delete any existing subsidiary model files
C
      MODEL_ERROR = .FALSE.
      DO I = N1, MAXMOD
         NEQNS(I) = N0
         NPARS(I) = N0
         NVARS(I) = N0
         READY(I) = .FALSE.
         CALL DELEET (FNAMES(I), ASKIF, THERE)
         IF (THERE) THEN
            WORD80 = TRIM80(FNAMES(I))
            L = LEN_TRIM(WORD80)
            WRITE (LINE,100) WORD80(1:L)
            CALL PUTFAT (LINE)
            MODEL_ERROR = .TRUE.
            RETURN
         ENDIF
      ENDDO
C
C Run systematically through models 1 to MAXMOD on UNIT = NIN
C At this stage we are still reading the model file after the end of
C the model or Jacobian, i.e. immediately after the final % character.
C
      DO I = N1, MAXMOD
         READ (NIN,'(A)',IOSTAT=IOS) LINE
C
C End scan and GOTO 20 if EOF detected or some other error
C
         IF (IOS.NE.N0) GOTO 20
C
C Otherwise check if the XSTART(I) cipher is next
C
         CALL TRIML1 (LINE)
         WORD16 = LINE(1:16)
         CALL LCASE1 (WORD16)
C
C End scan and GOTO 20 if not a subsidiary model
C
         IF (WORD16.NE.XSTART(I)) GOTO 20
C
C The XSTART cipher has been read off the file so copy the data into a file
C
C********************************************************
C*****PUTADV code can be activated for new-model checking
C********CALL PUTADV ('EXTRA_MODELS: opening extra model')
C********************************************************
         CALL GETNOU (NOUT)
         OPEN (UNIT = NOUT, FILE = FNAMES(I))
         ICOUNT = N1
         IOS = N0
         DO WHILE (IOS.EQ.N0)
            READ (NIN,'(A)',IOSTAT=IOS) LINE
            ICOUNT = ICOUNT + N1
            IF (IOS.NE.N0) THEN
C
C ERROR: File has ended before reading XSTOP cipher off the file
C
               CLOSE (UNIT = NOUT)
               CALL DELEET (FNAMES(I), ASKIF, THERE)
               WRITE (LINE,200) I, ICOUNT
               MODEL_ERROR = .TRUE.
               GOTO 20
            ENDIF
            CALL TRIML1 (LINE)
            WORD14 = LINE(1:14)
            CALL LCASE1 (WORD14)
            IF (WORD14.EQ.XSTOP(I)) THEN
C
C The XSTOP(I) cipher has been encountered so end this file
C
C********************************************************
C*****PUTADV code can be activated for new-model checking
C********CALL PUTADV ('EXTRA_MODELS: closing extra model')
C********************************************************
               IOS = - N1
               READY(I) = .TRUE.
            ELSE
C
C Copy MODEL(I) line by line into FNAMES(I)
C
               L = LEN_TRIM(LINE)
               WRITE (NOUT,'(A)') LINE(1:L)
            ENDIF
         ENDDO
         CLOSE (UNIT = NOUT)
      ENDDO
C
C Parse the submodels requested, if any, otherwise return
C
   20 CONTINUE
      ISEND = 1
      IF (READY(1)) THEN
C********************************************************
C*****PUTADV code can be activated for new-model checking
C********CALL PUTADV (
C****+'EXTRA_MODELS: initialising sub-model 1')
C********************************************************
         CALL USER_SUBMOD1 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                      F, X, Y, YDE, Z, FNAMES(1), ABORT)
         IF (ABORT) CALL PUTFAT (
     +  'EXTRA_MODELS: error encountered in sub-model 1')
         NEQNS(1) = NEQN
         NPARS(1) = NPAR
         NVARS(1) = NVAR
      ENDIF
      IF (READY(2)) THEN
C********************************************************
C*****PUTADV code can be activated for new-model checking
C********CALL PUTADV (
C****+'EXTRA_MODELS: initialising sub-model 2')
C********************************************************
         CALL USER_SUBMOD2 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                      F, X, Y, YDE, Z, FNAMES(2), ABORT)
         IF (ABORT) CALL PUTFAT (
     +  'EXTRA_MODELS: error encountered in sub-model 2')
         NEQNS(2) = NEQN
         NPARS(2) = NPAR
         NVARS(2) = NVAR
      ENDIF
      IF (READY(3)) THEN
C********************************************************
C*****PUTADV code can be activated for new-model checking
C********CALL PUTADV (
C****+'EXTRA_MODELS: initialising sub-model 3')
C********************************************************
         CALL USER_SUBMOD3 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                      F, X, Y, YDE, Z, FNAMES(3), ABORT)
         IF (ABORT) CALL PUTFAT (
     +  'EXTRA_MODELS: error encountered in sub-model 3')
         NEQNS(3) = NEQN
         NPARS(3) = NPAR
         NVARS(3) = NVAR
      ENDIF
      IF (READY(4)) THEN
C********************************************************
C*****PUTADV code can be activated for new-model checking
C********CALL PUTADV (
C****+'EXTRA_MODELS: initialising sub-model 4')
C********************************************************
         CALL USER_SUBMOD4 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                      F, X, Y, YDE, Z, FNAMES(4), ABORT)
         IF (ABORT) CALL PUTFAT (
     +  'EXTRA_MODELS: error encountered in sub-model 4')
         NEQNS(4) = NEQN
         NPARS(4) = NPAR
         NVARS(4) = NVAR
      ENDIF
      IF (READY(5)) THEN
C********************************************************
C*****PUTADV code can be activated for new-model checking
C********CALL PUTADV (
C****+'EXTRA_MODELS: initialising sub-model 5')
C********************************************************
         CALL USER_SUBMOD5 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                      F, X, Y, YDE, Z, FNAMES(5), ABORT)
         IF (ABORT) CALL PUTFAT (
     +  'EXTRA_MODELS: error encountered in sub-model 5')
         NEQNS(5) = NEQN
         NPARS(5) = NPAR
         NVARS(5) = NVAR
      ENDIF
      IF (READY(6)) THEN
C********************************************************
C*****PUTADV code can be activated for new-model checking
C********CALL PUTADV (
C****+'EXTRA_MODELS: initialising sub-model 6')
C********************************************************
         CALL USER_SUBMOD6 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                      F, X, Y, YDE, Z, FNAMES(6), ABORT)
         IF (ABORT) CALL PUTFAT (
     +  'EXTRA_MODELS: error encountered in sub-model 6')
         NEQNS(6) = NEQN
         NPARS(6) = NPAR
         NVARS(6) = NVAR
      ENDIF
      IF (READY(7)) THEN
C********************************************************
C*****PUTADV code can be activated for new-model checking
C********CALL PUTADV (
C****+'EXTRA_MODELS: initialising sub-model 7')
C********************************************************
         CALL USER_SUBMOD7 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                      F, X, Y, YDE, Z, FNAMES(7), ABORT)
         IF (ABORT) CALL PUTFAT (
     +  'EXTRA_MODELS: error encountered in sub-model 7')
         NEQNS(7) = NEQN
         NPARS(7) = NPAR
         NVARS(7) = NVAR
      ENDIF
      IF (READY(8)) THEN
C********************************************************
C*****PUTADV code can be activated for new-model checking
C********CALL PUTADV (
C****+'EXTRA_MODELS: initialising sub-model 8')
C********************************************************
         CALL USER_SUBMOD8 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                      F, X, Y, YDE, Z, FNAMES(8), ABORT)
         IF (ABORT) CALL PUTFAT (
     +  'EXTRA_MODELS: error encountered in sub-model 8')
         NEQNS(8) = NEQN
         NPARS(8) = NPAR
         NVARS(8) = NVAR
      ENDIF
      IF (READY(9)) THEN
C********************************************************
C*****PUTADV code can be activated for new-model checking
C********CALL PUTADV (
C****+'EXTRA_MODELS: initialising sub-model 9')
C********************************************************
         CALL USER_SUBMOD8 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                      F, X, Y, YDE, Z, FNAMES(9), ABORT)
         IF (ABORT) CALL PUTFAT (
     +  'EXTRA_MODELS: error encountered in sub-model 9')
         NEQNS(9) = NEQN
         NPARS(9) = NPAR
         NVARS(9) = NVAR
      ENDIF
      IF (READY(10)) THEN
C********************************************************
C*****PUTADV code can be activated for new-model checking
C********CALL PUTADV (
C****+'EXTRA_MODELS: initialising sub-model 10')
C********************************************************
         CALL USER_SUBMOD8 (ISEND, KMAX_F, KMAX_Y, NEQN, NPAR, NVAR,
     +                      F, X, Y, YDE, Z, FNAMES(10), ABORT)
         IF (ABORT) CALL PUTFAT (
     +  'EXTRA_MODELS: error encountered in sub-model 10')
         NEQNS(10) = NEQN
         NPARS(10) = NPAR
         NVARS(10) = NVAR
      ENDIF
  100 FORMAT (
     +'EXTRA_MODELS: Cannot delete ',A,' use attrib -r')
  200 FORMAT (
     +'EXTRA_MODELS: error in sub-model',I3,' at sub-model line',I5)
      END
C
C
