C
C
      SUBROUTINE SUBMOD_FILE (INDEX1, NEQN, NIN, NLINES, NPAR,
     +                        NSTACK, NUMBER, NUMMOD, NVAR, NX,
     +                        DATA1,
     +                        FNAME,
     +                        ABORT, USED)
C
C ACTION : Open a file = FNAME with a user defined submodel
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.,
C          Derived from USER01 = USER_FILE 04/12/2001
C          This version always returns NEQN, NPAR and NVAR irrespective
C          of the input values. It checks for unused variables but
C          rejects DEQN = .TRUE., NEQN > 1 and NVAR < 1
C ADVICE : If the file cannot be interpreted ABORT is returned as .TRUE.
C
C          Date of this version 04/12/2001
C
      IMPLICIT   NONE
      INTEGER    NEQN, NIN, NPAR, NVAR, NLINES, NSTACK, NX
      INTEGER    INDEX1(NSTACK), NUMBER(NSTACK), NUMMOD
      INTEGER    N0_S, N1_S, N2_S, N3_S, N8_S, N9_S, N37_S, 
     +           N48_S
      PARAMETER (N0_S = 0, N1_S = 1, N2_S = 2, N3_S = 3, N8_S = 8,
     +           N9_S = 9, N37_S = 37, N48_S = 48)
      INTEGER    I, IOS, J, NSTART
      INTEGER    N0, N1, N2, N3, N6, N10, N25, N100
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N6 = 6, N10 = 10,
     +           N25 = 25, N100 = 100)
      DOUBLE PRECISION DATA1(NSTACK/N10)
      DOUBLE PRECISION ZERO_S
      PARAMETER (ZERO_S = 0.0D+00)
      CHARACTER  FNAME*(*)
      CHARACTER  LINE*80, TEMP*80
      CHARACTER  WORD6*6
      LOGICAL    ABORT, USED(NSTACK)
      LOGICAL    VUSED(N100), XUSED, YUSED, ZUSED
      LOGICAL    MODEL_ERROR
      EXTERNAL   FILE_PARSE
      EXTERNAL   PUTFAT, LCASE1, TRIML1
      INTRINSIC  INDEX
C
C Set default logicals then open file containing the model and re-set ABORT
C
      ABORT = .TRUE.
      MODEL_ERROR = .FALSE.
      J = N1
      OPEN (UNIT = NIN, FILE = FNAME, IOSTAT = IOS)
      IF (IOS.NE.0) THEN
         CALL PUTFAT (
     +  'SUBMOD_FILE: error opening sub-model temporary file')
         GOTO 40
      ENDIF
C
C Read in the model name and details
C
      READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
      CALL TRIML1 (LINE)
      IF (LINE(N1:N1).NE.'%') THEN
         CALL PUTFAT (
     +  'SUBMOD_FILE: sub-model .tmp file must start with % symbol')
         GOTO 40
      ENDIF
      IF (IOS.NE.0) GOTO 40
      DO I = N1, N25
         J = J + N1
         READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
         IF (IOS.NE.N0) GOTO 40
         TEMP = LINE
         CALL TRIML1 (TEMP)
         IF (TEMP(N1:N1).EQ.'%') THEN
C
C Escape from model text since % encountered
C
            GOTO 10
         ENDIF
         IF (I.EQ.N25) THEN
            CALL PUTFAT (
     +     'SUBMOD_FILE: sub-model title must have < 25 text lines')
            GOTO 40
         ENDIF
      ENDDO
   10 CONTINUE
C
C Read the number of equations
C
      J = J + N1
      READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
      IF (IOS.NE.N0) GOTO 40
      CALL TRIML1 (LINE)
      CALL LCASE1 (LINE)
      NSTART = INDEX(LINE, 'eq')
      IF (NSTART.GT.N1) THEN
         READ (LINE(N1:NSTART - N1),*,END=40,ERR=40,IOSTAT=IOS) NEQN
         IF (IOS.NE.N0) GOTO 40
      ELSE
         CALL PUTFAT (
     +  'SUBMOD_FILE: must define no. of eqns., e.g. 1 equation')
         GOTO 40
      ENDIF
      IF (NEQN.NE.N1) THEN
         CALL PUTFAT (
     +  'SUBMOD_FILE: number of equations in sub-model must be 1')
         GOTO 40
      ENDIF
C
C Read the type identifier line, e.g. 1 variable, differential equation
C
      J = J + N1
      READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
      IF (IOS.NE.N0) GOTO 40
      CALL TRIML1 (LINE)
      CALL LCASE1 (LINE)
      WORD6 = LINE(N1:N6)
      IF (WORD6.EQ.'differ') THEN
         CALL PUTFAT (
     +  'SUBMOD_FILE: sub-model cannot be a differential equation')
         GOTO 40
      ELSE
         NSTART = INDEX(LINE, 'var')
         IF (NSTART.GT.N1) THEN
            READ (LINE(N1:NSTART - N1),*,END=40,ERR=40,IOSTAT=IOS) NVAR
            IF (IOS.NE.N0) GOTO 40
         ELSE
            CALL PUTFAT (
     +     'SUBMOD_FILE: must define no. of variables, e.g. 1 variable')
            GOTO 40
         ENDIF
      ENDIF
      IF (NVAR.LT.N1) THEN
         CALL PUTFAT (
     +   'SUBMOD_FILE: must have no. of variables > 0')
         GOTO 40
      ENDIF
C
C Read the number of parameters
C
      J = J + N1
      READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
      IF (IOS.NE.N0) GOTO 40
      CALL TRIML1 (LINE)
      CALL LCASE1 (LINE)
      NSTART = INDEX(LINE, 'par')
      IF (NSTART.GT.N1) THEN
         READ (LINE(N1:NSTART - N1),*,END=40,ERR=40,IOSTAT=IOS) NPAR
         IF (IOS.NE.N0) GOTO 40
      ELSE
         CALL PUTFAT (
     +  'SUBMOD_FILE: must define no. parameters, e.g. 3 parameters')
         GOTO 40
      ENDIF
      IF (NPAR.LT.N0) THEN
         CALL PUTFAT (
     +   'SUBMOD_FILE: must define no. of parameters >= 0')
         GOTO 40
      ENDIF
C
C Check for begin model sign
C
      J = J + N1
      READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
      IF (IOS.NE.N0) GOTO 40
      CALL TRIML1 (LINE)
      IF (LINE(N1:N1).NE.'%') THEN
         CALL PUTFAT (
     +  'SUBMOD_FILE: start of model must be indicated by %')
         GOTO 40
      ENDIF
C
C Initialise INDEX, NUMBER, NLINES and DATA
C
      DO I = N1, NSTACK
         INDEX1(I) = N0_S
         NUMBER(I) = N0_S
      ENDDO
      DO I = N1, NSTACK/N10
         DATA1(I) = ZERO_S
      ENDDO
      NLINES = N0
      CALL FILE_PARSE (INDEX1, J, NEQN, NIN, NLINES, NPAR, NSTACK,
     +                 NUMBER, NVAR, NX, DATA1, MODEL_ERROR)
      IF (MODEL_ERROR) GOTO 40
      CLOSE (UNIT = NIN)
      IF (NLINES.LT.N1) GOTO 40
C
C Check if x, y, z have been used
C
      ABORT = .FALSE.
      XUSED = .FALSE.
      YUSED = .FALSE.
      ZUSED = .FALSE.
      IF (NVAR.LE.N3) THEN
         DO I = N1, NLINES
            IF (INDEX1(I).EQ.N1_S) XUSED = .TRUE.
            IF (INDEX1(I).EQ.N2_S) YUSED = .TRUE.
            IF (INDEX1(I).EQ.N3_S) ZUSED = .TRUE.
            IF (INDEX1(I).EQ.N8_S) USED(NUMBER(I)) = .TRUE.
            IF (INDEX1(I).EQ.N48_S) THEN
               XUSED = .TRUE.
               YUSED = .TRUE.
               ZUSED = .TRUE.
            ENDIF
         ENDDO
      ELSE
         DO I = N1, NVAR
            VUSED(I) = .FALSE.
         ENDDO
         DO I = N1, NLINES
            IF (INDEX1(I).EQ.N37_S) VUSED(NUMBER(I)) = .TRUE.
            IF (INDEX1(I).EQ.N8_S) USED(NUMBER(I)) = .TRUE.
            IF (INDEX1(I).EQ.N48_S) THEN
               DO J = N1, NVAR
                  VUSED(J) = .TRUE.
               ENDDO
            ENDIF
         ENDDO
         XUSED = VUSED(1)
         YUSED = VUSED(2)
         ZUSED = VUSED(3)
      ENDIF
      IF (NVAR.LE.N3) THEN
         IF (.NOT.XUSED) THEN
            CALL PUTFAT (
     +      'SUBMOD_FILE: x has not been used in the sub-model')
            ABORT = .TRUE.
         ENDIF
         IF (NVAR.GT.N1 .AND. .NOT.YUSED) THEN
            CALL PUTFAT (
     +      'SUBMOD_FILE: y has not been used in the sub-model')
            ABORT = .TRUE.
         ENDIF
         IF (NVAR.GT.N2 .AND. .NOT.ZUSED) THEN
            CALL PUTFAT (
     +      'SUBMOD_FILE: z has not been used in the sub-model')
            ABORT = .TRUE.
         ENDIF
      ELSE
         DO I = N1, NVAR
            IF (.NOT.VUSED(I)) THEN
               ABORT = .TRUE.
               WRITE (LINE,100) I
               CALL PUTFAT (LINE)
            ENDIF
         ENDDO
      ENDIF
      IF (ABORT) GOTO 40
C
C Check if all equations have been defined
C
      ABORT = .TRUE.
      DO I = N1, NEQN
         USED(I) = .FALSE.
      ENDDO
      DO I = N1, NLINES
         IF (INDEX1(I).EQ.N9_S) USED(NUMBER(I)) = .TRUE.
      ENDDO
      J = N0
      DO I = N1, NEQN
         IF (USED(I)) THEN
            J = J + N1
         ELSE
           WRITE (LINE,200) I
           CALL PUTFAT (LINE)
         ENDIF
      ENDDO
      IF (J.EQ.NEQN) ABORT = .FALSE.
      RETURN
C
C Error trapping
C
   40 CONTINUE
      CLOSE (UNIT = NIN)
      ABORT = .TRUE.
      IF (.NOT.MODEL_ERROR) THEN
         WRITE (LINE,300) J
         CALL PUTFAT (LINE)
      ENDIF
      WRITE (LINE,400) NUMMOD
      CALL PUTFAT (LINE)
  100 FORMAT (
     +'SUBMOD_FILE: variable number',I4,' has not been used')
  200 FORMAT (
     +'SUBMOD_FILE: equation number',I4,' has not been defined')
  300 FORMAT (
     +'SUBMOD_FILE: check sub-model at sub_model line number',I6)
  400 FORMAT (
     +'SUBMOD_FILE: sub-model',I3,'is not correctly formatted')
      END
C
C
