C
C Copy of PARSE_FILE for use by sub models
C
C ================================================================
C Note: 1 = x, 2 = y, 3 = z, 8 = p(), 9 = f(), 37 = y(), 38 = j(),
C       48 = value, 49 = putpar
C       must NOT be redefined as they are used for model checking
C ================================================================
C
C    
      SUBROUTINE FILE_PARSE (INDEX1, J, NEQN, NIN, NLINES, NPAR, NSTACK,
     +                       NUMBER, NVAR, NX, DATA, ABORT)
C
C ACTION : Parse a file with a user defined sub-model
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          Derived from PARSE_FILE 06/12/2001
C          14/12/2001 added SUB_PARSE_FILE
C          28/12/2001 added 53 = 'order '
C          31/12/2001 added store
C          17/04/2002 added if(.) and ifnot(.)
C          27/05/2003 added convolute(.)
C          The file must be correctly formatted in reverse Polish
C ADVICE : If the file cannot be interpreted ABORT is returned as .TRUE.
C
      IMPLICIT   NONE
      INCLUDE   'global.ins'
      INTEGER    J, NEQN, NIN, NLINES, NPAR, NSTACK, NVAR, NX
      INTEGER    INDEX1(NSTACK), NUMBER(NSTACK)
      INTEGER    K, K1, K2, K3, L, NUMIF
      INTEGER    I, IADD1, ICOUNT, IOS
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, N10, N11, N13,
     +           N100
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6,
     +           N7 = 7, N8 = 8, N10 = 10, N11 = 11, N13 = 13,
     +           N100 = 100)
      INTEGER    NLIMIT
      PARAMETER (NLIMIT = 20)
      DOUBLE PRECISION DATA(NSTACK/N10)
      DOUBLE PRECISION TEMP
      DOUBLE PRECISION TMAX, TMIN, ZERO
      PARAMETER (TMAX = 1.0D+300, TMIN = 1.0D-300, ZERO = 0.0D+00)
      CHARACTER  LINE*1024, LINE1*1024
      CHARACTER  WORD1*1, WORD2*2, WORD3*3, WORD4*4, WORD5*5, WORD6*6,
     +           WORD7*7, WORD8*8, WORD10*10, WORD16*16
      CHARACTER  BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT
      LOGICAL    STACK_ERROR
      EXTERNAL   PUTFAT, TRIML1, LCASE1, PUTADV
      EXTERNAL   PARSE_SPECIALS
      INTRINSIC  ABS, DBLE, INDEX
      SAVE       IADD1, ICOUNT
      DATA       IADD1, ICOUNT / N0, N0 /
C
C Initialise
C
      ABORT = .TRUE.
      STACK_ERROR = .FALSE.
      LINE = BLANK
      I = NX!to silence FTN95
C
C Read line by line and assign INDEX
C
      IADD1 = N0
      NUMIF = N0
      ICOUNT = N0
      DO I = N1, NSTACK
         J = J + N1
         READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
         IF (IOS.NE.N0) GOTO 40
C
C Trim each line and remove all BLANKS
C
         IF (LINE.EQ.BLANK) THEN
            CALL PUTFAT (
     +'FILE_PARSE: blank line encountered in sub-model file')
            GOTO 40
         ENDIF
         CALL TRIML1 (LINE)
         CALL LCASE1 (LINE)
C
C Define the important words to scan
C
         WORD1 = LINE(N1:N1)
         WORD2 = LINE(N1:N2)
         WORD3 = LINE(N1:N3)
         WORD4 = LINE(N1:N4)
         WORD5 = LINE(N1:N5)
         WORD6 = LINE(N1:N6)
         WORD7 = LINE(N1:N7)
         WORD8 = LINE(N1:N8)
         WORD10 = LINE(N1:N10)
         IF (WORD1.EQ.'%') THEN
C
C End of model is indicated by %, endoffile will send to 40 from READ
C
            GOTO 20
         ELSEIF (WORD1.EQ.'!' .OR. WORD1.EQ.'*' .OR. WORD1.EQ.'/') THEN
C
C A comment line has been encountered
C
            WORD1 = BLANK!to silence ftn95
         ELSEIF (WORD6.EQ.'store(') THEN
C
C store( has been encountered
C
            CALL PUTFAT (
     +'FILE_PARSE: cannot use store(i) in a sub-model')
            GOTO 40
         ELSEIF (WORD7.EQ.'storef(') THEN
            CALL PUTFAT (
     +'FILE_PARSE: cannot use storef(file) in a sub-model')
            GOTO 40
         ELSE
            IF (NLINES.EQ.NSTACK) THEN
               CALL PUTFAT (
     +'FILE_PARSE: max. no. lines exceeded in sub-model file')
               GOTO 40
            ENDIF
            NLINES = NLINES + N1
            IF (WORD2.EQ.'x ') THEN
C
C 1 = x (Note: INDEX = 1 is used for checking if x is used)
C
               IF (NVAR.GT.3) THEN
                  CALL PUTFAT (
     +'FILE_PARSE: use y(1) not x if > 3 variables')
                  GOTO 40
               ENDIF
               INDEX1(NLINES) = 1
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD2.EQ.'y ') THEN
C
C 2 = y (Note: INDEX = 2 is used for checking if y is used)
C
               IF (NVAR.EQ.N1) THEN
                  CALL PUTFAT (
     +'FILE_PARSE: y cannot be used in f(x) ?')
                  GOTO 40
               ENDIF
               IF (NVAR.GT.3) THEN
                  CALL PUTFAT (
     +'FILE_PARSE: use y(2) not y if > 3 variables')
                  GOTO 40
               ENDIF
               INDEX1(NLINES) = 2
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD2.EQ.'z ') THEN
C
C 3 = z  (Note: INDEX = 3 is used for checking if z is used)
C
               IF (NVAR.LT.N3) THEN
                  IF (NVAR.EQ.N1) THEN
                     CALL PUTFAT (
     +'FILE_PARSE: z cannot be used in f(x) ?')
                  ELSE
                     CALL PUTFAT (
     +'FILE_PARSE: z cannot be used in g(x,y) ?')
                  ENDIF
                  GOTO 40
               ENDIF
               IF (NVAR.GT.3) THEN
                  CALL PUTFAT (
     +'FILE_PARSE: use y(3) not z if > 3 variables')
                  GOTO 40
               ENDIF
               INDEX1(NLINES) = 3
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD4.EQ.'add ') THEN
C
C 4 = add
C
               IF (ICOUNT.LT.N2) STACK_ERROR = .TRUE.
               INDEX1(NLINES) = 4
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD4.EQ.'sub ' .OR. WORD6.EQ.'minus ' .OR.
     +              WORD8.EQ.'subtract') THEN
C
C 5 = sub, minus or subtract
C
               IF (ICOUNT.LT.N2) STACK_ERROR = .TRUE.
               INDEX1(NLINES) = 5
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD4.EQ.'mul ' .OR. WORD8.EQ.'multiply') THEN
C
C 6 = mul or multiply
C
               IF (ICOUNT.LT.N2) STACK_ERROR = .TRUE.
               INDEX1(NLINES) = 6
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD4.EQ.'div ' .OR. WORD6.EQ.'divide') THEN
C
C 7 = div or divide
C
               IF (ICOUNT.LT.N2) STACK_ERROR = .TRUE.
               INDEX1(NLINES) = 7
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD2.EQ.'p(') THEN
C
C 8 = p( (Note: INDEX = 8 is used for checking if p(i) used)
C
               INDEX1(NLINES) = 8
               L = INDEX(LINE,')')
               IF (L.GT.N3) THEN
                  READ (LINE(N3:L - N1),*,END=40,ERR=40,IOSTAT=IOS) K
                  IF (IOS.NE.N0) GOTO 40
               ELSE
                  GOTO 40
               ENDIF
               IF (K.LT.N1 .OR. K.GT.NPAR) THEN
                  CALL PUTFAT (
     +'FILE_PARSE: parameter index exceeded')
                  GOTO 40
               ENDIF
               NUMBER(NLINES) = K
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD2.EQ.'f(') THEN
C
C 9 = f(
C
               INDEX1(NLINES) = 9
               L = INDEX(LINE,')')
               IF (L.GT.N3) THEN
                  READ (LINE(N3:L - N1),*,END=40,ERR=40,IOSTAT=IOS) K
                  IF (IOS.NE.N0) GOTO 40
               ELSE
                  GOTO 40
               ENDIF
               IF (K.LT.N1 .OR. K.GT.NEQN) THEN
                  CALL PUTFAT (
     +'FILE_PARSE: equation index exceeded')
                  GOTO 40
               ENDIF
               NUMBER(NLINES) = K
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD5.EQ.'power') THEN
C
C 10 = power
C
               INDEX1(NLINES) = 10
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD5.EQ.'sqrt ' .OR. WORD8.EQ.'squarero') THEN
C
C 11 = sqrt or squarero(ot)
C
               INDEX1(NLINES) = 11
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD4.EQ.'exp ' .OR. WORD8.EQ.'exponent') THEN
C
C 12 = exp or exponent(ial)
C
               INDEX1(NLINES) = 12
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD4.EQ.'ten ' .OR. WORD8.EQ.'tentothe') THEN
C
C 13 = ten or tentothe(power)
C
               INDEX1(NLINES) = 13
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD3.EQ.'ln ' .OR. WORD4.EQ.'log ') THEN
C
C 14 = ln or log
C
               INDEX1(NLINES) = 14
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD5.EQ.'log10') THEN
C
C 15 = log10
C
               INDEX1(NLINES) = 15
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD3.EQ.'pi ') THEN
C
C 16 = pi
C
               INDEX1(NLINES) = 16
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD4.EQ.'sin ' .OR. WORD4.EQ.'sine') THEN
C
C 17 = sin or sine
C
               INDEX1(NLINES) = 17
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD4.EQ.'cos ' .OR. WORD6.EQ.'cosine') THEN
C
C 18 = cos or cosine
C
               INDEX1(NLINES) = 18
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD4.EQ.'tan ' .OR. WORD7.EQ.'tangent') THEN
C
C 19 = tan or tangent
C
               INDEX1(NLINES) = 19
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD5.EQ.'asin ' .OR. WORD6.EQ.'arcsin') THEN
C
C 20 = asin, arcsin or arcsin(e)
C
               INDEX1(NLINES) = 20
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD5.EQ.'acos ' .OR. WORD6.EQ.'arccos') THEN
C
C 21 = acos, arccos or arccosine
C
               INDEX1(NLINES) = 21
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD5.EQ.'atan ' .OR. WORD6.EQ.'arctan') THEN
C
C 22 = atan, arctan or arctangent
C
               INDEX1(NLINES) = 22
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD5.EQ.'sinh ') THEN
C
C 23 = sinh
C
               INDEX1(NLINES) = 23
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD5.EQ.'cosh ') THEN
C
C 24 = cosh
C
               INDEX1(NLINES) = 24
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD5.EQ.'tanh ') THEN
C
C 25 = tanh
C
               INDEX1(NLINES) = 25
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD4.EQ.'dup ' .OR. WORD8.EQ.'duplicat') THEN
C
C 26 = dup or duplicat(e)
C
               INDEX1(NLINES) = 26
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD5.EQ.'exch ' .OR. WORD8.EQ.'exchange' .OR.
     +              WORD5.EQ.'swap ') THEN
C
C 27 = exch, exchchange or swap
C
               INDEX1(NLINES) = 27
               IF (ICOUNT.LT.N2) STACK_ERROR = .TRUE.
            ELSEIF (WORD4.EQ.'del ' .OR. WORD6.EQ.'delete' .OR.
     +              WORD4.EQ.'pop ') THEN
C
C 28 = del, delete or pop
C
               INDEX1(NLINES) = 28
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD4.EQ.'abs ' .OR. WORD8.EQ.'absolute') THEN
C
C 29 = abs or absolute
C
               INDEX1(NLINES) = 29
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD4.EQ.'neg ' .OR. WORD8.EQ.'negative') THEN
C
C 30 = neg or negative
C
               INDEX1(NLINES) = 30
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD4.EQ.'min ' .OR. WORD7.EQ.'minimum') THEN
C
C 31 = min or minimum
C
               INDEX1(NLINES) = 31
               IF (ICOUNT.LT.N2) STACK_ERROR = .TRUE.
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD4.EQ.'max ' .OR. WORD7.EQ.'maximum') THEN
C
C 32 = max or maximum
C
               INDEX1(NLINES) = 32
               IF (ICOUNT.LT.N2) STACK_ERROR = .TRUE.
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD6.EQ.'gamma ') THEN
C
C 33 = gamma
C
               INDEX1(NLINES) = 33
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD6.EQ.'lgamma') THEN
C
C 34 = log(gamma)
C
               INDEX1(NLINES) = 34
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD4.EQ.'phi ' .OR. WORD7.EQ.'normal ' .OR.
     +              WORD8.EQ.'normalcd') THEN
C
C 35 = phi, normal or normalcd(f)
C
               INDEX1(NLINES) = 35
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD5.EQ.'erfc ') THEN
C
C 36 = erfc
C
               INDEX1(NLINES) = 36
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
            ELSEIF (WORD2.EQ.'y(') THEN
C
C 37 = y(  (Note: INDEX = 37 is used for checking if y(i) are all used)
C
               INDEX1(NLINES) = 37
               L = INDEX(LINE,')')
               IF (L.GT.N3) THEN
                  READ (LINE(N3:L - N1),*,END=40,ERR=40,IOSTAT=IOS) K
                  IF (IOS.NE.N0) GOTO 40
               ELSE
                  GOTO 40
               ENDIF
               IF (NVAR.GT.3) THEN
                  IF (K.LT.N1 .OR. K.GT.NVAR) THEN
                     CALL PUTFAT (
     +'FILE_PARSE: variable index exceeded')
                     GOTO 40
                  ENDIF
               ELSE
                  CALL PUTFAT (
     +'FILE_PARSE: y(i) requires nvar > 3')
                  GOTO 40
               ENDIF
               NUMBER(NLINES) = K
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD2.EQ.'j(') THEN
               CALL PUTFAT (
     +'FILE_PARSE: Jacobian not allowed in sub_model')
               GOTO 40
            ELSEIF (WORD4.EQ.'put(') THEN
C
C 39 = put(
C
               INDEX1(NLINES) = 39
               L = INDEX(LINE,')')
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
               IF (L.GT.N5) THEN
                  READ (LINE(N5:L - N1),*,END=40,ERR=40,IOSTAT=IOS) K
                  IF (IOS.NE.N0) GOTO 40
               ELSE
                  GOTO 40
               ENDIF
               IF (K.LT.N1 .OR. K.GT.NSTORE) THEN
                  WRITE (LINE,100) NSTORE
                  CALL PUTFAT (LINE)
                  GOTO 40
               ENDIF
               NUMBER(NLINES) = K
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD4.EQ.'get(') THEN
C
C 40 = get(
C
               INDEX1(NLINES) = 40
               L = INDEX(LINE,')')
               IF (L.GT.N5) THEN
                  READ (LINE(N5:L - N1),*,END=40,ERR=40,IOSTAT=IOS) K
                  IF (IOS.NE.N0) GOTO 40
               ELSE
                  GOTO 40
               ENDIF
               IF (K.LT.N1 .OR. K.GT.NSTORE) THEN
                  WRITE (LINE,200) NSTORE
                  CALL PUTFAT (LINE)
                  GOTO 40
               ENDIF
               NUMBER(NLINES) = K
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD5.EQ.'blim(') THEN
C
C 41 = blim(
C
               INDEX1(NLINES) = 41
               L = INDEX(LINE,')')
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
               IF (L.GT.N6) THEN
                  READ (LINE(N6:L - N1),*,END=40,ERR=40,IOSTAT=IOS) K
                  IF (IOS.NE.N0) GOTO 40
               ELSE
                  GOTO 40
               ENDIF
               IF (K.LT.N1 .OR. K.GT.NLIMIT) THEN
                  WRITE (LINE,300) NLIMIT
                  CALL PUTFAT (LINE)
                  GOTO 40
               ENDIF
               NUMBER(NLINES) = K
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD5.EQ.'tlim(') THEN
C
C 42 = tlim(
C
               INDEX1(NLINES) = 42
               L = INDEX(LINE,')')
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
               IF (L.GT.N6) THEN
                  READ (LINE(N6:L - N1),*,END=40,ERR=40,IOSTAT=IOS) K
                  IF (IOS.NE.N0) GOTO 40
               ELSE
                  GOTO 40
               ENDIF
               IF (K.LT.N1 .OR. K.GT.NLIMIT) THEN
                  WRITE (LINE,300) NLIMIT
                  CALL PUTFAT (LINE)
                  GOTO 40
               ENDIF
               NUMBER(NLINES) = K
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD6.EQ.'abserr' .OR. WORD6.EQ.'epsabs') THEN
C
C 43 abserr or epsabs
C
               INDEX1(NLINES) = 43
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD6.EQ.'relerr' .OR. WORD6.EQ.'epsrel') THEN
C
C 44 relerr or epsrel
C
               INDEX1(NLINES) = 44
               IF (ICOUNT.LT.N1) STACK_ERROR = .TRUE.
               ICOUNT = ICOUNT - N1
            ELSEIF (WORD5.EQ.'get3(') THEN
C
C 45 get3 ... 3-way get
C
               INDEX1(NLINES) = 45
               L = INDEX(LINE,')')
               K1 = N0
               K2 = N0
               K3 = N0
               IF (L.GE.N11) THEN
                  READ (LINE(N6:L - N1),*,IOSTAT=IOS) K1, K2, K3
                  IF (IOS.NE.N0) GOTO 40
               ENDIF
               IF (K1.LT.N1 .OR. K1.GT.NSTORE .OR.
     +             K2.LT.N1 .OR. K2.GT.NSTORE .OR.
     +             K3.LT.N1 .OR. K3.GT.NSTORE) THEN
                  WRITE (LINE,200) NSTORE
                  CALL PUTFAT (LINE)
                  GOTO 40
               ENDIF
               NUMBER(NLINES) = K1
               IADD1 = IADD1 + N1
               DATA(IADD1) = DBLE(K2)
               IADD1 = IADD1 + N1
               DATA(IADD1) = DBLE(K3)
            ELSEIF (WORD5.EQ.'quad(') THEN
C
C 46 = quad(
C
               INDEX1(NLINES) = 46
               L = INDEX(LINE,')')
               IF (L.GT.N6) THEN
                  READ (LINE(N6:L - N1),*,END=40,ERR=40,IOSTAT=IOS) K
                  IF (IOS.NE.N0) GOTO 40
               ELSE
                  GOTO 40
               ENDIF
               IF (K.LT.N1 .OR. K.GT.MAXMOD) THEN
                  WRITE (LINE,400) MAXMOD
                  CALL PUTFAT (LINE)
                  GOTO 40
               ENDIF
               NUMBER(NLINES) = K
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD5.EQ.'root(') THEN
C
C 47 = root(
C
               INDEX1(NLINES) = 47
               L = INDEX(LINE,')')
               IF (L.GT.N6) THEN
                  READ (LINE(N6:L - N1),*,END=40,ERR=40,IOSTAT=IOS) K
                  IF (IOS.NE.N0) GOTO 40
               ELSE
                  GOTO 40
               ENDIF
               IF (K.LT.N1 .OR. K.GT.MAXMOD) THEN
                  WRITE (LINE,400) MAXMOD
                  CALL PUTFAT (LINE)
                  GOTO 40
               ENDIF
               NUMBER(NLINES) = K
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD6.EQ.'value(') THEN
C
C 48 = value( Note: index = 48 is used to check if x, y, z have been used
C
               INDEX1(NLINES) = 48
               L = INDEX(LINE,')')
               IF (L.GT.N7) THEN
                  READ (LINE(N7:L - N1),*,END=40,ERR=40,IOSTAT=IOS) K
                  IF (IOS.NE.N0) GOTO 40
               ELSE
                  GOTO 40
               ENDIF
               IF (K.LT.N1 .OR. K.GT.MAXMOD) THEN
                  WRITE (LINE,400) MAXMOD
                  CALL PUTFAT (LINE)
                  GOTO 40
               ENDIF
               NUMBER(NLINES) = K
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD7.EQ.'putpar ') THEN
C
C 49 putpar
C
               CALL PUTFAT (
     +'FILE_PARSE: cannot use putpar in a sub-model')
               GOTO 40
            ELSEIF (WORD4.EQ.'mid ' .OR. WORD6.EQ.'middle') THEN
C
C 50 mid or middle
C
               INDEX1(NLINES) = 50
               IF (ICOUNT.LT.N3) STACK_ERROR = .TRUE.
               ICOUNT = ICOUNT - N2
            ELSEIF (WORD7.EQ.'value3(') THEN
C
C 51 value3 ... 3-way evaluation
C
               INDEX1(NLINES) = 51
               L = INDEX(LINE,')')
               K1 = N0
               K2 = N0
               K3 = N0
               IF (L.GE.N13) THEN
                  READ (LINE(N8:L - N1),*,IOSTAT=IOS) K1, K2, K3
                  IF (IOS.NE.N0) GOTO 40
               ENDIF
               IF (K1.LT.N1 .OR. K1.GT.MAXMOD .OR.
     +             K2.LT.N1 .OR. K2.GT.MAXMOD .OR.
     +             K3.LT.N1 .OR. K3.GT.MAXMOD) THEN
                  CALL PUTFAT (
     +'value3(i,j,k) used with i,j, and/or k out of range')
                  GOTO 40
               ENDIF
               NUMBER(NLINES) = K1 + 1000*K2 + 1000000*K3
            ELSEIF (
     +         WORD1.EQ.'1' .OR. WORD1.EQ.'2' .OR. WORD1.EQ.'3' .OR.
     +         WORD1.EQ.'4' .OR. WORD1.EQ.'5' .OR. WORD1.EQ.'6' .OR.
     +         WORD1.EQ.'7' .OR. WORD1.EQ.'8' .OR. WORD1.EQ.'9' .OR.
     +         WORD1.EQ.'0' .OR. WORD1.EQ.'-' .OR. WORD1.EQ.'.' .OR.
     +         WORD1.EQ.'+') THEN
C
C 52 is a special case ... the text has not been recognised so try a number
C
               INDEX1(NLINES) = 52
               READ (LINE,*,END=40,ERR=40,IOSTAT=IOS) TEMP
               IF (IOS.NE.N0) GOTO 40
               IF (ABS(TEMP).LE.TMIN) THEN
                  TEMP = ZERO
               ELSEIF (TEMP.LE. - TMAX .OR. TEMP.GE.TMAX) THEN
                  CALL PUTFAT (
     +'FILE_PARSE: must have -1.0e300 < constants < 1.0e300')
                  GOTO 40
               ENDIF
               IADD1 = IADD1 + N1
               IF (IADD1.GT.NSTACK/N10) THEN
                  CALL PUTFAT (
     +'FILE_PARSE: too many constants ... More than NSTACK/10')
                  GOTO 40
               ENDIF
               DATA(IADD1) = TEMP
               ICOUNT = ICOUNT + N1
            ELSEIF (WORD6.EQ.'order ') THEN
C
C 53 = order
C
               INDEX1(NLINES) = 53
               IF (ICOUNT.LT.N3) STACK_ERROR = .TRUE.
               ICOUNT = ICOUNT - N2
            ELSEIF (WORD3.EQ.'if(') THEN
C
C 54 = if(i)
C
               INDEX1(NLINES) = 54
               NUMIF = NUMIF + N1
               L = INDEX(LINE,')')
               IF (L.GT.N4) THEN
                  READ (LINE(N4:L - N1),*,END=40,ERR=40,IOSTAT=IOS) K
                  IF (IOS.NE.N0) GOTO 40
               ELSE
                  GOTO 40
               ENDIF
               IF (K.LT.N1 .OR. K.GT.NSTORE) THEN
                  WRITE (LINE,100) NSTORE
                  CALL PUTFAT (LINE)
                  GOTO 40
               ENDIF
               NUMBER(NLINES) = K
            ELSEIF (WORD6.EQ.'ifnot(') THEN
C
C 55 = ifnot(i)
C
               INDEX1(NLINES) = 55
               NUMIF = NUMIF + N1
               L = INDEX(LINE,')')
               IF (L.GT.N7) THEN
                  READ (LINE(N7:L - N1),*,END=40,ERR=40,IOSTAT=IOS) K
                  IF (IOS.NE.N0) GOTO 40
               ELSE
                  GOTO 40
               ENDIF
               IF (K.LT.N1 .OR. K.GT.NSTORE) THEN
                  WRITE (LINE,100) NSTORE
                  CALL PUTFAT (LINE)
                  GOTO 40
               ENDIF
               NUMBER(NLINES) = K
            ELSEIF (WORD10.EQ.'convolute(') THEN
C
C 56 = convolute(
C
               INDEX1(NLINES) = 56
               L = INDEX(LINE,')')
               IF (L.GT.N13) THEN
                  READ (LINE(N11:L - N1),*,END=40,ERR=40,IOSTAT=IOS) K1,
     +                                                               K2
                  IF (IOS.NE.N0) GOTO 40
               ELSE
                  GOTO 40
               ENDIF
               IF (K1.LT.N1 .OR. K1.GT.MAXMOD .OR.
     +             K2.LT.N1 .OR. K2.GT.MAXMOD) THEN
                  WRITE (LINE,400) MAXMOD
                  CALL PUTFAT (LINE)
                  GOTO 40
               ENDIF
               K = K1 + N100*K2
               NUMBER(NLINES) = K
               ICOUNT = ICOUNT + N1
            ELSE
               CALL PARSE_SPECIALS (ICOUNT, INDEX1(I), NLINES, NSTACK,
     +                              LINE, WORD1, WORD2, WORD3, WORD4,
     +                              WORD5, WORD6, WORD7, WORD8, WORD10,
     +                              ABORT, STACK_ERROR)
            ENDIF
         ENDIF
         IF (ICOUNT.LT.N0 .OR. STACK_ERROR) THEN
            CALL PUTFAT (
     +'FILE_PARSE: stack error ... empty stack encountered')
            GOTO 40
         ENDIF
      ENDDO
C
C End of reading the model
C
   20 CONTINUE
      IF (ICOUNT.GT.N0 .AND. NUMIF.LE.N0) THEN
         WRITE (LINE,600) ICOUNT
         CALL PUTADV (LINE)
      ELSEIF (ICOUNT.LE.N0 .AND. NUMIF.GT.N0) THEN
         WRITE (LINE,700) NUMIF
         CALL PUTADV (LINE)
      ELSEIF (ICOUNT.GT.N0 .AND. NUMIF.GT.N0) THEN
         WRITE (LINE,800) NUMIF, ICOUNT
         CALL PUTADV (LINE)
      ENDIF
      ABORT = .FALSE.
      RETURN
C
C Error trapping
C
   40 CONTINUE
      CLOSE (UNIT = NIN)
      ABORT = .TRUE.
      WRITE (LINE1,900) IOS, J
      CALL PUTFAT (LINE1)
      WRITE (WORD16,1000) J
      LINE1 = WORD16//LINE(1:240)
      CALL PUTADV (LINE1)
  100 FORMAT (
     +'FILE_PARSE: put(.) must be in the range 1 to',I6)
  200 FORMAT (
     +'FILE_PARSE: get(.) and get3(.,.,.) must be in the range 1 to',I6)
  300 FORMAT (
     +'FILE_PARSE: blim(.) and tlim(.) must be in the range 1 to',I6)
  400 FORMAT (
     +'FILE_PARSE: maximum number of sub-models =',I3)
C*500 FORMAT ('put(.) at line',I6,' is not used by a get()')
  600 FORMAT (
     +'FILE_PARSE: No. unused stack elements after model eval. =',I4)
  700 FORMAT (
     +'FILE_PARSE: No. of if(.) and/or ifnot(.) logical functions =',I4)
  800 FORMAT (
     +'FILE_PARSE: if/ifnot logicals =',I4,', No. unused elements =',I4)
  900 FORMAT ('FILE_PARSE: IOSTAT =',I6,
     +': Error in file ... Check model at line number',I6)
 1000 FORMAT ('Line (',I6,') = ')
      END
C
C
